/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.internal.symbol.TypeSym;
import oracle.javatools.parser.java.v2.internal.symbol.expr.ListExpr;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceHasType;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.DebugContext;
import oracle.jdevimpl.runner.debug.EvaluationInfo;

class JavaEvaluator
extends BaseEvaluator {
    private boolean allowMethodInvocation;
    private static final String PRIMITIVE_TYPE_BOOLEAN = "boolean";
    private static final String PRIMITIVE_TYPE_BYTE = "byte";
    private static final String PRIMITIVE_TYPE_CHAR = "char";
    private static final String PRIMITIVE_TYPE_DOUBLE = "double";
    private static final String PRIMITIVE_TYPE_FLOAT = "float";
    private static final String PRIMITIVE_TYPE_INT = "int";
    private static final String PRIMITIVE_TYPE_LONG = "long";
    private static final String PRIMITIVE_TYPE_SHORT = "short";
    private static final char SIGNATURE_OBJECT = 'L';
    private static final char SIGNATURE_BOOLEAN = 'Z';
    private static final char SIGNATURE_DOUBLE = 'D';
    private static final char SIGNATURE_FLOAT = 'F';
    private static final char SIGNATURE_INT = 'I';
    private static final char SIGNATURE_LONG = 'J';

    private static boolean isPrimitiveType(String type) {
        return type.equals(PRIMITIVE_TYPE_BOOLEAN) || type.equals(PRIMITIVE_TYPE_BYTE) || type.equals(PRIMITIVE_TYPE_CHAR) || type.equals(PRIMITIVE_TYPE_SHORT) || type.equals(PRIMITIVE_TYPE_INT) || type.equals(PRIMITIVE_TYPE_LONG) || type.equals(PRIMITIVE_TYPE_FLOAT) || type.equals(PRIMITIVE_TYPE_DOUBLE);
    }

    JavaEvaluator(DebugContext debugContext, boolean allowMethodInvocation) {
        super(debugContext);
        this.allowMethodInvocation = allowMethodInvocation;
    }

    private static SourceExpression getSourceExpression(String exp) {
        try {
            SourceFile file = SourceFactory.createFile((int)3);
            SourceFactory factory = file.getFactory();
            SourceExpression se = factory.createExpressionFromText(exp);
            return se;
        }
        catch (Throwable e) {
            if (e instanceof ThreadDeath) {
                throw (ThreadDeath)e;
            }
            return null;
        }
    }

    static boolean validate(String exp) {
        return JavaEvaluator.getSourceExpression(exp) != null;
    }

    @Override
    protected int evaluateConditionResult(Object o) {
        block4: {
            try {
                EvaluationInfo eval = this.convertToEvaluationInfo(o);
                if (eval != null && eval.getClassInfo().getName().equals(PRIMITIVE_TYPE_BOOLEAN)) {
                    if (eval.getBooleanValue()) {
                        return 1;
                    }
                    return 0;
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block4;
                throw (ThreadDeath)e;
            }
        }
        return -1;
    }

    @Override
    protected Object evaluate(String exp) {
        block3: {
            SourceExpression se = null;
            try {
                se = JavaEvaluator.getSourceExpression(exp);
                if (se != null) {
                    Object o = this.evaluateSourceExpression_evaluateSimple(se);
                    return o;
                }
            }
            catch (Throwable e) {
                if (!(e instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)e;
            }
        }
        return null;
    }

    private Object evaluateSourceExpression(SourceExpression se) throws Exception {
        switch (se.getOperatorCode()) {
            case 4: {
                throw new Exception("Unable to evaluate source expression: annotation");
            }
            case 16: {
                return this.evaluateArrayAccess(se);
            }
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 52: 
            case 57: {
                throw new Exception("Unable to evaluate source expression: assignment");
            }
            case 19: {
                return this.evaluateDot(se);
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: 
            case 12: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 42: 
            case 43: 
            case 51: 
            case 56: {
                return this.evaluateInfix(se);
            }
            case 5: 
            case 26: {
                throw new Exception("Unable to evaluate source expression: list");
            }
            case 27: {
                return this.evaluateLiteral(se);
            }
            case 24: {
                return this.evaluateMethodCall(se);
            }
            case 39: {
                throw new Exception("Unable to evaluate source expression: new array");
            }
            case 40: {
                return this.evaluateNewObject(se);
            }
            case 15: {
                return this.evaluateQuestion(se);
            }
            case 53: {
                return this.evaluateSimpleName(se);
            }
            case 54: {
                return this.evaluateType(se);
            }
            case 55: {
                return this.evaluateTypecast(se);
            }
            case 9: 
            case 14: 
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return this.evaluateUnary(se);
            }
            case 38: {
                return this.evaluateWrapper(se);
            }
        }
        throw new Exception("Unable to evaluate source expression");
    }

    private Object evaluateSourceExpression_evaluateSimple(SourceExpression se) throws Exception {
        Object o1 = this.evaluateSourceExpression(se);
        if (o1 instanceof String) {
            o1 = this.evaluateSimple((String)o1);
        }
        return o1;
    }

    private EvaluationInfo evaluateSourceExpression_convertToEvaluationInfo(SourceExpression se) throws Exception {
        Object o1 = this.evaluateSourceExpression(se);
        return this.convertToEvaluationInfo(o1);
    }

    private Object evaluateArrayAccess(SourceExpression se) throws Exception {
        DebugDataArrayInfo a;
        Object o1 = this.evaluateSourceExpression_evaluateSimple(se.getFirstOperand());
        DebugDataInfo data1 = JavaEvaluator.getDataInfo(o1);
        SourceExpression seIndices = se.getSecondOperand();
        int countIndices = seIndices.getOperandCount();
        for (int i = 0; i < countIndices && data1 instanceof DebugDataArrayInfo && !(a = (DebugDataArrayInfo)data1).isNull(); ++i) {
            int arrayStart = a.getArrayStart();
            int arrayCount = a.getArrayCount();
            EvaluationInfo evalIndex = this.evaluateSourceExpression_convertToEvaluationInfo(seIndices.getOperandAt(i));
            int arrayIndex = evalIndex.getIntValue();
            if (arrayStart > arrayIndex || arrayCount != -1 && arrayIndex >= arrayStart + arrayCount) break;
            DebugArrayElementInfo arrayElement = a.getArrayElements(arrayIndex, 1)[0];
            if (i == countIndices - 1) {
                return arrayElement;
            }
            data1 = arrayElement.getDataInfo();
        }
        throw new Exception("Unable to evaluate array access");
    }

    private Object evaluateDot(SourceExpression se) throws Exception {
        DebugClassInfo clazz;
        DebugFieldInfo[] fields;
        Object field;
        Object o1 = null;
        String s1 = null;
        boolean useSuper = false;
        SourceExpression left = se.getFirstOperand();
        int leftOperatorCode = left.getOperatorCode();
        if (leftOperatorCode == 53 && ((SourceHasName)left).getName().equals("super")) {
            o1 = this.evaluateSimple("this");
            useSuper = true;
        } else {
            o1 = this.evaluateSourceExpression(se.getFirstOperand());
            if (o1 instanceof String) {
                s1 = (String)o1;
                o1 = this.evaluateSimple(s1);
            }
        }
        String name = ((SourceHasName)se).getName();
        DebugDataInfo data1 = JavaEvaluator.getDataInfo(o1);
        if (data1 instanceof DebugDataObjectInfo) {
            DebugDataObjectInfo dataObject1 = (DebugDataObjectInfo)data1;
            if (!useSuper && dataObject1.canGetFieldByName()) {
                DebugFieldInfo field2 = dataObject1.getField(name);
                if (field2 != null) {
                    return field2;
                }
            } else {
                DebugClassInfo clazz2 = dataObject1.getClassInfo();
                int classLevel = 0;
                if (useSuper) {
                    classLevel = 1;
                    clazz2 = clazz2.getSuperClass(1);
                }
                for (DebugClassInfo c = clazz2; c != null; c = c.getSuperClass(1)) {
                    DebugFieldInfo[] fields2 = dataObject1.getFields(classLevel);
                    Object field3 = this.checkFields(name, fields2);
                    if (field3 == null) continue;
                    return field3;
                }
            }
        }
        if (o1 instanceof DebugClassInfo && (field = this.checkFields(name, fields = (clazz = (DebugClassInfo)o1).getStaticFields(-1))) != null) {
            return field;
        }
        if (s1 != null) {
            return s1 + "." + name;
        }
        throw new Exception("Unable to evaluate dot");
    }

    private EvaluationInfo evaluateInfix(SourceExpression se) throws Exception {
        int operator = se.getOperatorCode();
        switch (operator) {
            case 23: {
                return this.evaluateInstanceOfOperator(se);
            }
            case 3: 
            case 43: {
                return this.evaluateLogicalInfixOperator(se, operator);
            }
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 30: 
            case 42: {
                return this.evaluateComparisonOperator(se, operator);
            }
            case 28: 
            case 51: 
            case 56: {
                return this.evaluateShiftOperator(se, operator);
            }
            case 17: 
            case 31: 
            case 33: {
                return this.evaluateArithmeticInfixOperator(se, operator);
            }
            case 1: 
            case 7: 
            case 10: 
            case 12: 
            case 35: {
                return this.evaluateArithmeticInfixOperatorMulti(se, operator);
            }
        }
        throw new Exception("Unable to evaluate infix");
    }

    private EvaluationInfo evaluateInstanceOfOperator(SourceExpression se) throws Exception {
        EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo(se.getFirstOperand());
        String className2 = ((SourceHasType)se.getSecondOperand()).getSourceType().getName();
        DebugClassInfo c1 = eval1.getClassInfo();
        DebugClassInfo c2 = this.findClass(className2);
        if (!c1.isPrimitive() && c2 != null && !c2.isPrimitive()) {
            className2 = c2.getName();
            if (c2.isInterface()) {
                DebugClassInfo[] interfaces1 = c1.getInterfaces(-1);
                int length = interfaces1.length;
                for (int i = 0; i < length; ++i) {
                    String interface1Name = interfaces1[i].getName();
                    if (!interface1Name.equals(className2)) continue;
                    return new EvaluationInfo(true, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
                }
                return new EvaluationInfo(false, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
            if (c2.isObject() || c2.isArray()) {
                for (DebugClassInfo c1Super = c1; c1Super != null; c1Super = c1Super.getSuperClass(1)) {
                    String class1Super = c1Super.getName();
                    if (!class1Super.equals(className2)) continue;
                    return new EvaluationInfo(true, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
                }
                return new EvaluationInfo(false, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
        }
        throw new Exception("Unable to evaluate instanceof operator");
    }

    private EvaluationInfo evaluateLogicalInfixOperator(SourceExpression se, int operator) throws Exception {
        boolean b;
        switch (operator) {
            case 43: {
                b = true;
                break;
            }
            case 3: {
                b = false;
                break;
            }
            default: {
                throw new Exception("Unable to evaluate logical infix operator");
            }
        }
        int operandCount = se.getOperandCount();
        for (int i = 0; i < operandCount; ++i) {
            EvaluationInfo eval = this.evaluateSourceExpression_convertToEvaluationInfo(se.getOperandAt(i));
            DebugClassInfo c = eval.getClassInfo();
            if (c.getName().equals(PRIMITIVE_TYPE_BOOLEAN)) {
                if (eval.getBooleanValue() != b) continue;
                return new EvaluationInfo(b, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
            throw new Exception("Unable to evaluate logical infix operator");
        }
        return new EvaluationInfo(!b, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
    }

    private EvaluationInfo evaluateComparisonOperator(SourceExpression se, int operator) throws Exception {
        EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo(se.getFirstOperand());
        EvaluationInfo eval2 = this.evaluateSourceExpression_convertToEvaluationInfo(se.getSecondOperand());
        char sig = this.comparisonPromotion(eval1, eval2);
        switch (sig) {
            case 'L': {
                long n1 = this.getComparableId(eval1);
                long n2 = this.getComparableId(eval2);
                boolean result = false;
                switch (operator) {
                    case 20: {
                        result = n1 == n2;
                        break;
                    }
                    case 42: {
                        result = n1 != n2;
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 25: 
                    case 30: {
                        throw new Exception("Unable to evaluate comparison operator");
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
            case 'Z': {
                boolean n1 = eval1.getBooleanValue();
                boolean n2 = eval2.getBooleanValue();
                boolean result = false;
                switch (operator) {
                    case 20: {
                        result = n1 == n2;
                        break;
                    }
                    case 42: {
                        result = n1 != n2;
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 25: 
                    case 30: {
                        throw new Exception("Unable to evaluate comparison operator");
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
            case 'I': {
                int n1 = eval1.getIntValue();
                int n2 = eval2.getIntValue();
                boolean result = false;
                switch (operator) {
                    case 20: {
                        result = n1 == n2;
                        break;
                    }
                    case 42: {
                        result = n1 != n2;
                        break;
                    }
                    case 30: {
                        result = n1 < n2;
                        break;
                    }
                    case 22: {
                        result = n1 > n2;
                        break;
                    }
                    case 25: {
                        result = n1 <= n2;
                        break;
                    }
                    case 21: {
                        result = n1 >= n2;
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
            case 'J': {
                long n1 = eval1.getLongValue();
                long n2 = eval2.getLongValue();
                boolean result = false;
                switch (operator) {
                    case 20: {
                        result = n1 == n2;
                        break;
                    }
                    case 42: {
                        result = n1 != n2;
                        break;
                    }
                    case 30: {
                        result = n1 < n2;
                        break;
                    }
                    case 22: {
                        result = n1 > n2;
                        break;
                    }
                    case 25: {
                        result = n1 <= n2;
                        break;
                    }
                    case 21: {
                        result = n1 >= n2;
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
            case 'F': {
                float n1 = eval1.getFloatValue();
                float n2 = eval2.getFloatValue();
                boolean result = false;
                switch (operator) {
                    case 20: {
                        result = n1 == n2;
                        break;
                    }
                    case 42: {
                        result = n1 != n2;
                        break;
                    }
                    case 30: {
                        result = n1 < n2;
                        break;
                    }
                    case 22: {
                        result = n1 > n2;
                        break;
                    }
                    case 25: {
                        result = n1 <= n2;
                        break;
                    }
                    case 21: {
                        result = n1 >= n2;
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
            case 'D': {
                double n1 = eval1.getDoubleValue();
                double n2 = eval2.getDoubleValue();
                boolean result = false;
                switch (operator) {
                    case 20: {
                        result = n1 == n2;
                        break;
                    }
                    case 42: {
                        result = n1 != n2;
                        break;
                    }
                    case 30: {
                        result = n1 < n2;
                        break;
                    }
                    case 22: {
                        result = n1 > n2;
                        break;
                    }
                    case 25: {
                        result = n1 <= n2;
                        break;
                    }
                    case 21: {
                        result = n1 >= n2;
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
        }
        throw new Exception("Unable to evaluate comparison operator");
    }

    private EvaluationInfo evaluateShiftOperator(SourceExpression se, int operator) throws Exception {
        EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo(se.getFirstOperand());
        EvaluationInfo eval2 = this.evaluateSourceExpression_convertToEvaluationInfo(se.getSecondOperand());
        char sig = this.numericPromotion(eval1);
        switch (sig) {
            case 'I': {
                int n1 = eval1.getIntValue();
                int n2 = eval2.getIntValue();
                int result = 0;
                switch (operator) {
                    case 28: {
                        result = n1 << n2;
                        break;
                    }
                    case 51: {
                        result = n1 >> n2;
                        break;
                    }
                    case 56: {
                        result = n1 >>> n2;
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_INT));
            }
            case 'J': {
                long n1 = eval1.getLongValue();
                int n2 = eval2.getIntValue();
                long result = 0L;
                switch (operator) {
                    case 28: {
                        result = n1 << n2;
                        break;
                    }
                    case 51: {
                        result = n1 >> n2;
                        break;
                    }
                    case 56: {
                        result = n1 >>> n2;
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_LONG));
            }
        }
        throw new Exception("Unable to evaluate shift operator");
    }

    private EvaluationInfo evaluateArithmeticInfixOperator(SourceExpression se, int operator) throws Exception {
        EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo(se.getFirstOperand());
        EvaluationInfo eval2 = this.evaluateSourceExpression_convertToEvaluationInfo(se.getSecondOperand());
        return this.evaluateArithmeticInfixOperator(eval1, eval2, operator);
    }

    private EvaluationInfo evaluateArithmeticInfixOperatorMulti(SourceExpression se, int operator) throws Exception {
        EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo(se.getFirstOperand());
        int operandCount = se.getOperandCount();
        for (int i = 1; i < operandCount; ++i) {
            EvaluationInfo eval2 = this.evaluateSourceExpression_convertToEvaluationInfo(se.getOperandAt(i));
            eval1 = operator == 1 && (this.isStringClass(eval1.getClassInfo()) || this.isStringClass(eval2.getClassInfo())) ? this.evaluateStringConcatenation(eval1, eval2) : this.evaluateArithmeticInfixOperator(eval1, eval2, operator);
        }
        return eval1;
    }

    private EvaluationInfo evaluateArithmeticInfixOperator(EvaluationInfo eval1, EvaluationInfo eval2, int operator) throws Exception {
        char sig = this.numericPromotion(eval1, eval2);
        switch (sig) {
            case 'I': {
                int n1 = eval1.getIntValue();
                int n2 = eval2.getIntValue();
                int result = 0;
                switch (operator) {
                    case 1: {
                        result = n1 + n2;
                        break;
                    }
                    case 31: {
                        result = n1 - n2;
                        break;
                    }
                    case 35: {
                        result = n1 * n2;
                        break;
                    }
                    case 17: {
                        result = n1 / n2;
                        break;
                    }
                    case 33: {
                        result = n1 % n2;
                        break;
                    }
                    case 10: {
                        result = n1 | n2;
                        break;
                    }
                    case 12: {
                        result = n1 ^ n2;
                        break;
                    }
                    case 7: {
                        result = n1 & n2;
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_INT));
            }
            case 'J': {
                long n1 = eval1.getLongValue();
                long n2 = eval2.getLongValue();
                long result = 0L;
                switch (operator) {
                    case 1: {
                        result = n1 + n2;
                        break;
                    }
                    case 31: {
                        result = n1 - n2;
                        break;
                    }
                    case 35: {
                        result = n1 * n2;
                        break;
                    }
                    case 17: {
                        result = n1 / n2;
                        break;
                    }
                    case 33: {
                        result = n1 % n2;
                        break;
                    }
                    case 10: {
                        result = n1 | n2;
                        break;
                    }
                    case 12: {
                        result = n1 ^ n2;
                        break;
                    }
                    case 7: {
                        result = n1 & n2;
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_LONG));
            }
            case 'F': {
                float n1 = eval1.getFloatValue();
                float n2 = eval2.getFloatValue();
                float result = 0.0f;
                switch (operator) {
                    case 1: {
                        result = n1 + n2;
                        break;
                    }
                    case 31: {
                        result = n1 - n2;
                        break;
                    }
                    case 35: {
                        result = n1 * n2;
                        break;
                    }
                    case 17: {
                        result = n1 / n2;
                        break;
                    }
                    case 33: {
                        result = n1 % n2;
                        break;
                    }
                    case 7: 
                    case 10: 
                    case 12: {
                        throw new Exception("Unable to evaluate arithmetic infix operator");
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_FLOAT));
            }
            case 'D': {
                double n1 = eval1.getDoubleValue();
                double n2 = eval2.getDoubleValue();
                double result = 0.0;
                switch (operator) {
                    case 1: {
                        result = n1 + n2;
                        break;
                    }
                    case 31: {
                        result = n1 - n2;
                        break;
                    }
                    case 35: {
                        result = n1 * n2;
                        break;
                    }
                    case 17: {
                        result = n1 / n2;
                        break;
                    }
                    case 33: {
                        result = n1 % n2;
                        break;
                    }
                    case 7: 
                    case 10: 
                    case 12: {
                        throw new Exception("Unable to evaluate arithmetic infix operator");
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_DOUBLE));
            }
        }
        throw new Exception("Unable to evaluate arithmetic infix operator");
    }

    private EvaluationInfo evaluateStringConcatenation(EvaluationInfo eval1, EvaluationInfo eval2) throws Exception {
        String s1 = this.convertToStringForConcatenation(eval1);
        String s2 = this.convertToStringForConcatenation(eval2);
        String resultS = s1 + s2;
        return new EvaluationInfo('\"' + resultS + '\"', this.findStringClass());
    }

    private String convertToStringForConcatenation(EvaluationInfo eval) throws Exception {
        EvaluationInfo toStringEval;
        DebugClassInfo clazz = eval.getClassInfo();
        if (eval.isNull()) {
            return "null";
        }
        if (this.isStringClass(clazz)) {
            return eval.getStringValue();
        }
        if (clazz.isPrimitive()) {
            return eval.getValue();
        }
        Object toStringResult = this.evaluateMethodInvocation(eval, false, "toString", new ArrayList(0));
        if (toStringResult != null && (toStringEval = this.convertToEvaluationInfo(toStringResult)) != null && this.isStringClass(toStringEval.getClassInfo())) {
            return toStringEval.getStringValue();
        }
        throw new Exception("Unable to evaluate string concatenation");
    }

    private EvaluationInfo evaluateLiteral(SourceExpression se) throws Exception {
        String value = se.getText();
        switch (((SourceLiteralExpression)se).getTokenValue()) {
            case 8: {
                return new EvaluationInfo(DebugSharedPrimitives.intDecode(value), this.findClass(PRIMITIVE_TYPE_INT));
            }
            case 9: {
                int length = value.length();
                char lastChar = value.charAt(length - 1);
                if (lastChar == 'l' || lastChar == 'L') {
                    value = value.substring(0, length - 1);
                }
                return new EvaluationInfo(DebugSharedPrimitives.longDecode(value), this.findClass(PRIMITIVE_TYPE_LONG));
            }
            case 10: {
                int length = value.length();
                char lastChar = value.charAt(length - 1);
                if (lastChar == 'f' || lastChar == 'F') {
                    value = value.substring(0, length - 1);
                }
                return new EvaluationInfo(DebugSharedPrimitives.floatDecode(value), this.findClass(PRIMITIVE_TYPE_FLOAT));
            }
            case 11: {
                int length = value.length();
                char lastChar = value.charAt(length - 1);
                if (lastChar == 'd' || lastChar == 'D') {
                    value = value.substring(0, length - 1);
                }
                return new EvaluationInfo(DebugSharedPrimitives.doubleDecode(value), this.findClass(PRIMITIVE_TYPE_DOUBLE));
            }
            case 12: {
                return new EvaluationInfo(DebugSharedPrimitives.booleanDecode(value), this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            }
            case 13: {
                return new EvaluationInfo(DebugSharedPrimitives.charDecode(value), this.findClass(PRIMITIVE_TYPE_CHAR));
            }
            case 14: {
                return new EvaluationInfo(value, this.findStringClass());
            }
            case 15: {
                return new EvaluationInfo("null", this.findClass("java.lang.Object"), null);
            }
        }
        throw new Exception("Unable to evaluate literal");
    }

    private Object evaluateMethodCall(SourceExpression se) throws Exception {
        Object o1 = null;
        boolean useSuper = false;
        String methodName = ((SourceHasName)se).getName();
        List args = null;
        int operandCount = se.getOperandCount();
        if (operandCount == 1) {
            DebugMethodInfo method;
            DebugLocation location;
            o1 = this.evaluateSimple("this");
            if (o1 == null && this.debugContext.frame != null && (location = this.debugContext.frame.getLocation()) != null && (method = location.getMethod()) != null && (method.getAccess() & 8) != 0) {
                o1 = location.getClassInfo();
            }
            args = se.getFirstOperand().getOperands();
        } else if (operandCount == 2) {
            SourceExpression left = se.getFirstOperand();
            int leftOperatorCode = left.getOperatorCode();
            if (leftOperatorCode == 53 && ((SourceHasName)left).getName().equals("super")) {
                o1 = this.evaluateSimple("this");
                useSuper = true;
            } else {
                o1 = this.evaluateSourceExpression_evaluateSimple(left);
            }
            args = se.getSecondOperand().getOperands();
        } else if (operandCount == 3) {
            // empty if block
        }
        if (o1 != null && args != null) {
            return this.evaluateMethodInvocation(o1, useSuper, methodName, args);
        }
        throw new Exception("Unable to evaluate method call");
    }

    private Object evaluateMethodInvocation(Object o0, boolean useSuper, String methodName, List args) throws Exception {
        if (this.allowMethodInvocation && this.debugContext.vm != null && this.debugContext.vm.getCapabilities().canInvokeMethod()) {
            EvaluationInfo eval0;
            DebugClassInfo clazz;
            DebugDataInfo data0;
            EvaluationInfo[] argumentsAsEvaluationInfo = this.evaluateArguments(args);
            List argumentsToPass = this.convertArguments(argumentsAsEvaluationInfo);
            DebugMethodInfo method = null;
            if (o0 instanceof DebugClassInfo) {
                DebugClassInfo clazz2 = (DebugClassInfo)o0;
                method = this.findMethod(clazz2, methodName, 8, argumentsAsEvaluationInfo);
            }
            if (method == null && (data0 = JavaEvaluator.getDataInfo(o0)) instanceof DebugDataObjectInfo) {
                clazz = data0.getClassInfo();
                if (useSuper) {
                    clazz = clazz.getSuperClass(1);
                }
                if ((method = this.findMethod(clazz, methodName, 0, argumentsAsEvaluationInfo)) != null && (method.getAccess() & 8) == 0) {
                    argumentsToPass.add(0, data0);
                }
            }
            if (method == null && this.isStringClass((clazz = (eval0 = this.convertToEvaluationInfo(o0)).getClassInfo()).getName())) {
                String s = eval0.getStringValue();
                method = this.findMethod(clazz, methodName, 0, argumentsAsEvaluationInfo);
                if (method != null && (method.getAccess() & 8) == 0) {
                    argumentsToPass.add(0, s);
                }
            }
            if (method != null) {
                DebugDataInfo result = method.invoke(argumentsToPass);
                return result;
            }
            throw new Exception("Unable to evaluate method invocation");
        }
        return this.simulateMethodInvocation(o0, methodName, args);
    }

    private EvaluationInfo[] evaluateArguments(List args) throws Exception {
        int argsSize = args.size();
        EvaluationInfo[] argumentsAsEvaluationInfo = new EvaluationInfo[argsSize];
        for (int i = 0; i < argsSize; ++i) {
            argumentsAsEvaluationInfo[i] = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(i));
        }
        return argumentsAsEvaluationInfo;
    }

    private List convertArguments(EvaluationInfo[] argumentsAsEvaluationInfo) throws Exception {
        ArrayList<Object> argumentsToPass = new ArrayList<Object>();
        for (int i = 0; i < argumentsAsEvaluationInfo.length; ++i) {
            EvaluationInfo eval = argumentsAsEvaluationInfo[i];
            DebugDataInfo data = eval.getDataInfo();
            if (data != null) {
                argumentsToPass.add(data);
                continue;
            }
            Object wrappedValue = eval.getWrappedValue();
            if (wrappedValue != null) {
                argumentsToPass.add(wrappedValue);
                continue;
            }
            if (this.isStringClass(eval.getClassInfo())) {
                String s = eval.getStringValue();
                argumentsToPass.add(s);
                continue;
            }
            if (eval.isNull()) {
                argumentsToPass.add(null);
                continue;
            }
            throw new Exception("Unable to evaluate method invocation");
        }
        return argumentsToPass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object simulateMethodInvocation(Object o0, String methodName, List args) throws Exception {
        String c0Name;
        EvaluationInfo eval0 = this.convertToEvaluationInfo(o0);
        if (methodName.equals("equals") && args.size() == 1) {
            EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(0));
            try {
                long n0 = this.getComparableId(eval0);
                long n1 = this.getComparableId(eval1);
                if (n0 == n1) {
                    return new EvaluationInfo(true, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.isStringClass(c0Name = eval0.getClassInfo().getName())) {
            String value0;
            boolean charAt = false;
            boolean compareTo = true;
            int compareToIgnoreCase = 2;
            int concat = 3;
            int endsWith = 4;
            int equals = 5;
            int equalsIgnoreCase = 6;
            int indexOf = 7;
            int intern = 8;
            int lastIndexOf = 9;
            int length = 10;
            int matches = 11;
            int regionMatches = 12;
            int replace = 13;
            int replaceAll = 14;
            int replaceFirst = 15;
            int startsWith = 16;
            int substring = 17;
            int toLowerCase = 18;
            int toString = 19;
            int toUpperCase = 20;
            int trim = 21;
            int m = -1;
            if (methodName.equals("charAt")) {
                m = 0;
            } else if (methodName.equals("compareTo")) {
                m = 1;
            } else if (methodName.equals("compareToIgnoreCase")) {
                m = 2;
            } else if (methodName.equals("concat")) {
                m = 3;
            } else if (methodName.equals("endsWith")) {
                m = 4;
            } else if (methodName.equals("equals")) {
                m = 5;
            } else if (methodName.equals("equalsIgnoreCase")) {
                m = 6;
            } else if (methodName.equals("indexOf")) {
                m = 7;
            } else if (methodName.equals("intern")) {
                m = 8;
            } else if (methodName.equals("lastIndexOf")) {
                m = 9;
            } else if (methodName.equals("length")) {
                m = 10;
            } else if (methodName.equals("matches")) {
                m = 11;
            } else if (methodName.equals("regionMatches")) {
                m = 12;
            } else if (methodName.equals("replace")) {
                m = 13;
            } else if (methodName.equals("replaceAll")) {
                m = 14;
            } else if (methodName.equals("replaceFirst")) {
                m = 15;
            } else if (methodName.equals("startsWith")) {
                m = 16;
            } else if (methodName.equals("substring")) {
                m = 17;
            } else if (methodName.equals("toLowerCase")) {
                m = 18;
            } else if (methodName.equals("toString")) {
                m = 19;
            } else if (methodName.equals("toUpperCase")) {
                m = 20;
            } else if (methodName.equals("trim")) {
                m = 21;
            }
            if (m == -1 || (value0 = eval0.getStringValue()) == null) throw new Exception("Unable to simulate method invocation");
            switch (m) {
                case 0: {
                    if (args.size() != 1) throw new Exception("Unable to simulate method invocation");
                    EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(0));
                    if (!eval1.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) throw new Exception("Unable to simulate method invocation");
                    int value1 = eval1.getIntValue();
                    char resultC = value0.charAt(value1);
                    return new EvaluationInfo(resultC, this.findClass(PRIMITIVE_TYPE_CHAR));
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 11: {
                    if (args.size() != 1) throw new Exception("Unable to simulate method invocation");
                    EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(0));
                    if (!this.isStringClass(eval1.getClassInfo())) throw new Exception("Unable to simulate method invocation");
                    String value1 = eval1.getStringValue();
                    boolean resultB = false;
                    boolean gotBooleanResult = false;
                    int resultI = 0;
                    boolean gotIntResult = false;
                    String resultS = null;
                    boolean gotStringResult = false;
                    if (m == 5) {
                        resultB = value0.equals(value1);
                        gotBooleanResult = true;
                    } else if (m == 6) {
                        resultB = value0.equalsIgnoreCase(value1);
                        gotBooleanResult = true;
                    } else if (m == 1) {
                        resultI = value0.compareTo(value1);
                        gotIntResult = true;
                    } else if (m == 2) {
                        resultI = value0.compareToIgnoreCase(value1);
                        gotIntResult = true;
                    } else if (m == 4) {
                        resultB = value0.endsWith(value1);
                        gotBooleanResult = true;
                    } else if (m == 11) {
                        resultB = value0.matches(value1);
                        gotBooleanResult = true;
                    } else if (m == 3) {
                        resultS = value0.concat(value1);
                        gotStringResult = true;
                    }
                    if (gotBooleanResult) {
                        return new EvaluationInfo(resultB, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
                    }
                    if (gotIntResult) {
                        return new EvaluationInfo(resultI, this.findClass(PRIMITIVE_TYPE_INT));
                    }
                    if (!gotStringResult) throw new Exception("Unable to simulate method invocation");
                    return new EvaluationInfo('\"' + resultS + '\"', this.findStringClass());
                }
                case 16: {
                    if (args.size() == 1) {
                        EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(0));
                        if (!this.isStringClass(eval1.getClassInfo())) throw new Exception("Unable to simulate method invocation");
                        String value1 = eval1.getStringValue();
                        boolean resultB = value0.startsWith(value1);
                        return new EvaluationInfo(resultB, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
                    }
                    if (args.size() != 2) throw new Exception("Unable to simulate method invocation");
                    EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(0));
                    if (!this.isStringClass(eval1.getClassInfo())) throw new Exception("Unable to simulate method invocation");
                    String value1 = eval1.getStringValue();
                    EvaluationInfo eval2 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(1));
                    if (!eval2.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) throw new Exception("Unable to simulate method invocation");
                    int value2 = eval2.getIntValue();
                    boolean resultB = value0.startsWith(value1, value2);
                    return new EvaluationInfo(resultB, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
                }
                case 8: 
                case 10: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    if (args.size() != 0) throw new Exception("Unable to simulate method invocation");
                    int resultI = 0;
                    boolean gotIntResult = false;
                    String resultS = null;
                    boolean gotStringResult = false;
                    if (m == 10) {
                        resultI = value0.length();
                        gotIntResult = true;
                    } else if (m == 8) {
                        resultS = value0.intern();
                        gotStringResult = true;
                    } else if (m == 18) {
                        resultS = value0.toLowerCase();
                        gotStringResult = true;
                    } else if (m == 19) {
                        resultS = value0.toString();
                        gotStringResult = true;
                    } else if (m == 20) {
                        resultS = value0.toUpperCase();
                        gotStringResult = true;
                    } else if (m == 21) {
                        resultS = value0.trim();
                        gotStringResult = true;
                    }
                    if (gotIntResult) {
                        return new EvaluationInfo(resultI, this.findClass(PRIMITIVE_TYPE_INT));
                    }
                    if (!gotStringResult) throw new Exception("Unable to simulate method invocation");
                    return new EvaluationInfo('\"' + resultS + '\"', this.findStringClass());
                }
                case 7: 
                case 9: {
                    EvaluationInfo eval2;
                    int resultI = 0;
                    boolean gotIntResult = false;
                    if (args.size() == 1) {
                        EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(0));
                        String className1 = eval1.getClassInfo().getName();
                        if (className1.equals(PRIMITIVE_TYPE_INT)) {
                            int value1 = eval1.getIntValue();
                            if (m == 7) {
                                resultI = value0.indexOf(value1);
                                gotIntResult = true;
                            } else if (m == 9) {
                                resultI = value0.lastIndexOf(value1);
                                gotIntResult = true;
                            }
                        } else if (this.isStringClass(className1)) {
                            String value1 = eval1.getStringValue();
                            if (m == 7) {
                                resultI = value0.indexOf(value1);
                                gotIntResult = true;
                            } else if (m == 9) {
                                resultI = value0.lastIndexOf(value1);
                                gotIntResult = true;
                            }
                        }
                    } else if (args.size() == 2 && (eval2 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(1))).getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) {
                        int value2 = eval2.getIntValue();
                        EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(0));
                        String className1 = eval1.getClassInfo().getName();
                        if (className1.equals(PRIMITIVE_TYPE_INT)) {
                            int value1 = eval1.getIntValue();
                            if (m == 7) {
                                resultI = value0.indexOf(value1, value2);
                                gotIntResult = true;
                            } else if (m == 9) {
                                resultI = value0.lastIndexOf(value1, value2);
                                gotIntResult = true;
                            }
                        } else if (this.isStringClass(className1)) {
                            String value1 = eval1.getStringValue();
                            if (m == 7) {
                                resultI = value0.indexOf(value1, value2);
                                gotIntResult = true;
                            } else if (m == 9) {
                                resultI = value0.lastIndexOf(value1, value2);
                                gotIntResult = true;
                            }
                        }
                    }
                    if (!gotIntResult) throw new Exception("Unable to simulate method invocation");
                    return new EvaluationInfo(resultI, this.findClass(PRIMITIVE_TYPE_INT));
                }
                case 12: {
                    EvaluationInfo eval1;
                    boolean resultB = false;
                    boolean gotBooleanResult = false;
                    if (args.size() == 5) {
                        EvaluationInfo eval12 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(0));
                        if (eval12.getClassInfo().getName().equals(PRIMITIVE_TYPE_BOOLEAN)) {
                            boolean value1 = eval12.getBooleanValue();
                            EvaluationInfo eval2 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(1));
                            if (eval2.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) {
                                int value2 = eval2.getIntValue();
                                EvaluationInfo eval3 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(2));
                                if (this.isStringClass(eval3.getClassInfo())) {
                                    String value3 = eval3.getStringValue();
                                    EvaluationInfo eval4 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(3));
                                    if (eval4.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) {
                                        int value4 = eval4.getIntValue();
                                        EvaluationInfo eval5 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(4));
                                        if (eval5.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) {
                                            int value5 = eval5.getIntValue();
                                            resultB = value0.regionMatches(value1, value2, value3, value4, value5);
                                            gotBooleanResult = true;
                                        }
                                    }
                                }
                            }
                        }
                    } else if (args.size() == 4 && (eval1 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(0))).getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) {
                        int value1 = eval1.getIntValue();
                        EvaluationInfo eval2 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(1));
                        if (this.isStringClass(eval2.getClassInfo())) {
                            String value2 = eval2.getStringValue();
                            EvaluationInfo eval3 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(2));
                            if (eval3.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) {
                                int value3 = eval3.getIntValue();
                                EvaluationInfo eval4 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(3));
                                if (eval4.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) {
                                    int value4 = eval4.getIntValue();
                                    resultB = value0.regionMatches(value1, value2, value3, value4);
                                    gotBooleanResult = true;
                                }
                            }
                        }
                    }
                    if (!gotBooleanResult) throw new Exception("Unable to simulate method invocation");
                    return new EvaluationInfo(resultB, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
                }
                case 13: {
                    if (args.size() != 2) throw new Exception("Unable to simulate method invocation");
                    EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(0));
                    if (!eval1.getClassInfo().getName().equals(PRIMITIVE_TYPE_CHAR)) throw new Exception("Unable to simulate method invocation");
                    char value1 = eval1.getCharValue();
                    EvaluationInfo eval2 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(1));
                    if (!eval2.getClassInfo().getName().equals(PRIMITIVE_TYPE_CHAR)) throw new Exception("Unable to simulate method invocation");
                    char value2 = eval2.getCharValue();
                    String resultS = value0.replace(value1, value2);
                    return new EvaluationInfo('\"' + resultS + '\"', this.findStringClass());
                }
                case 14: 
                case 15: {
                    if (args.size() != 2) throw new Exception("Unable to simulate method invocation");
                    EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(0));
                    if (!this.isStringClass(eval1.getClassInfo())) throw new Exception("Unable to simulate method invocation");
                    String value1 = eval1.getStringValue();
                    EvaluationInfo eval2 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(1));
                    if (!this.isStringClass(eval2.getClassInfo())) throw new Exception("Unable to simulate method invocation");
                    String value2 = eval2.getStringValue();
                    String resultS = null;
                    boolean gotStringResult = false;
                    if (m == 14) {
                        resultS = value0.replaceAll(value1, value2);
                        gotStringResult = true;
                    } else if (m == 15) {
                        resultS = value0.replaceFirst(value1, value2);
                        gotStringResult = true;
                    }
                    if (!gotStringResult) throw new Exception("Unable to simulate method invocation");
                    return new EvaluationInfo('\"' + resultS + '\"', this.findStringClass());
                }
                case 17: {
                    EvaluationInfo eval1;
                    if (args.size() == 1) {
                        EvaluationInfo eval13 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(0));
                        if (!eval13.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) throw new Exception("Unable to simulate method invocation");
                        int value1 = eval13.getIntValue();
                        String resultS = value0.substring(value1);
                        return new EvaluationInfo('\"' + resultS + '\"', this.findStringClass());
                    }
                    if (args.size() != 2 || !(eval1 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(0))).getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) throw new Exception("Unable to simulate method invocation");
                    int value1 = eval1.getIntValue();
                    EvaluationInfo eval2 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(1));
                    if (!eval2.getClassInfo().getName().equals(PRIMITIVE_TYPE_INT)) throw new Exception("Unable to simulate method invocation");
                    int value2 = eval2.getIntValue();
                    String resultS = value0.substring(value1, value2);
                    return new EvaluationInfo('\"' + resultS + '\"', this.findStringClass());
                }
            }
            throw new Exception("Unable to simulate method invocation");
        } else {
            if (!c0Name.equals("java.lang.Boolean") && !c0Name.equals("java.lang.Byte") && !c0Name.equals("java.lang.Character") && !c0Name.equals("java.lang.Double") && !c0Name.equals("java.lang.Float") && !c0Name.equals("java.lang.Integer") && !c0Name.equals("java.lang.Long") && !c0Name.equals("java.lang.Short") && !c0Name.startsWith("$Oracle.Builtin.") || !methodName.equals("equals") || args.size() != 1) throw new Exception("Unable to simulate method invocation");
            EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo((SourceExpression)args.get(0));
            boolean result = false;
            if (!eval1.getClassInfo().getName().equals(c0Name)) throw new Exception("Unable to simulate method invocation");
            DebugDataInfo d0 = eval0.getDataInfo();
            DebugDataInfo d1 = eval1.getDataInfo();
            if (!(d0 instanceof DebugDataObjectInfo) || !(d1 instanceof DebugDataObjectInfo)) return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            DebugDataObjectInfo do0 = (DebugDataObjectInfo)d0;
            DebugDataObjectInfo do1 = (DebugDataObjectInfo)d1;
            if (do0.isNull()) return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
            String value0 = DebugShared.makeCourtesyValue(do0);
            String value1 = null;
            if (!do1.isNull()) {
                value1 = DebugShared.makeCourtesyValue(do1);
            }
            result = value0.equals(value1);
            return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
        }
    }

    private Object evaluateNewObject(SourceExpression se) throws Exception {
        List<Object> args;
        if (this.debugContext.vm == null) {
            throw new Exception("Unable to evaluate source expression: new object");
        }
        try {
            ListExpr argsList = (ListExpr)se.getChildren().get(1);
            EvaluationInfo[] argumentsAsEvaluationInfo = this.evaluateArguments(argsList.getChildren());
            args = Arrays.asList(argumentsAsEvaluationInfo);
        }
        catch (Throwable t) {
            throw new Exception("Unable to evaluate source expression: new object");
        }
        return this.debugContext.vm.newObject(((TypeSym)se.getChildren().get(0)).getName(), args);
    }

    private Object evaluateQuestion(SourceExpression se) throws Exception {
        EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo(se.getFirstOperand());
        DebugClassInfo c1 = eval1.getClassInfo();
        if (c1.getName().equals(PRIMITIVE_TYPE_BOOLEAN)) {
            boolean b1 = eval1.getBooleanValue();
            if (b1) {
                return this.evaluateSourceExpression(se.getSecondOperand());
            }
            return this.evaluateSourceExpression(se.getThirdOperand());
        }
        throw new Exception("Unable to evaluate question-colon operator");
    }

    private String evaluateSimpleName(SourceExpression se) {
        return ((SourceHasName)se).getName();
    }

    private Object evaluateType(SourceExpression se) throws Exception {
        String className = ((SourceHasType)se).getSourceType().getName();
        DebugClassInfo c = this.findClass(className);
        if (c != null) {
            return c;
        }
        throw new Exception("Unable to evaluate type");
    }

    private Object evaluateTypecast(SourceExpression se) throws Exception {
        block4: {
            Object o2;
            DebugClassInfo c1;
            String className1;
            block5: {
                className1 = ((SourceHasType)se.getFirstOperand()).getSourceType().getName();
                c1 = this.findClass(className1);
                if (c1 == null) break block4;
                className1 = c1.getName();
                boolean primitive1 = c1.isPrimitive();
                o2 = this.evaluateSourceExpression(se.getSecondOperand());
                EvaluationInfo eval2 = this.convertToEvaluationInfo(o2);
                DebugClassInfo c2 = eval2.getClassInfo();
                if (c2.isPrimitive() != primitive1) {
                    throw new Exception("Unable to evaluate typecast");
                }
                if (primitive1) {
                    String class2 = c2.getName();
                    return this.performPrimitiveTypecast(o2, eval2, class2, className1);
                }
                if (!c1.isInterface()) break block5;
                DebugClassInfo[] interfaces2 = c2.getInterfaces(-1);
                int length = interfaces2.length;
                for (int i = 0; i < length; ++i) {
                    String interface2Name = interfaces2[i].getName();
                    if (!interface2Name.equals(className1)) continue;
                    return o2;
                }
                break block4;
            }
            if (!c1.isObject() && !c1.isArray()) break block4;
            for (DebugClassInfo c2Super = c2; c2Super != null; c2Super = c2Super.getSuperClass(1)) {
                String class2Super = c2Super.getName();
                if (!class2Super.equals(className1)) continue;
                return o2;
            }
        }
        throw new Exception("Unable to evaluate typecast");
    }

    private Object evaluateUnary(SourceExpression se) throws Exception {
        int operator = se.getOperatorCode();
        switch (operator) {
            case 41: {
                return this.evaluateLogicalPrefixOperator(se, operator);
            }
            case 9: 
            case 37: 
            case 44: 
            case 47: 
            case 48: {
                return this.evaluateArithmeticPrefixOperator(se, operator);
            }
            case 45: 
            case 46: {
                return this.evaluateArithmeticPostfixOperator(se);
            }
            case 14: {
                return this.evaluateClassLiteralOperators(se);
            }
            case 49: {
                break;
            }
        }
        throw new Exception("Unable to evaluate unary operator");
    }

    private EvaluationInfo evaluateLogicalPrefixOperator(SourceExpression se, int operator) throws Exception {
        EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo(se.getFirstOperand());
        DebugClassInfo c1 = eval1.getClassInfo();
        if (c1.getName().equals(PRIMITIVE_TYPE_BOOLEAN)) {
            boolean b1 = eval1.getBooleanValue();
            boolean result = false;
            switch (operator) {
                case 41: {
                    result = !b1;
                }
            }
            return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_BOOLEAN));
        }
        throw new Exception("Unable to evaluate logical prefix operator");
    }

    private EvaluationInfo evaluateArithmeticPrefixOperator(SourceExpression se, int operator) throws Exception {
        EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo(se.getFirstOperand());
        char sig = this.numericPromotion(eval1);
        switch (sig) {
            case 'I': {
                int n1 = eval1.getIntValue();
                int result = 0;
                switch (operator) {
                    case 9: {
                        result = ~n1;
                        break;
                    }
                    case 44: {
                        result = n1;
                        break;
                    }
                    case 37: {
                        result = -n1;
                        break;
                    }
                    case 48: {
                        result = ++n1;
                        break;
                    }
                    case 47: {
                        result = --n1;
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_INT));
            }
            case 'J': {
                long n1 = eval1.getLongValue();
                long result = 0L;
                switch (operator) {
                    case 9: {
                        result = n1 ^ 0xFFFFFFFFFFFFFFFFL;
                        break;
                    }
                    case 44: {
                        result = n1;
                        break;
                    }
                    case 37: {
                        result = -n1;
                        break;
                    }
                    case 48: {
                        result = ++n1;
                        break;
                    }
                    case 47: {
                        result = --n1;
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_LONG));
            }
            case 'F': {
                float n1 = eval1.getFloatValue();
                float result = 0.0f;
                switch (operator) {
                    case 9: {
                        throw new Exception("Unable to evaluate arithmetic prefix operator");
                    }
                    case 44: {
                        result = n1;
                        break;
                    }
                    case 37: {
                        result = -n1;
                        break;
                    }
                    case 48: {
                        result = n1 += 1.0f;
                        break;
                    }
                    case 47: {
                        result = n1 -= 1.0f;
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_FLOAT));
            }
            case 'D': {
                double n1 = eval1.getDoubleValue();
                double result = 0.0;
                switch (operator) {
                    case 9: {
                        throw new Exception("Unable to evaluate arithmetic prefix operator");
                    }
                    case 44: {
                        result = n1;
                        break;
                    }
                    case 37: {
                        result = -n1;
                        break;
                    }
                    case 48: {
                        result = n1 + 1.0;
                        break;
                    }
                    case 47: {
                        result = n1 - 1.0;
                    }
                }
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_DOUBLE));
            }
        }
        throw new Exception("Unable to evaluate arithmetic prefix operator");
    }

    private EvaluationInfo evaluateArithmeticPostfixOperator(SourceExpression se) throws Exception {
        EvaluationInfo eval1 = this.evaluateSourceExpression_convertToEvaluationInfo(se.getFirstOperand());
        char sig = this.numericPromotion(eval1);
        switch (sig) {
            case 'I': {
                int result = eval1.getIntValue();
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_INT));
            }
            case 'J': {
                long result = eval1.getLongValue();
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_LONG));
            }
            case 'F': {
                float result = eval1.getFloatValue();
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_FLOAT));
            }
            case 'D': {
                double result = eval1.getDoubleValue();
                return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_DOUBLE));
            }
        }
        throw new Exception("Unable to evaluate postfix operator");
    }

    private Object evaluateClassLiteralOperators(SourceExpression se) throws Exception {
        String className1 = ((SourceHasType)se.getFirstOperand()).getSourceType().getName();
        DebugClassInfo c1 = this.findClass(className1);
        if (c1 != null) {
            return c1.getClassObject();
        }
        throw new Exception("Unable to class literal operator");
    }

    private Object evaluateWrapper(SourceExpression se) throws Exception {
        return this.evaluateSourceExpression(se.getFirstOperand());
    }

    private char comparisonPromotion(EvaluationInfo eval1, EvaluationInfo eval2) throws Exception {
        DebugClassInfo c1 = eval1.getClassInfo();
        DebugClassInfo c2 = eval2.getClassInfo();
        if (c1.isObject() || c1.isInterface() || c1.isArray()) {
            if (c2.isObject() || c2.isInterface() || c2.isArray()) {
                return 'L';
            }
            throw new Exception("Unable to evaluate comparison operator");
        }
        if (c2.isObject() || c2.isInterface() || c2.isArray()) {
            throw new Exception("Unable to evaluate comparison operator");
        }
        String class1 = c1.getName();
        String className2 = c2.getName();
        if (class1.equals(PRIMITIVE_TYPE_BOOLEAN)) {
            if (className2.equals(PRIMITIVE_TYPE_BOOLEAN)) {
                return 'Z';
            }
            throw new Exception("Unable to evaluate comparison operator");
        }
        if (className2.equals(PRIMITIVE_TYPE_BOOLEAN)) {
            throw new Exception("Unable to evaluate comparison operator");
        }
        return this.numericPromotion(eval1, class1, eval2, className2);
    }

    private char numericPromotion(EvaluationInfo eval1) throws Exception {
        DebugClassInfo c1;
        String class1 = "";
        if (eval1 != null && (c1 = eval1.getClassInfo()) != null) {
            class1 = c1.getName();
        }
        return this.numericPromotion(eval1, class1);
    }

    private char numericPromotion(EvaluationInfo eval1, String class1) throws Exception {
        if (class1.equals(PRIMITIVE_TYPE_DOUBLE)) {
            return 'D';
        }
        if (class1.equals(PRIMITIVE_TYPE_FLOAT)) {
            return 'F';
        }
        if (class1.equals(PRIMITIVE_TYPE_LONG)) {
            return 'J';
        }
        EvaluationInfo casted1 = (EvaluationInfo)this.performPrimitiveTypecast(eval1, eval1, class1, PRIMITIVE_TYPE_INT);
        if (casted1 != eval1) {
            eval1.copyFrom(casted1);
        }
        return 'I';
    }

    private char numericPromotion(EvaluationInfo eval1, EvaluationInfo eval2) throws Exception {
        DebugClassInfo c2;
        DebugClassInfo c1;
        String class1 = "";
        String className2 = "";
        if (eval1 != null && (c1 = eval1.getClassInfo()) != null) {
            class1 = c1.getName();
        }
        if (eval2 != null && (c2 = eval2.getClassInfo()) != null) {
            className2 = c2.getName();
        }
        return this.numericPromotion(eval1, class1, eval2, className2);
    }

    private char numericPromotion(EvaluationInfo eval1, String class1, EvaluationInfo eval2, String className2) throws Exception {
        EvaluationInfo casted1;
        if (class1.equals(PRIMITIVE_TYPE_DOUBLE)) {
            EvaluationInfo casted2 = (EvaluationInfo)this.performPrimitiveTypecast(eval2, eval2, className2, PRIMITIVE_TYPE_DOUBLE);
            if (casted2 != eval2) {
                eval2.copyFrom(casted2);
            }
            return 'D';
        }
        if (className2.equals(PRIMITIVE_TYPE_DOUBLE)) {
            EvaluationInfo casted12 = (EvaluationInfo)this.performPrimitiveTypecast(eval1, eval1, class1, PRIMITIVE_TYPE_DOUBLE);
            if (casted12 != eval1) {
                eval1.copyFrom(casted12);
            }
            return 'D';
        }
        if (class1.equals(PRIMITIVE_TYPE_FLOAT)) {
            EvaluationInfo casted2 = (EvaluationInfo)this.performPrimitiveTypecast(eval2, eval2, className2, PRIMITIVE_TYPE_FLOAT);
            if (casted2 != eval2) {
                eval2.copyFrom(casted2);
            }
            return 'F';
        }
        if (className2.equals(PRIMITIVE_TYPE_FLOAT)) {
            EvaluationInfo casted13 = (EvaluationInfo)this.performPrimitiveTypecast(eval1, eval1, class1, PRIMITIVE_TYPE_FLOAT);
            if (casted13 != eval1) {
                eval1.copyFrom(casted13);
            }
            return 'F';
        }
        if (class1.equals(PRIMITIVE_TYPE_LONG)) {
            EvaluationInfo casted2 = (EvaluationInfo)this.performPrimitiveTypecast(eval2, eval2, className2, PRIMITIVE_TYPE_LONG);
            if (casted2 != eval2) {
                eval2.copyFrom(casted2);
            }
            return 'J';
        }
        if (className2.equals(PRIMITIVE_TYPE_LONG)) {
            EvaluationInfo casted14 = (EvaluationInfo)this.performPrimitiveTypecast(eval1, eval1, class1, PRIMITIVE_TYPE_LONG);
            if (casted14 != eval1) {
                eval1.copyFrom(casted14);
            }
            return 'J';
        }
        EvaluationInfo casted2 = (EvaluationInfo)this.performPrimitiveTypecast(eval2, eval2, className2, PRIMITIVE_TYPE_INT);
        if (casted2 != eval2) {
            eval2.copyFrom(casted2);
        }
        if ((casted1 = (EvaluationInfo)this.performPrimitiveTypecast(eval1, eval1, class1, PRIMITIVE_TYPE_INT)) != eval1) {
            eval1.copyFrom(casted1);
        }
        return 'I';
    }

    private Object performPrimitiveTypecast(Object o1, EvaluationInfo eval1, String class1, String className2) throws Exception {
        if (class1.equals(className2)) {
            return o1;
        }
        if (className2.equals(PRIMITIVE_TYPE_BOOLEAN)) {
            throw new Exception("Unable to evaluate typecast");
        }
        if (className2.equals(PRIMITIVE_TYPE_BYTE)) {
            byte result = 0;
            if (class1.equals(PRIMITIVE_TYPE_CHAR)) {
                char n1 = eval1.getCharValue();
                result = (byte)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_SHORT)) {
                short n1 = eval1.getShortValue();
                result = (byte)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_INT)) {
                int n1 = eval1.getIntValue();
                result = (byte)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_LONG)) {
                long n1 = eval1.getLongValue();
                result = (byte)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_FLOAT)) {
                float n1 = eval1.getFloatValue();
                result = (byte)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_DOUBLE)) {
                double n1 = eval1.getDoubleValue();
                result = (byte)n1;
            } else {
                throw new Exception("Unable to evaluate typecast");
            }
            return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_BYTE));
        }
        if (className2.equals(PRIMITIVE_TYPE_CHAR)) {
            char result = '\u0000';
            if (class1.equals(PRIMITIVE_TYPE_BYTE)) {
                byte n1 = eval1.getByteValue();
                result = (char)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_SHORT)) {
                short n1 = eval1.getShortValue();
                result = (char)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_INT)) {
                int n1 = eval1.getIntValue();
                result = (char)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_LONG)) {
                long n1 = eval1.getLongValue();
                result = (char)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_FLOAT)) {
                float n1 = eval1.getFloatValue();
                result = (char)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_DOUBLE)) {
                double n1 = eval1.getDoubleValue();
                result = (char)n1;
            } else {
                throw new Exception("Unable to evaluate typecast");
            }
            return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_CHAR));
        }
        if (className2.equals(PRIMITIVE_TYPE_SHORT)) {
            short result = 0;
            if (class1.equals(PRIMITIVE_TYPE_BYTE)) {
                byte n1 = eval1.getByteValue();
                result = n1;
            } else if (class1.equals(PRIMITIVE_TYPE_CHAR)) {
                char n1 = eval1.getCharValue();
                result = (short)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_INT)) {
                int n1 = eval1.getIntValue();
                result = (short)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_LONG)) {
                long n1 = eval1.getLongValue();
                result = (short)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_FLOAT)) {
                float n1 = eval1.getFloatValue();
                result = (short)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_DOUBLE)) {
                double n1 = eval1.getDoubleValue();
                result = (short)n1;
            } else {
                throw new Exception("Unable to evaluate typecast");
            }
            return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_SHORT));
        }
        if (className2.equals(PRIMITIVE_TYPE_INT)) {
            int result = 0;
            if (class1.equals(PRIMITIVE_TYPE_BYTE)) {
                int n1;
                result = n1 = eval1.getByteValue();
            } else if (class1.equals(PRIMITIVE_TYPE_CHAR)) {
                int n1;
                result = n1 = eval1.getCharValue();
            } else if (class1.equals(PRIMITIVE_TYPE_SHORT)) {
                int n1;
                result = n1 = eval1.getShortValue();
            } else if (class1.equals(PRIMITIVE_TYPE_LONG)) {
                long n1 = eval1.getLongValue();
                result = (int)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_FLOAT)) {
                float n1 = eval1.getFloatValue();
                result = (int)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_DOUBLE)) {
                double n1 = eval1.getDoubleValue();
                result = (int)n1;
            } else {
                throw new Exception("Unable to evaluate typecast");
            }
            return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_INT));
        }
        if (className2.equals(PRIMITIVE_TYPE_LONG)) {
            long result = 0L;
            if (class1.equals(PRIMITIVE_TYPE_BYTE)) {
                byte n1 = eval1.getByteValue();
                result = n1;
            } else if (class1.equals(PRIMITIVE_TYPE_CHAR)) {
                char n1 = eval1.getCharValue();
                result = n1;
            } else if (class1.equals(PRIMITIVE_TYPE_SHORT)) {
                short n1 = eval1.getShortValue();
                result = n1;
            } else if (class1.equals(PRIMITIVE_TYPE_INT)) {
                int n1 = eval1.getIntValue();
                result = n1;
            } else if (class1.equals(PRIMITIVE_TYPE_FLOAT)) {
                float n1 = eval1.getFloatValue();
                result = (long)n1;
            } else if (class1.equals(PRIMITIVE_TYPE_DOUBLE)) {
                double n1 = eval1.getDoubleValue();
                result = (long)n1;
            } else {
                throw new Exception("Unable to evaluate typecast");
            }
            return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_LONG));
        }
        if (className2.equals(PRIMITIVE_TYPE_FLOAT)) {
            float result = 0.0f;
            if (class1.equals(PRIMITIVE_TYPE_BYTE)) {
                byte n1 = eval1.getByteValue();
                result = n1;
            } else if (class1.equals(PRIMITIVE_TYPE_CHAR)) {
                char n1 = eval1.getCharValue();
                result = n1;
            } else if (class1.equals(PRIMITIVE_TYPE_SHORT)) {
                short n1 = eval1.getShortValue();
                result = n1;
            } else if (class1.equals(PRIMITIVE_TYPE_INT)) {
                int n1 = eval1.getIntValue();
                result = n1;
            } else if (class1.equals(PRIMITIVE_TYPE_LONG)) {
                long n1 = eval1.getLongValue();
                result = n1;
            } else if (class1.equals(PRIMITIVE_TYPE_DOUBLE)) {
                double n1 = eval1.getDoubleValue();
                result = (float)n1;
            } else {
                throw new Exception("Unable to evaluate typecast");
            }
            return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_FLOAT));
        }
        if (className2.equals(PRIMITIVE_TYPE_DOUBLE)) {
            double result = 0.0;
            if (class1.equals(PRIMITIVE_TYPE_BYTE)) {
                byte n1 = eval1.getByteValue();
                result = n1;
            } else if (class1.equals(PRIMITIVE_TYPE_CHAR)) {
                char n1 = eval1.getCharValue();
                result = n1;
            } else if (class1.equals(PRIMITIVE_TYPE_SHORT)) {
                short n1 = eval1.getShortValue();
                result = n1;
            } else if (class1.equals(PRIMITIVE_TYPE_INT)) {
                int n1 = eval1.getIntValue();
                result = n1;
            } else if (class1.equals(PRIMITIVE_TYPE_LONG)) {
                long n1 = eval1.getLongValue();
                result = n1;
            } else if (class1.equals(PRIMITIVE_TYPE_FLOAT)) {
                float n1 = eval1.getFloatValue();
                result = n1;
            } else {
                throw new Exception("Unable to evaluate typecast");
            }
            return new EvaluationInfo(result, this.findClass(PRIMITIVE_TYPE_DOUBLE));
        }
        throw new Exception("Unable to evaluate typecast");
    }

    private boolean canPerformPrimitiveArgumentConversion(String className1, String className2) {
        if (className1.equals(className2)) {
            return true;
        }
        return className1.equals(PRIMITIVE_TYPE_BYTE) ? className2.equals(PRIMITIVE_TYPE_SHORT) || className2.equals(PRIMITIVE_TYPE_INT) || className2.equals(PRIMITIVE_TYPE_LONG) || className2.equals(PRIMITIVE_TYPE_FLOAT) || className2.equals(PRIMITIVE_TYPE_DOUBLE) : (className1.equals(PRIMITIVE_TYPE_SHORT) ? className2.equals(PRIMITIVE_TYPE_INT) || className2.equals(PRIMITIVE_TYPE_LONG) || className2.equals(PRIMITIVE_TYPE_FLOAT) || className2.equals(PRIMITIVE_TYPE_DOUBLE) : (className1.equals(PRIMITIVE_TYPE_CHAR) ? className2.equals(PRIMITIVE_TYPE_INT) || className2.equals(PRIMITIVE_TYPE_LONG) || className2.equals(PRIMITIVE_TYPE_FLOAT) || className2.equals(PRIMITIVE_TYPE_DOUBLE) : (className1.equals(PRIMITIVE_TYPE_INT) ? className2.equals(PRIMITIVE_TYPE_LONG) || className2.equals(PRIMITIVE_TYPE_FLOAT) || className2.equals(PRIMITIVE_TYPE_DOUBLE) : (className1.equals(PRIMITIVE_TYPE_LONG) ? className2.equals(PRIMITIVE_TYPE_FLOAT) || className2.equals(PRIMITIVE_TYPE_DOUBLE) : className1.equals(PRIMITIVE_TYPE_FLOAT) && className2.equals(PRIMITIVE_TYPE_DOUBLE)))));
    }

    private boolean canPerformReferenceArgumentConversion(EvaluationInfo eval1, DebugClassInfo class1, String className1, String className2) {
        if (className1.equals(className2)) {
            return true;
        }
        if (class1 == null) {
            class1 = this.findClass(className1);
        }
        DebugClassInfo class2 = this.findClass(className2);
        if (class1 != null && class2 != null) {
            className1 = class1.getName();
            className2 = class2.getName();
            if (eval1 != null && eval1.isNull() && (class2.isObject() || class2.isInterface() || class2.isArray())) {
                return true;
            }
            if (class1.isObject()) {
                if (class2.isObject()) {
                    if (className2.equals("java.lang.Object")) {
                        return true;
                    }
                    for (DebugClassInfo c = class1.getSuperClass(1); c != null; c = c.getSuperClass(1)) {
                        if (!c.getName().equals(className2)) continue;
                        return true;
                    }
                }
                if (class2.isInterface()) {
                    DebugClassInfo[] interfaces = class1.getInterfaces(-1);
                    for (int i = interfaces.length - 1; i >= 0; --i) {
                        if (!interfaces[i].getName().equals(className2)) continue;
                        return true;
                    }
                }
            } else if (class1.isInterface()) {
                if (class2.isInterface()) {
                    DebugClassInfo[] superInterfaces = class1.getInterfaces(-1);
                    for (int i = superInterfaces.length - 1; i >= 0; --i) {
                        if (!superInterfaces[i].getName().equals(className2)) continue;
                        return true;
                    }
                }
                if (className2.equals("java.lang.Object")) {
                    return true;
                }
            } else if (class1.isArray()) {
                String elementClassName2;
                String elementClassName1;
                if (className2.equals("java.lang.Object")) {
                    return true;
                }
                if (className2.equals("java.lang.Cloneable")) {
                    return true;
                }
                if (class2.isArray() && className1.endsWith("[]") && className2.endsWith("[]") && this.canPerformReferenceArgumentConversion(null, null, elementClassName1 = className1.substring(0, className1.length() - 2), elementClassName2 = className2.substring(0, className2.length() - 2))) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canPerformArgumentConversion(EvaluationInfo eval1, DebugClassInfo class1, String className1, String className2) {
        return JavaEvaluator.isPrimitiveType(className2) ? this.canPerformPrimitiveArgumentConversion(className1, className2) : this.canPerformReferenceArgumentConversion(eval1, class1, className1, className2);
    }

    private boolean isMethodMoreSpecific(DebugClassInfo class1, List parameters1, DebugClassInfo class2, List parameters2) {
        if (this.canPerformArgumentConversion(null, class1, class1.getName(), class2.getName())) {
            int size = parameters1.size();
            if (parameters2.size() == size) {
                for (int i = 0; i < size; ++i) {
                    String p2;
                    String p1 = (String)parameters1.get(i);
                    if (this.canPerformArgumentConversion(null, null, p1, p2 = (String)parameters2.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private DebugMethodInfo findMethod(DebugClassInfo clazz, String methodName, int access, EvaluationInfo[] arguments) {
        DebugMethodInfo possibleMethod = null;
        DebugClassInfo possibleMethodClass = null;
        ArrayList<String> possibleMethodParameters = null;
        boolean possibleMethodAmbiguous = false;
        int argumentsLength = arguments.length;
        while (clazz != null) {
            DebugMethodInfo[] methods = clazz.getMethods();
            for (int im = methods.length - 1; im >= 0; --im) {
                DebugMethodInfo method = methods[im];
                if (access != 0 && (method.getAccess() & access) == 0 || !methodName.equals(method.getNameWithoutClassOrSignature())) continue;
                String methodSignature = method.getParameterSignature();
                ArrayList<String> methodParameters = new ArrayList<String>();
                if (methodSignature.startsWith("(") && methodSignature.endsWith(")")) {
                    methodSignature = methodSignature.substring(1, methodSignature.length() - 1);
                }
                StringTokenizer st = new StringTokenizer(methodSignature, ",");
                while (st.hasMoreTokens()) {
                    methodParameters.add(st.nextToken().trim());
                }
                if (methodParameters.size() != argumentsLength) continue;
                boolean exactMatch = true;
                boolean possibleMatch = true;
                for (int i = 0; i < argumentsLength; ++i) {
                    String methodParameterType;
                    DebugClassInfo argumentClass = arguments[i].getClassInfo();
                    String argumentClassName = argumentClass.getName();
                    if (argumentClassName.equals(methodParameterType = (String)methodParameters.get(i))) continue;
                    exactMatch = false;
                    if (this.canPerformArgumentConversion(arguments[i], argumentClass, argumentClassName, methodParameterType)) continue;
                    possibleMatch = false;
                    break;
                }
                if (exactMatch) {
                    return method;
                }
                if (!possibleMatch) continue;
                if (possibleMethod == null) {
                    possibleMethod = method;
                    possibleMethodClass = clazz;
                    possibleMethodParameters = methodParameters;
                    possibleMethodAmbiguous = false;
                    continue;
                }
                if (((Object)methodParameters).equals(possibleMethodParameters)) continue;
                if (this.isMethodMoreSpecific(clazz, methodParameters, possibleMethodClass, possibleMethodParameters)) {
                    possibleMethod = method;
                    possibleMethodClass = clazz;
                    possibleMethodParameters = methodParameters;
                    possibleMethodAmbiguous = false;
                    continue;
                }
                if (this.isMethodMoreSpecific(possibleMethodClass, possibleMethodParameters, clazz, methodParameters)) continue;
                possibleMethodAmbiguous = true;
            }
            clazz = clazz.getSuperClass(1);
        }
        if (!possibleMethodAmbiguous) {
            return possibleMethod;
        }
        return null;
    }

    private EvaluationInfo convertToEvaluationInfo(Object o) throws Exception {
        DebugDataInfo data;
        if (o instanceof EvaluationInfo) {
            return (EvaluationInfo)o;
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.equals("null")) {
                return new EvaluationInfo("null", this.findClass("java.lang.Object"), null);
            }
            Object simpleResult = this.evaluateSimple(s);
            if (simpleResult != null) {
                o = simpleResult;
            }
            if (o instanceof EvaluationInfo) {
                return (EvaluationInfo)o;
            }
        }
        if ((data = JavaEvaluator.getDataInfo(o)) != null) {
            return new EvaluationInfo(data.getValue(), data.getClassInfo(), data);
        }
        throw new Exception("Unable to evaluate: " + o);
    }

    @Override
    protected DebugClassInfo findClass(String name) {
        DebugClassInfo clazz = super.findClass(name);
        if (clazz != null) {
            return clazz;
        }
        if (this.debugContext.vm == null && JavaEvaluator.isPrimitiveType(name)) {
            return DebugSharedPrimitives.getPrimitiveClassInfo(name);
        }
        return null;
    }

    @Override
    protected DebugClassInfo findPrimitiveIntClass() {
        return this.findClass(PRIMITIVE_TYPE_INT);
    }

    private boolean isStringClass(DebugClassInfo c) {
        return this.isStringClass(c.getName());
    }

    protected boolean isStringClass(String className) {
        return className.equals("java.lang.String");
    }

    protected DebugClassInfo findStringClass() {
        return this.findClass("java.lang.String");
    }
}

