/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.CursorListener;
import oracle.ide.ceditor.keymap.IdeEditorPane;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.Compiler;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverProvider;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutResetEvent;
import oracle.ide.layout.LayoutResetListener;
import oracle.ide.layout.Layouts;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Navigable;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.DebuggerAdapter;
import oracle.ide.runner.DebuggerExtender;
import oracle.ide.runner.DebuggerExtenderCallback;
import oracle.ide.runner.DebuggerInspectorExpressionProvider;
import oracle.ide.runner.DebuggerListener;
import oracle.ide.runner.DebuggerStartCallback;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.runner.DebuggerWindowProviderCallback;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.RunnableItem;
import oracle.ide.runner.Runner;
import oracle.ide.runner.SmartDataProvider;
import oracle.ide.runner.ToolTipExpressionProvider;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideimpl.runner.TerminateRunProcessButtons;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaPackage;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.Log;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.debugger.DebuggerConstants;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PackagedSource;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugCapabilities;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.java.explorer.ClassElement;
import oracle.jdevimpl.java.explorer.FieldElement;
import oracle.jdevimpl.runner.RunManager;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BreakpointDetails;
import oracle.jdevimpl.runner.debug.BreakpointsWindow;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettingsPanel2;
import oracle.jdevimpl.runner.debug.BytecodeFileSystemHelper;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.ClassesWindowSettings;
import oracle.jdevimpl.runner.debug.ClassesWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;
import oracle.jdevimpl.runner.debug.DebugConfigurationPanel;
import oracle.jdevimpl.runner.debug.DebugContext;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebugWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.DebuggingListener;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluationInfo;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.ExpressionProvider;
import oracle.jdevimpl.runner.debug.ExtenderCallback;
import oracle.jdevimpl.runner.debug.ExtenderManager;
import oracle.jdevimpl.runner.debug.HeapWindow;
import oracle.jdevimpl.runner.debug.HeapWindowSettings;
import oracle.jdevimpl.runner.debug.HeapWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.InspectorWindow;
import oracle.jdevimpl.runner.debug.InspectorWindowSettings;
import oracle.jdevimpl.runner.debug.InspectorWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.JavaEvaluator;
import oracle.jdevimpl.runner.debug.JavaExpressionProvider;
import oracle.jdevimpl.runner.debug.LocalsWindow;
import oracle.jdevimpl.runner.debug.LocalsWindowSettings;
import oracle.jdevimpl.runner.debug.LocalsWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.MonitorsWindow;
import oracle.jdevimpl.runner.debug.MonitorsWindowDataSettingsPanel;
import oracle.jdevimpl.runner.debug.MonitorsWindowSettings;
import oracle.jdevimpl.runner.debug.MonitorsWindowThreadsSettingsPanel;
import oracle.jdevimpl.runner.debug.ObjectPreferences;
import oracle.jdevimpl.runner.debug.PackageFileLineCheck;
import oracle.jdevimpl.runner.debug.PackageFileLineChecker;
import oracle.jdevimpl.runner.debug.RemoteDebugSettingsPanel;
import oracle.jdevimpl.runner.debug.RunWhilePaused;
import oracle.jdevimpl.runner.debug.SharedActions;
import oracle.jdevimpl.runner.debug.SmartJava;
import oracle.jdevimpl.runner.debug.SmartWindow;
import oracle.jdevimpl.runner.debug.SmartWindowSettings;
import oracle.jdevimpl.runner.debug.SmartWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.SourceIcon;
import oracle.jdevimpl.runner.debug.StackWindow;
import oracle.jdevimpl.runner.debug.StackWindowSettings;
import oracle.jdevimpl.runner.debug.StackWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.ThreadsWindow;
import oracle.jdevimpl.runner.debug.ThreadsWindowSettings;
import oracle.jdevimpl.runner.debug.ThreadsWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.ToolTipEvaluator;
import oracle.jdevimpl.runner.debug.ToolTipSettingsPanel;
import oracle.jdevimpl.runner.debug.TracingPanel;
import oracle.jdevimpl.runner.debug.Utils;
import oracle.jdevimpl.runner.debug.WatchWindow;
import oracle.jdevimpl.runner.debug.WatchWindowSettings;
import oracle.jdevimpl.runner.debug.WatchWindowSettingsPanel;
import oracle.jdevimpl.runner.debug.WindowManager;
import oracle.jdevimpl.runner.run.JRunner;
import oracle.jdevimpl.runner.run.RunArb;

public final class JDebugger
extends Debugger
implements ActiveViewListener,
ContextMenuListener,
Controller,
EditorListener,
GutterClickListener,
MenuListener,
Observer,
CursorListener,
Addin,
ShutdownHook,
IdeListener,
ViewSelectionListener,
BuildSystemListener,
HoverProvider {
    public static final Log logger = new Log("JDebugger");
    private static JDebugger instance;
    private DebugDockableFactory debugDockableFactory;
    private IdeLayout debugLayout;
    private DebugWindowSettings dbgSettings;
    private static ContextMenu contextMenu;
    static URL lastSavedFile;
    private Workspace activeWorkspace;
    private Project activeProject;
    private View activeView;
    private CodeEditor activeCodeEditor;
    private List[] activeBreakpoints = new List[0];
    private InspectorWindow activeInspector;
    private DebuggingProcess activeDebuggingProcess;
    private volatile int duringClassRedefinition;
    private boolean isToolTipProvider;
    private ToolTipEvaluator toolTipEvaluator;
    private Map<DebugBreakpoint, Breakpoint> breakpointForDebugBreakpoint;
    private List<DebuggingProcess> debuggingProcesses;
    private List<DebuggingProcess> debuggingProcessesConnecting;
    private List<DebuggingListener> debuggingListeners;
    private Map<DebuggingProcess, DebugBreakpoint> temporaryBreakpoints;
    private List<DebuggerListener> debuggerListeners = new ArrayList<DebuggerListener>();
    private WindowManager windowManager = new WindowManager();
    private ExtenderManager extenderManager = ExtenderManager.getInstance();
    private List<Breakpoint> cachedNewBreakpoints;
    private Boolean cacheNewBreakpoints = Boolean.FALSE;
    private BreakpointsWindow breakpointsWindow;
    private ThreadsWindow threadsWindow;
    private StackWindow stackWindow;
    private SmartWindow smartWindow;
    private LocalsWindow localsWindow;
    private WatchWindow watchWindow;
    private ClassesWindow classesWindow;
    private HeapWindow heapWindow;
    private MonitorsWindow monitorsWindow;
    private List inspectorWindows;
    private ObjectPreferences objectPreferences;
    private static JMenu viewDebuggerSubMenu;
    private static boolean viewDebuggerSubMenuBuilt;
    private static JMenu runMenu;
    private static boolean debugMenuBuilt;
    private static JMenu debugContextSubMenu;
    private static boolean debugContextSubMenuAdded;
    private static boolean debugContextSubMenuBuilt;
    private static List<SmartDataProvider> smartDataProviders;
    private static List<ToolTipExpressionProvider> toolTipExpressionProviders;
    private static List<DebuggerInspectorExpressionProvider> inspectorExpressionProviders;
    private static List<IdeAction> viewDebuggerActions;
    private static IdeAction actionViewBreakpoints;
    private static IdeAction actionViewThreads;
    private static IdeAction actionViewStack;
    private static IdeAction actionViewSmart;
    private static IdeAction actionViewLocals;
    private static IdeAction actionViewWatches;
    private static IdeAction actionViewClasses;
    private static IdeAction actionViewHeap;
    private static IdeAction actionViewMonitors;
    private static IdeAction actionViewLog;
    private static IdeAction actionDebugProject;
    private static IdeAction actionEmpty;
    private static IdeAction actionDebugSelection;
    private static IdeAction actionDebugToggleBreakpoint;
    private static IdeAction actionDebugPause;
    private static IdeAction actionDebugResume;
    private static IdeAction actionDebugDetach;
    private static IdeAction actionDebugReset;
    private static IdeAction actionDebugStepOver;
    private static IdeAction actionDebugStepOverBC;
    private static IdeAction actionDebugStepInto;
    private static IdeAction actionDebugStepIntoBC;
    private static IdeAction actionDebugStepOut;
    private static IdeAction actionDebugStepToEndOfMethod;
    private static IdeAction actionDebugContinueStep;
    private static IdeAction actionDebugRunToCursor;
    private static IdeAction actionDebugStepIntoMethod;
    private static IdeAction actionDebugSetNextStatement;
    private static IdeAction actionDebugShowIP;
    private static IdeAction actionDebugGC;
    private static IdeAction actionContextMenuDebug;
    private static final int DEBUG_CMD_MRU_CONFIGURATION_ID;
    private static IdeAction actionMRUConfigurationMenuDebug;
    @Deprecated
    public static Component debugContextMenu;
    private static IdeAction actionNavigatorStopListening;
    private static IdeAction actionNavigatorDetachDebugger;
    private static JMenuItem menuitemNavigatorStopListening;
    private static JMenuItem menuitemNavigatorDetachDebugger;
    private static IdeAction actionCodeEditorGutterToggleBreakpoint;
    private static IdeAction actionCodeEditorToggleWatchpoint;
    private static IdeAction actionCodeEditorGutterEnableBreakpoint;
    private static IdeAction actionCodeEditorGutterDisableBreakpoint;
    private static IdeAction actionCodeEditorGutterEditBreakpoint;
    private static IdeAction actionCodeEditorWatch;
    private static IdeAction actionCodeEditorInspect;
    private static JMenuItem menuitemCodeEditorGutterToggleBreakpoint;
    private static JMenuItem menuitemCodeEditorToggleWatchpoint;
    private static JMenuItem menuitemCodeEditorGutterEnableBreakpoint;
    private static JMenuItem menuitemCodeEditorGutterDisableBreakpoint;
    private static JMenuItem menuitemCodeEditorGutterEditBreakpoint;
    private static JMenuItem menuitemCodeEditorRunToCursor;
    private static JMenuItem menuitemCodeEditorStepIntoMethod;
    private static JMenuItem menuitemCodeEditorSetNextStatement;
    private static JMenuItem menuitemCodeEditorWatch;
    private static JMenuItem menuitemCodeEditorInspect;
    private static IdeAction actionStructureCreateWatchpoint;
    private static JMenuItem menuitemStructureCreateWatchpoint;
    private static IdeAction actionLogWindowCancelDebugConnection;
    private static IdeAction actionLogWindowShowIP;
    private static IdeAction actionLogWindowResume;
    private static IdeAction actionLogWindowStepOver;
    private static IdeAction actionLogWindowStepInto;
    private static IdeAction actionLogWindowStepOut;
    private static IdeAction actionLogWindowStepToEndOfMethod;
    private static IdeAction actionLogWindowStepOverBC;
    private static IdeAction actionLogWindowStepIntoBC;
    private static IdeAction actionLogWindowPause;
    private static IdeAction actionLogWindowGC;
    private static IdeAction actionLogWindowReset;
    private static JMenuItem menuitemLogWindowCancelDebugConnection;
    private static final int VIEW_BREAKPOINTS_CMD_ID;
    private static final int VIEW_THREADS_CMD_ID;
    private static final int VIEW_STACK_CMD_ID;
    private static final int VIEW_SMART_CMD_ID;
    private static final int VIEW_LOCALS_CMD_ID;
    private static final int VIEW_WATCHES_CMD_ID;
    private static final int VIEW_CLASSES_CMD_ID;
    private static final int VIEW_HEAP_CMD_ID;
    private static final int VIEW_MONITORS_CMD_ID;
    private static final int VIEW_LOG_CMD_ID;
    private static final String DEBUG_PROJECT_CMD_PREFIX = "DebugProjectCommand";
    private static final int DEBUG_PROJECT_CMD_ID;
    private static int[] debugProjectCmdIds;
    private static final int DEBUG_SELECTION_CMD_ID;
    private static final int DEBUG_PAUSE_CMD_ID;
    private static final int DEBUG_RESUME_CMD_ID;
    private static final int DEBUG_DETACH_CMD_ID;
    private static final int DEBUG_RESET_CMD_ID;
    private static final int DEBUG_STEPOVER_CMD_ID;
    private static final int DEBUG_STEPOVERBC_CMD_ID;
    private static final int DEBUG_STEPINTO_CMD_ID;
    private static final int DEBUG_STEPINTOBC_CMD_ID;
    private static final int DEBUG_STEPOUT_CMD_ID;
    private static final int DEBUG_STEPTOENDOFMETHOD_CMD_ID;
    private static final int DEBUG_CONTINUESTEP_CMD_ID;
    private static final int DEBUG_RUNTOCURSOR_CMD_ID;
    private static final int DEBUG_STEPINTOMETHOD_CMD_ID;
    private static final int DEBUG_SETNEXTSTATEMENT_CMD_ID;
    private static final int DEBUG_SHOWIP_CMD_ID;
    private static final int DEBUG_GC_CMD_ID;
    private static final int DEBUG_POP_1_STACK_FRAME_CMD_ID;
    private static final int CONTEXTMENU_DEBUG_CMD_ID;
    private static final int NAVIGATOR_STOPLISTENING_CMD_ID;
    private static final int NAVIGATOR_DETACHDEBUGGER_CMD_ID;
    private static final int CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID;
    private static final int CODE_EDITOR_WATCH_CMD_ID;
    private static final int CODE_EDITOR_INSPECT_CMD_ID;
    private static final int STRUCTURE_CREATEWATCHPOINT_CMD_ID;
    private static final int LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID;
    static final String ACTION_OWNER = "Debugger.actionOwner";
    static final String DEBUGGER_ID = "Debugger";
    static final String DEBUG_LAYOUT_KEY = "debugLayout";
    volatile boolean firstDebuggingProcessCreated = true;

    public JDebugger() throws SingletonClassException {
        if (instance != null) {
            throw new SingletonClassException("oracle.jdevimpl.runner.debug.JDebugger");
        }
        instance = this;
    }

    public static JDebugger getInstance() {
        return instance;
    }

    public static int getContextMenuDebugCommandID() {
        return CONTEXTMENU_DEBUG_CMD_ID;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.isLocalAction() && (cmdId == DEBUG_SHOWIP_CMD_ID || cmdId == DEBUG_STEPOVER_CMD_ID || cmdId == DEBUG_STEPINTO_CMD_ID || cmdId == DEBUG_STEPOUT_CMD_ID || cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID || cmdId == DEBUG_STEPOVERBC_CMD_ID || cmdId == DEBUG_STEPINTOBC_CMD_ID || cmdId == DEBUG_RESUME_CMD_ID || cmdId == DEBUG_PAUSE_CMD_ID || cmdId == DEBUG_GC_CMD_ID || cmdId == DEBUG_RESET_CMD_ID)) {
            this.doLogWindowAction(context, cmdId);
            return true;
        }
        if (cmdId == VIEW_BREAKPOINTS_CMD_ID) {
            this.viewBreakpoints();
            return true;
        }
        if (cmdId == VIEW_THREADS_CMD_ID) {
            DockUtil.showDockableWindow((DockableView)this.getThreadsWindow(true));
            return true;
        }
        if (cmdId == VIEW_STACK_CMD_ID) {
            DockUtil.showDockableWindow((DockableView)this.getStackWindow(true));
            return true;
        }
        if (cmdId == VIEW_SMART_CMD_ID) {
            DockUtil.showDockableWindow((DockableView)this.getSmartWindow(true));
            return true;
        }
        if (cmdId == VIEW_LOCALS_CMD_ID) {
            DockUtil.showDockableWindow((DockableView)this.getLocalsWindow(true));
            return true;
        }
        if (cmdId == VIEW_WATCHES_CMD_ID) {
            this.viewWatches();
            return true;
        }
        if (cmdId == VIEW_CLASSES_CMD_ID) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DockUtil.showDockableWindow((DockableView)JDebugger.this.getClassesWindow(true));
                }
            };
            SwingUtilities.invokeLater(runnable);
            return true;
        }
        if (cmdId == VIEW_HEAP_CMD_ID) {
            this.viewHeap();
            return true;
        }
        if (cmdId == VIEW_MONITORS_CMD_ID) {
            this.viewMonitors();
            return true;
        }
        if (cmdId == VIEW_LOG_CMD_ID) {
            this.viewLog();
            return true;
        }
        if (cmdId == DEBUG_PROJECT_CMD_ID) {
            this.startMruProcess(context);
            return true;
        }
        if (cmdId == DEBUG_CMD_MRU_CONFIGURATION_ID) {
            this.startMruProcess(context);
            return true;
        }
        if (RunManager.arrayContains(debugProjectCmdIds, cmdId)) {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)action.getValue("UserData"));
            RunConfigurations.setActiveRunConfiguration(this.activeProject, runConfiguration);
            this.startProcess(null, true);
            return true;
        }
        if (cmdId == DEBUG_SELECTION_CMD_ID) {
            Node contextNode = RunProcess.getContextNodeForRun((Context)context);
            if (contextNode != null && !(contextNode instanceof Workspace) && !(contextNode instanceof Project)) {
                context.setProperty(RunProcess.RUN_PROCESS_DO_NOT_CONSIDER_DEFAULT, (Object)Boolean.TRUE);
            }
            this.startProcess(context, false);
            return true;
        }
        if (cmdId == DEBUG_PAUSE_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.pause();
            }
            return true;
        }
        if (cmdId == DEBUG_RESUME_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.resume();
            }
            return true;
        }
        if (cmdId == DEBUG_DETACH_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.detach();
            }
            return true;
        }
        if (cmdId == DEBUG_RESET_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.terminate();
            }
            return true;
        }
        if (cmdId == DEBUG_STEPOVER_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepOver(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_STEPOVERBC_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepOverBC(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_STEPINTO_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepInto(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_STEPINTOBC_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepIntoBC(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_STEPOUT_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepOut(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepToEndOfMethod(JDebugger.getEventTime(context));
            }
            return true;
        }
        if (cmdId == DEBUG_CONTINUESTEP_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.continueStep();
            }
            return true;
        }
        if (cmdId == DEBUG_RUNTOCURSOR_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.runToCursor(context);
            }
            return true;
        }
        if (cmdId == DEBUG_STEPINTOMETHOD_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.stepIntoMethod(context);
            }
            return true;
        }
        if (cmdId == DEBUG_POP_1_STACK_FRAME_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.pop1StackFrame(context);
            }
            return true;
        }
        if (cmdId == DEBUG_SETNEXTSTATEMENT_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.setNextStatement(context);
            }
            return true;
        }
        if (cmdId == DEBUG_SHOWIP_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.showIP();
            }
            return true;
        }
        if (cmdId == DEBUG_GC_CMD_ID) {
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.gc();
            }
            return true;
        }
        if (cmdId == CONTEXTMENU_DEBUG_CMD_ID) {
            context = (Context)action.getValue("UserData");
            action.putValue("UserData", null);
            Node contextNode = RunProcess.getContextNodeForRun((Context)context);
            if (contextNode != null && !(contextNode instanceof Workspace) && !(contextNode instanceof Project)) {
                context.setProperty(RunProcess.RUN_PROCESS_DO_NOT_CONSIDER_DEFAULT, (Object)Boolean.TRUE);
            }
            this.startProcess(context, false);
            return true;
        }
        if (cmdId == NAVIGATOR_STOPLISTENING_CMD_ID) {
            this.stopListening(context);
            return true;
        }
        if (cmdId == NAVIGATOR_DETACHDEBUGGER_CMD_ID) {
            this.detachDebugger(context);
            return true;
        }
        if (cmdId == DebuggerConstants.TOGGLEBREAKPOINT_CMD_ID) {
            return this.toggleBreakpointFromCodeEditor(context, null);
        }
        if (cmdId == CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID) {
            this.toggleWatchpointFromCodeEditor(context, null);
            return true;
        }
        if (cmdId == DebuggerConstants.ENABLEBREAKPOINT_CMD_ID) {
            return this.enableBreakpointFromCodeEditor(context, null);
        }
        if (cmdId == DebuggerConstants.DISABLEBREAKPOINT_CMD_ID) {
            return this.disableBreakpointFromCodeEditor(context, null);
        }
        if (cmdId == DebuggerConstants.EDITBREAKPOINT_CMD_ID) {
            return this.editBreakpointFromCodeEditor(context, null);
        }
        if (cmdId == CODE_EDITOR_WATCH_CMD_ID) {
            this.watchFromCodeEditor(context);
            return true;
        }
        if (cmdId == CODE_EDITOR_INSPECT_CMD_ID) {
            this.inspectFromCodeEditor(context);
            return true;
        }
        if (cmdId == STRUCTURE_CREATEWATCHPOINT_CMD_ID) {
            this.createWatchpointFromStructure(context, null);
            return true;
        }
        if (cmdId == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID) {
            this.doLogWindowAction(context, cmdId);
            return true;
        }
        return cmdId == 5 || cmdId == 6 || cmdId == 18 || cmdId == 17 || cmdId == 78 || cmdId == 19;
    }

    private void startMruProcess(Context context) {
        context = JRunner.prepareMruProcess(context);
        this.startProcess(context, true);
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (action.isLocalAction() && (cmdId == DEBUG_SHOWIP_CMD_ID || cmdId == DEBUG_STEPOVER_CMD_ID || cmdId == DEBUG_STEPINTO_CMD_ID || cmdId == DEBUG_STEPOUT_CMD_ID || cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID || cmdId == DEBUG_STEPOVERBC_CMD_ID || cmdId == DEBUG_STEPINTOBC_CMD_ID || cmdId == DEBUG_RESUME_CMD_ID || cmdId == DEBUG_PAUSE_CMD_ID || cmdId == DEBUG_GC_CMD_ID || cmdId == DEBUG_RESET_CMD_ID)) {
            action.setEnabled(this.canDoLogWindowAction(context, cmdId));
            return true;
        }
        if (cmdId == DEBUG_PROJECT_CMD_ID) {
            this.updateDebugProjectAction(action, context);
            return true;
        }
        if (cmdId == DEBUG_CMD_MRU_CONFIGURATION_ID) {
            this.updateDebugMRUConfigurationAction(action, context);
            return true;
        }
        if (RunManager.arrayContains(debugProjectCmdIds, cmdId)) {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)action.getValue("UserData"));
            action.setState(false);
            return true;
        }
        if (cmdId == DEBUG_SELECTION_CMD_ID) {
            this.updateDebugSelectionAction(action, context);
            return true;
        }
        if (cmdId == DEBUG_PAUSE_CMD_ID) {
            this.setActionName(action, DbgArb.getString(13));
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canPause());
            return true;
        }
        if (cmdId == DEBUG_RESUME_CMD_ID) {
            this.setActionName(action, DbgArb.getString(15));
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canResume());
            return true;
        }
        if (cmdId == DEBUG_DETACH_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canDetach());
            return true;
        }
        if (cmdId == DEBUG_RESET_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canTerminate());
            return true;
        }
        if (cmdId == DEBUG_STEPOVER_CMD_ID || cmdId == DEBUG_STEPOVERBC_CMD_ID) {
            if (cmdId == DEBUG_STEPOVER_CMD_ID) {
                this.setActionName(action, DbgArb.getString(20));
            } else {
                this.setActionName(action, DbgArb.getString(22));
            }
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepOver());
            return true;
        }
        if (cmdId == DEBUG_STEPINTO_CMD_ID || cmdId == DEBUG_STEPINTOBC_CMD_ID) {
            if (cmdId == DEBUG_STEPINTO_CMD_ID) {
                this.setActionName(action, DbgArb.getString(24));
            } else {
                this.setActionName(action, DbgArb.getString(26));
            }
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepInto());
            return true;
        }
        if (cmdId == DEBUG_STEPOUT_CMD_ID) {
            this.setActionName(action, DbgArb.getString(28));
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepOut());
            return true;
        }
        if (cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID) {
            this.setActionName(action, DbgArb.getString(30));
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepToEndOfMethod());
            return true;
        }
        if (cmdId == DEBUG_CONTINUESTEP_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canContinueStep());
            return true;
        }
        if (cmdId == DEBUG_RUNTOCURSOR_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canRunToCursor(context));
            return true;
        }
        if (cmdId == DEBUG_STEPINTOMETHOD_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canStepIntoMethod(context));
            return true;
        }
        if (cmdId == DEBUG_SETNEXTSTATEMENT_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canSetNextStatement(context));
            return true;
        }
        if (cmdId == DEBUG_POP_1_STACK_FRAME_CMD_ID) {
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canPop1StackFrame(context));
            return true;
        }
        if (cmdId == DEBUG_SHOWIP_CMD_ID) {
            this.setActionName(action, DbgArb.getString(43));
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canShowIP());
            return true;
        }
        if (cmdId == DEBUG_GC_CMD_ID) {
            this.setActionName(action, DbgArb.getString(45));
            action.setEnabled(this.activeDebuggingProcess != null && this.activeDebuggingProcess.canGC());
            return true;
        }
        if (cmdId == VIEW_BREAKPOINTS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == VIEW_THREADS_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_CLASSES_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_STACK_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_SMART_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_LOCALS_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_WATCHES_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == VIEW_HEAP_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows() && this.canShowHeapWindow());
            return true;
        }
        if (cmdId == VIEW_MONITORS_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows() && this.canShowMonitorsWindow());
            return true;
        }
        if (cmdId == VIEW_LOG_CMD_ID) {
            action.setEnabled(this.canShowDebuggingWindows());
            return true;
        }
        if (cmdId == CONTEXTMENU_DEBUG_CMD_ID) {
            context = (Context)action.getValue("UserData");
            this.updateContextMenuDebugAction(action, context);
            return true;
        }
        if (cmdId == NAVIGATOR_STOPLISTENING_CMD_ID) {
            action.setEnabled(this.canStopListening(context));
            return true;
        }
        if (cmdId == NAVIGATOR_DETACHDEBUGGER_CMD_ID) {
            action.setEnabled(this.canDetachDebugger(context));
            return true;
        }
        if (cmdId == DebuggerConstants.TOGGLEBREAKPOINT_CMD_ID) {
            return this.toggleBreakpointFromCodeEditor(context, action);
        }
        if (cmdId == CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID) {
            action.setEnabled(this.toggleWatchpointFromCodeEditor(context, action));
            return true;
        }
        if (cmdId == DebuggerConstants.ENABLEBREAKPOINT_CMD_ID) {
            return this.enableBreakpointFromCodeEditor(context, action);
        }
        if (cmdId == DebuggerConstants.DISABLEBREAKPOINT_CMD_ID) {
            return this.disableBreakpointFromCodeEditor(context, action);
        }
        if (cmdId == DebuggerConstants.EDITBREAKPOINT_CMD_ID) {
            return this.editBreakpointFromCodeEditor(context, action);
        }
        if (cmdId == CODE_EDITOR_WATCH_CMD_ID || cmdId == CODE_EDITOR_INSPECT_CMD_ID) {
            boolean enable;
            boolean bl = enable = this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped();
            if (enable) {
                enable = Source.getCodeEditorFromContext(context) != null;
            }
            action.setEnabled(enable);
            return true;
        }
        if (cmdId == STRUCTURE_CREATEWATCHPOINT_CMD_ID) {
            action.setEnabled(this.createWatchpointFromStructure(context, action));
            return true;
        }
        if (cmdId == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID) {
            action.setEnabled(this.canDoLogWindowAction(context, cmdId));
            return true;
        }
        if (cmdId == 5 || cmdId == 6 || cmdId == 18 || cmdId == 17 || cmdId == 78 || cmdId == 19) {
            action.setEnabled(false);
            return true;
        }
        return false;
    }

    private void setActionName(IdeAction action, String actionName) {
        if (this.activeDebuggingProcess != null) {
            Object[] strs = new String[]{actionName, this.activeDebuggingProcess.getShortLabel()};
            action.setName(DbgArb.format(907, strs));
        } else {
            action.setName(actionName);
        }
    }

    public void menuWillShow(ContextMenu popup) {
        DebuggingProcess connectingDebuggingProcess;
        Context context = popup.getContext();
        View view = context.getView();
        if (view instanceof NavigatorWindow) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            this.insertRunnableItems(popup, context);
            if (actionNavigatorStopListening != null) {
                this.update(actionNavigatorStopListening, context);
                if (actionNavigatorStopListening.isEnabled()) {
                    if (menuitemNavigatorStopListening == null) {
                        menuitemNavigatorStopListening = popup.createMenuItem((ToggleAction)actionNavigatorStopListening);
                    }
                    popup.add((Component)menuitemNavigatorStopListening, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
            if (actionNavigatorDetachDebugger != null) {
                this.update(actionNavigatorDetachDebugger, context);
                if (actionNavigatorDetachDebugger.isEnabled()) {
                    if (menuitemNavigatorDetachDebugger == null) {
                        menuitemNavigatorDetachDebugger = popup.createMenuItem((ToggleAction)actionNavigatorDetachDebugger);
                    }
                    popup.add((Component)menuitemNavigatorDetachDebugger, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
                }
            }
        } else if (view instanceof Editor) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            this.insertRunnableItems(popup, context);
            this.update(actionCodeEditorToggleWatchpoint, context);
            if (actionCodeEditorToggleWatchpoint.isEnabled()) {
                if (menuitemCodeEditorToggleWatchpoint == null) {
                    menuitemCodeEditorToggleWatchpoint = popup.createMenuItem((ToggleAction)actionCodeEditorToggleWatchpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT);
                }
                popup.add((Component)menuitemCodeEditorToggleWatchpoint, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
            this.update(actionDebugRunToCursor, context);
            if (actionDebugRunToCursor.isEnabled()) {
                if (menuitemCodeEditorRunToCursor == null) {
                    menuitemCodeEditorRunToCursor = popup.createMenuItem((ToggleAction)actionDebugRunToCursor, JDeveloperMenuConstants.WEIGHT_DEBUG_RUN_TO_CURSOR);
                }
                popup.add((Component)menuitemCodeEditorRunToCursor, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
            this.update(actionDebugStepIntoMethod, context);
            if (actionDebugStepIntoMethod.isEnabled()) {
                if (menuitemCodeEditorStepIntoMethod == null) {
                    menuitemCodeEditorStepIntoMethod = popup.createMenuItem((ToggleAction)actionDebugStepIntoMethod, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_INTO_METHOD_AT_CURSOR);
                }
                popup.add((Component)menuitemCodeEditorStepIntoMethod, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
            this.update(actionDebugSetNextStatement, context);
            if (actionDebugSetNextStatement.isEnabled()) {
                if (menuitemCodeEditorSetNextStatement == null) {
                    menuitemCodeEditorSetNextStatement = popup.createMenuItem((ToggleAction)actionDebugSetNextStatement, JDeveloperMenuConstants.WEIGHT_DEBUG_SET_NEXT_STATEMENT);
                }
                popup.add((Component)menuitemCodeEditorSetNextStatement, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
            this.update(actionCodeEditorWatch, context);
            if (actionCodeEditorWatch.isEnabled()) {
                if (menuitemCodeEditorWatch == null) {
                    menuitemCodeEditorWatch = popup.createMenuItem((ToggleAction)actionCodeEditorWatch, JDeveloperMenuConstants.WEIGHT_DEBUG_VIEW_WATCH);
                }
                popup.add((Component)menuitemCodeEditorWatch, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
            this.update(actionCodeEditorInspect, context);
            if (actionCodeEditorInspect.isEnabled()) {
                if (menuitemCodeEditorInspect == null) {
                    menuitemCodeEditorInspect = popup.createMenuItem((ToggleAction)actionCodeEditorInspect, JDeveloperMenuConstants.WEIGHT_DEBUG_VIEW_INSPECT);
                }
                popup.add((Component)menuitemCodeEditorInspect, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
        } else if (view instanceof CodeEditorGutter.GutterView) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            if (CodeEditorGutter.isMarkDroppingDown((Context)context)) {
                return;
            }
            this.update(actionCodeEditorGutterToggleBreakpoint, context);
            if (actionCodeEditorGutterToggleBreakpoint.isEnabled()) {
                if (menuitemCodeEditorGutterToggleBreakpoint == null) {
                    menuitemCodeEditorGutterToggleBreakpoint = popup.createMenuItem((ToggleAction)actionCodeEditorGutterToggleBreakpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT);
                }
                popup.add((Component)menuitemCodeEditorGutterToggleBreakpoint, 3.0f);
            }
            this.update(actionCodeEditorToggleWatchpoint, context);
            if (actionCodeEditorToggleWatchpoint.isEnabled()) {
                if (menuitemCodeEditorToggleWatchpoint == null) {
                    menuitemCodeEditorToggleWatchpoint = popup.createMenuItem((ToggleAction)actionCodeEditorToggleWatchpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT);
                }
                popup.add((Component)menuitemCodeEditorToggleWatchpoint, 3.0f);
            }
            this.update(actionCodeEditorGutterEnableBreakpoint, context);
            if (actionCodeEditorGutterEnableBreakpoint.isEnabled()) {
                if (menuitemCodeEditorGutterEnableBreakpoint == null) {
                    menuitemCodeEditorGutterEnableBreakpoint = popup.createMenuItem((ToggleAction)actionCodeEditorGutterEnableBreakpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_ENABLE_BREAKPOINT);
                }
                popup.add((Component)menuitemCodeEditorGutterEnableBreakpoint, 3.0f);
            }
            this.update(actionCodeEditorGutterDisableBreakpoint, context);
            if (actionCodeEditorGutterDisableBreakpoint.isEnabled()) {
                if (menuitemCodeEditorGutterDisableBreakpoint == null) {
                    menuitemCodeEditorGutterDisableBreakpoint = popup.createMenuItem((ToggleAction)actionCodeEditorGutterDisableBreakpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_ENABLE_BREAKPOINT);
                }
                popup.add((Component)menuitemCodeEditorGutterDisableBreakpoint, 3.0f);
            }
            this.update(actionCodeEditorGutterEditBreakpoint, context);
            if (actionCodeEditorGutterEditBreakpoint.isEnabled()) {
                if (menuitemCodeEditorGutterEditBreakpoint == null) {
                    menuitemCodeEditorGutterEditBreakpoint = popup.createMenuItem((ToggleAction)actionCodeEditorGutterEditBreakpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_EDIT_BREAKPOINT);
                }
                popup.add((Component)menuitemCodeEditorGutterEditBreakpoint, 3.0f);
            }
        } else if (view instanceof ExplorerWindow) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            this.update(actionStructureCreateWatchpoint, context);
            if (actionStructureCreateWatchpoint.isEnabled()) {
                if (menuitemStructureCreateWatchpoint == null) {
                    menuitemStructureCreateWatchpoint = popup.createMenuItem((ToggleAction)actionStructureCreateWatchpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT);
                }
                popup.add((Component)menuitemStructureCreateWatchpoint, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
        } else if (view instanceof RunLogPage && (connectingDebuggingProcess = this.findDebuggingProcess((RunLogPage)view, true)) != null) {
            this.update(actionLogWindowCancelDebugConnection, context);
            if (actionLogWindowCancelDebugConnection.isEnabled()) {
                if (menuitemLogWindowCancelDebugConnection == null) {
                    menuitemLogWindowCancelDebugConnection = popup.createMenuItem((ToggleAction)actionLogWindowCancelDebugConnection);
                }
                popup.add((Component)menuitemLogWindowCancelDebugConnection, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            }
        }
    }

    public void menuWillHide(ContextMenu popup) {
        RunnableItem.reset();
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void insertRunnableItems(ContextMenu popup, Context context) {
        if (actionContextMenuDebug == null) {
            actionContextMenuDebug = IdeAction.get((int)CONTEXTMENU_DEBUG_CMD_ID, null, (String)DbgArb.getString(103), null, (Integer)DbgArb.getInteger(106), (Icon)OracleIcons.getIcon((String)"debug.png"), null, (boolean)false);
            actionContextMenuDebug.putValue("NoCtxName", (Object)DbgArb.getString(103));
            actionContextMenuDebug.addController((Controller)this);
        }
        actionContextMenuDebug.putValue("UserData", (Object)context);
        this.update(actionContextMenuDebug, context);
        if (actionContextMenuDebug.isEnabled()) {
            MnemonicSolver.MenuLabel mlabel;
            JMenuItem menuitemContextMenuDebug = popup.createMenuItem((ToggleAction)actionContextMenuDebug, JDeveloperMenuConstants.WEIGHT_DEBUG_DEBUG_FILE);
            popup.add((Component)menuitemContextMenuDebug, JDeveloperMenuConstants.SECTION_DEBUG_CTXT_MENU);
            MnemonicSolver solver = popup.getMnemonicSolver();
            if (solver != null && (mlabel = solver.findMenuLabel(menuitemContextMenuDebug)) != null) {
                mlabel.setText(DbgArb.getString(103));
            }
        } else {
            actionContextMenuDebug.putValue("UserData", null);
        }
    }

    public void editorOpened(Editor editor) {
        if (editor instanceof CodeEditor) {
            BasicEditorPane basicEditorPane;
            CodeEditor ceditor = (CodeEditor)editor;
            SourceIcon.gutterCreated(ceditor);
            CodeEditorGutter gutter = ceditor.getGutter();
            gutter.addGutterClickListener((GutterClickListener)this);
            if (this.isToolTipProvider && (basicEditorPane = ceditor.getFocusedEditorPane()) instanceof IdeEditorPane) {
                ((IdeEditorPane)basicEditorPane).getHoverRegistry().registerProvider((HoverProvider)this);
            }
        }
    }

    public void editorActivated(Editor editor) {
    }

    public void editorDeactivated(Editor editor) {
    }

    public void editorClosed(Editor editor) {
        if (editor instanceof CodeEditor) {
            BasicEditorPane basicEditorPane;
            CodeEditor ceditor = (CodeEditor)editor;
            SourceIcon.gutterDestroyed(ceditor);
            CodeEditorGutter gutter = ceditor.getGutter();
            gutter.removeGutterClickListener((GutterClickListener)this);
            if (this.isToolTipProvider && (basicEditorPane = ceditor.getFocusedEditorPane()) instanceof IdeEditorPane) {
                ((IdeEditorPane)basicEditorPane).getHoverRegistry().unregisterProvider((HoverProvider)this);
            }
        }
    }

    public void lineClicked(Gutter gutter, int clickedLine, MouseEvent event) {
        CodeEditorGutter codeEditorGutter;
        Context context;
        if (gutter instanceof CodeEditorGutter && (context = (codeEditorGutter = (CodeEditorGutter)gutter).getContext()) != null) {
            this.toggleBreakpoint(context, codeEditorGutter.getCodeEditor(), clickedLine);
        }
    }

    @Deprecated
    public String getToolTipText(CodeEditor codeEditor, MouseEvent mouseEvent, int offset) {
        if (this.shouldProvideToolTip()) {
            if (this.toolTipEvaluator == null) {
                this.toolTipEvaluator = new ToolTipEvaluator(this);
            }
            String toolTip = this.toolTipEvaluator.getToolTip(codeEditor, offset);
            return toolTip;
        }
        return null;
    }

    public void activeViewChanged(ActiveViewEvent e) {
        if (this.activeView != null) {
            this.activeView.removeViewSelectionListener((ViewSelectionListener)this);
        }
        if (this.activeCodeEditor != null) {
            this.activeCodeEditor.removeCursorListener((CursorListener)this);
        }
        if (this.activeInspector != null) {
            this.activeInspector.inspectorActiveView(false);
        }
        this.activeView = Ide.getMainWindow().getLastActiveView();
        Context context = this.activeView.getContext();
        this.activeCodeEditor = Source.getCodeEditorFromContext(context);
        InspectorWindow inspectorWindow = this.activeInspector = this.activeView instanceof InspectorWindow ? (InspectorWindow)this.activeView : null;
        if (this.activeView != null) {
            this.activeView.addViewSelectionListener((ViewSelectionListener)this);
        }
        if (this.activeCodeEditor != null) {
            this.activeCodeEditor.addCursorListener((CursorListener)this);
        }
        if (this.activeInspector != null) {
            this.activeInspector.inspectorActiveView(true);
        }
        this.checkCommandsBecauseActiveViewChanged();
    }

    public void viewSelectionChanged(ViewSelectionEvent e) {
        this.checkCommandsBecauseViewSelectionChanged();
    }

    public void update(final Object observed, final UpdateMessage change) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int messageID = change.getMessageID();
                if (observed == Ide.getSystem()) {
                    if (messageID == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                        JDebugger.this.activeProjectChanged();
                    }
                } else if (observed instanceof Workspace) {
                    if (messageID == UpdateMessage.OBJECT_RENAMED) {
                        Breakpoint.breakpointOwnerRenamed(change);
                    }
                } else if (observed instanceof Project && messageID == UpdateMessage.OBJECT_RENAMED) {
                    Breakpoint.breakpointOwnerRenamed(change);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
        Ide.removeIdeListener((IdeListener)this);
        Breakpoint.loadBreakpoints();
        JDebugger.registerPanels();
        SourceIcon.createHighlightStyles();
        this.extenderManager.breakpointsLoaded();
        this.activeViewChanged(null);
        this.activeProjectChanged();
        Ide.getSystem().attach((Observer)this);
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            compiler.addBuildSystemListener((BuildSystemListener)this);
        }
        if (NavigatorManager.getWorkspaceNavigatorManager() != null) {
            NavigatorManager.getWorkspaceNavigatorManager().addContextMenuListener((ContextMenuListener)this, null);
        }
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        LogManager.getLogManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        CodeEditorGutter.getGutterContextMenu().addContextMenuListener((ContextMenuListener)this);
        ExplorerManager.getExplorerManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        Project.addProjectChangeListener((String)"", (ProjectChangeListener)new ProjectChangeListener(){

            public void projectOpened(Project project) {
                if (project == JDebugger.this.activeProject) {
                    this.updateNowOrLater();
                }
            }

            public void projectPropertiesChanged(ProjectChangeEvent e) {
                if (e.getProject() == JDebugger.this.activeProject) {
                    this.updateNowOrLater();
                }
            }

            private void updateNowOrLater() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        JDebugger.this.updateRunConfigurationList();
                        JDebugger.this.tracingChanged();
                        JDebugger.this.checkCommandsBecauseActiveProjectChanged();
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
    }

    public void mainWindowClosing(IdeEvent e) {
        Ide.getSystem().detach((Observer)this);
        Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            compiler.removeBuildSystemListener((BuildSystemListener)this);
        }
        NavigatorManager.getWorkspaceNavigatorManager().removeContextMenuListener((ContextMenuListener)this);
        EditorManager.getEditorManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
        LogManager.getLogManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
        CodeEditorGutter.getGutterContextMenu().removeContextMenuListener((ContextMenuListener)this);
        ExplorerManager.getExplorerManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
    }

    public void cursorUpdate(CodeEditor codeEditor) {
        this.checkCommandsBecauseCursorMoved();
    }

    public void initialize() {
        Layouts.getLayouts().addLayoutResetListener(new LayoutResetListener(){

            public void beforeLayoutActivation(LayoutResetEvent e) {
                if (!Debugger.getDebugger().isDebugging()) {
                    return;
                }
                LogManager logManager = LogManager.getLogManager();
                if (logManager.isLogVisible()) {
                    return;
                }
                logManager.showLog();
            }
        });
        Debugger.setDebugger((Debugger)this);
        this.initializeIDESettings();
        this.dbgSettings = DebugWindowSettings.getInstance();
        this.dbgSettings.addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent e) {
                if (Utils.structureReallyChanged(e)) {
                    JDebugger.this.debugWindowSettingsChanged();
                }
            }
        });
        this.makeActions();
        this.declareShortcuts();
        this.addViewDebuggerSubMenu();
        runMenu = MenuManager.getJMenu((String)"Run");
        runMenu.addMenuListener(this);
        this.debugDockableFactory = new DebugDockableFactory(this);
        this.getDebugLayout();
        EditorManager.getEditorManager().addEditorListener((EditorListener)this);
        Ide.addIdeListener((IdeListener)this);
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        int i;
        EditorManager.getEditorManager().removeEditorListener((EditorListener)this);
        if (this.debuggingListeners != null) {
            for (i = this.debuggingListeners.size() - 1; i >= 0; --i) {
                DebuggingListener debuggingListener = this.debuggingListeners.get(i);
                debuggingListener.stopListening();
            }
        }
        if (this.debuggingProcesses != null) {
            for (i = this.debuggingProcesses.size() - 1; i >= 0; --i) {
                DebuggingProcess debuggingProcess = this.debuggingProcesses.get(i);
                debuggingProcess.terminate();
            }
        }
        if (this.objectPreferences != null) {
            this.objectPreferences.saveChangedSettings();
        }
        Breakpoint.saveBreakpoints();
        this.windowManager.shutdownWindows();
    }

    public void buildWillStart(Context context) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDebugger.this.updateDebugActions();
            }
        });
    }

    public void buildFinished(int errorCount, int warningCount, int infoCount) {
        new Thread("JDebuggerWaitForCompiler"){

            @Override
            public void run() {
                try {
                    UnifiedBuildSystem.getInstance().join(0L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JDebugger.this.updateDebugActions();
                    }
                });
            }
        }.start();
    }

    public void cleanWillStart(Context context) {
    }

    public void cleanFinished(Context context) {
    }

    public JMenu getDebugMenu() {
        return runMenu;
    }

    public synchronized ContextMenu getContextMenu() {
        if (contextMenu == null) {
            contextMenu = new ContextMenu();
        }
        return contextMenu;
    }

    public JMenu getViewMenu() {
        if (!viewDebuggerSubMenuBuilt) {
            this.buildViewDebuggerSubMenu();
        }
        return viewDebuggerSubMenu;
    }

    public boolean isDebugging() {
        if (this.debuggingProcesses != null) {
            return !this.debuggingProcesses.isEmpty();
        }
        return false;
    }

    public void startDebugger(Context context, DebuggerStartCallback callBack) {
        DebuggingProcess pr = new DebuggingProcess(context, callBack);
        pr.start();
    }

    @Deprecated
    public void redefineClasses(Map compilerMap) {
        this.redefineClasses(null, compilerMap);
    }

    public void redefineClasses(Project project, Map compilerMap) {
        final HashMap nameToGuts = new HashMap();
        nameToGuts.putAll(compilerMap);
        ++this.duringClassRedefinition;
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(final DebuggingProcess debuggingProcess, boolean live) {
                if (live) {
                    debuggingProcess.redefineClasses(nameToGuts);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JDebugger.this.getStackWindow(true).everythingChanged();
                            Breakpoint.updateBreakpointIcons(Breakpoint.getBreakpoints(debuggingProcess.getWorkspace(), debuggingProcess.getProject()));
                            JDebugger.this.updateBreakpointsWindow();
                        }
                    });
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                JDebugger.this.duringClassRedefinition--;
            }
        };
        this.pauseAndInvoke(runWhilePaused, runOnceLater);
    }

    public boolean isStackTraceLine(String line) {
        try {
            int openParen = line.indexOf(40);
            if (openParen != -1) {
                int closeParen;
                int space = line.lastIndexOf(32, openParen);
                int dot = line.lastIndexOf(46, openParen);
                int colon = line.indexOf(58, openParen);
                if (space != -1 && dot != -1 && colon != -1 && dot > space + 1 && colon > openParen + 1 && (closeParen = line.indexOf(41, colon)) != -1 && closeParen > colon + 1) {
                    int lineNumber = Integer.parseInt(line.substring(colon + 1, closeParen));
                    String classname = line.substring(space + 1, dot);
                    String filename = line.substring(openParen + 1, colon);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean showSourceFileForStackTraceLine(Workspace workspace, Project project, String stackTraceLine) {
        try {
            int openParen = stackTraceLine.indexOf(40);
            if (openParen != -1) {
                int closeParen;
                int space = stackTraceLine.lastIndexOf(32, openParen);
                int dot = stackTraceLine.lastIndexOf(46, openParen);
                int colon = stackTraceLine.indexOf(58, openParen);
                if (space != -1 && dot != -1 && colon != -1 && dot > space + 1 && colon > openParen + 1 && (closeParen = stackTraceLine.indexOf(41, colon)) != -1 && closeParen > colon + 1) {
                    int lineNumber = Integer.parseInt(stackTraceLine.substring(colon + 1, closeParen));
                    String classname = stackTraceLine.substring(space + 1, dot);
                    String filename = stackTraceLine.substring(openParen + 1, colon);
                    int lastDot = classname.lastIndexOf(46);
                    String pkg = lastDot != -1 ? classname.substring(0, lastDot) : "";
                    return Source.showSourceFile(workspace, project, pkg, classname, filename, lineNumber, false, null);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public URL parseStackTraceLine(Workspace workspace, Project project, String stackTraceLine) {
        try {
            int openParen = stackTraceLine.indexOf(40);
            if (openParen != -1) {
                int closeParen;
                int space = stackTraceLine.lastIndexOf(32, openParen);
                int dot = stackTraceLine.lastIndexOf(46, openParen);
                int colon = stackTraceLine.indexOf(58, openParen);
                if (space != -1 && dot != -1 && colon != -1 && dot > space + 1 && colon > openParen + 1 && (closeParen = stackTraceLine.indexOf(41, colon)) != -1 && closeParen > colon + 1) {
                    int lineNumber = Integer.parseInt(stackTraceLine.substring(colon + 1, closeParen));
                    String classname = stackTraceLine.substring(space + 1, dot);
                    String filename = stackTraceLine.substring(openParen + 1, colon);
                    int lastDot = classname.lastIndexOf(46);
                    String pkg = lastDot != -1 ? classname.substring(0, lastDot) : "";
                    URL url = Source.findSourceFile(workspace, project, pkg, filename);
                    URL urlWithLine = URLFactory.replaceRefPart((URL)url, (String)Integer.toString(lineNumber));
                    return urlWithLine;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public boolean showSourceFileForStackTraceLine(Workspace workspace, Project project, URL urlWithLine) {
        int lineNumber = 0;
        try {
            String ref = urlWithLine.getRef();
            lineNumber = Integer.parseInt(ref);
        }
        catch (Exception e) {
            // empty catch block
        }
        URL url = URLFactory.replaceRefPart((URL)urlWithLine, null);
        return Source.showSourceFile(workspace, project, url, lineNumber, true);
    }

    public void addSmartDataProvider(SmartDataProvider smartDataProvider) {
        smartDataProviders.add(smartDataProvider);
    }

    public void removeSmartDataProvider(SmartDataProvider smartDataProvider) {
        smartDataProviders.remove(smartDataProvider);
    }

    public void addToolTipExpressionProvider(ToolTipExpressionProvider toolTipExpressionProvider) {
        toolTipExpressionProviders.add(toolTipExpressionProvider);
    }

    public void removeToolTipExpressionProvider(ToolTipExpressionProvider toolTipExpressionProvider) {
        toolTipExpressionProviders.remove(toolTipExpressionProvider);
    }

    public void addInspectorExpressionProvider(DebuggerInspectorExpressionProvider expressionProvider) {
        inspectorExpressionProviders.add(expressionProvider);
    }

    public void removeInspectorExpressionProvider(DebuggerInspectorExpressionProvider expressionProvider) {
        inspectorExpressionProviders.remove(expressionProvider);
    }

    public void addRunAndDebugToContextMenu(ContextMenu popup, Context context) {
        JRunner.getInstance().insertRunnableItems(popup, context);
        this.insertRunnableItems(popup, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDebuggerListener(DebuggerAdapter debuggerListener) {
        List<DebuggerListener> list = this.debuggerListeners;
        synchronized (list) {
            if (!this.debuggerListeners.contains(debuggerListener)) {
                this.debuggerListeners.add((DebuggerListener)debuggerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDebuggerListener(DebuggerAdapter debuggerListener) {
        List<DebuggerListener> list = this.debuggerListeners;
        synchronized (list) {
            this.debuggerListeners.remove(debuggerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerWindowProviderCallback addDebuggerWindowProvider(DebuggerWindowProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Need a valid DebuggerWindowProvider argument");
        }
        List<DebuggerListener> list = this.debuggerListeners;
        synchronized (list) {
            provider.setDebuggerDockableLayoutPrefix(DEBUGGER_ID);
            if (!this.debuggerListeners.contains(provider)) {
                this.debuggerListeners.add((DebuggerListener)provider);
            }
        }
        return this.windowManager.addDebuggerWindowProvider(provider, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDebuggerWindowProvider(DebuggerWindowProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Need a valid DebuggerWindowProvider argument");
        }
        List<DebuggerListener> list = this.debuggerListeners;
        synchronized (list) {
            this.debuggerListeners.remove(provider);
        }
        this.windowManager.removeDebuggerWindowProvider(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggerExtenderCallback addDebuggerExtender(DebuggerExtender extender) {
        if (extender == null) {
            throw new IllegalArgumentException("Need a valid DebuggerExtender argument");
        }
        List<DebuggerListener> list = this.debuggerListeners;
        synchronized (list) {
            if (!this.debuggerListeners.contains(extender)) {
                this.debuggerListeners.add((DebuggerListener)extender);
            }
        }
        ExtenderCallback callback = this.extenderManager.addExtender(extender);
        if (Breakpoint.breakpointsLoaded()) {
            extender.breakpointsLoaded();
        }
        return callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDebuggerExtender(DebuggerExtender extender) {
        if (extender == null) {
            throw new IllegalArgumentException("Need a valid DebuggerExtender argument");
        }
        List<DebuggerListener> list = this.debuggerListeners;
        synchronized (list) {
            this.debuggerListeners.remove(extender);
        }
        this.extenderManager.removeExtender(extender);
    }

    BreakpointDetails debuggeeStoppedAtBreakpoint(DebuggingProcess debuggingProcess, DebugBreakpoint dbp) {
        BreakpointDetails details = new BreakpointDetails();
        details.setDebugBreakpoint(dbp);
        Breakpoint bp = this.findBreakpoint(dbp);
        details.setBreakpoint(bp);
        if (bp != null) {
            this.extenderManager.debuggeeStoppedAtBreakpoint(debuggingProcess.getContext(), details);
        }
        return details;
    }

    boolean canDebuggerExtenderShowBreakpointLocation(Breakpoint bp) {
        DebuggingProcess process = this.activeDebuggingProcess;
        Context context = process != null ? process.getContext() : null;
        return this.extenderManager.canShowBreakpointLocation(context, bp);
    }

    boolean debuggerExtenderShowBreakpointLocation(Breakpoint bp) {
        DebuggingProcess process = this.activeDebuggingProcess;
        Context context = process != null ? process.getContext() : null;
        return this.extenderManager.showBreakpointLocation(context, bp);
    }

    void setDebuggerExtendersEvaluator(DebuggingProcess process, Evaluator evaluator) {
        Breakpoint bp;
        DebugVirtualMachine vm = process.vm;
        if (vm != null && (bp = this.findBreakpoint(vm.getCurrentBreakpoint())) != null && this.extenderManager.isExtenderBreakpoint(bp)) {
            this.extenderManager.setEvaluator(process, bp, evaluator);
            this.checkCommandsBecauseDebuggingProcessStateChanged(process);
        }
    }

    private DebugBreakpoint doSteppingAction(DebuggingProcess process, BreakpointDetails breakpointDetails, ExtenderManager.ExtenderAction action) {
        DebugVirtualMachine vm = process.vm;
        if (vm != null && this.extenderManager.stoppedAtExtenderBreakpoint(breakpointDetails)) {
            DebugBreakpoint dbp;
            Breakpoint tempBreakpoint = null;
            switch (action) {
                case STEP_OVER: {
                    tempBreakpoint = this.extenderManager.stepOver(process, breakpointDetails);
                    break;
                }
                case STEP_INTO: {
                    tempBreakpoint = this.extenderManager.stepInto(process, breakpointDetails);
                    break;
                }
                case STEP_OUT: {
                    tempBreakpoint = this.extenderManager.stepOut(process, breakpointDetails);
                    break;
                }
                case STEP_TO_END_OF_METHOD: {
                    tempBreakpoint = this.extenderManager.stepToEndOfMethod(process, breakpointDetails);
                    break;
                }
                case RUN_TO_CURSOR: {
                    tempBreakpoint = this.extenderManager.runToCursor(process, breakpointDetails);
                }
            }
            if (tempBreakpoint != null && (dbp = tempBreakpoint.putBreakpoint(process, true)) != null) {
                this.tempBreakpointHasBeenPut(process, tempBreakpoint, dbp);
                return dbp;
            }
        }
        this.clearTempBreakpoint(process);
        return null;
    }

    DebugBreakpoint debuggerExtenderStepOver(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.doSteppingAction(process, breakpointDetails, ExtenderManager.ExtenderAction.STEP_OVER);
    }

    DebugBreakpoint debuggerExtenderStepInto(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.doSteppingAction(process, breakpointDetails, ExtenderManager.ExtenderAction.STEP_INTO);
    }

    DebugBreakpoint debuggerExtenderStepOut(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.doSteppingAction(process, breakpointDetails, ExtenderManager.ExtenderAction.STEP_OUT);
    }

    DebugBreakpoint debuggerExtenderStepToEndOfMethod(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.doSteppingAction(process, breakpointDetails, ExtenderManager.ExtenderAction.STEP_TO_END_OF_METHOD);
    }

    DebugBreakpoint debuggerExtenderRunToCursor(DebuggingProcess process, BreakpointDetails breakpointDetails) {
        return this.doSteppingAction(process, breakpointDetails, ExtenderManager.ExtenderAction.RUN_TO_CURSOR);
    }

    public Object evaluateNumericExpression(String expression) {
        JavaEvaluator evaluator = new JavaEvaluator(new DebugContext(), false);
        Object o = evaluator.evaluate(expression);
        if (o instanceof EvaluationInfo) {
            EvaluationInfo eval = (EvaluationInfo)o;
            return eval.getWrappedValue();
        }
        return null;
    }

    public void addObjectPreferencesExpression(String className, String expression, boolean select) {
        if (expression != null && expression.length() > 0) {
            this.getObjectPreferences();
            this.objectPreferences.addValueExpressionSuggestion(className, expression);
            if (select) {
                this.objectPreferences.setValueExpression(className, expression);
            }
        }
    }

    public void addObjectPreferencesExpansion(String className, String expansion, boolean select) {
        if (expansion != null && expansion.length() > 0) {
            this.getObjectPreferences();
            this.objectPreferences.addExpandExpressionSuggestion(className, expansion);
            if (select) {
                this.objectPreferences.setExpandExpression(className, expansion);
            }
        }
    }

    public void addObjectPreferencesHideAllFields(String className) {
        if (className != null && className.length() > 0) {
            this.getObjectPreferences();
            this.objectPreferences.addHideAllFields(className);
        }
    }

    public void addObjectPreferencesHideField(String className, String fieldName) {
        if (className != null && className.length() > 0 && fieldName != null && fieldName.length() > 0) {
            this.getObjectPreferences();
            this.objectPreferences.addHideField(className, fieldName);
        }
    }

    public void addObjectPreferencesIcon(String className, String iconName) {
        if (className != null && className.length() > 0 && iconName != null && iconName.length() > 0) {
            this.getObjectPreferences();
            this.objectPreferences.addIcon(className, iconName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DebuggerListener[] getDebuggerListeners() {
        List<DebuggerListener> list = this.debuggerListeners;
        synchronized (list) {
            return this.debuggerListeners.toArray(new DebuggerListener[this.debuggerListeners.size()]);
        }
    }

    synchronized IdeLayout getDebugLayout() {
        if (this.debugLayout == null) {
            ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
            URL url = er.getSystemDirectory("oracle.ide");
            String filename = url.getPath() + "Debugging" + ".layout";
            this.debugLayout = new IdeLayout(URLFactory.newFileURL((String)filename), DbgArb.getString(553), OracleIcons.getIcon((String)"debug.png"));
            this.debugLayout.setProperty(DEBUG_LAYOUT_KEY, Boolean.toString(true));
            Layouts.getLayouts().add((Element)this.debugLayout);
        }
        return this.debugLayout;
    }

    private void makeActions() {
        String category = DbgArb.getString(0);
        SharedActions shared = SharedActions.getInstance();
        this.getActionEmpty();
        this.getActionDebugProject();
        actionDebugSelection = IdeAction.get((int)DEBUG_SELECTION_CMD_ID, null, (String)DbgArb.getString(7), (String)category, (Integer)DbgArb.getInteger(11), (ArrayResourceBundle)DbgArb.getInstance(), (int)12, null, (boolean)false);
        actionDebugSelection.putValue("NoCtxName", (Object)DbgArb.getString(7));
        actionDebugSelection.addController((Controller)this);
        actionDebugToggleBreakpoint = IdeAction.get((int)DebuggerConstants.TOGGLEBREAKPOINT_CMD_ID, null, (String)DbgArb.getString(117), (String)category, (Integer)DbgArb.getInteger(118), (Icon)OracleIcons.getIcon((String)"unverifiedbreakpoint.png"), null, (boolean)false);
        actionDebugToggleBreakpoint.addController((Controller)this);
        actionDebugPause = shared.getSuspendAction();
        actionDebugResume = shared.getResumeAction();
        actionDebugDetach = shared.getDetachAction();
        actionDebugReset = shared.getTerminateAction();
        this.getActionDebugStepOver();
        this.getActionDebugStepOverBC();
        this.getActionDebugStepInto();
        this.getActionDebugStepIntoBC();
        this.getActionDebugStepOut();
        this.getActionDebugStepToEndOfMethod();
        actionDebugContinueStep = IdeAction.get((int)DEBUG_CONTINUESTEP_CMD_ID, null, (String)DbgArb.getString(32), (String)category, (Integer)DbgArb.getInteger(33), (ArrayResourceBundle)DbgArb.getInstance(), (int)34, null, (boolean)false);
        actionDebugContinueStep.addController((Controller)this);
        actionDebugRunToCursor = IdeAction.get((int)DEBUG_RUNTOCURSOR_CMD_ID, null, (String)DbgArb.getString(35), (String)category, (Integer)DbgArb.getInteger(36), (Icon)OracleIcons.getIcon((String)"debugger/rnto_crs.gif"), null, (boolean)false);
        actionDebugRunToCursor.addController((Controller)this);
        actionDebugStepIntoMethod = IdeAction.get((int)DEBUG_STEPINTOMETHOD_CMD_ID, null, (String)DbgArb.getString(37), (String)category, (Integer)DbgArb.getInteger(38), (ArrayResourceBundle)DbgArb.getInstance(), (int)39, null, (boolean)false);
        actionDebugStepIntoMethod.addController((Controller)this);
        actionDebugSetNextStatement = IdeAction.get((int)DEBUG_POP_1_STACK_FRAME_CMD_ID, null, (String)DbgArb.getString(898), (String)category, (Integer)DbgArb.getInteger(899), (ArrayResourceBundle)DbgArb.getInstance(), (int)900, null, (boolean)false);
        actionDebugSetNextStatement.addController((Controller)this);
        this.getActionDebugShowIP();
        actionDebugGC = shared.getGcAction();
        shared.addController(this);
        String ACTION_CATEGORY_VIEW = IdeMainWindow.ACTION_CATEGORY_VIEW;
        actionViewBreakpoints = IdeAction.get((int)VIEW_BREAKPOINTS_CMD_ID, null, (String)DbgArb.getString(49), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(50), (Icon)OracleIcons.getIcon((String)"debugger/breakpoints.png"), null, (boolean)true);
        actionViewBreakpoints.addController((Controller)this);
        actionViewThreads = IdeAction.get((int)VIEW_THREADS_CMD_ID, null, (String)DbgArb.getString(51), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(52), (Icon)OracleIcons.getIcon((String)"debugger/threads.png"), null, (boolean)false);
        actionViewThreads.addController((Controller)this);
        actionViewStack = IdeAction.get((int)VIEW_STACK_CMD_ID, null, (String)DbgArb.getString(53), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(54), (Icon)OracleIcons.getIcon((String)"debugger/stack.png"), null, (boolean)false);
        actionViewStack.addController((Controller)this);
        actionViewSmart = IdeAction.get((int)VIEW_SMART_CMD_ID, null, (String)DbgArb.getString(57), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(58), (Icon)OracleIcons.getIcon((String)"debugger/smrtdata.png"), null, (boolean)false);
        actionViewSmart.addController((Controller)this);
        actionViewLocals = IdeAction.get((int)VIEW_LOCALS_CMD_ID, null, (String)DbgArb.getString(59), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(60), (Icon)OracleIcons.getIcon((String)"field.png"), null, (boolean)false);
        actionViewLocals.addController((Controller)this);
        actionViewWatches = IdeAction.get((int)VIEW_WATCHES_CMD_ID, null, (String)DbgArb.getString(61), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(62), (Icon)OracleIcons.getIcon((String)"watch.png"), null, (boolean)false);
        actionViewWatches.addController((Controller)this);
        actionViewClasses = IdeAction.get((int)VIEW_CLASSES_CMD_ID, null, (String)DbgArb.getString(63), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(64), (Icon)OracleIcons.getIcon((String)"class.png"), null, (boolean)false);
        actionViewClasses.addController((Controller)this);
        actionViewHeap = IdeAction.get((int)VIEW_HEAP_CMD_ID, null, (String)DbgArb.getString(65), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(66), (Icon)OracleIcons.getIcon((String)"debugger/heap.png"), null, (boolean)false);
        actionViewHeap.addController((Controller)this);
        actionViewMonitors = IdeAction.get((int)VIEW_MONITORS_CMD_ID, null, (String)DbgArb.getString(67), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(68), (Icon)OracleIcons.getIcon((String)"debugger/monitors.png"), null, (boolean)false);
        actionViewMonitors.addController((Controller)this);
        actionViewLog = IdeAction.get((int)VIEW_LOG_CMD_ID, null, (String)DbgArb.getString(69), (String)ACTION_CATEGORY_VIEW, (Integer)DbgArb.getInteger(70), (Icon)OracleIcons.getIcon((String)"log.png"), null, (boolean)false);
        actionViewLog.addController((Controller)this);
        viewDebuggerActions.add(actionViewStack);
        viewDebuggerActions.add(actionViewSmart);
        viewDebuggerActions.add(actionViewLocals);
        viewDebuggerActions.add(actionViewWatches);
        viewDebuggerActions.add(actionViewLog);
        if (!Product.isRaptor()) {
            viewDebuggerActions.add(actionViewThreads);
            viewDebuggerActions.add(actionViewClasses);
            viewDebuggerActions.add(actionViewHeap);
            viewDebuggerActions.add(actionViewMonitors);
        }
        Collections.sort(viewDebuggerActions, new Comparator<IdeAction>(){

            @Override
            public int compare(IdeAction o1, IdeAction o2) {
                String name1 = (String)o1.getValue("Name");
                String name2 = (String)o2.getValue("Name");
                return name1.compareTo(name2);
            }
        });
        actionCodeEditorGutterToggleBreakpoint = IdeAction.get((int)DebuggerConstants.TOGGLEBREAKPOINT_CMD_ID, null, (String)DbgArb.getString(117), (String)category, (Integer)DbgArb.getInteger(118), (Icon)OracleIcons.getIcon((String)"unverifiedbreakpoint.png"), null, (boolean)false);
        actionCodeEditorGutterToggleBreakpoint.addController((Controller)this);
        actionCodeEditorToggleWatchpoint = IdeAction.get((int)CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID, null, (String)DbgArb.getString(119), (String)category, (Integer)DbgArb.getInteger(120), (Icon)OracleIcons.getIcon((String)"debugger/enabledwatchpoint.gif"), null, (boolean)false);
        actionCodeEditorToggleWatchpoint.addController((Controller)this);
        actionCodeEditorGutterEnableBreakpoint = IdeAction.get((int)DebuggerConstants.ENABLEBREAKPOINT_CMD_ID, null, (String)DbgArb.getString(121), (String)category, (Integer)DbgArb.getInteger(123), (Icon)OracleIcons.getIcon((String)"unverifiedbreakpoint.png"), null, (boolean)false);
        actionCodeEditorGutterEnableBreakpoint.addController((Controller)this);
        actionCodeEditorGutterDisableBreakpoint = IdeAction.get((int)DebuggerConstants.DISABLEBREAKPOINT_CMD_ID, null, (String)DbgArb.getString(124), (String)category, (Integer)DbgArb.getInteger(126), (Icon)OracleIcons.getIcon((String)"disabledbreakpoint.png"), null, (boolean)false);
        actionCodeEditorGutterDisableBreakpoint.addController((Controller)this);
        actionCodeEditorGutterEditBreakpoint = IdeAction.get((int)DebuggerConstants.EDITBREAKPOINT_CMD_ID, null, (String)DbgArb.getString(127), (String)category, (Integer)DbgArb.getInteger(129), (Icon)OracleIcons.getIcon((String)"edit.png"), null, (boolean)false);
        actionCodeEditorGutterEditBreakpoint.addController((Controller)this);
        actionCodeEditorWatch = IdeAction.get((int)CODE_EDITOR_WATCH_CMD_ID, null, (String)DbgArb.getString(130), (String)category, (Integer)DbgArb.getInteger(131), (Icon)OracleIcons.getIcon((String)"watch.png"), null, (boolean)false);
        actionCodeEditorWatch.addController((Controller)this);
        actionCodeEditorInspect = IdeAction.get((int)CODE_EDITOR_INSPECT_CMD_ID, null, (String)DbgArb.getString(132), (String)category, (Integer)DbgArb.getInteger(133), (Icon)OracleIcons.getIcon((String)"properties.png"), null, (boolean)false);
        actionCodeEditorInspect.addController((Controller)this);
        actionStructureCreateWatchpoint = IdeAction.get((int)STRUCTURE_CREATEWATCHPOINT_CMD_ID, null, (String)DbgArb.getString(138), (String)category, (Integer)DbgArb.getInteger(139), (Icon)OracleIcons.getIcon((String)"debugger/enabledwatchpoint.gif"), null, (boolean)false);
        actionStructureCreateWatchpoint.addController((Controller)this);
        actionMRUConfigurationMenuDebug = IdeAction.get((int)DEBUG_CMD_MRU_CONFIGURATION_ID, null, (String)RunMgrArb.getString(2), (String)category, null, null, null, null, (boolean)false);
        actionMRUConfigurationMenuDebug.putValue("NoCtxName", (Object)RunArb.getString(0));
        actionMRUConfigurationMenuDebug.putValue("Radio", (Object)Boolean.TRUE);
        actionMRUConfigurationMenuDebug.addController((Controller)this);
    }

    void makeDebuggingListenerActions() {
        if (actionNavigatorStopListening != null) {
            return;
        }
        actionNavigatorStopListening = IdeAction.get((int)NAVIGATOR_STOPLISTENING_CMD_ID, null, (String)DbgArb.getString(111), null, (Integer)DbgArb.getInteger(112), (ArrayResourceBundle)DbgArb.getInstance(), (int)113, null, (boolean)false);
        actionNavigatorStopListening.addController((Controller)this);
    }

    private void makeDebuggingProcessActions() {
        if (actionNavigatorDetachDebugger != null) {
            return;
        }
        actionNavigatorDetachDebugger = IdeAction.get((int)NAVIGATOR_DETACHDEBUGGER_CMD_ID, null, (String)DbgArb.getString(114), null, (Integer)DbgArb.getInteger(115), (ArrayResourceBundle)DbgArb.getInstance(), (int)116, null, (boolean)false);
        actionNavigatorDetachDebugger.addController((Controller)this);
        actionLogWindowCancelDebugConnection = IdeAction.get((int)LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID, null, (String)DbgArb.getString(140), null, (Integer)DbgArb.getInteger(141), (Icon)OracleIcons.getIcon((String)"terminate.png"), null, (boolean)false);
        actionLogWindowCancelDebugConnection.addController((Controller)this);
        actionLogWindowShowIP = actionDebugShowIP.newLocalAction(null);
        actionLogWindowResume = actionDebugResume.newLocalAction(null);
        actionLogWindowStepOver = actionDebugStepOver.newLocalAction(null);
        actionLogWindowStepInto = actionDebugStepInto.newLocalAction(null);
        actionLogWindowStepOut = actionDebugStepOut.newLocalAction(null);
        actionLogWindowStepToEndOfMethod = actionDebugStepToEndOfMethod.newLocalAction(null);
        actionLogWindowStepOverBC = actionDebugStepOverBC.newLocalAction(null);
        actionLogWindowStepIntoBC = actionDebugStepIntoBC.newLocalAction(null);
        actionLogWindowPause = actionDebugPause.newLocalAction(null);
        actionLogWindowGC = actionDebugGC.newLocalAction(null);
        actionLogWindowReset = actionDebugReset.newLocalAction(null);
    }

    private void addViewDebuggerSubMenu() {
        Menubar menubar = Ide.getMenubar();
        viewDebuggerSubMenu = menubar.createSubMenu(DbgArb.getString(47), DbgArb.getInteger(48), JDeveloperMenuConstants.WEIGHT_VIEW_DEBUGGER);
        MenuManager.putJMenu((String)"ViewDebuggerMenu", (JMenu)viewDebuggerSubMenu);
        viewDebuggerSubMenu.addMenuListener(this);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewBreakpoints), MenuManager.getJMenu((String)"View"), JDeveloperMenuConstants.SECTION_VIEW_ALPHABETIZED_VIEWS);
        if (viewDebuggerActions.size() > 0) {
            viewDebuggerSubMenu.add(menubar.createMenuItem((ToggleAction)viewDebuggerActions.get(0)));
        }
        menubar.add((Component)viewDebuggerSubMenu, MenuManager.getJMenu((String)"View"), JDeveloperMenuConstants.SECTION_VIEW_ALPHABETIZED_VIEWS);
    }

    private void declareShortcuts() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/runner/debug/accelerators.xml");
    }

    static String getExtensionID() {
        return Product.getProductID();
    }

    private void initializeIDESettings() {
        Preferences preferences = Preferences.getPreferences();
        IdeSettings settings = Ide.getSettings();
        settings.putLegacyData("DebugWindowOptions", (Copyable)DebugWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("BreakpointsWindowOptions", (Copyable)BreakpointsWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("ClassesWindowOptions", (Copyable)ClassesWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("LocalsWindowOptions", (Copyable)LocalsWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("HeapWindowOptions", (Copyable)HeapWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("InspectorWindowOptions", (Copyable)InspectorWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("SmartWindowOptions", (Copyable)SmartWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("StackWindowOptions", (Copyable)StackWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("WatchWindowOptions", (Copyable)WatchWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("ThreadsWindowOptions", (Copyable)ThreadsWindowSettings.getInstance((PropertyStorage)preferences));
        settings.putLegacyData("MonitorsWindowOptions", (Copyable)MonitorsWindowSettings.getInstance((PropertyStorage)preferences));
    }

    private static void registerPanels() {
        Navigable debuggerNavigable = new Navigable(DbgArb.getString(673), DebugWindowSettingsPanel.class);
        Navigable navigable = new Navigable(DbgArb.getString(690), BreakpointsWindowSettingsPanel.class);
        Navigable navigable2 = new Navigable(DbgArb.getString(691), BreakpointsWindowSettingsPanel2.class);
        navigable.addChildNavigable(navigable2);
        debuggerNavigable.addChildNavigable(navigable);
        navigable = new Navigable(DbgArb.getString(713), StackWindowSettingsPanel.class);
        debuggerNavigable.addChildNavigable(navigable);
        navigable = new Navigable(DbgArb.getString(741), SmartWindowSettingsPanel.class);
        debuggerNavigable.addChildNavigable(navigable);
        navigable = new Navigable(DbgArb.getString(720), LocalsWindowSettingsPanel.class);
        debuggerNavigable.addChildNavigable(navigable);
        navigable = new Navigable(DbgArb.getString(740), WatchWindowSettingsPanel.class);
        debuggerNavigable.addChildNavigable(navigable);
        navigable = new Navigable(DbgArb.getString(745), InspectorWindowSettingsPanel.class);
        debuggerNavigable.addChildNavigable(navigable);
        navigable = new Navigable(DbgArb.getString(916), ToolTipSettingsPanel.class);
        debuggerNavigable.addChildNavigable(navigable);
        if (!Product.isRaptor()) {
            navigable = new Navigable(DbgArb.getString(706), ThreadsWindowSettingsPanel.class);
            debuggerNavigable.addChildNavigable(navigable);
            navigable = new Navigable(DbgArb.getString(746), ClassesWindowSettingsPanel.class);
            debuggerNavigable.addChildNavigable(navigable);
            navigable = new Navigable(DbgArb.getString(766), HeapWindowSettingsPanel.class);
            debuggerNavigable.addChildNavigable(navigable);
            navigable = new Navigable(DbgArb.getString(771), MonitorsWindowDataSettingsPanel.class);
            navigable2 = new Navigable(DbgArb.getString(772), MonitorsWindowThreadsSettingsPanel.class);
            navigable.addChildNavigable(navigable2);
            debuggerNavigable.addChildNavigable(navigable);
        }
        IdeSettings.registerUI((Navigable)debuggerNavigable);
        navigable = new Navigable(DbgArb.getString(851), DebugConfigurationPanel.class);
        navigable2 = new Navigable(DbgArb.getString(336), RemoteDebugSettingsPanel.class);
        navigable.addChildNavigable(navigable2);
        Runner.getRunner().addRunConfigurationToolNavigable(navigable);
    }

    private void activeProjectChanged() {
        if (this.activeWorkspace != null) {
            this.activeWorkspace.detach((Observer)this);
        }
        if (this.activeProject != null) {
            this.activeProject.detach((Observer)this);
        }
        Workspace prevWorkspace = this.activeWorkspace;
        Project prevProject = this.activeProject;
        this.activeWorkspace = Ide.getActiveWorkspace();
        this.activeProject = Ide.getActiveProject();
        if (this.activeWorkspace != null) {
            this.activeWorkspace.attach((Observer)this);
        }
        if (this.activeProject != null) {
            this.activeProject.attach((Observer)this);
        }
        this.updateRunConfigurationList();
        this.checkCommandsBecauseActiveProjectChanged();
        if (this.activeWorkspace != prevWorkspace || this.activeProject != prevProject || this.activeBreakpoints.length == 0) {
            this.updateActiveBreakpoints();
        }
    }

    void updateActiveBreakpoints() {
        Breakpoint.hideBreakpointIcons(this.activeBreakpoints);
        this.activeBreakpoints = Breakpoint.getBreakpoints(this.activeWorkspace, this.activeProject);
        Breakpoint.showBreakpointIcons(this.activeBreakpoints);
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.setBreakpoints(this.activeWorkspace, this.activeProject, this.activeBreakpoints);
        }
    }

    private void debugWindowSettingsChanged() {
        DebuggingProcess debuggingProcess;
        int i;
        if (debugMenuBuilt) {
            if (this.dbgSettings.isContextMenusOnMainMenu()) {
                if (!debugContextSubMenuAdded) {
                    runMenu.add(debugContextSubMenu);
                    debugContextSubMenuAdded = true;
                }
            } else if (debugContextSubMenuAdded) {
                runMenu.remove(debugContextSubMenu);
                debugContextSubMenuAdded = false;
            }
        }
        this.updateToolTipProvider();
        boolean isShowActionButtonsOnToolbar = this.dbgSettings.isShowActionButtonsOnToolbar();
        if (this.debuggingProcessesConnecting != null) {
            for (i = this.debuggingProcessesConnecting.size() - 1; i >= 0; --i) {
                debuggingProcess = this.debuggingProcessesConnecting.get(i);
                debuggingProcess.showProcessActionButtonsOnToolbar(isShowActionButtonsOnToolbar);
            }
        }
        if (this.debuggingProcesses != null) {
            for (i = this.debuggingProcesses.size() - 1; i >= 0; --i) {
                debuggingProcess = this.debuggingProcesses.get(i);
                debuggingProcess.showProcessActionButtonsOnToolbar(isShowActionButtonsOnToolbar);
            }
        }
    }

    void tracingChanged() {
        RunWhilePaused runWhilePaused = new RunWhilePaused(){

            @Override
            public void run(DebuggingProcess debuggingProcess, boolean live) {
                if (debuggingProcess != null && live) {
                    debuggingProcess.setTracing();
                }
            }
        };
        Runnable runOnceLater = new Runnable(){

            @Override
            public void run() {
                JDebugger.this.checkCommandsBecauseTracingChanged();
            }
        };
        this.pauseAndInvoke(runWhilePaused, runOnceLater);
        ClassesWindow classesWindow = this.getClassesWindow(false);
        if (classesWindow != null) {
            classesWindow.tracingChanged();
        }
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        Object source = e.getSource();
        if (source == runMenu) {
            runMenu.removeMenuListener(this);
            this.buildDebugMenu();
        } else if (source == viewDebuggerSubMenu) {
            viewDebuggerSubMenu.removeMenuListener(this);
            this.buildViewDebuggerSubMenu();
        } else if (source == debugContextSubMenu) {
            debugContextSubMenu.removeMenuListener(this);
            JDebugger.buildDebugContextSubMenu();
        }
    }

    private void buildDebugMenu() {
        if (!debugMenuBuilt) {
            Menubar menubar = Ide.getMenubar();
            Context[] context = new Context[]{Ide.getMainWindow().getLastActiveView().getContext()};
            if (!Product.isRaptor()) {
                this.updateIfNotVisible(actionDebugProject, context);
                menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugProject, JDeveloperMenuConstants.WEIGHT_DEBUG_DEBUG_PROJECT), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_DEBUG_RUN);
            }
            this.updateIfNotVisible(actionDebugToggleBreakpoint, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugToggleBreakpoint, JDeveloperMenuConstants.WEIGHT_DEBUG_TOGGLE_BREAKPOINT), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_BREAKPOINT);
            this.updateIfNotVisible(actionDebugPause, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugPause, JDeveloperMenuConstants.WEIGHT_DEBUG_PAUSE), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_PAUSE_RESUME);
            this.updateIfNotVisible(actionDebugResume, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugResume, JDeveloperMenuConstants.WEIGHT_DEBUG_RESUME), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_PAUSE_RESUME);
            this.updateIfNotVisible(actionDebugDetach, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugDetach, JDeveloperMenuConstants.WEIGHT_DEBUG_DETACH), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_PAUSE_RESUME);
            this.updateIfNotVisible(actionDebugStepOver, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugStepOver, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_OVER), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugStepInto, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugStepInto, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_INTO), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugStepOut, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugStepOut, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_OUT), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugStepToEndOfMethod, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugStepToEndOfMethod, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_TO_END_OF_METHOD), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugContinueStep, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugContinueStep, JDeveloperMenuConstants.WEIGHT_DEBUG_CONTINUE_STEP), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugRunToCursor, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugRunToCursor, JDeveloperMenuConstants.WEIGHT_DEBUG_RUN_TO_CURSOR), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_PRECISION);
            this.updateIfNotVisible(actionDebugStepIntoMethod, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugStepIntoMethod, JDeveloperMenuConstants.WEIGHT_DEBUG_STEP_INTO_METHOD_AT_CURSOR), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_STEP);
            this.updateIfNotVisible(actionDebugSetNextStatement, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugSetNextStatement, JDeveloperMenuConstants.WEIGHT_DEBUG_SET_NEXT_STATEMENT), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_PRECISION);
            this.updateIfNotVisible(actionDebugShowIP, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugShowIP, JDeveloperMenuConstants.WEIGHT_DEBUG_FIND_EXECUTION_POINT), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_PRECISION);
            this.updateIfNotVisible(actionDebugGC, context);
            menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDebugGC, JDeveloperMenuConstants.WEIGHT_DEBUG_GARBAGE_COLLECT), runMenu, JDeveloperMenuConstants.SECTION_DEBUG_GARBAGE);
            debugContextSubMenu = menubar.createSubMenu(DbgArb.getString(71), DbgArb.getInteger(72));
            debugContextSubMenu.addMenuListener(this);
            JMenu subMenu = menubar.createSubMenu(DbgArb.getString(73), DbgArb.getInteger(74));
            BreakpointsWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            if (this.dbgSettings.isContextMenusOnMainMenu()) {
                menubar.add((Component)debugContextSubMenu, runMenu, JDeveloperMenuConstants.SECTION_DEBUG_GARBAGE);
                debugContextSubMenuAdded = true;
            }
            debugMenuBuilt = true;
        }
    }

    private void buildViewDebuggerSubMenu() {
        if (!viewDebuggerSubMenuBuilt) {
            Menubar menubar = Ide.getMenubar();
            Context context = Ide.getMainWindow().getLastActiveView().getContext();
            int size = viewDebuggerActions.size();
            for (int i = 1; i < size; ++i) {
                IdeAction action = viewDebuggerActions.get(i);
                this.update(action, context);
                viewDebuggerSubMenu.add(menubar.createMenuItem((ToggleAction)action));
            }
            viewDebuggerSubMenuBuilt = true;
            viewDebuggerActions = null;
        }
    }

    private static void buildDebugContextSubMenu() {
        if (!debugContextSubMenuBuilt) {
            Menubar menubar = Ide.getMenubar();
            JMenu subMenu = menubar.createSubMenu(DbgArb.getString(75), DbgArb.getInteger(76));
            ThreadsWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            subMenu = menubar.createSubMenu(DbgArb.getString(77), DbgArb.getInteger(78));
            StackWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            subMenu = menubar.createSubMenu(DbgArb.getString(85), DbgArb.getInteger(86));
            SmartWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            subMenu = menubar.createSubMenu(DbgArb.getString(81), DbgArb.getInteger(82));
            LocalsWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            subMenu = menubar.createSubMenu(DbgArb.getString(83), DbgArb.getInteger(84));
            WatchWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            subMenu = menubar.createSubMenu(DbgArb.getString(87), DbgArb.getInteger(88));
            InspectorWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            subMenu = menubar.createSubMenu(DbgArb.getString(89), DbgArb.getInteger(90));
            ClassesWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            subMenu = menubar.createSubMenu(DbgArb.getString(91), DbgArb.getInteger(92));
            HeapWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            subMenu = menubar.createSubMenu(DbgArb.getString(93), DbgArb.getInteger(94));
            MonitorsWindow.addContextMenuToMainMenu(menubar, subMenu);
            debugContextSubMenu.add(subMenu);
            debugContextSubMenuBuilt = true;
        }
    }

    private void updateDebugProjectAction(IdeAction action, Context context) {
        String name;
        boolean isUseCurrentWorkingSet = Runner.getRunner().getRunnerOptions().isRunCurrentWorkingSet();
        action.setEnabled(this.canStartProcess(null));
        Project mruProject = JRunner.getMRUProject(context);
        if (mruProject != null) {
            String projectShortLabel = mruProject.getShortLabel();
            name = DbgArb.format(isUseCurrentWorkingSet ? 5 : 4, projectShortLabel);
        } else {
            Project project = context.getProject();
            name = project == null ? DbgArb.getString(isUseCurrentWorkingSet ? 3 : 2) : DbgArb.format(isUseCurrentWorkingSet ? 5 : 4, project.getShortLabel());
            if (isUseCurrentWorkingSet) {
                action.setEnabled(false);
            }
        }
        action.putValue("Name", (Object)name);
    }

    private void updateDebugSelectionAction(IdeAction action, Context context) {
        String name;
        boolean isUseCurrentWorkingSet = Runner.getRunner().getRunnerOptions().isRunCurrentWorkingSet();
        Project project = context.getProject();
        if (project != null && RunConfiguration.getInstance((PropertyStorage)project).isRemoteDebuggingProfiling()) {
            action.setEnabled(false);
            action.putValue("Name", (Object)DbgArb.getString(isUseCurrentWorkingSet ? 8 : 7));
            return;
        }
        Node node = RunProcess.getContextNodeForRun((Context)context);
        if (node instanceof Project) {
            action.setEnabled(false);
            action.putValue("Name", (Object)DbgArb.getString(isUseCurrentWorkingSet ? 8 : 7));
            return;
        }
        action.setEnabled(this.canStartProcess(context));
        if (node != null && Runner.getRunner().couldNodeBeRunnable(node, DebuggingProcess.starterFactorySubClass)) {
            String nodeShortLabel = node.getShortLabel();
            name = DbgArb.format(isUseCurrentWorkingSet ? 10 : 9, nodeShortLabel);
        } else {
            name = DbgArb.getString(isUseCurrentWorkingSet ? 8 : 7);
        }
        action.putValue("Name", (Object)name);
    }

    private void updateContextMenuDebugAction(IdeAction action, Context context) {
        Project project;
        boolean isUseCurrentWorkingSet = Runner.getRunner().getRunnerOptions().isRunCurrentWorkingSet();
        boolean enabled = Runner.getRunner().enableRunDebugActions(context, DebuggingProcess.starterFactorySubClass) && this.canStartProcess(context);
        action.setEnabled(enabled);
        if (enabled && (project = context.getProject()) != null && RunConfiguration.getInstance((PropertyStorage)project).isRemoteDebuggingProfiling()) {
            action.putValue("Name", (Object)DbgArb.getString(105));
            return;
        }
        action.putValue("Name", (Object)DbgArb.getString(isUseCurrentWorkingSet ? 104 : 103));
    }

    private void updateDebugActions() {
        Context[] context = new Context[1];
        this.updateIfVisible(actionDebugProject, context);
        this.updateIfVisible(actionDebugSelection, context);
    }

    private void updateDebugMRUConfigurationAction(IdeAction action, Context context) {
        String mruMenuLabel = JRunner.getMRUMenuName(context);
        action.setState(true);
        if (RunMgrArb.getString(2).equals(mruMenuLabel)) {
            action.setEnabled(false);
        } else {
            action.setName(mruMenuLabel);
            action.setEnabled(true);
        }
    }

    private boolean isActionVisible(IdeAction action) {
        int cmdId = action.getCommandId();
        if (cmdId == DEBUG_STEPOVERBC_CMD_ID || cmdId == DEBUG_STEPINTOBC_CMD_ID) {
            return BytecodeFileSystemHelper.getInstance(false) != null;
        }
        return cmdId == DEBUG_PROJECT_CMD_ID || cmdId == DEBUG_CMD_MRU_CONFIGURATION_ID || cmdId == DEBUG_RESUME_CMD_ID || cmdId == DEBUG_STEPOVER_CMD_ID || cmdId == DEBUG_STEPINTO_CMD_ID || cmdId == DEBUG_STEPOUT_CMD_ID || cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID || cmdId == DEBUG_PAUSE_CMD_ID || cmdId == DEBUG_RESET_CMD_ID || cmdId == DEBUG_SHOWIP_CMD_ID || cmdId == DEBUG_GC_CMD_ID || cmdId == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID;
    }

    private void updateIfVisible(IdeAction action, Context[] context) {
        if (this.isActionVisible(action)) {
            if (context[0] == null) {
                context[0] = Ide.getMainWindow().getLastActiveView().getContext();
            }
            this.update(action, context[0]);
        }
    }

    private void updateIfNotVisible(IdeAction action, Context[] context) {
        if (!this.isActionVisible(action)) {
            if (context[0] == null) {
                context[0] = Ide.getMainWindow().getLastActiveView().getContext();
            }
            this.update(action, context[0]);
        }
    }

    private void checkCommandsBecauseActiveProjectChanged() {
        this.updateDebugActions();
    }

    private void checkCommandsBecauseActiveViewChanged() {
        this.updateDebugActions();
        Context[] context = new Context[1];
        this.updateIfVisible(actionDebugRunToCursor, context);
        this.updateIfVisible(actionDebugStepIntoMethod, context);
        this.updateIfVisible(actionDebugSetNextStatement, context);
        this.checkCommandsForTopLogPage();
    }

    private void checkCommandsBecauseViewSelectionChanged() {
        this.updateDebugActions();
    }

    private void checkCommandsBecauseCursorMoved() {
        if (this.activeDebuggingProcess != null) {
            Context[] context = new Context[1];
            this.updateIfVisible(actionDebugRunToCursor, context);
            this.updateIfVisible(actionDebugStepIntoMethod, context);
            this.updateIfVisible(actionDebugSetNextStatement, context);
        }
    }

    private boolean shouldProvideToolTip() {
        return this.duringClassRedefinition == 0 && this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped() && this.dbgSettings.isShowToolTipInCodeEditor();
    }

    private void updateToolTipProvider() {
        block5: {
            boolean should = this.shouldProvideToolTip();
            if (this.isToolTipProvider == should) break block5;
            this.isToolTipProvider = should;
            CodeEditor[] ceditors = SourceIcon.getOpenCodeEditors();
            if (this.isToolTipProvider) {
                for (int i = ceditors.length - 1; i >= 0; --i) {
                    BasicEditorPane basicEditorPane = ceditors[i].getFocusedEditorPane();
                    if (!(basicEditorPane instanceof IdeEditorPane)) continue;
                    ((IdeEditorPane)basicEditorPane).getHoverRegistry().registerProvider((HoverProvider)this);
                }
            } else {
                if (this.toolTipEvaluator != null) {
                    this.toolTipEvaluator.clearEvaluator();
                }
                for (int i = ceditors.length - 1; i >= 0; --i) {
                    BasicEditorPane basicEditorPane = ceditors[i].getFocusedEditorPane();
                    if (!(basicEditorPane instanceof IdeEditorPane)) continue;
                    ((IdeEditorPane)basicEditorPane).getHoverRegistry().unregisterProvider((HoverProvider)this);
                }
            }
        }
    }

    private void updateMainDebugCommands() {
        Context[] context = new Context[1];
        this.updateIfVisible(actionDebugPause, context);
        this.updateIfVisible(actionDebugResume, context);
        this.updateIfVisible(actionDebugDetach, context);
        this.updateIfVisible(actionDebugReset, context);
        this.updateIfVisible(actionDebugStepOver, context);
        this.updateIfVisible(actionDebugStepOverBC, context);
        this.updateIfVisible(actionDebugStepInto, context);
        this.updateIfVisible(actionDebugStepIntoBC, context);
        this.updateIfVisible(actionDebugStepOut, context);
        this.updateIfVisible(actionDebugStepToEndOfMethod, context);
        this.updateIfVisible(actionDebugContinueStep, context);
        this.updateIfVisible(actionDebugRunToCursor, context);
        this.updateIfVisible(actionDebugStepIntoMethod, context);
        this.updateIfVisible(actionDebugSetNextStatement, context);
        this.updateIfVisible(actionDebugShowIP, context);
        this.updateIfVisible(actionDebugGC, context);
    }

    private void checkCommandsBecauseActiveDebuggingProcessChanged() {
        this.updateToolTipProvider();
        this.updateMainDebugCommands();
        this.checkCommandsForTopLogPage();
    }

    void checkCommandsBecauseDebuggingProcessStateChanged(DebuggingProcess debuggingProcess) {
        if (debuggingProcess == this.activeDebuggingProcess) {
            this.updateToolTipProvider();
            this.updateMainDebugCommands();
        }
        this.checkCommandsForTopLogPage();
    }

    private void checkCommandsForTopLogPage() {
        LogPage logPage = LogManager.getIdeLogWindow().getPage();
        if (logPage instanceof RunLogPage) {
            DebuggingProcess debuggingProcess;
            Context[] context = new Context[]{logPage.getLogPageView().getContext()};
            DebuggingProcess connectingDebuggingProcess = this.findDebuggingProcess((RunLogPage)logPage, true);
            if (connectingDebuggingProcess != null) {
                this.updateIfVisible(actionLogWindowCancelDebugConnection, context);
            }
            if ((debuggingProcess = this.findDebuggingProcess((RunLogPage)logPage, false)) != null) {
                this.updateIfVisible(actionLogWindowShowIP, context);
                this.updateIfVisible(actionLogWindowResume, context);
                this.updateIfVisible(actionLogWindowStepOver, context);
                this.updateIfVisible(actionLogWindowStepInto, context);
                this.updateIfVisible(actionLogWindowStepOut, context);
                this.updateIfVisible(actionLogWindowStepToEndOfMethod, context);
                this.updateIfVisible(actionLogWindowStepOverBC, context);
                this.updateIfVisible(actionLogWindowStepIntoBC, context);
                this.updateIfVisible(actionLogWindowPause, context);
                this.updateIfVisible(actionLogWindowGC, context);
                this.updateIfVisible(actionLogWindowReset, context);
            }
        }
    }

    private void checkCommandsBecauseTracingChanged() {
        Context[] context = new Context[1];
        this.updateIfVisible(actionDebugStepOver, context);
        this.updateIfVisible(actionDebugStepOverBC, context);
        this.updateIfVisible(actionDebugStepInto, context);
        this.updateIfVisible(actionDebugStepIntoBC, context);
        this.updateIfVisible(actionDebugStepToEndOfMethod, context);
        this.checkCommandsForTopLogPage();
    }

    private boolean canStartProcess(Context context) {
        Node node;
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null && compiler.isBusy(null)) {
            return false;
        }
        if (context != null && (node = RunProcess.getContextNodeForRun((Context)context)) instanceof Project && node == context.getProject()) {
            context = null;
        }
        boolean contextOk = false;
        if (context != null) {
            contextOk = this.isContextNodeRunnable(context);
        } else if (this.activeProject != null) {
            contextOk = true;
        } else {
            Context activeContext = new Context(Ide.getMainWindow().getLastActiveView().getContext());
            if (activeContext != null) {
                contextOk = this.isContextNodeRunnable(activeContext);
            }
        }
        return contextOk;
    }

    private boolean isContextNodeRunnable(Context context) {
        Node node = RunProcess.getContextNodeForRun((Context)context);
        return node != null && Runner.getRunner().couldNodeBeRunnable(node, DebuggingProcess.starterFactorySubClass);
    }

    private void startProcess(Context context, boolean updateMruProperties) {
        if (this.debuggingProcesses == null) {
            this.windowManager.installCustomWindows();
        }
        this.extenderManager.newDebugSession(context);
        DebuggingProcess debuggingProcess = this.createDebuggingProcess(context, updateMruProperties);
        debuggingProcess.start();
    }

    private DebuggingProcess createDebuggingProcess(Context context, boolean updateMruProperties) {
        Context context2 = JRunner.prepareProcessContext(context, updateMruProperties);
        DebuggingProcess debuggingProcess = new DebuggingProcess(context2);
        return debuggingProcess;
    }

    private boolean canStopListening(Context context) {
        Element[] selection = context.getSelection();
        if (selection != null && selection.length > 0) {
            for (int i = selection.length - 1; i >= 0; --i) {
                Element element = selection[i];
                if (element instanceof DebuggingListener) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void stopListening(Context context) {
        Element[] selection = context.getSelection();
        if (selection != null && selection.length > 0) {
            for (int i = selection.length - 1; i >= 0; --i) {
                Element element = selection[i];
                if (!(element instanceof DebuggingListener)) continue;
                DebuggingListener debuggingListener = (DebuggingListener)element;
                debuggingListener.stopListening();
            }
        }
    }

    private boolean canDetachDebugger(Context context) {
        Element[] selection = context.getSelection();
        if (selection != null && selection.length > 0) {
            for (int i = selection.length - 1; i >= 0; --i) {
                Element element = selection[i];
                if (element instanceof DebuggingProcess) {
                    DebuggingProcess debuggingProcess = (DebuggingProcess)element;
                    if (debuggingProcess.canDetach()) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void detachDebugger(Context context) {
        Element[] selection = context.getSelection();
        if (selection != null && selection.length > 0) {
            for (int i = selection.length - 1; i >= 0; --i) {
                DebuggingProcess debuggingProcess;
                Element element = selection[i];
                if (!(element instanceof DebuggingProcess) || !(debuggingProcess = (DebuggingProcess)element).canDetach()) continue;
                debuggingProcess.detach();
            }
        }
    }

    DockableWindow getOrCreateDebuggerWindow(String windowID) {
        DockableWindow debuggerWindow = this.windowManager.getDebuggerWindow(windowID);
        if (debuggerWindow != null) {
            return debuggerWindow;
        }
        if (windowID.equals("Debugger.BreakpointsWindow")) {
            return this.getBreakpointsWindow(true);
        }
        if (windowID.equals("Debugger.ThreadsWindow")) {
            return this.getThreadsWindow(true);
        }
        if (windowID.equals("Debugger.StackWindow")) {
            return this.getStackWindow(true);
        }
        if (windowID.equals("Debugger.LocalsWindow")) {
            return this.getLocalsWindow(true);
        }
        if (windowID.equals("Debugger.WatchWindow")) {
            return this.getWatchWindow(true);
        }
        if (windowID.equals("Debugger.SmartWindow")) {
            return this.getSmartWindow(true);
        }
        if (windowID.equals("Debugger.HeapWindow")) {
            return this.getHeapWindow(true);
        }
        if (windowID.equals("Debugger.ClassesWindow")) {
            return this.getClassesWindow(true);
        }
        if (windowID.equals("Debugger.MonitorsWindow")) {
            return this.getMonitorsWindow(true);
        }
        if (InspectorWindow.isInspectorWindowId(windowID)) {
            return this.getOrCreateInspectorWindow(windowID);
        }
        return null;
    }

    BreakpointsWindow getBreakpointsWindow(boolean forceCreate) {
        if (this.breakpointsWindow == null && forceCreate) {
            this.breakpointsWindow = new BreakpointsWindow(this.activeWorkspace, this.activeProject, this.activeBreakpoints);
            this.windowManager.addDebuggerWindowProvider(this.breakpointsWindow, false);
        }
        return this.breakpointsWindow;
    }

    ThreadsWindow getThreadsWindow(boolean forceCreate) {
        if (this.threadsWindow == null && forceCreate) {
            this.threadsWindow = new ThreadsWindow();
            this.windowManager.addDebuggerWindowProvider(this.threadsWindow, false);
            if (this.stackWindow != null) {
                this.threadsWindow.setStackWindow(this.stackWindow);
            }
        }
        return this.threadsWindow;
    }

    StackWindow getStackWindow(boolean forceCreate) {
        this.getThreadsWindow(forceCreate);
        if (this.stackWindow == null && forceCreate) {
            this.stackWindow = new StackWindow();
            this.windowManager.addDebuggerWindowProvider(this.stackWindow, false);
            if (this.threadsWindow != null) {
                this.threadsWindow.setStackWindow(this.stackWindow);
            }
            if (this.localsWindow != null) {
                this.stackWindow.setLocalsWindow(this.localsWindow);
            }
            if (this.watchWindow != null) {
                this.stackWindow.setWatchWindow(this.watchWindow);
            }
        }
        return this.stackWindow;
    }

    SmartWindow getSmartWindow(boolean forceCreate) {
        if (this.smartWindow == null && forceCreate) {
            this.smartWindow = new SmartWindow();
            this.windowManager.addDebuggerWindowProvider(this.smartWindow, false);
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.smartWindowCreated(this.smartWindow);
            }
        }
        return this.smartWindow;
    }

    LocalsWindow getLocalsWindow(boolean forceCreate) {
        this.getStackWindow(forceCreate);
        if (this.localsWindow == null && forceCreate) {
            this.localsWindow = new LocalsWindow();
            this.windowManager.addDebuggerWindowProvider(this.localsWindow, false);
            if (this.stackWindow != null) {
                this.stackWindow.setLocalsWindow(this.localsWindow);
            }
        }
        return this.localsWindow;
    }

    WatchWindow getWatchWindow(boolean forceCreate) {
        this.getStackWindow(forceCreate);
        if (this.watchWindow == null && forceCreate) {
            this.watchWindow = new WatchWindow();
            this.windowManager.addDebuggerWindowProvider(this.watchWindow, false);
            if (this.stackWindow != null) {
                this.stackWindow.setWatchWindow(this.watchWindow);
            }
        }
        return this.watchWindow;
    }

    ClassesWindow getClassesWindow(boolean forceCreate) {
        if (this.classesWindow == null && forceCreate) {
            this.classesWindow = new ClassesWindow();
            this.windowManager.addDebuggerWindowProvider(this.classesWindow, false);
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.classesWindowCreated(this.classesWindow);
            }
        }
        return this.classesWindow;
    }

    HeapWindow getHeapWindow(boolean forceCreate) {
        if (this.heapWindow == null && forceCreate) {
            this.heapWindow = new HeapWindow();
            this.windowManager.addDebuggerWindowProvider(this.heapWindow, false);
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.heapWindowCreated(this.heapWindow);
            }
        }
        return this.heapWindow;
    }

    MonitorsWindow getMonitorsWindow(boolean forceCreate) {
        if (this.monitorsWindow == null && forceCreate) {
            this.monitorsWindow = new MonitorsWindow();
            this.windowManager.addDebuggerWindowProvider(this.monitorsWindow, false);
            if (this.activeDebuggingProcess != null) {
                this.activeDebuggingProcess.monitorsWindowCreated(this.monitorsWindow);
            }
        }
        return this.monitorsWindow;
    }

    public EvaluatorItem addWatch(Object expression) {
        this.viewWatches();
        this.getWatchWindow(true);
        return this.watchWindow.addWatch(expression);
    }

    public boolean removeWatch(EvaluatorItem ei) {
        this.getWatchWindow(true);
        return this.watchWindow.removeWatch(ei);
    }

    public InspectorWindow inspect(Object expression) {
        String windowId = InspectorWindow.getNewInspectorWindowId();
        InspectorWindow inspectorWindow = this.createInspectorWindow(windowId, expression);
        this.addInspectorWindow(inspectorWindow, true);
        return inspectorWindow;
    }

    private void addInspectorWindow(InspectorWindow inspectorWindow, boolean updateLayout) {
        if (this.inspectorWindows == null) {
            this.inspectorWindows = new ArrayList();
        }
        this.inspectorWindows.add(inspectorWindow);
        this.getStackWindow(true);
        this.stackWindow.newInspectorWindow(inspectorWindow);
        if (updateLayout) {
            this.windowManager.installWindow(inspectorWindow.getId());
        }
    }

    private InspectorWindow createInspectorWindow(String windowID, Object expression) {
        InspectorWindow inspectorWindow = new InspectorWindow(windowID, expression);
        this.windowManager.addDebuggerWindowProvider(inspectorWindow, false);
        return inspectorWindow;
    }

    InspectorWindow getOrCreateInspectorWindow(String windowId) {
        if (this.inspectorWindows != null) {
            for (InspectorWindow inspectorWindow : this.inspectorWindows) {
                if (!windowId.equals(inspectorWindow.getId())) continue;
                return inspectorWindow;
            }
        }
        InspectorWindow inspectorWindow = this.createInspectorWindow(windowId, null);
        this.addInspectorWindow(inspectorWindow, false);
        return inspectorWindow;
    }

    void removeInspectorWindow(InspectorWindow inspectorWindow) {
        if (this.inspectorWindows != null) {
            this.inspectorWindows.remove(inspectorWindow);
            inspectorWindow.removeInspector();
        }
    }

    Iterator getInspectorWindows() {
        if (this.inspectorWindows != null) {
            List clone = (List)((ArrayList)this.inspectorWindows).clone();
            return clone.iterator();
        }
        return new ArrayList().iterator();
    }

    DebuggingProcess[] getDebuggingProcessesForBreakpoint(Breakpoint bp) {
        ArrayList<DebuggingProcess> list = new ArrayList<DebuggingProcess>();
        if (this.debuggingProcesses != null) {
            block0: for (DebuggingProcess debuggingProcess : this.debuggingProcesses) {
                List[] breakpoints = Breakpoint.getBreakpoints(debuggingProcess.getWorkspace(), debuggingProcess.getProject());
                int length = breakpoints.length;
                for (int i = 0; i < length; ++i) {
                    if (!breakpoints[i].contains(bp)) continue;
                    list.add(debuggingProcess);
                    continue block0;
                }
            }
        }
        return list.toArray(new DebuggingProcess[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheNewBreakpoints() {
        Boolean bl = this.cacheNewBreakpoints;
        synchronized (bl) {
            this.cacheNewBreakpoints = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushNewBreakpoints() {
        Boolean bl = this.cacheNewBreakpoints;
        synchronized (bl) {
            this.cacheNewBreakpoints = false;
            if (this.cachedNewBreakpoints != null) {
                for (Breakpoint bp : this.cachedNewBreakpoints) {
                    this.addBreakpoint(bp);
                }
                this.cachedNewBreakpoints = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBreakpoint(Breakpoint bp) {
        Boolean bl = this.cacheNewBreakpoints;
        synchronized (bl) {
            if (this.cacheNewBreakpoints.booleanValue()) {
                if (this.cachedNewBreakpoints == null) {
                    this.cachedNewBreakpoints = new ArrayList<Breakpoint>();
                }
                this.cachedNewBreakpoints.add(bp);
                return;
            }
        }
        if (bp != null) {
            if (this.breakpointsWindow != null) {
                this.breakpointsWindow.addNewBreakpoint(bp);
            } else {
                this.addBreakpoint(bp, null);
            }
        }
    }

    void addBreakpoint(Breakpoint bp, Runnable runOnceLater) {
        Breakpoint.addBreakpointToOwner(bp);
        if (this.extenderManager.isExtenderBreakpoint(bp)) {
            this.extenderManager.breakpointAdded(bp);
        }
        boolean inScope = false;
        List[] breakpoints = Breakpoint.getBreakpoints(this.activeWorkspace, this.activeProject);
        int length = breakpoints.length;
        for (int i = 0; i < length; ++i) {
            if (!breakpoints[i].contains(bp)) continue;
            inScope = true;
            break;
        }
        if (inScope) {
            bp.showBreakpointIcon();
        } else {
            bp.hideBreakpointIcon();
        }
        bp.putBreakpoint(runOnceLater);
        if (!this.extenderManager.isExtenderBreakpoint(bp)) {
            String classOrPackage1 = null;
            String classOrPackage2 = null;
            int bpType = bp.getType();
            if (bpType == 0) {
                classOrPackage1 = bp.getPackage();
                String file = bp.getFile();
                int dot = file.indexOf(46);
                if (dot != -1) {
                    file = file.substring(0, dot);
                }
                classOrPackage2 = classOrPackage1 + "." + file;
            } else if (bpType == 1) {
                String method = bp.getMethod();
                int lastDot = method.lastIndexOf(46);
                if (lastDot != -1) {
                    classOrPackage1 = method.substring(0, lastDot);
                }
            } else if (bpType == 7) {
                int iDot;
                int iClass;
                String fqMethodName = bp.getMethod();
                int iSignature = fqMethodName.indexOf("(");
                if (iSignature != -1 && (iClass = fqMethodName.lastIndexOf(" ", iSignature) + 1) != -1 && (iDot = fqMethodName.lastIndexOf(".", iSignature)) != -1) {
                    classOrPackage1 = fqMethodName.substring(iClass, iDot);
                }
            } else if (bpType == 4) {
                classOrPackage1 = bp.getClassName();
            }
            if (!(classOrPackage1 == null && classOrPackage2 == null || this.activeDebuggingProcess != null && !this.activeDebuggingProcess.canSetTracing())) {
                DebugConfiguration debugConfiguration = null;
                if (this.activeDebuggingProcess != null) {
                    debugConfiguration = this.activeDebuggingProcess.getDebugConfiguration();
                } else if (this.activeProject != null) {
                    debugConfiguration = DebugConfiguration.getInstance((PropertyStorage)this.activeProject);
                }
                if (debugConfiguration != null) {
                    List tracingIncludeList = debugConfiguration.getTracingIncludeList();
                    List tracingExcludeList = debugConfiguration.getTracingExcludeList();
                    if (classOrPackage1 != null && !DebugShared.isClassOrPackageDebuggable(classOrPackage1, tracingIncludeList, tracingExcludeList) || classOrPackage2 != null && !DebugShared.isClassOrPackageDebuggable(classOrPackage2, tracingIncludeList, tracingExcludeList)) {
                        RunConfiguration runConfiguration = debugConfiguration.getRunConfiguration();
                        String message = DbgArb.format(837, runConfiguration.getName(), DbgArb.getString(20));
                        message = message + DbgArb.getString(838);
                        if (!runConfiguration.isCustom()) {
                            message = message + DbgArb.format(839, runConfiguration.getName());
                        }
                        message = message + DbgArb.getString(840);
                        String title = DbgArb.getString(841);
                        boolean answer = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)title, null);
                        if (answer) {
                            TracingPanel.showTracingDialog(debugConfiguration);
                        }
                    }
                }
            }
        }
    }

    void removeBreakpoint(Breakpoint bp) {
        if (bp != null) {
            bp.removeBreakpoint();
            this.updateBreakpointsWindow();
        }
    }

    void updateBreakpointsWindow() {
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.everythingChanged();
        }
    }

    void updateBreakpointsWindowDescription() {
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.breakpointDescriptionChanged();
        }
    }

    void updateBreakpointsWindowStatus(Breakpoint bp) {
        this.extenderManager.breakpointChanged(null, bp);
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.breakpointStatusChanged();
        }
    }

    void updateBreakpointsWindowInstanceFilters() {
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.breakpointInstanceFiltersChanged();
        }
    }

    private Breakpoint findBreakpointByIconLocation(CodeEditor codeEditor, int line, Boolean watchpoint) {
        Breakpoint possible = null;
        URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.activeWorkspace, this.activeProject);
        int length = this.activeBreakpoints.length;
        for (int i = 0; i < length; ++i) {
            for (Breakpoint bp : this.activeBreakpoints[i]) {
                if (watchpoint != null && (watchpoint == false ? bp.getType() == 6 : bp.getType() != 6) || !bp.matchesIconLocation(codeEditor, line)) continue;
                if (ownerURL == null || URLFileSystem.equals((URL)ownerURL, (URL)bp.getOwnerURL())) {
                    return bp;
                }
                possible = bp;
            }
        }
        return possible;
    }

    private void toggleBreakpoint(Context context, CodeEditor codeEditor, int line) {
        Breakpoint bp = this.findBreakpointByIconLocation(codeEditor, line, Boolean.FALSE);
        if (bp != null) {
            bp.removeBreakpoint();
            this.updateBreakpointsWindow();
        } else {
            this.createBreakpoint(context, line);
        }
    }

    private void createBreakpoint(Context context, int line) {
        URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.activeWorkspace, this.activeProject);
        Node node = context.getNode();
        if (node != null) {
            Breakpoint bp = null;
            if (JDebugger.usePackageFileLine(context, line)) {
                String pkg = Source.getPackageFromNode(node, context.getProject());
                String file = Source.getFilenameFromNode(node);
                if (pkg != null && file != null && file.length() > 0) {
                    bp = new Breakpoint(ownerURL, 0, pkg, file, line);
                }
            } else {
                String methodName;
                URL url = node.getURL();
                boolean nodeIsBytecodeDisassembly = false;
                BytecodeFileSystemHelper bytecodeHelper = BytecodeFileSystemHelper.getInstance(false);
                if (bytecodeHelper != null && (methodName = BytecodeFileSystemHelper.getMethodName(url)) != null) {
                    nodeIsBytecodeDisassembly = true;
                    int offset = bytecodeHelper.getBytecodeOffsetFromLine(url, line);
                    if (offset != -1) {
                        bp = new Breakpoint(ownerURL, 7, methodName, offset);
                    }
                }
                if (!nodeIsBytecodeDisassembly) {
                    bp = new Breakpoint(ownerURL, 5, url, line);
                }
            }
            this.addBreakpoint(bp);
        }
    }

    Breakpoint findWatchpoint(String className, String fieldName) {
        Breakpoint possible = null;
        URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.activeWorkspace, this.activeProject);
        int length = this.activeBreakpoints.length;
        for (int i = 0; i < length; ++i) {
            for (Breakpoint bp : this.activeBreakpoints[i]) {
                if (bp.getType() != 6 || !bp.getClassName().equals(className) || !bp.getFieldName().equals(fieldName)) continue;
                if (ownerURL == null || URLFileSystem.equals((URL)ownerURL, (URL)bp.getOwnerURL())) {
                    return bp;
                }
                possible = bp;
            }
        }
        return possible;
    }

    private void createWatchpoint(String className, String fieldName) {
        URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.activeWorkspace, this.activeProject);
        this.addBreakpoint(new Breakpoint(ownerURL, 6, className, fieldName, false, true));
    }

    private void toggleWatchpoint(String className, String fieldName) {
        Breakpoint bp = this.findWatchpoint(className, fieldName);
        if (bp != null) {
            bp.removeBreakpoint();
            this.updateBreakpointsWindow();
        } else {
            this.createWatchpoint(className, fieldName);
        }
    }

    static URL getNewBreakpointOwnerURL(Workspace workspace, Project project) {
        String bpScope = BreakpointsWindowSettings.getInstance().getBreakpointScope();
        if (bpScope.equals("workspace") && workspace != null && workspace != Ide.getDefaultWorkspace()) {
            return workspace.getURL();
        }
        if (bpScope.equals("project") && project != null && project != Ide.getDefaultProject()) {
            return project.getURL();
        }
        return null;
    }

    static boolean usePackageFileLine(Context context, int line) {
        Iterator<PackageFileLineCheck> packageFileLineChecks = PackageFileLineChecker.getPackageFileLineChecks();
        while (packageFileLineChecks.hasNext()) {
            if (packageFileLineChecks.next().usePackageFileLine(context, line)) continue;
            return false;
        }
        Node node = context.getNode();
        return node instanceof PackagedSource;
    }

    void breakpointHasBeenPut(Breakpoint bp, DebugBreakpoint dbp) {
        if (this.breakpointForDebugBreakpoint == null) {
            this.breakpointForDebugBreakpoint = new HashMap<DebugBreakpoint, Breakpoint>();
        }
        this.breakpointForDebugBreakpoint.put(dbp, bp);
    }

    private void tempBreakpointHasBeenPut(DebuggingProcess process, Breakpoint bp, DebugBreakpoint dbp) {
        this.breakpointHasBeenPut(bp, dbp);
        this.clearTempBreakpoint(process);
        if (this.temporaryBreakpoints == null) {
            this.temporaryBreakpoints = new HashMap<DebuggingProcess, DebugBreakpoint>();
        }
        this.temporaryBreakpoints.put(process, dbp);
        this.extenderManager.temporaryBreakpointSet(process.getContext(), bp);
    }

    void clearTempBreakpoint(DebuggingProcess process) {
        DebugBreakpoint dbp;
        if (this.temporaryBreakpoints != null && (dbp = this.temporaryBreakpoints.remove(process)) != null) {
            Breakpoint bp = this.breakpointForDebugBreakpoint.get(dbp);
            if (bp != null) {
                this.breakpointHasBeenRemoved(bp);
            }
            this.breakpointHasBeenRemoved(dbp);
        }
    }

    void breakpointHasBeenRemoved(DebugBreakpoint dbp) {
        this.breakpointForDebugBreakpoint.remove(dbp);
    }

    void breakpointHasBeenRemoved(Breakpoint bp) {
        this.extenderManager.breakpointDeleted(bp);
    }

    void breakpointHasBeenMoved(Breakpoint bp) {
        this.extenderManager.breakpointMoved(bp);
        this.updateBreakpointsWindow();
    }

    void breakpointHasBeenRefactored(Breakpoint bp) {
        this.extenderManager.breakpointRefactored(bp);
        this.updateBreakpointsWindow();
    }

    Breakpoint findBreakpoint(DebugBreakpoint dbp) {
        if (dbp == null) {
            return null;
        }
        if (this.breakpointForDebugBreakpoint != null) {
            return this.breakpointForDebugBreakpoint.get(dbp);
        }
        return null;
    }

    void breakpointChanged(DebuggingProcess debuggingProcess, DebugBreakpoint dbp) {
        Breakpoint bp = this.findBreakpoint(dbp);
        if (bp != null) {
            bp.changed(dbp, debuggingProcess);
            this.updateBreakpointsWindow();
            this.extenderManager.breakpointChanged(debuggingProcess, bp);
        }
    }

    void viewBreakpoints() {
        DockUtil.showDockableWindow((DockableView)this.getBreakpointsWindow(true));
    }

    void viewWatches() {
        DockUtil.showDockableWindow((DockableView)this.getWatchWindow(true));
    }

    void viewHeap() {
        DockUtil.showDockableWindow((DockableView)this.getHeapWindow(true));
    }

    void viewMonitors() {
        this.windowManager.installWindow("Debugger.MonitorsWindow");
        DockableWindow dw = this.windowManager.getDebuggerWindow("Debugger.MonitorsWindow");
        DockUtil.showDockableWindow((DockableView)dw);
    }

    private void viewLog() {
        LogPage logPage;
        DebuggingProcess process = this.activeDebuggingProcess;
        if (process != null && (logPage = process.getLogPage()) instanceof RunLogPage) {
            ((RunLogPage)logPage).show();
        }
    }

    void listenerStarted(DebuggingListener debuggingListener) {
        if (this.debuggingListeners == null) {
            this.debuggingListeners = new ArrayList<DebuggingListener>();
        }
        this.debuggingListeners.add(debuggingListener);
    }

    void listenerStopped(DebuggingListener debuggingListener) {
        this.debuggingListeners.remove(debuggingListener);
    }

    void debuggingProcessCreated() {
        if (this.firstDebuggingProcessCreated) {
            this.firstDebuggingProcessCreated = false;
            this.makeDebuggingProcessActions();
            this.addSmartDataProvider(new SmartJava());
            JavaExpressionProvider expressionProvider = new JavaExpressionProvider();
            this.addToolTipExpressionProvider(expressionProvider);
            this.addInspectorExpressionProvider(expressionProvider);
        }
    }

    void debuggingProcessBeforeConnecting(DebuggingProcess debuggingProcess) {
        if (this.debuggingProcessesConnecting == null) {
            this.debuggingProcessesConnecting = new ArrayList<DebuggingProcess>();
        }
        this.debuggingProcessesConnecting.add(debuggingProcess);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowCancelDebugConnection);
        this.checkCommandsForTopLogPage();
    }

    void debuggingProcessAfterConnecting(DebuggingProcess debuggingProcess) {
        if (this.debuggingProcessesConnecting != null) {
            this.debuggingProcessesConnecting.remove(debuggingProcess);
        }
    }

    void debuggingProcessStarted(DebuggingProcess debuggingProcess) {
        if (this.debuggingProcesses == null) {
            this.debuggingProcesses = new ArrayList<DebuggingProcess>();
        }
        if (this.debuggingProcesses.isEmpty()) {
            this.showActionButtonsOnMainToolbar(true);
        }
        this.debuggingProcesses.add(debuggingProcess);
        SharedActions.getInstance().processStarted(debuggingProcess);
        this.addNormalButtons(debuggingProcess);
        debuggingProcess.showProcessActionButtonsOnToolbar(this.dbgSettings.isShowActionButtonsOnToolbar());
        this.checkCommandsForTopLogPage();
        this.getThreadsWindow(true).getGUI();
        this.getStackWindow(true).getGUI();
    }

    private void addNormalButtons(DebuggingProcess debuggingProcess) {
        JComponent terminateButton = TerminateRunProcessButtons.getTerminateRunProcessButton((RunProcess)debuggingProcess, (IdeAction)actionLogWindowReset);
        debuggingProcess.addProcessActionButtonToToolbar(terminateButton);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowShowIP);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowStepOver);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowStepInto);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowStepOut);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowStepToEndOfMethod);
        debuggingProcess.addByteCodeActionButtonToToolbar(actionLogWindowStepOverBC);
        debuggingProcess.addByteCodeActionButtonToToolbar(actionLogWindowStepIntoBC);
        if (BytecodeFileSystemHelper.getInstance(false) != null) {
            debuggingProcess.enableByteCodeButtonsOnToolbar();
        }
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowResume);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowPause);
        debuggingProcess.addProcessActionButtonToToolbar(actionLogWindowGC);
    }

    void addStepBytecodeActions() {
        if (this.debuggingProcesses != null) {
            for (DebuggingProcess debuggingProcess : this.debuggingProcesses) {
                debuggingProcess.enableByteCodeButtonsOnToolbar();
                debuggingProcess.showProcessActionButtonsOnToolbar(this.dbgSettings.isShowActionButtonsOnToolbar());
            }
            this.showByteCodeActionButtonsOnMainToolbar(true);
            Context[] context = new Context[1];
            this.updateIfVisible(actionDebugStepOverBC, context);
            this.updateIfVisible(actionDebugStepIntoBC, context);
            LogPage logPage = LogManager.getIdeLogWindow().getPage();
            if (logPage instanceof RunLogPage) {
                context[0] = logPage.getLogPageView().getContext();
                this.updateIfVisible(actionLogWindowStepOverBC, context);
                this.updateIfVisible(actionLogWindowStepIntoBC, context);
            }
        }
    }

    void pauseAndInvoke(RunWhilePaused runWhilePaused, Runnable runOnceLater) {
        DebuggingProcess[] processes = this.debuggingProcesses != null ? this.debuggingProcesses.toArray(new DebuggingProcess[this.debuggingProcesses.size()]) : new DebuggingProcess[]{};
        JDebugger.pauseAndInvoke(processes, runWhilePaused, runOnceLater);
    }

    static void pauseAndInvoke(DebuggingProcess[] processes, final RunWhilePaused runWhilePaused, final Runnable runOnceLater) {
        int length = processes.length;
        if (length > 0) {
            final int[] countDown = new int[]{length};
            RunWhilePaused wrapper = new RunWhilePaused(){

                @Override
                public void run(DebuggingProcess debuggingProcess, boolean live) {
                    if (debuggingProcess != null && live) {
                        runWhilePaused.run(debuggingProcess, live);
                    }
                    countDown[0] = countDown[0] - 1;
                    if (countDown[0] == 0 && runOnceLater != null) {
                        SwingUtilities.invokeLater(runOnceLater);
                    }
                }
            };
            for (int i = 0; i < length; ++i) {
                processes[i].runWhilePaused(wrapper);
            }
        } else if (runOnceLater != null) {
            SwingUtilities.invokeLater(runOnceLater);
        }
    }

    DebuggingProcess findDebuggingProcess(DebugVirtualMachine vm) {
        if (this.debuggingProcesses != null) {
            for (DebuggingProcess debuggingProcess : this.debuggingProcesses) {
                if (debuggingProcess.getVM() != vm) continue;
                return debuggingProcess;
            }
        }
        return null;
    }

    DebuggingProcess findDebuggingProcess(RunLogPage runLogPage, boolean connecting) {
        List<DebuggingProcess> list;
        List<DebuggingProcess> list2 = list = connecting ? this.debuggingProcessesConnecting : this.debuggingProcesses;
        if (list != null) {
            for (DebuggingProcess debuggingProcess : list) {
                if (debuggingProcess.getLogPage() != runLogPage) continue;
                return debuggingProcess;
            }
        }
        return null;
    }

    void processSelected(DebuggingProcess debuggingProcess) {
        this.activeDebuggingProcess = debuggingProcess;
        Workspace workspace = debuggingProcess.getWorkspace();
        Project project = debuggingProcess.getProject();
        List[] breakpoints = Breakpoint.getBreakpoints(workspace, project);
        Breakpoint.updateBreakpointIcons(breakpoints);
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.processSelectionChanged();
        }
        this.checkCommandsBecauseActiveDebuggingProcessChanged();
        this.windowManager.setDebuggerWindowProvidersContext(debuggingProcess.getContext());
    }

    void processUnselected(DebuggingProcess debuggingProcess) {
        this.activeDebuggingProcess = null;
        SourceIcon.removeColumn(2);
        Container popupMenu = contextMenu.getGUI(false);
        if (popupMenu != null && popupMenu.isVisible()) {
            popupMenu.setVisible(false);
        }
        Workspace workspace = debuggingProcess.getWorkspace();
        Project project = debuggingProcess.getProject();
        List[] breakpoints = Breakpoint.getBreakpoints(workspace, project);
        Breakpoint.updateBreakpointIcons(breakpoints);
        if (this.breakpointsWindow != null) {
            this.breakpointsWindow.processSelectionChanged();
        }
        this.checkCommandsBecauseActiveDebuggingProcessChanged();
    }

    void debuggingProcessFinished(DebuggingProcess debuggingProcess) {
        if (this.activeDebuggingProcess == debuggingProcess) {
            this.activeDebuggingProcess = null;
            SourceIcon.removeColumn(2);
        }
        if (this.debuggingProcesses != null) {
            this.debuggingProcesses.remove(debuggingProcess);
            if (this.debuggingProcesses.isEmpty()) {
                this.showActionButtonsOnMainToolbar(false);
            }
        }
        if (this.threadsWindow != null) {
            this.threadsWindow.processFinished(debuggingProcess);
        }
        if (this.smartWindow != null) {
            this.smartWindow.processFinished(debuggingProcess);
        }
        if (this.classesWindow != null) {
            this.classesWindow.processFinished(debuggingProcess);
        }
        if (this.heapWindow != null) {
            this.heapWindow.processFinished(debuggingProcess);
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.processFinished(debuggingProcess);
        }
        if (this.objectPreferences != null) {
            this.objectPreferences.processFinished();
        }
    }

    boolean isActiveDebuggingProcess(DebuggingProcess debuggingProcess) {
        if (this.activeDebuggingProcess != null) {
            return this.activeDebuggingProcess.equals(debuggingProcess);
        }
        return false;
    }

    DebuggingProcess getActiveDebuggingProcess() {
        return this.activeDebuggingProcess;
    }

    boolean canShowDebuggingWindows() {
        return this.activeDebuggingProcess != null;
    }

    static boolean isDebuggingLayout(Layout layout) {
        String debugLayoutProperty = layout.getProperty(DEBUG_LAYOUT_KEY, Boolean.toString(false));
        return Boolean.toString(true).equals(debugLayoutProperty);
    }

    boolean canShowDebuggingWindows(Layout layout) {
        return this.canShowDebuggingWindows() && JDebugger.isDebuggingLayout(layout);
    }

    boolean canShowHeapWindow() {
        if (this.activeDebuggingProcess != null) {
            try {
                DebugVirtualMachine vm = this.activeDebuggingProcess.getVM();
                if (vm != null) {
                    return vm.getCapabilities().canGetHeap();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    boolean canShowMonitorsWindow() {
        if (this.activeDebuggingProcess != null) {
            try {
                DebugVirtualMachine vm = this.activeDebuggingProcess.getVM();
                if (vm != null) {
                    return vm.getCapabilities().canGetMonitors();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private Breakpoint getBreakpointFromGutterMarkRightClick(Context context) {
        Object o;
        GutterMark gutterMark;
        if (context.getView() instanceof CodeEditorGutter.GutterView && (gutterMark = CodeEditorGutter.getMarkForContext((Context)context)) != null && (o = gutterMark.getUserData()) instanceof SourceIcon) {
            SourceIcon sourceIcon = (SourceIcon)o;
            Breakpoint bp = sourceIcon.getBreakpoint();
            return bp;
        }
        return null;
    }

    private boolean toggleBreakpointFromCodeEditor(Context context, IdeAction action) {
        int editorLine;
        Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
        if (bp != null && bp.getType() != 6) {
            if (action != null) {
                action.setEnabled(true);
            } else {
                bp.removeBreakpoint();
                this.updateBreakpointsWindow();
            }
            return true;
        }
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorLine = Source.getLineFromCodeEditor(context)) != 0) {
            if (action != null) {
                action.setEnabled(true);
            } else {
                this.toggleBreakpoint(context, codeEditor, editorLine);
            }
            return true;
        }
        if (action != null) {
            action.setEnabled(false);
        }
        return false;
    }

    private boolean toggleWatchpointFromCodeEditor(Context context, IdeAction action) {
        Node editorNode;
        Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
        if (bp != null && bp.getType() == 6) {
            if (action == null) {
                bp.removeBreakpoint();
                this.updateBreakpointsWindow();
            }
            return true;
        }
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorNode = Source.getNodeFromCodeEditor(context)) instanceof JavaSourceNode) {
            JavaManager javaManager;
            SourceFile sourceFile;
            int editorOffset = 0;
            if (context.getView() instanceof CodeEditorGutter.GutterView) {
                int line = Source.getLineFromCodeEditor(context);
                if (line == 0) {
                    return false;
                }
                editorOffset = JDebugger.getLineStartOffsetSkipWhite(codeEditor, line);
            } else {
                editorOffset = codeEditor.getCaretPosition();
            }
            Project project = context.getProject();
            if (project != null && (sourceFile = (javaManager = JavaManager.getJavaManager((Project)project)).getSourceFile(editorNode.getURL())) != null) {
                SourceElement sourceElement = sourceFile.getElementAt(editorOffset);
                SourceFieldVariable sourceFieldVariable = null;
                if (sourceElement instanceof SourceName) {
                    Iterator itVariables;
                    if ((sourceElement = sourceElement.getParent()) instanceof SourceFieldVariable) {
                        sourceFieldVariable = (SourceFieldVariable)sourceElement;
                    } else if (sourceElement instanceof SourceTypeReference && (sourceElement = sourceElement.getParent()) instanceof SourceFieldDeclaration && (itVariables = ((SourceFieldDeclaration)sourceElement).getVariables().iterator()).hasNext()) {
                        sourceFieldVariable = (SourceFieldVariable)itVariables.next();
                    }
                }
                if (sourceFieldVariable != null) {
                    SourcePackage sourcePackage;
                    SourceClass sourceClass = sourceFieldVariable.getEnclosingClass();
                    String className = sourceClass.getName();
                    if (className.indexOf(".") == -1 && (sourcePackage = sourceFile.getSourcePackage()) != null) {
                        className = sourcePackage.getName() + "." + className;
                    }
                    String fieldName = sourceFieldVariable.getName();
                    if (action == null) {
                        this.toggleWatchpoint(className, fieldName);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean enableBreakpointFromCodeEditor(Context context, IdeAction action) {
        int editorLine;
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorLine = Source.getLineFromCodeEditor(context)) != 0) {
            Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
            if (bp == null) {
                bp = this.findBreakpointByIconLocation(codeEditor, editorLine, null);
            }
            if (bp != null && !bp.isEnabledNow()) {
                if (action != null) {
                    if (bp.getType() == 6) {
                        action.putValue("Name", (Object)DbgArb.getString(122));
                    } else {
                        action.putValue("Name", (Object)DbgArb.getString(121));
                    }
                    action.setEnabled(true);
                } else {
                    bp.setEnabled(true);
                }
                return true;
            }
        }
        if (action != null) {
            action.setEnabled(false);
        }
        return false;
    }

    private boolean disableBreakpointFromCodeEditor(Context context, IdeAction action) {
        int editorLine;
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorLine = Source.getLineFromCodeEditor(context)) != 0) {
            Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
            if (bp == null) {
                bp = this.findBreakpointByIconLocation(codeEditor, editorLine, null);
            }
            if (bp != null && bp.isEnabledNow()) {
                if (action != null) {
                    if (bp.getType() == 6) {
                        action.putValue("Name", (Object)DbgArb.getString(125));
                    } else {
                        action.putValue("Name", (Object)DbgArb.getString(124));
                    }
                    action.setEnabled(true);
                } else {
                    bp.setEnabled(false);
                }
                return true;
            }
        }
        if (action != null) {
            action.setEnabled(false);
        }
        return false;
    }

    private boolean editBreakpointFromCodeEditor(Context context, IdeAction action) {
        int editorLine;
        CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
        if (codeEditor != null && (editorLine = Source.getLineFromCodeEditor(context)) != 0) {
            Breakpoint bp = this.getBreakpointFromGutterMarkRightClick(context);
            if (bp == null) {
                bp = this.findBreakpointByIconLocation(codeEditor, editorLine, null);
            }
            if (bp != null) {
                if (action != null) {
                    if (bp.getType() == 6) {
                        action.putValue("Name", (Object)DbgArb.getString(128));
                    } else {
                        action.putValue("Name", (Object)DbgArb.getString(127));
                    }
                    action.setEnabled(true);
                } else {
                    this.getBreakpointsWindow(true).editBreakpoint(bp);
                }
                return true;
            }
        }
        if (action != null) {
            action.setEnabled(false);
        }
        return false;
    }

    boolean editBreakpoint(Breakpoint bp) {
        return this.getBreakpointsWindow(true).editBreakpoint(bp);
    }

    private boolean createWatchpointFromStructure(Context context, IdeAction action) {
        Element element = context.getElement();
        if (element instanceof FieldElement) {
            String fieldName;
            Breakpoint bp;
            String pkg;
            FieldElement fieldElement = (FieldElement)element;
            ClassElement classElement = fieldElement.getEnclosingClass();
            String className = classElement.getSymbolName();
            if (className.indexOf(".") == -1 && (pkg = classElement.getPackageName()) != null && pkg.length() > 0) {
                className = pkg + "." + className;
            }
            if ((bp = this.findWatchpoint(className, fieldName = fieldElement.getSymbolName())) == null) {
                if (action == null) {
                    this.createWatchpoint(className, fieldName);
                }
                return true;
            }
        }
        return false;
    }

    static String trimExpression(String expression) {
        StringBuffer buffer = new StringBuffer();
        String[] parts = expression.split("[\r\n]");
        for (int i = 0; i < parts.length; ++i) {
            buffer.append(parts[i].trim());
        }
        return buffer.toString();
    }

    private void watchFromCodeEditor(Context context) {
        if (this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped()) {
            String expression = null;
            CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
            if (codeEditor != null) {
                expression = codeEditor.getSelectedText();
                if (expression != null) {
                    expression = JDebugger.trimExpression(expression);
                }
            } else {
                return;
            }
            boolean showWatchWindow = false;
            if (expression != null && expression.length() > 0) {
                this.addWatch(expression);
                showWatchWindow = true;
            } else {
                Set<String> expressions = ExpressionProvider.getInspectorExpressions(codeEditor, codeEditor.getCaretPosition());
                if (expressions.size() > 0) {
                    expression = expressions.iterator().next();
                }
                if (expression == null) {
                    expression = "";
                }
                this.getWatchWindow(true);
                if (this.watchWindow.addWatchDialog(expression)) {
                    showWatchWindow = true;
                }
            }
            if (showWatchWindow) {
                this.viewWatches();
            }
        }
    }

    private void inspectFromCodeEditor(Context context) {
        if (this.activeDebuggingProcess != null && this.activeDebuggingProcess.isStopped()) {
            String expression = null;
            CodeEditor codeEditor = Source.getCodeEditorFromContext(context);
            if (codeEditor != null) {
                expression = codeEditor.getSelectedText();
                if (expression != null) {
                    expression = JDebugger.trimExpression(expression);
                }
            } else {
                return;
            }
            if (expression != null && expression.length() > 0) {
                this.inspect(expression);
                return;
            }
            Set<String> expressions = ExpressionProvider.getInspectorExpressions(codeEditor, codeEditor.getCaretPosition());
            if (expressions.size() > 0) {
                expression = expressions.iterator().next();
            }
            if (expression == null) {
                expression = "";
            }
            if ((expression = InspectorWindow.inspectDialog(expression)) != null) {
                this.inspect(expression);
            }
        }
    }

    private static RunLogPage getRunLogPage(Context context) {
        LogPage logPage;
        View view = context.getView();
        if (view instanceof RunLogPage) {
            return (RunLogPage)view;
        }
        LogWindow logWindow = LogManager.getLogManager().getLogWindow();
        if (logWindow != null && (logPage = logWindow.getPage()) instanceof RunLogPage) {
            return (RunLogPage)logPage;
        }
        return null;
    }

    private boolean canDoLogWindowAction(Context context, int cmdId) {
        RunLogPage runLogPage;
        if (context != null && (runLogPage = JDebugger.getRunLogPage(context)) != null) {
            if (cmdId == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID) {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, true);
                if (debuggingProcess != null) {
                    return debuggingProcess.canCancelConnection();
                }
            } else {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, false);
                if (debuggingProcess != null && debuggingProcess == this.activeDebuggingProcess) {
                    if (cmdId == DEBUG_SHOWIP_CMD_ID) {
                        return debuggingProcess.canShowIP();
                    }
                    if (cmdId == DEBUG_RESUME_CMD_ID) {
                        return debuggingProcess.canResume();
                    }
                    if (cmdId == DEBUG_STEPOVER_CMD_ID) {
                        return debuggingProcess.canStepOver();
                    }
                    if (cmdId == DEBUG_STEPINTO_CMD_ID) {
                        return debuggingProcess.canStepInto();
                    }
                    if (cmdId == DEBUG_STEPOUT_CMD_ID) {
                        return debuggingProcess.canStepOut();
                    }
                    if (cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID) {
                        return debuggingProcess.canStepToEndOfMethod();
                    }
                    if (cmdId == DEBUG_STEPOVERBC_CMD_ID) {
                        return debuggingProcess.canStepOver();
                    }
                    if (cmdId == DEBUG_STEPINTOBC_CMD_ID) {
                        return debuggingProcess.canStepInto();
                    }
                    if (cmdId == DEBUG_PAUSE_CMD_ID) {
                        return debuggingProcess.canPause();
                    }
                    if (cmdId == DEBUG_GC_CMD_ID) {
                        return debuggingProcess.canGC();
                    }
                    if (cmdId == DEBUG_RESET_CMD_ID) {
                        return debuggingProcess.canTerminate();
                    }
                }
            }
        }
        return false;
    }

    private void doLogWindowAction(Context context, int cmdId) {
        RunLogPage runLogPage;
        if (context != null && (runLogPage = JDebugger.getRunLogPage(context)) != null) {
            if (cmdId == LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID) {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, true);
                if (debuggingProcess != null) {
                    debuggingProcess.cancelConnection();
                }
            } else {
                DebuggingProcess debuggingProcess = this.findDebuggingProcess(runLogPage, false);
                if (debuggingProcess != null) {
                    if (cmdId == DEBUG_SHOWIP_CMD_ID) {
                        debuggingProcess.showIP();
                    } else if (cmdId == DEBUG_RESUME_CMD_ID) {
                        debuggingProcess.resume();
                    } else if (cmdId == DEBUG_STEPOVER_CMD_ID) {
                        debuggingProcess.stepOver(JDebugger.getEventTime(context));
                    } else if (cmdId == DEBUG_STEPINTO_CMD_ID) {
                        debuggingProcess.stepInto(JDebugger.getEventTime(context));
                    } else if (cmdId == DEBUG_STEPOUT_CMD_ID) {
                        debuggingProcess.stepOut(JDebugger.getEventTime(context));
                    } else if (cmdId == DEBUG_STEPTOENDOFMETHOD_CMD_ID) {
                        debuggingProcess.stepToEndOfMethod(JDebugger.getEventTime(context));
                    } else if (cmdId == DEBUG_STEPOVERBC_CMD_ID) {
                        debuggingProcess.stepOverBC(JDebugger.getEventTime(context));
                    } else if (cmdId == DEBUG_STEPINTOBC_CMD_ID) {
                        debuggingProcess.stepIntoBC(JDebugger.getEventTime(context));
                    } else if (cmdId == DEBUG_PAUSE_CMD_ID) {
                        debuggingProcess.pause();
                    } else if (cmdId == DEBUG_GC_CMD_ID) {
                        debuggingProcess.gc();
                    } else if (cmdId == DEBUG_RESET_CMD_ID) {
                        debuggingProcess.terminate();
                    }
                }
            }
        }
    }

    void showContextMenu(MouseEvent e, DockableWindow dw, JFastTreeTable treeTable) {
        if (treeTable != null && treeTable.isEnabled() && e.getSource() == treeTable) {
            JTree tree = treeTable.getTree();
            int y = e.getY();
            int w = treeTable.getWidth();
            for (int x = 20; x < w; x += 20) {
                TreePath treePath = tree.getPathForLocation(x, y);
                if (treePath == null) continue;
                boolean alreadySelected = false;
                TreePath[] treePaths = tree.getSelectionPaths();
                if (treePaths != null) {
                    for (int i = treePaths.length - 1; i >= 0; --i) {
                        if (!treePath.equals(treePaths[i])) continue;
                        alreadySelected = true;
                        break;
                    }
                }
                if (alreadySelected) continue;
                this.selectTreeTablePath(treeTable, treePath, false);
            }
        }
        this.showContextMenu(e, dw);
    }

    void showContextMenu(MouseEvent e, DockableWindow dw, JTable table) {
        int row;
        if (table != null && table.isEnabled() && e.getSource() == table && table.isEnabled() && (row = table.rowAtPoint(e.getPoint())) != -1) {
            ListSelectionModel listSelectionModel = table.getSelectionModel();
            listSelectionModel.clearSelection();
            listSelectionModel.addSelectionInterval(row, row);
        }
        this.showContextMenu(e, dw);
    }

    void showContextMenu(final MouseEvent e, DockableWindow dw) {
        DockStation.getDockStation().activateDockable((Dockable)dw);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Context context = Ide.getMainWindow().getLastActiveView().getContext((EventObject)e);
                ContextMenu debuggerContextMenu = JDebugger.this.getContextMenu();
                debuggerContextMenu.show(context);
            }
        });
    }

    void selectTreeTablePath(JFastTreeTable treeTable, TreePath treePath, boolean scrollToVisible) {
        this.selectTreeTablePath(treeTable, new TreePath[]{treePath}, scrollToVisible);
    }

    void selectTreeTablePath(final JFastTreeTable treeTable, final TreePath[] treePaths, boolean scrollToVisible) {
        final JTree tree = treeTable.getTree();
        if (scrollToVisible) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int row = tree.getRowForPath(treePaths[0]);
                    Rectangle r = treeTable.getCellRect(row, 0, true);
                    if (r != null) {
                        treeTable.scrollRectToVisible(r);
                    }
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePath[] currentSelection = tree.getSelectionPaths();
                boolean areEqual = true;
                if (currentSelection == null || currentSelection.length != treePaths.length) {
                    areEqual = false;
                } else {
                    for (int i = 0; i < currentSelection.length; ++i) {
                        if (currentSelection[i].equals(treePaths[i])) continue;
                        areEqual = false;
                        break;
                    }
                }
                if (!areEqual) {
                    tree.setSelectionPaths(treePaths);
                }
            }
        });
    }

    static void adjustColumnsAfterResize(JScrollPane scrollPane, JTable table) {
        int tableWidth;
        if (table.getAutoResizeMode() == 0) {
            tableWidth = table.getWidth();
        } else {
            tableWidth = 0;
            TableColumnModel tableColumnModel = table.getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                TableColumn column = e.nextElement();
                tableWidth += column.getPreferredWidth();
            }
        }
        int extra = scrollPane.getViewport().getWidth() - tableWidth;
        if (extra > 0) {
            boolean firstColumn = true;
            TableColumnModel tableColumnModel = table.getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                TableColumn column = e.nextElement();
                int width = column.getPreferredWidth();
                if (firstColumn) {
                    int remainingColumnCount = tableColumnModel.getColumnCount() - 1;
                    int extraForFirstColumn = remainingColumnCount > 0 ? extra / 2 : extra;
                    width += extraForFirstColumn;
                    if ((extra -= extraForFirstColumn) > 0 && remainingColumnCount > 0) {
                        extra /= remainingColumnCount;
                    }
                } else {
                    width += extra;
                }
                column.setPreferredWidth(width);
                firstColumn = false;
                if (extra > 0) continue;
                break;
            }
        }
    }

    static void addColumnsMenu(final JTable table, final ColumnMenuListener columnMenuListener, boolean[] showColumnInMenu) {
        int showColumnInMenuLength = showColumnInMenu.length;
        final ArrayList<TableColumn> allColumns = new ArrayList<TableColumn>();
        TableColumnModel tableColumnModel = table.getColumnModel();
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            int modelIndex = column.getModelIndex();
            if (modelIndex >= showColumnInMenuLength || !showColumnInMenu[modelIndex]) continue;
            allColumns.add(column);
        }
        JTableHeader tableHeader = table.getTableHeader();
        tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            private void showPopup(MouseEvent e) {
                Context context = Ide.getMainWindow().getLastActiveView().getContext((EventObject)e);
                ContextMenu contextMenu = new ContextMenu();
                contextMenu.addContextMenuListener(new ContextMenuListener(){

                    public void menuWillShow(ContextMenu popup) {
                        HashMap<Integer, JCheckBoxMenuItem> menuItems = new HashMap<Integer, JCheckBoxMenuItem>();
                        for (TableColumn column : allColumns) {
                            final int modelIndex = column.getModelIndex();
                            final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(column.getHeaderValue().toString());
                            menuItem.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (menuItem.getState()) {
                                        columnMenuListener.showColumn(modelIndex);
                                    } else {
                                        columnMenuListener.hideColumn(modelIndex);
                                    }
                                }
                            });
                            menuItems.put(modelIndex, menuItem);
                            popup.add((Component)menuItem);
                        }
                        TableColumnModel tableColumnModel = table.getColumnModel();
                        Enumeration<TableColumn> e = tableColumnModel.getColumns();
                        while (e.hasMoreElements()) {
                            TableColumn column = e.nextElement();
                            int modelIndex = column.getModelIndex();
                            JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)menuItems.get(modelIndex);
                            if (menuItem == null) continue;
                            menuItem.setState(true);
                        }
                    }

                    public void menuWillHide(ContextMenu popup) {
                    }

                    public boolean handleDefaultAction(Context context) {
                        return false;
                    }
                });
                contextMenu.show(context);
            }
        });
    }

    static boolean isDoubleClickInTreeTable(JFastTreeTable treeTable, MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0 && e.getClickCount() == 2) {
            int columnAtX = treeTable.getColumnModel().getColumnIndexAtX(e.getX());
            int column = treeTable.convertColumnIndexToModel(columnAtX);
            if (column == 0) {
                Rectangle r;
                JTree tree = treeTable.getTree();
                TreePath treePath = tree.getSelectionPath();
                if (treePath != null && (r = tree.getPathBounds(treePath)) != null) {
                    r.width = 1000;
                    Point p = e.getPoint();
                    if (r.contains(p)) {
                        return true;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    ObjectPreferences getObjectPreferences() {
        if (this.objectPreferences == null) {
            this.objectPreferences = new ObjectPreferences();
        }
        return this.objectPreferences;
    }

    void setUseFilters(boolean useFilters) {
        this.dbgSettings.setUseFilters(useFilters);
        if (this.smartWindow != null) {
            this.smartWindow.setUseFilters(useFilters);
        }
        if (this.localsWindow != null) {
            this.localsWindow.setUseFilters(useFilters);
        }
        if (this.watchWindow != null) {
            this.watchWindow.setUseFilters(useFilters);
        }
        if (this.inspectorWindows != null) {
            for (InspectorWindow inspectorWindow : this.inspectorWindows) {
                inspectorWindow.setUseFilters(useFilters);
            }
        }
        if (this.heapWindow != null) {
            this.heapWindow.setUseFilters(useFilters);
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.setUseFilters(useFilters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dataHasBeenModified() {
        WaitCursor wc = Ide.getWaitCursor();
        wc.show();
        try {
            this.updateDataWindows();
            if (this.threadsWindow != null) {
                this.threadsWindow.everythingChanged();
            }
            if (this.classesWindow != null) {
                this.classesWindow.everythingChanged();
            }
        }
        finally {
            wc.hide();
        }
    }

    void updateDataWindows() {
        if (this.smartWindow != null) {
            this.smartWindow.everythingChanged();
        }
        if (this.localsWindow != null) {
            this.localsWindow.everythingChanged();
        }
        if (this.watchWindow != null) {
            this.watchWindow.everythingChanged();
        }
        if (this.inspectorWindows != null) {
            for (InspectorWindow inspectorWindow : this.inspectorWindows) {
                inspectorWindow.everythingChanged();
            }
        }
        if (this.heapWindow != null) {
            this.heapWindow.everythingChanged();
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.everythingChanged();
        }
        this.windowManager.refreshCustomWindows();
    }

    void refreshSmartWindow() {
        if (this.smartWindow != null) {
            this.smartWindow.refreshWindow();
        }
    }

    void refreshCustomWindows(Evaluator evaluator, DebuggingProcess process) {
        this.windowManager.refreshCustomWindows(evaluator, process);
    }

    static List<SmartDataProvider> getSmartDataProviders() {
        return smartDataProviders;
    }

    static List<ToolTipExpressionProvider> getToolTipExpressionProviders() {
        return toolTipExpressionProviders;
    }

    static List<DebuggerInspectorExpressionProvider> getInspectorExpressionProviders() {
        return inspectorExpressionProviders;
    }

    void stackFramesPopped() {
        if (this.stackWindow != null) {
            this.stackWindow.everythingChanged();
        }
        if (this.monitorsWindow != null) {
            this.monitorsWindow.everythingChanged();
        }
    }

    static PrintWriter printHtmlHeader(URL url, String title) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)), IdeUtil.getIdeIanaEncoding()));
        pw.println("<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">");
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + IdeUtil.getIdeIanaEncoding() + "\">");
        pw.println("<meta name=\"Author\" content=\"JDeveloper Debugger\">");
        pw.println("<title>" + title + "</title>");
        pw.println("</head>");
        pw.println("<body>");
        return pw;
    }

    static void printHtmlFooter(PrintWriter pw) {
        pw.println("</body>");
        pw.println("</html>");
    }

    static void setControllerForActions(IdeAction[] actions, Controller controller) {
        for (int i = 0; i < actions.length; ++i) {
            IdeAction action = actions[i];
            if (action == null) continue;
            action.addController(controller);
            action.putValue(ACTION_OWNER, (Object)controller);
        }
    }

    static void clearControllerForActions(IdeAction[] actions, Controller controller) {
        for (int i = 0; i < actions.length; ++i) {
            IdeAction action = actions[i];
            if (action == null) continue;
            action.removeController(controller);
            action.putValue(ACTION_OWNER, null);
            action.setEnabled(false);
        }
    }

    static String fixTreeCellAccessibleName(String accessibleName, boolean expanded) {
        if (accessibleName != null) {
            accessibleName = expanded ? DbgArb.format(843, accessibleName) : DbgArb.format(844, accessibleName);
        }
        return accessibleName;
    }

    static long getObjectNumber(DebugDataCompositeInfo dci) {
        long address;
        DebugVirtualMachine vm = dci.getVM();
        DebugCapabilities capabilities = vm.getCapabilities();
        if (capabilities.canGetUniqueIDs()) {
            long uniqueID = dci.getUniqueID();
            if (uniqueID != 0L) {
                return uniqueID;
            }
        } else if (capabilities.canGetAddresses() && (address = dci.getAddressOfObject()) != 0L) {
            return address;
        }
        return 0L;
    }

    private static URL getUrlForClassSourceFile(Project jproject, String className) {
        SourceClass sourceClass;
        JavaManager javaManager = JavaManager.getJavaManager((Project)jproject);
        JavaClass javaClass = javaManager.getClass(className);
        if (javaClass != null && (sourceClass = (SourceClass)javaClass.getSourceElement()) != null) {
            return sourceClass.getURL();
        }
        return null;
    }

    private static URL getUrlForPackage(Project jproject, String packageName) {
        JavaManager javaManager = JavaManager.getJavaManager((Project)jproject);
        JavaPackage javaPackage = javaManager.getPackage(packageName);
        Collection classes = javaPackage.getDeclaredClasses();
        if (classes != null && classes.size() > 0) {
            for (JavaClass javaClass : classes) {
                SourceClass sourceClass;
                if (javaClass == null || (sourceClass = (SourceClass)javaClass.getSourceElement()) == null) continue;
                URL urlClass = sourceClass.getURL();
                URL urlPackage = URLFileSystem.getParent((URL)urlClass);
                return urlPackage;
            }
        }
        return null;
    }

    private static String[] getFileNamesFromUrls(URL[] urls) {
        int length = urls.length;
        String[] fileNames = new String[length];
        for (int i = 0; i < length; ++i) {
            fileNames[i] = URLFileSystem.getFileName((URL)urls[i]);
        }
        return fileNames;
    }

    private static long getEventTime(Context context) {
        EventObject event = context.getEvent();
        if (event instanceof ActionEvent) {
            return ((ActionEvent)event).getWhen();
        }
        return 0L;
    }

    static int getLineStartOffsetSkipWhite(CodeEditor codeEditor, int line) {
        int offset = codeEditor.getLineStartOffset(line);
        try {
            String lineOfText = codeEditor.getText(offset, codeEditor.getLineEndOffset(line) - offset);
            int i = 0;
            while (Character.isWhitespace(lineOfText.charAt(i))) {
                ++offset;
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return offset;
    }

    private synchronized void updateRunConfigurationList() {
        RunConfigurations runConfigurations;
        RunConfiguration[] runConfigs;
        int runConfigsLength;
        IdeAction[] actions = null;
        if (this.activeProject != null && this.activeProject.isOpen() && (runConfigsLength = (runConfigs = (runConfigurations = RunConfigurations.getInstance((PropertyStorage)this.activeProject)).getVisibleRunConfigurations()).length) > 0) {
            debugProjectCmdIds = new int[runConfigsLength];
            actions = new IdeAction[runConfigsLength];
            String category = DbgArb.getString(0);
            Context context = Ide.getMainWindow().getLastActiveView().getContext();
            for (int i = 0; i < runConfigsLength; ++i) {
                RunConfiguration runConfiguration = runConfigs[i];
                String name = runConfiguration.getName();
                int cmdId = Ide.findOrCreateCmdID((String)(DEBUG_PROJECT_CMD_PREFIX + i));
                IdeAction action = IdeAction.get((int)cmdId, null, (String)name, (String)category, null, null, (Object)((Object)runConfiguration), (boolean)true);
                action.putValue("Name", (Object)name);
                action.putValue("UserData", (Object)runConfiguration);
                action.putValue("Radio", (Object)Boolean.TRUE);
                action.addController((Controller)this);
                JDebugger.debugProjectCmdIds[i] = cmdId;
                actions[i] = action;
                this.update(action, context);
            }
        }
        if (actions == null) {
            debugProjectCmdIds = new int[0];
            actions = new IdeAction[]{this.getActionEmpty()};
        }
        int i = actions.length;
        IdeAction[] newActions = new IdeAction[i + 2];
        if (actionMRUConfigurationMenuDebug != null) {
            newActions = new IdeAction[i + 4];
        }
        System.arraycopy(actions, 0, newActions, 0, i);
        actions = newActions;
        if (actionMRUConfigurationMenuDebug != null) {
            actions[i++] = null;
            actions[i++] = actionMRUConfigurationMenuDebug;
        }
        actions[i++] = null;
        actions[i] = RunManager.getManageRunConfigurationsAction();
        actionDebugProject.putValue("ActionMenuActions", (Object)actions);
    }

    private IdeAction getActionEmpty() {
        if (actionEmpty == null) {
            String category = DbgArb.getString(0);
            int EMPTY_DEBUG_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugProjectCommandEmpty");
            actionEmpty = IdeAction.get((int)EMPTY_DEBUG_PROJECT_CMD_ID, null, (String)RunMgrArb.getString(2), (String)category, null, null, null, (boolean)false);
        }
        return actionEmpty;
    }

    public IdeAction getActionDebugProject() {
        if (actionDebugProject == null) {
            String category = DbgArb.getString(0);
            actionDebugProject = IdeAction.get((int)DEBUG_PROJECT_CMD_ID, null, (String)DbgArb.getString(2), (String)category, (Integer)DbgArb.getInteger(6), (Icon)OracleIcons.getIcon((String)"debug.png"), null, (boolean)false);
            actionDebugProject.putValue("NoCtxName", (Object)DbgArb.getString(2));
            actionDebugProject.addController((Controller)this);
            actionDebugProject.putValue("ActionMenuActions", (Object)new IdeAction[]{this.getActionEmpty()});
        }
        return actionDebugProject;
    }

    public IdeAction getActionDebugShowIP() {
        if (actionDebugShowIP == null) {
            String category = DbgArb.getString(0);
            actionDebugShowIP = IdeAction.get((int)DEBUG_SHOWIP_CMD_ID, null, (String)DbgArb.getString(43), (String)category, (Integer)DbgArb.getInteger(44), (Icon)OracleIcons.getIcon((String)"debugger/show_ip.gif"), null, (boolean)false);
            actionDebugShowIP.addController((Controller)this);
        }
        return actionDebugShowIP;
    }

    public IdeAction getActionDebugStepOver() {
        if (actionDebugStepOver == null) {
            String category = DbgArb.getString(0);
            actionDebugStepOver = IdeAction.get((int)DEBUG_STEPOVER_CMD_ID, null, (String)DbgArb.getString(20), (String)category, (Integer)DbgArb.getInteger(21), (Icon)OracleIcons.getIcon((String)"debugger/stp_ovr.png"), null, (boolean)false);
            actionDebugStepOver.addController((Controller)this);
        }
        return actionDebugStepOver;
    }

    public IdeAction getActionDebugStepInto() {
        if (actionDebugStepInto == null) {
            String category = DbgArb.getString(0);
            actionDebugStepInto = IdeAction.get((int)DEBUG_STEPINTO_CMD_ID, null, (String)DbgArb.getString(24), (String)category, (Integer)DbgArb.getInteger(25), (Icon)OracleIcons.getIcon((String)"debugger/stp_into.png"), null, (boolean)false);
            actionDebugStepInto.addController((Controller)this);
        }
        return actionDebugStepInto;
    }

    public IdeAction getActionDebugStepOut() {
        if (actionDebugStepOut == null) {
            String category = DbgArb.getString(0);
            actionDebugStepOut = IdeAction.get((int)DEBUG_STEPOUT_CMD_ID, null, (String)DbgArb.getString(28), (String)category, (Integer)DbgArb.getInteger(29), (Icon)OracleIcons.getIcon((String)"debugger/stp_out.png"), null, (boolean)false);
            actionDebugStepOut.addController((Controller)this);
        }
        return actionDebugStepOut;
    }

    public IdeAction getActionDebugStepToEndOfMethod() {
        if (actionDebugStepToEndOfMethod == null) {
            String category = DbgArb.getString(0);
            actionDebugStepToEndOfMethod = IdeAction.get((int)DEBUG_STEPTOENDOFMETHOD_CMD_ID, null, (String)DbgArb.getString(30), (String)category, (Integer)DbgArb.getInteger(31), (Icon)OracleIcons.getIcon((String)"debugger/rnto_end.png"), null, (boolean)false);
            actionDebugStepToEndOfMethod.addController((Controller)this);
        }
        return actionDebugStepToEndOfMethod;
    }

    public IdeAction getActionDebugStepOverBC() {
        if (actionDebugStepOverBC == null) {
            String category = DbgArb.getString(0);
            actionDebugStepOverBC = IdeAction.get((int)DEBUG_STEPOVERBC_CMD_ID, null, (String)DbgArb.getString(22), (String)category, (Integer)DbgArb.getInteger(23), (Icon)OracleIcons.getIcon((String)"debugger/stp_ovrbc.png"), null, (boolean)false);
            actionDebugStepOverBC.addController((Controller)this);
        }
        return actionDebugStepOverBC;
    }

    public IdeAction getActionDebugStepIntoBC() {
        if (actionDebugStepIntoBC == null) {
            String category = DbgArb.getString(0);
            actionDebugStepIntoBC = IdeAction.get((int)DEBUG_STEPINTOBC_CMD_ID, null, (String)DbgArb.getString(26), (String)category, (Integer)DbgArb.getInteger(27), (Icon)OracleIcons.getIcon((String)"debugger/stp_intobc.png"), null, (boolean)false);
            actionDebugStepIntoBC.addController((Controller)this);
        }
        return actionDebugStepIntoBC;
    }

    static boolean isSecretFeatureEnabled(String feature) {
        return Ide.getProperty((String)feature) != null;
    }

    public void installWindows() {
        boolean isRaptor = Product.isRaptor();
        this.windowManager.installWindow("Debugger.BreakpointsWindow");
        this.windowManager.installWindow("Debugger.SmartWindow");
        this.windowManager.installWindow("Debugger.LocalsWindow");
        this.windowManager.installWindow("Debugger.WatchWindow");
        if (!isRaptor) {
            this.windowManager.installWindow("Debugger.HeapWindow");
            this.windowManager.installWindow("Debugger.ThreadsWindow");
            this.windowManager.installWindow("Debugger.ClassesWindow");
        }
        this.windowManager.installWindow("Debugger.StackWindow");
        if (!isRaptor) {
            this.windowManager.installWindow("Debugger.MonitorsWindow");
        }
        this.windowManager.installCustomWindows();
    }

    DebugDockableFactory getDebugDockableFactory() {
        return this.debugDockableFactory;
    }

    void showActionButtonsOnMainToolbar(boolean visible) {
        Toolbar tb = Ide.getToolbar();
        for (int i = 0; i < tb.getComponentCount(); ++i) {
            IdeAction ideAction;
            int cmdId;
            Action action;
            Component c = tb.getComponent(i);
            if (!(c instanceof AbstractButton) || !((action = ((AbstractButton)c).getAction()) instanceof IdeAction) || (cmdId = (ideAction = (IdeAction)action).getCommandId()) != DEBUG_SHOWIP_CMD_ID && cmdId != DEBUG_STEPOVER_CMD_ID && cmdId != DEBUG_STEPINTO_CMD_ID && cmdId != DEBUG_STEPOUT_CMD_ID && cmdId != DEBUG_STEPTOENDOFMETHOD_CMD_ID) continue;
            c.setVisible(visible);
        }
        if (!visible) {
            this.showByteCodeActionButtonsOnMainToolbar(false);
        } else if (BytecodeFileSystemHelper.getInstance(false) != null) {
            this.showByteCodeActionButtonsOnMainToolbar(true);
        }
    }

    void showByteCodeActionButtonsOnMainToolbar(boolean visible) {
        Toolbar tb = Ide.getToolbar();
        for (int i = 0; i < tb.getComponentCount(); ++i) {
            IdeAction ideAction;
            int cmdId;
            Action action;
            Component c = tb.getComponent(i);
            if (!(c instanceof AbstractButton) || !((action = ((AbstractButton)c).getAction()) instanceof IdeAction) || (cmdId = (ideAction = (IdeAction)action).getCommandId()) != DEBUG_STEPOVERBC_CMD_ID && cmdId != DEBUG_STEPINTOBC_CMD_ID) continue;
            c.setVisible(visible);
        }
    }

    List<String> getCurrentThreadNames() {
        DebugVirtualMachine vm;
        ArrayList<String> names = new ArrayList<String>();
        DebuggingProcess process = this.getActiveDebuggingProcess();
        if (process != null && (vm = process.vm) != null) {
            DebugThreadInfo[] threads;
            for (DebugThreadInfo thread : threads = vm.listThreads()) {
                names.add(thread.getName());
            }
        }
        return names;
    }

    public static String[] filterBlanksFromHistoryList(String[] historyList) {
        ArrayList<String> newHistoryList = new ArrayList<String>();
        for (String history : historyList) {
            if (history.trim().length() <= 0) continue;
            newHistoryList.add(history);
        }
        return newHistoryList.toArray(new String[newHistoryList.size()]);
    }

    public static void selectHistoryString(JComboBox comboBox, String selection) {
        if (selection != null && selection.trim().length() > 0) {
            IdeUtil.comboBoxSelectItem((JComboBox)comboBox, (Object)selection);
        } else {
            comboBox.setSelectedIndex(-1);
            JTextField editor = (JTextField)comboBox.getEditor().getEditorComponent();
            editor.setText("");
        }
    }

    public Hover hover(JComponent component, Point p, List<HoverFlavor> flavors) {
        if (this.shouldProvideToolTip()) {
            if (this.toolTipEvaluator == null) {
                this.toolTipEvaluator = new ToolTipEvaluator(this);
            }
            SwingUtilities.convertPointFromScreen(p, component);
            BasicEditorPane editor = (BasicEditorPane)component;
            CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)editor);
            int offset = editor.viewToModel(p);
            Hover hover = this.toolTipEvaluator.showDataHover(codeEditor, offset);
            return hover;
        }
        return null;
    }

    public void terminateDebuggingProcess(DebugVirtualMachine vm) {
        if (this.debuggingProcesses != null) {
            for (DebuggingProcess debuggingProcess : this.debuggingProcesses) {
                if (debuggingProcess.getVM() != vm) continue;
                debuggingProcess.terminate();
                break;
            }
        }
    }

    static {
        lastSavedFile = null;
        viewDebuggerSubMenuBuilt = false;
        debugMenuBuilt = false;
        debugContextSubMenuAdded = false;
        debugContextSubMenuBuilt = false;
        smartDataProviders = new ArrayList<SmartDataProvider>();
        toolTipExpressionProviders = new ArrayList<ToolTipExpressionProvider>();
        inspectorExpressionProviders = new ArrayList<DebuggerInspectorExpressionProvider>();
        viewDebuggerActions = new ArrayList<IdeAction>();
        DEBUG_CMD_MRU_CONFIGURATION_ID = Ide.findOrCreateCmdID((String)"DebugMRUConfiguration_ID");
        VIEW_BREAKPOINTS_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugBreakpointsCommand");
        VIEW_THREADS_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugThreadsCommand");
        VIEW_STACK_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugStackCommand");
        VIEW_SMART_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugSmartCommand");
        VIEW_LOCALS_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugLocalsCommand");
        VIEW_WATCHES_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugWatchesCommand");
        VIEW_CLASSES_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugClassesCommand");
        VIEW_HEAP_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugHeapCommand");
        VIEW_MONITORS_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugMonitorsCommand");
        VIEW_LOG_CMD_ID = Ide.findOrCreateCmdID((String)"ViewDebugLogCommand");
        DEBUG_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)DEBUG_PROJECT_CMD_PREFIX);
        debugProjectCmdIds = new int[0];
        DEBUG_SELECTION_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSelectionCommand");
        DEBUG_PAUSE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugPauseCommand");
        DEBUG_RESUME_CMD_ID = Ide.findOrCreateCmdID((String)"DebugResumeCommand");
        DEBUG_DETACH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugDetachCommand");
        DEBUG_RESET_CMD_ID = Ide.findOrCreateCmdID((String)"DebugResetCommand");
        DEBUG_STEPOVER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepOverCommand");
        DEBUG_STEPOVERBC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepOverBCCommand");
        DEBUG_STEPINTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepIntoCommand");
        DEBUG_STEPINTOBC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepIntoBCCommand");
        DEBUG_STEPOUT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepOutCommand");
        DEBUG_STEPTOENDOFMETHOD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepToEndOfMethodCommand");
        DEBUG_CONTINUESTEP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugContinueStepCommand");
        DEBUG_RUNTOCURSOR_CMD_ID = Ide.findOrCreateCmdID((String)"DebugRunToCursorCommand");
        DEBUG_STEPINTOMETHOD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStepIntoMethodCommand");
        DEBUG_SETNEXTSTATEMENT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSetNextStatementCommand");
        DEBUG_SHOWIP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugShowIPCommand");
        DEBUG_GC_CMD_ID = Ide.findOrCreateCmdID((String)"DebugGCCommand");
        DEBUG_POP_1_STACK_FRAME_CMD_ID = Ide.findOrCreateCmdID((String)"DebugPop1StackFrameCommand");
        CONTEXTMENU_DEBUG_CMD_ID = Ide.findOrCreateCmdID((String)"ContextMenuDebug");
        NAVIGATOR_STOPLISTENING_CMD_ID = Ide.findOrCreateCmdID((String)"NavigatorStopListening");
        NAVIGATOR_DETACHDEBUGGER_CMD_ID = Ide.findOrCreateCmdID((String)"NavigatorDetachDebugger");
        CODE_EDITOR_GUTTER_TOGGLEWATCHPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorToggleWatchpointCommand");
        CODE_EDITOR_WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorWatchCommand");
        CODE_EDITOR_INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugCodeEditorInspectCommand");
        STRUCTURE_CREATEWATCHPOINT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStructureCreateWatchpointCommand");
        LOG_WINDOW_CANCEL_DEBUG_CONNECTION_CMD_ID = Ide.findOrCreateCmdID((String)"DebugLogWindowCancelDebugConnectionCommand");
    }
}

