/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.layout.Layout;
import oracle.ide.model.Project;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.PropertyAccess;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugHeapAncestor;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetAncestors;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetClasses;
import oracle.jdevimpl.debugger.support.DebugPinListener;
import oracle.jdevimpl.debugger.support.DebugPinnedInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EditHeapClassDialog;
import oracle.jdevimpl.runner.debug.HeapWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

final class HeapWindow
extends DataWindow {
    private List pins;
    private List pinDebuggingProcesses;
    private List pinSubsets;
    private HeapWindowSettings heapWindowSettings = HeapWindowSettings.getInstance();
    private static IdeAction actionAddNewClass;
    private static IdeAction actionEditClass;
    private static IdeAction actionRemoveFolder;
    private static IdeAction actionShowAncestors;
    private static IdeAction actionExpandAncestor;
    private static IdeAction actionViewWhole;
    private static IdeAction actionViewAnnotations;
    private static IdeAction actionViewAnnotationsForClass;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatch;
    private static IdeAction actionInspect;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionRemoveAllFolders;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemAddNewClass;
    private static JMenuItem menuitemEditClass;
    private static JMenuItem menuitemRemoveFolder;
    private static JMenuItem menuitemShowAncestors;
    private static JMenuItem menuitemExpandAncestor;
    private static JMenuItem menuitemRemoveAllFolders;
    private static JMenuItem menuitemSettings;
    private static final int ADD_NEW_CLASS_CMD_ID;
    private static final int EDIT_CLASS_CMD_ID;
    private static final int REMOVE_FOLDER_CMD_ID;
    private static final int SHOW_ANCESTORS_CMD_ID;
    private static final int EXPAND_ANCESTOR_CMD_ID;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int VIEW_ANNOTATIONS_CMD_ID;
    private static final int VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CMD_ID;
    private static final int INSPECT_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int REMOVE_ALL_FOLDERS_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final String HEAP_WINDOW_ID = "Debugger.HeapWindow";
    private static Icon heapTabIcon;
    private static final String HEAP_KEY_COUNT = "Heap.Count";
    private static final String HEAP_KEY_PREFIX = "Heap.";
    private static final String HEAP_KEY_DOT = ".";
    private static final String HEAP_KEY_SCOPE = "scope";
    private static final String HEAP_KEY_CLASS = "class";
    private static final String GlobalHeapScope = "GlobalHeapScope";

    HeapWindow() {
        super(HEAP_WINDOW_ID, DbgArb.getString(618), "f1_deb_heapwindow_html");
        HeapWindow.makeActions();
        this.setDataPanel(new HeapPanel());
        this.setControllerForActions();
    }

    @Override
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.SOUTH;
    }

    public boolean installByDefault() {
        return true;
    }

    @Override
    public void shutDown() {
        super.shutDown();
        ((HeapPanel)this.dataPanel).saveClasses((PropertyAccess)Ide.getIdeProperties());
    }

    @Override
    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public Icon getTabIcon() {
        if (heapTabIcon == null) {
            heapTabIcon = OracleIcons.getIcon((String)"debugger/heap.png");
        }
        return heapTabIcon;
    }

    public String getMenuTitle() {
        if (!JDebugger.getInstance().canShowHeapWindow()) {
            return null;
        }
        return this.title;
    }

    @Override
    public Component getGUI() {
        if (!JDebugger.getInstance().canShowHeapWindow()) {
            return null;
        }
        return super.getGUI();
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu subMenu) {
        HeapWindow.makeActions();
        float section = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAddNewClass), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionEditClass), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemoveFolder), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionShowAncestors), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionExpandAncestor), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewWhole), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotations), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewAnnotationsForClass), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdjustRange), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionToggleValue), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionModifyValue), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatch), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspect), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoto), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoDeclared), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoField), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemoveAllFolders), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUseFilters), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionObjectPreferences), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), subMenu, section);
    }

    private static void makeActions() {
        if (actionShowAncestors == null) {
            actionShowAncestors = IdeAction.get((int)SHOW_ANCESTORS_CMD_ID, null, (String)DbgArb.getString(627), null, (Integer)DbgArb.getInteger(628), null, null, (boolean)false);
            actionShowAncestors.setEnabled(false);
            actionExpandAncestor = IdeAction.get((int)EXPAND_ANCESTOR_CMD_ID, null, (String)DbgArb.getString(629), null, (Integer)DbgArb.getInteger(630), null, null, (boolean)false);
            actionExpandAncestor.setEnabled(false);
            actionEditClass = IdeAction.get((int)EDIT_CLASS_CMD_ID, null, (String)DbgArb.getString(619), null, (Integer)DbgArb.getInteger(620), null, null, (boolean)false);
            actionEditClass.setEnabled(false);
            actionRemoveFolder = IdeAction.get((int)REMOVE_FOLDER_CMD_ID, null, (String)DbgArb.getString(623), null, (Integer)DbgArb.getInteger(624), null, null, (boolean)false);
            actionRemoveFolder.setEnabled(false);
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(286), null, (Integer)DbgArb.getInteger(287), null, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionViewAnnotations = IdeAction.get((int)VIEW_ANNOTATIONS_CMD_ID, null, (String)DbgArb.getString(280), null, (Integer)DbgArb.getInteger(283), null, null, (boolean)false);
            actionViewAnnotations.putValue("NoCtxName", (Object)DbgArb.getString(280));
            actionViewAnnotations.setEnabled(false);
            actionViewAnnotationsForClass = IdeAction.get((int)VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID, null, (String)DbgArb.getString(284), null, (Integer)DbgArb.getInteger(285), null, null, (boolean)false);
            actionViewAnnotationsForClass.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(288), null, (Integer)DbgArb.getInteger(289), null, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(290), null, (Integer)DbgArb.getInteger(291), null, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(292), null, (Integer)DbgArb.getInteger(293), null, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatch = IdeAction.get((int)WATCH_CMD_ID, null, (String)DbgArb.getString(296), null, (Integer)DbgArb.getInteger(297), null, null, (boolean)false);
            actionWatch.setEnabled(false);
            actionInspect = IdeAction.get((int)INSPECT_CMD_ID, null, (String)DbgArb.getString(298), null, (Integer)DbgArb.getInteger(299), null, null, (boolean)false);
            actionInspect.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(312), null, (Integer)DbgArb.getInteger(313), null, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(314), null, (Integer)DbgArb.getInteger(315), null, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(300), null, (Integer)DbgArb.getInteger(302), null, null, (boolean)false);
            actionGoto.putValue("NoCtxName", (Object)DbgArb.getString(300));
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(303), null, (Integer)DbgArb.getInteger(305), null, null, (boolean)false);
            actionGotoDeclared.putValue("NoCtxName", (Object)DbgArb.getString(303));
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(306), null, (Integer)DbgArb.getInteger(308), null, null, (boolean)false);
            actionGotoField.putValue("NoCtxName", (Object)DbgArb.getString(306));
            actionGotoField.setEnabled(false);
            actionAddNewClass = IdeAction.get((int)ADD_NEW_CLASS_CMD_ID, null, (String)DbgArb.getString(621), null, (Integer)DbgArb.getInteger(622), null, null, (boolean)false);
            actionAddNewClass.setEnabled(false);
            actionRemoveAllFolders = IdeAction.get((int)REMOVE_ALL_FOLDERS_CMD_ID, null, (String)DbgArb.getString(625), null, (Integer)DbgArb.getInteger(626), null, null, (boolean)false);
            actionRemoveAllFolders.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(316), null, (Integer)DbgArb.getInteger(317), null, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(318, ""), null, (Integer)DbgArb.getInteger(319), null, null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(102), null, (Integer)RunMgrArb.getInteger(103), null, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(98), null, (Integer)RunMgrArb.getInteger(99), null, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(100), null, (Integer)RunMgrArb.getInteger(101), null, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionShowAncestors, actionExpandAncestor, actionEditClass, actionRemoveFolder, actionViewWhole, actionViewAnnotations, actionViewAnnotationsForClass, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatch, actionInspect, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionAddNewClass, actionRemoveAllFolders, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(actions, this.dataPanel);
    }

    void addHeapClass(String name) {
        ((HeapPanel)this.dataPanel).addClass(name);
    }

    static {
        ADD_NEW_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapAddNewClass");
        EDIT_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapEditClass");
        REMOVE_FOLDER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapRemoveFolder");
        SHOW_ANCESTORS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapShowAncestors");
        EXPAND_ANCESTOR_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapExpandAncestor");
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapViewWhole");
        VIEW_ANNOTATIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapViewAnnotations");
        VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapViewAnnotationsForClass");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapModifyValue");
        WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapWatch");
        INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapInspect");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapGotoField");
        REMOVE_ALL_FOLDERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapRemoveAllFolders");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugHeapSettings");
        heapTabIcon = null;
    }

    final class HeapPanel
    extends DataPanel
    implements DebugPinListener {
        private Map mapProjectHeapFolders;
        private Map mapProcessHeapFolders;

        HeapPanel() {
            super(HeapWindow.this, HeapWindow.this.heapWindowSettings.getDataPanelSettings());
            this.mapProjectHeapFolders = new HashMap();
            this.mapProcessHeapFolders = new HashMap();
            this.loadHeap((PropertyAccess)Ide.getIdeProperties());
            this._actionViewWhole = actionViewWhole;
            this._actionViewAnnotations = actionViewAnnotations;
            this._actionViewAnnotationsForClass = actionViewAnnotationsForClass;
            this._actionAdjustRange = actionAdjustRange;
            this._actionToggleValue = actionToggleValue;
            this._actionModifyValue = actionModifyValue;
            this._actionWatch = actionWatch;
            this._actionInspect = actionInspect;
            this._actionWatchClassLoader = actionWatchClassLoader;
            this._actionInspectClassLoader = actionInspectClassLoader;
            this._actionGoto = actionGoto;
            this._actionGotoDeclared = actionGotoDeclared;
            this._actionGotoField = actionGotoField;
            this._actionUseFilters = actionUseFilters;
            this._actionObjectPreferences = actionObjectPreferences;
            this._actionCollapseAll = actionCollapseAll;
            this._actionSave = actionSave;
            this._VIEW_WHOLE_CMD_ID = VIEW_WHOLE_CMD_ID;
            this._VIEW_ANNOTATIONS_CMD_ID = VIEW_ANNOTATIONS_CMD_ID;
            this._VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID = VIEW_ANNOTATIONS_FOR_CLASS_CMD_ID;
            this._ADJUST_RANGE_CMD_ID = ADJUST_RANGE_CMD_ID;
            this._TOGGLE_VALUE_CMD_ID = TOGGLE_VALUE_CMD_ID;
            this._MODIFY_VALUE_CMD_ID = MODIFY_VALUE_CMD_ID;
            this._WATCH_CMD_ID = WATCH_CMD_ID;
            this._INSPECT_CMD_ID = INSPECT_CMD_ID;
            this._WATCH_CLASSLOADER_CMD_ID = WATCH_CLASSLOADER_CMD_ID;
            this._INSPECT_CLASSLOADER_CMD_ID = INSPECT_CLASSLOADER_CMD_ID;
            this._GOTO_CMD_ID = GOTO_CMD_ID;
            this._GOTO_DECLARED_CMD_ID = GOTO_DECLARED_CMD_ID;
            this._GOTO_FIELD_CMD_ID = GOTO_FIELD_CMD_ID;
            this._USE_FILTERS_CMD_ID = USE_FILTERS_CMD_ID;
            this._OBJECT_PREFERENCES_CMD_ID = OBJECT_PREFERENCES_CMD_ID;
            this._COLLAPSE_ALL_CMD_ID = COLLAPSE_ALL_CMD_ID;
            this._SAVE_CMD_ID = SAVE_CMD_ID;
        }

        @Override
        protected void adjustGUI() {
            if (Version.DEBUG_BUILD != 0) {
                this.heapAncestorOutsideHeapFont = this.getBoldFont();
                this.ancestorDepthZeroFont = this.getBoldItalicFont();
            } else {
                this.ancestorDepthZeroFont = this.getBoldFont();
            }
            this.treeTable.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    int key = e.getKeyCode();
                    switch (key) {
                        case 127: {
                            Context context = HeapPanel.this.getContext(e);
                            HeapPanel.this.update(actionRemoveFolder, context);
                            if (!actionRemoveFolder.isEnabled()) break;
                            HeapPanel.this.handleEvent(actionRemoveFolder, context);
                            e.consume();
                        }
                    }
                }
            });
        }

        private void loadHeap(PropertyAccess properties) {
            String s = properties.getProperty(HeapWindow.HEAP_KEY_COUNT, null);
            if (s != null) {
                try {
                    int count = Integer.parseInt(s);
                    for (int i = 0; i < count; ++i) {
                        this.loadHeapItem(properties, i);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private boolean loadHeapItem(PropertyAccess properties, int number) {
            String prefix = HeapWindow.HEAP_KEY_PREFIX + number + HeapWindow.HEAP_KEY_DOT;
            String scope = properties.getProperty(prefix + HeapWindow.HEAP_KEY_SCOPE, HeapWindow.GlobalHeapScope);
            String s = properties.getProperty(prefix + HeapWindow.HEAP_KEY_CLASS, null);
            if (s != null && s.length() > 0) {
                ArrayList<String> list = (ArrayList<String>)this.mapProjectHeapFolders.get(scope);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.mapProjectHeapFolders.put(scope, list);
                }
                list.add(s);
                return true;
            }
            return false;
        }

        private void saveClasses(PropertyAccess properties) {
            int previousCount = 0;
            String s = properties.getProperty(HeapWindow.HEAP_KEY_COUNT, null);
            if (s != null) {
                try {
                    previousCount = Integer.parseInt(s);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            int count = 0;
            for (String scope : this.mapProjectHeapFolders.keySet()) {
                List list = (List)this.mapProjectHeapFolders.get(scope);
                for (String name : list) {
                    this.saveClass(properties, count, scope, name);
                    ++count;
                }
            }
            for (int i = count; i < previousCount; ++i) {
                this.removeSavedClass(properties, i);
            }
            properties.setProperty(HeapWindow.HEAP_KEY_COUNT, Integer.toString(count));
        }

        private void saveClass(PropertyAccess properties, int number, String scope, String name) {
            String prefix = HeapWindow.HEAP_KEY_PREFIX + number + HeapWindow.HEAP_KEY_DOT;
            properties.setProperty(prefix + HeapWindow.HEAP_KEY_SCOPE, scope);
            properties.setProperty(prefix + HeapWindow.HEAP_KEY_CLASS, name);
        }

        private void removeSavedClass(PropertyAccess properties, int number) {
            String prefix = HeapWindow.HEAP_KEY_PREFIX + number + HeapWindow.HEAP_KEY_DOT;
            properties.setProperty(prefix + HeapWindow.HEAP_KEY_SCOPE, null);
            properties.setProperty(prefix + HeapWindow.HEAP_KEY_CLASS, null);
        }

        @Override
        protected void addPopupMenuItemsForNew(ContextMenu popup, Context context) {
            this.update(actionAddNewClass, context);
            if (actionAddNewClass.isEnabled()) {
                if (menuitemAddNewClass == null) {
                    menuitemAddNewClass = popup.createMenuItem((ToggleAction)actionAddNewClass);
                }
                popup.add((Component)menuitemAddNewClass, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_NEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForNew(popup, context);
        }

        @Override
        protected void addPopupMenuItemsForDataItem(ContextMenu popup, Context context) {
            this.update(actionEditClass, context);
            if (actionEditClass.isEnabled()) {
                if (menuitemEditClass == null) {
                    menuitemEditClass = popup.createMenuItem((ToggleAction)actionEditClass);
                }
                popup.add((Component)menuitemEditClass, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(actionRemoveFolder, context);
            if (actionRemoveFolder.isEnabled()) {
                if (menuitemRemoveFolder == null) {
                    menuitemRemoveFolder = popup.createMenuItem((ToggleAction)actionRemoveFolder);
                }
                popup.add((Component)menuitemRemoveFolder, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(actionShowAncestors, context);
            if (actionShowAncestors.isEnabled()) {
                if (menuitemShowAncestors == null) {
                    menuitemShowAncestors = popup.createMenuItem((ToggleAction)actionShowAncestors);
                }
                popup.add((Component)menuitemShowAncestors, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(actionExpandAncestor, context);
            if (actionExpandAncestor.isEnabled()) {
                if (menuitemExpandAncestor == null) {
                    menuitemExpandAncestor = popup.createMenuItem((ToggleAction)actionExpandAncestor);
                }
                popup.add((Component)menuitemExpandAncestor, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForDataItem(popup, context);
        }

        @Override
        protected void addPopupMenuItemsForData(ContextMenu popup, Context context) {
            this.update(actionRemoveAllFolders, context);
            if (actionRemoveAllFolders.isEnabled()) {
                if (menuitemRemoveAllFolders == null) {
                    menuitemRemoveAllFolders = popup.createMenuItem((ToggleAction)actionRemoveAllFolders);
                }
                popup.add((Component)menuitemRemoveAllFolders, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
            }
            super.addPopupMenuItemsForData(popup, context);
        }

        @Override
        protected void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
            super.addPopupMenuItemsForCommon(popup, context);
            this.update(actionSettings, context);
            if (actionSettings.isEnabled()) {
                if (menuitemSettings == null) {
                    menuitemSettings = popup.createMenuItem((ToggleAction)actionSettings);
                }
                popup.add((Component)menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        @Override
        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (action.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    action.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || cmdId == SETTINGS_CMD_ID)) {
                    action.setEnabled(false);
                    return true;
                }
            }
            if (cmdId == SHOW_ANCESTORS_CMD_ID) {
                DataItem dataItem = this.getSelectedDataItem();
                if (dataItem != null) {
                    action.setEnabled(this.canShowAncestors(dataItem));
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == EXPAND_ANCESTOR_CMD_ID) {
                DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem != null && treePath != null) {
                    action.setEnabled(this.canExpandAncestor(dataItem));
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == EDIT_CLASS_CMD_ID) {
                DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem instanceof HeapClassFolderDataItem && treePath != null) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == REMOVE_FOLDER_CMD_ID) {
                DataItem dataItem = this.getSelectedDataItem();
                if (dataItem instanceof HeapDataItem) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == ADD_NEW_CLASS_CMD_ID) {
                action.setEnabled(true);
                return true;
            }
            if (cmdId == REMOVE_ALL_FOLDERS_CMD_ID) {
                action.setEnabled(this.canRemoveAllFolders());
                return true;
            }
            if (cmdId == SETTINGS_CMD_ID) {
                action.setEnabled(true);
                return true;
            }
            return super.update(action, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == SHOW_ANCESTORS_CMD_ID) {
                DataItem dataItem = this.getSelectedDataItem();
                if (dataItem != null) {
                    WaitCursor wc = Ide.getWaitCursor();
                    wc.show();
                    try {
                        this.showAncestors(dataItem);
                    }
                    finally {
                        wc.hide();
                    }
                }
                return true;
            }
            if (cmdId == EXPAND_ANCESTOR_CMD_ID) {
                DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem != null && treePath != null) {
                    WaitCursor wc = Ide.getWaitCursor();
                    wc.show();
                    try {
                        this.expandAncestor(dataItem, treePath);
                    }
                    finally {
                        wc.hide();
                    }
                }
                return true;
            }
            if (cmdId == EDIT_CLASS_CMD_ID) {
                DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem instanceof HeapClassFolderDataItem && treePath != null) {
                    this.editClass((HeapClassFolderDataItem)dataItem, treePath);
                }
                return true;
            }
            if (cmdId == REMOVE_FOLDER_CMD_ID) {
                DataItem dataItem = this.getSelectedDataItem();
                if (dataItem instanceof HeapDataItem) {
                    this.removeFolder((HeapDataItem)dataItem);
                }
                return true;
            }
            if (cmdId == ADD_NEW_CLASS_CMD_ID) {
                this.addNewClass();
                return true;
            }
            if (cmdId == REMOVE_ALL_FOLDERS_CMD_ID) {
                this.removeAllFolders();
                return true;
            }
            if (cmdId == SETTINGS_CMD_ID) {
                String[] path = new String[]{DbgArb.getString(673), DbgArb.getString(766)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
                return true;
            }
            return super.handleEvent(action, context);
        }

        @Override
        protected void addDataItems() {
            List processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess);
            if (processHeapFolders != null) {
                List root = this.getRoot();
                for (Object o : processHeapFolders) {
                    Object subset;
                    if (o instanceof String) {
                        String name = (String)o;
                        subset = this.makeHeapSubsetForClass(name);
                        HeapClassFolderDataItem heapClassFolderDataItem = new HeapClassFolderDataItem(subset);
                        root.add(heapClassFolderDataItem);
                        continue;
                    }
                    if (!(o instanceof HeapAncestorSubset)) continue;
                    HeapAncestorSubset has = (HeapAncestorSubset)o;
                    subset = this.makeHeapSubsetForAncestors(has);
                    HeapAncestorsFolderDataItem heapAncestorsFolderDataItem = new HeapAncestorsFolderDataItem(subset, has);
                    root.add(heapAncestorsFolderDataItem);
                }
            }
        }

        private Object makeHeapSubsetForClass(String name) {
            DebugHeapInfo heap;
            DebugHeapSubsetClasses subset = new DebugHeapSubsetClasses(name, null);
            subset.addClass(name, false);
            if (this.vm != null && (heap = this.vm.getHeap(subset)) != null) {
                return heap;
            }
            return subset;
        }

        @Override
        protected void checkDrag(DropTargetDragEvent e) {
            if (e.isDataFlavorSupported(ClassesWindow.getClassFlavor()) || e.isDataFlavorSupported(ClassesWindow.getArrayFlavor()) || e.isDataFlavorSupported(DataItem.getHeapObjectFlavor())) {
                e.acceptDrag(1);
                return;
            }
            super.checkDrag(e);
        }

        @Override
        protected void checkDrop(DropTargetDropEvent e) {
            if (e.isLocalTransfer()) {
                if (e.isDataFlavorSupported(ClassesWindow.getClassFlavor())) {
                    try {
                        Transferable t = e.getTransferable();
                        ClassesWindow.ClassFlavorData data = (ClassesWindow.ClassFlavorData)t.getTransferData(ClassesWindow.getClassFlavor());
                        this.addClass(data.getName());
                        JDebugger.getInstance().viewHeap();
                        e.acceptDrop(1);
                        e.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception ex) {}
                } else if (e.isDataFlavorSupported(ClassesWindow.getArrayFlavor())) {
                    try {
                        Transferable t = e.getTransferable();
                        ClassesWindow.ClassFlavorData data = (ClassesWindow.ClassFlavorData)t.getTransferData(ClassesWindow.getArrayFlavor());
                        this.addClass(data.getName());
                        JDebugger.getInstance().viewHeap();
                        e.acceptDrop(1);
                        e.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception ex) {}
                } else if (e.isDataFlavorSupported(DataItem.getHeapObjectFlavor())) {
                    try {
                        Transferable t = e.getTransferable();
                        DebugDataCompositeInfo data = (DebugDataCompositeInfo)t.getTransferData(DataItem.getHeapObjectFlavor());
                        this.showAncestors(data);
                        JDebugger.getInstance().viewHeap();
                        e.acceptDrop(1);
                        e.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            super.checkDrop(e);
        }

        @Override
        void processFinished(DebuggingProcess debuggingProcess) {
            if (HeapWindow.this.pinDebuggingProcesses != null) {
                for (int i = HeapWindow.this.pinDebuggingProcesses.size() - 1; i >= 0; --i) {
                    if (!debuggingProcess.equals(HeapWindow.this.pinDebuggingProcesses.get(i))) continue;
                    HeapWindow.this.pins.remove(i);
                    HeapWindow.this.pinDebuggingProcesses.remove(i);
                    HeapWindow.this.pinSubsets.remove(i);
                }
            }
            this.mapProcessHeapFolders.remove(debuggingProcess);
            super.processFinished(debuggingProcess);
        }

        private List getProcessHeapFolders(DebuggingProcess debuggingProcess) {
            if (debuggingProcess != null) {
                ArrayList list = (ArrayList)this.mapProcessHeapFolders.get(debuggingProcess);
                if (list == null) {
                    list = new ArrayList(this.getProjectHeapFolders(debuggingProcess));
                    this.mapProcessHeapFolders.put(debuggingProcess, list);
                }
                return list;
            }
            return null;
        }

        private List getProjectHeapFolders(DebuggingProcess debuggingProcess) {
            if (debuggingProcess != null) {
                Project project = debuggingProcess.getProject();
                String scope = project != null && project != Ide.getDefaultProject() ? project.getURL().toString() : HeapWindow.GlobalHeapScope;
                ArrayList list = (ArrayList)this.mapProjectHeapFolders.get(scope);
                if (list == null) {
                    list = new ArrayList();
                    this.mapProjectHeapFolders.put(scope, list);
                }
                return list;
            }
            return null;
        }

        private int convertProcessHeapFolderIndexToProjectHeapFolderIndex(List processHeapFolders, int index) {
            int count = 0;
            for (int i = 0; i < index; ++i) {
                Object o = processHeapFolders.get(i);
                if (!(o instanceof String)) continue;
                ++count;
            }
            return count;
        }

        private void editClass(HeapClassFolderDataItem heapClassFolderDataItem, TreePath treePath) {
            List processHeapFolders;
            int i = this.getRoot().indexOf(heapClassFolderDataItem);
            if (i != -1 && (processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess)) != null) {
                int index = this.convertProcessHeapFolderIndexToProjectHeapFolderIndex(processHeapFolders, i);
                String name = (String)processHeapFolders.get(i);
                String title = DbgArb.getString(631);
                String prompt = DbgArb.getString(632);
                String helpId = "f1_deb_edit_heap_classdialog_html";
                if ((name = EditHeapClassDialog.showEditHeapClassDialog(title, prompt, name, this.debuggingProcess.getProject(), helpId)) != null) {
                    processHeapFolders.set(i, name);
                    List projectHeapFolders = this.getProjectHeapFolders(this.debuggingProcess);
                    projectHeapFolders.set(index, name);
                    Object subset = this.makeHeapSubsetForClass(name);
                    heapClassFolderDataItem.modifyClass(subset, treePath);
                }
            }
        }

        private void removeFolder(HeapDataItem heapDataItem) {
            List processHeapFolders;
            int i = this.getRoot().indexOf(heapDataItem);
            if (i != -1 && (processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess)) != null) {
                int size;
                int index = -1;
                if (heapDataItem instanceof HeapClassFolderDataItem) {
                    index = this.convertProcessHeapFolderIndexToProjectHeapFolderIndex(processHeapFolders, i);
                }
                this.removeTopDataItem(i);
                processHeapFolders.remove(i);
                if (heapDataItem instanceof HeapClassFolderDataItem) {
                    List projectHeapFolders = this.getProjectHeapFolders(this.debuggingProcess);
                    projectHeapFolders.remove(index);
                }
                if (heapDataItem instanceof HeapAncestorsFolderDataItem) {
                    HeapAncestorsFolderDataItem hasFolder = (HeapAncestorsFolderDataItem)heapDataItem;
                    hasFolder.has.unpin();
                }
                if (i < (size = processHeapFolders.size())) {
                    this.selectTopDataItem(i);
                } else if (0 <= --i && i < size) {
                    this.selectTopDataItem(i);
                }
            }
        }

        private void addNewClass() {
            String title = DbgArb.getString(633);
            String prompt = DbgArb.getString(634);
            String helpId = "f1_deb_add_class_folder_dialog_html";
            String name = EditHeapClassDialog.showEditHeapClassDialog(title, prompt, null, this.debuggingProcess.getProject(), helpId);
            if (name != null) {
                this.addClass(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addClass(DebugDataCompositeInfo data) {
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            try {
                long address = data.getAddressOfObject();
                DebugClassInfo classInfo = data.getClassInfo();
                HeapClassFolderDataItem folder = this.addClass(classInfo.getName(), false);
                TreePath treePath = new TreePath(this.getRoot()).pathByAddingChild(folder);
                Iterator i = this.model.getChildren(folder);
                while (i.hasNext()) {
                    DataItem item = (DataItem)i.next();
                    if (item.getAddressOfObject() != address) continue;
                    TreePath treePathToSelect = treePath.pathByAddingChild(item);
                    this.treeTable.getTree().makeVisible(treePathToSelect);
                    JDebugger.getInstance().selectTreeTablePath(this.treeTable, treePathToSelect, true);
                    break;
                }
            }
            finally {
                wc.hide();
            }
        }

        HeapClassFolderDataItem addClass(String name) {
            return this.addClass(name, true);
        }

        HeapClassFolderDataItem addClass(String name, boolean highlight) {
            List processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess);
            if (processHeapFolders != null) {
                int index = processHeapFolders.indexOf(name);
                if (index == -1) {
                    index = processHeapFolders.size();
                    processHeapFolders.add(name);
                    index = processHeapFolders.size() - 1;
                    List projectHeapFolders = this.getProjectHeapFolders(this.debuggingProcess);
                    projectHeapFolders.add(name);
                    Object subset = this.makeHeapSubsetForClass(name);
                    HeapClassFolderDataItem heapClassFolderDataItem = new HeapClassFolderDataItem(subset);
                    this.addTopDataItem(heapClassFolderDataItem, highlight);
                    return heapClassFolderDataItem;
                }
                if (highlight) {
                    this.selectTopDataItem(index);
                }
                return (HeapClassFolderDataItem)this.getRoot().get(index);
            }
            return null;
        }

        private boolean canRemoveAllFolders() {
            List processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess);
            return processHeapFolders != null && processHeapFolders.size() > 0;
        }

        private void removeAllFolders() {
            List projectHeapFolders;
            this.unpinAncestorFolders();
            List processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess);
            if (processHeapFolders != null) {
                processHeapFolders.clear();
            }
            if ((projectHeapFolders = this.getProjectHeapFolders(this.debuggingProcess)) != null) {
                projectHeapFolders.clear();
            }
            this.everythingChanged();
        }

        private boolean canShowAncestors(DataItem dataItem) {
            return dataItem.getAddressOfObject() != 0L;
        }

        private void showAncestors(DataItem dataItem) {
            DebugDataInfo data = dataItem.getDataInfo();
            if (data instanceof DebugDataCompositeInfo) {
                DebugDataCompositeInfo datac = (DebugDataCompositeInfo)data;
                this.showAncestors(datac);
            }
        }

        private void showAncestors(DebugDataCompositeInfo datac) {
            long address = datac.getAddressOfObject();
            HeapAncestorSubset has = new HeapAncestorSubset(address, datac.getClassInfo());
            List processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess);
            if (processHeapFolders != null) {
                int index = processHeapFolders.indexOf(has);
                if (index == -1) {
                    processHeapFolders.add(has);
                    index = processHeapFolders.size() - 1;
                    this.pin(datac, has);
                    Object subset = this.makeHeapSubsetForAncestors(has);
                    HeapAncestorsFolderDataItem heapAncestorsFolderDataItem = new HeapAncestorsFolderDataItem(subset, has);
                    this.addTopDataItem(heapAncestorsFolderDataItem);
                } else {
                    this.selectTopDataItem(index);
                }
            }
        }

        private void pin(DebugDataCompositeInfo datac, HeapAncestorSubset has) {
            DebugPinnedInfo pin = datac.pinObject(this);
            if (HeapWindow.this.pins == null) {
                HeapWindow.this.pins = new ArrayList();
            }
            if (HeapWindow.this.pinDebuggingProcesses == null) {
                HeapWindow.this.pinDebuggingProcesses = new ArrayList();
            }
            if (HeapWindow.this.pinSubsets == null) {
                HeapWindow.this.pinSubsets = new ArrayList();
            }
            HeapWindow.this.pins.add(pin);
            HeapWindow.this.pinDebuggingProcesses.add(this.debuggingProcess);
            HeapWindow.this.pinSubsets.add(has);
        }

        private void unpinAncestorFolders() {
            List processHeapFolders = this.getProcessHeapFolders(this.debuggingProcess);
            if (processHeapFolders != null) {
                for (Object o : processHeapFolders) {
                    if (!(o instanceof HeapAncestorSubset)) continue;
                    HeapAncestorSubset has = (HeapAncestorSubset)o;
                    has.unpin();
                }
            }
        }

        @Override
        public void pinnedObjectDiscarded(DebugVirtualMachine vm, DebugPinnedInfo pin) {
            List processHeapFolders;
            long address = pin.getAddressOfObject();
            DebuggingProcess debuggingProcess = JDebugger.getInstance().findDebuggingProcess(vm);
            if (debuggingProcess != null && (processHeapFolders = this.getProcessHeapFolders(debuggingProcess)) != null) {
                for (Object o : processHeapFolders) {
                    if (!(o instanceof HeapAncestorSubset)) continue;
                    HeapAncestorSubset has = (HeapAncestorSubset)o;
                    if (has.address != address) continue;
                    has.discarded();
                }
            }
        }

        private Object makeHeapSubsetForAncestors(HeapAncestorSubset has) {
            DebugHeapInfo heap;
            String name = DbgArb.format(657, "@" + Long.toHexString(has.address).toUpperCase());
            if (has.discarded) {
                name = name + " " + DbgArb.getString(658);
            }
            int ignoreLevel = HeapWindow.this.heapWindowSettings.isIgnoreSoftWeak() ? 4 : 2;
            int depth = HeapWindow.this.heapWindowSettings.getMaximumDepth();
            DebugHeapSubsetAncestors subset = new DebugHeapSubsetAncestors(name, has.address, depth, ignoreLevel, has.classInfo);
            if (!has.discarded && this.vm != null && (heap = this.vm.getHeap(subset)) != null) {
                return heap;
            }
            return subset;
        }

        private boolean canExpandAncestor(DataItem dataItem) {
            return dataItem.ancestorHeapInfo != null && (dataItem.info instanceof DebugHeapAncestor || dataItem.ancestorDepth != 0);
        }

        private void expandAncestor(DataItem dataItem, TreePath treePath) {
            if (this.canExpandAncestor(dataItem)) {
                Iterator i = dataItem.getChildren();
                while (i.hasNext()) {
                    DataItem child = (DataItem)i.next();
                    if (!child.ancestorShortestDepth) continue;
                    this.treeTable.getTree().expandPath(treePath);
                    this.expandAncestor(child, treePath.pathByAddingChild(child));
                    break;
                }
            }
        }

        final class HeapAncestorSubset {
            final long address;
            final DebugClassInfo classInfo;
            boolean discarded;

            HeapAncestorSubset(long address, DebugClassInfo classInfo) {
                this.address = address;
                this.discarded = false;
                this.classInfo = classInfo;
            }

            private void unpin() {
                int i = HeapWindow.this.pinSubsets.indexOf(this);
                if (i != -1) {
                    DebugPinnedInfo pin = (DebugPinnedInfo)HeapWindow.this.pins.get(i);
                    pin.unpinObject();
                    HeapWindow.this.pins.remove(i);
                    HeapWindow.this.pinDebuggingProcesses.remove(i);
                    HeapWindow.this.pinSubsets.remove(i);
                }
            }

            private void discarded() {
                this.discarded = true;
                int i = HeapWindow.this.pinSubsets.indexOf(this);
                if (i != -1) {
                    HeapWindow.this.pins.remove(i);
                    HeapWindow.this.pinDebuggingProcesses.remove(i);
                    HeapWindow.this.pinSubsets.remove(i);
                }
            }

            public int hashCode() {
                return (int)this.address;
            }

            public boolean equals(Object o) {
                if (o instanceof HeapAncestorSubset) {
                    return this.address == ((HeapAncestorSubset)o).address;
                }
                return false;
            }
        }

        protected final class HeapAncestorsFolderDataItem
        extends HeapDataItem {
            HeapAncestorSubset has;

            HeapAncestorsFolderDataItem(Object info, HeapAncestorSubset has) {
                super(info);
                this.has = has;
            }
        }

        protected final class HeapClassFolderDataItem
        extends HeapDataItem {
            HeapClassFolderDataItem(Object info) {
                super(info);
            }

            void modifyClass(Object info, TreePath treePath) {
                this.modifyInfo(info, null, null, treePath);
            }
        }

        protected abstract class HeapDataItem
        extends DataItem {
            private boolean isDebugHeapAncestor;
            private boolean isDebugHeapAncestorOutsideHeap;

            HeapDataItem(Object info) {
                super(HeapPanel.this, info);
            }

            @Override
            protected void setInfo(Object info, String displayNameOverride, String expressionPartOverride) {
                this.isDebugHeapAncestor = info instanceof DebugHeapAncestor;
                this.isDebugHeapAncestorOutsideHeap = info instanceof DebugHeapAncestorOutsideHeap;
                super.setInfo(info, displayNameOverride, expressionPartOverride);
            }

            @Override
            protected Font getFont(int column) {
                if (column == 0) {
                    if (HeapPanel.this.ancestorDepthZeroFont != null && this.ancestorDepth == 0 && !this.isDebugHeapAncestor) {
                        return HeapPanel.this.ancestorDepthZeroFont;
                    }
                    if (HeapPanel.this.heapAncestorOutsideHeapFont != null && this.isDebugHeapAncestorOutsideHeap) {
                        return HeapPanel.this.heapAncestorOutsideHeapFont;
                    }
                }
                return super.getFont(column);
            }
        }
    }
}

