/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.runner.DebuggerBreakpoint;
import oracle.ide.runner.DebuggerBreakpointLogEntry;
import oracle.ide.runner.DebuggerExceptionBreakpoint;
import oracle.ide.runner.DebuggerExtender;
import oracle.ide.runner.DebuggerExtenderCallback;
import oracle.ide.runner.DebuggerFileLineBreakpoint;
import oracle.ide.runner.DebuggerMethodBreakpoint;
import oracle.ide.runner.DebuggerURLLineBreakpoint;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BreakpointSettings;
import oracle.jdevimpl.runner.debug.BreakpointsWindow;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.debug.CustomDataProvider;
import oracle.jdevimpl.runner.debug.ExtenderBreakpoint;
import oracle.jdevimpl.runner.debug.JDebugger;

class ExtenderCallback
implements DebuggerExtenderCallback {
    private DebuggerExtender extender;
    private String extenderID;
    private List<ExtenderBreakpoint> extenderBreakpoints;
    private CustomDataProvider customDataProvider;
    private Map<String, CustomBreakpointDetails> customBreakpointTypes = new HashMap<String, CustomBreakpointDetails>();

    ExtenderCallback(DebuggerExtender extender, String extenderID) {
        this.extender = extender;
        this.extenderID = extenderID;
    }

    DebuggerExtender getExtender() {
        return this.extender;
    }

    public DebuggerBreakpoint addBreakpoint(DebuggerBreakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Invalid breakpoint");
        }
        final Breakpoint bp = this.createBreakpoint(breakpoint);
        ExtenderBreakpoint extenderBreakpoint = new ExtenderBreakpoint(bp);
        this.addExtenderBreakpoint(extenderBreakpoint);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JDebugger.getInstance().addBreakpoint(bp);
            }
        });
        return extenderBreakpoint;
    }

    Breakpoint createBreakpoint(DebuggerBreakpoint debuggerBreakpoint) {
        Breakpoint bp = null;
        switch (debuggerBreakpoint.getKind()) {
            case METHOD: {
                if (!(debuggerBreakpoint instanceof DebuggerMethodBreakpoint)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                DebuggerMethodBreakpoint methodBreakpoint = (DebuggerMethodBreakpoint)debuggerBreakpoint;
                bp = new Breakpoint(methodBreakpoint.getScope(), 1, methodBreakpoint.getMethodName());
                break;
            }
            case FILE_LINE: {
                if (!(debuggerBreakpoint instanceof DebuggerFileLineBreakpoint)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                DebuggerFileLineBreakpoint fileLineBreakpoint = (DebuggerFileLineBreakpoint)debuggerBreakpoint;
                bp = new Breakpoint(fileLineBreakpoint.getScope(), 0, fileLineBreakpoint.getPackage(), fileLineBreakpoint.getFileName(), fileLineBreakpoint.getLine());
                break;
            }
            case URL_LINE: {
                if (!(debuggerBreakpoint instanceof DebuggerURLLineBreakpoint)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                DebuggerURLLineBreakpoint urlLineBreakpoint = (DebuggerURLLineBreakpoint)debuggerBreakpoint;
                bp = new Breakpoint(urlLineBreakpoint.getScope(), 5, urlLineBreakpoint.getURL(), urlLineBreakpoint.getLine());
                break;
            }
            case EXCEPTION: {
                if (!(debuggerBreakpoint instanceof DebuggerExceptionBreakpoint)) {
                    throw new IllegalArgumentException("Invalid breakpoint");
                }
                DebuggerExceptionBreakpoint exceptionBreakpoint = (DebuggerExceptionBreakpoint)debuggerBreakpoint;
                bp = new Breakpoint(exceptionBreakpoint.getScope(), 2, exceptionBreakpoint.getExceptionName(), exceptionBreakpoint.isBreakOnCaughtExceptions(), exceptionBreakpoint.isBreakOnUncaughtExceptions());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid breakpoint");
            }
        }
        bp.setShallow(true);
        bp.setDebuggerExtenderID(this.extenderID);
        bp.setEnabled(debuggerBreakpoint.isEnabled());
        bp.setCondition(debuggerBreakpoint.getCondition());
        bp.setCanEditCondition(debuggerBreakpoint.canEditCondition());
        bp.setHiddenCondition(debuggerBreakpoint.getHiddenCondition());
        bp.setPassCount(debuggerBreakpoint.getPassCount());
        bp.setCanEditPassCount(debuggerBreakpoint.canEditPassCount());
        bp.setGroupName(debuggerBreakpoint.getGroupName());
        bp.setCanEditGroupName(debuggerBreakpoint.canEditGroupName());
        bp.setCustomDescription(debuggerBreakpoint.getCustomDescription());
        bp.setCustomTypeString(debuggerBreakpoint.getCustomTypeString());
        bp.setThreadName(null);
        bp.setThreadNameNot(null);
        if (debuggerBreakpoint.getBreakForThreadNamed() != null) {
            bp.setThreadName(debuggerBreakpoint.getBreakForThreadNamed());
        } else if (debuggerBreakpoint.getBreakForThreadNotNamed() != null) {
            bp.setThreadNameNot(debuggerBreakpoint.getBreakForThreadNotNamed());
        }
        bp.setCanEditBreakForThreads(debuggerBreakpoint.canEditBreakForThreads());
        bp.setActionHalt(debuggerBreakpoint.isHaltOnBreakpointHit());
        bp.setActionBeep(debuggerBreakpoint.isBeepOnBreakpointHit());
        DebuggerBreakpointLogEntry logEntry = debuggerBreakpoint.getLogEntryOnBreakpointHit();
        if (logEntry != null) {
            bp.setActionLog(logEntry.isEnabled());
            bp.setActionLogStack(logEntry.isLogStackTrace());
            bp.setActionLogExpression(logEntry.getLogExpression());
            bp.setActionLogTag(logEntry.getLogTag());
        } else {
            bp.setActionLog(false);
            bp.setActionLogStack(false);
            bp.setActionLogExpression(null);
            bp.setActionLogTag(null);
        }
        bp.setActionEnableOther(debuggerBreakpoint.getEnableBreakpointGroupOnBreakpointHit());
        bp.setActionDisableOther(debuggerBreakpoint.getDisableBreakpointGroupOnBreakpointHit());
        bp.setCanEditBreakpointHitActions(debuggerBreakpoint.canEditBreakpointHitActions());
        bp.setProperties(debuggerBreakpoint.getProperties());
        bp.setShallow(false);
        return bp;
    }

    public boolean deleteBreakpoint(DebuggerBreakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Invalid breakpoint");
        }
        ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint(breakpoint);
        if (extenderBreakpoint != null) {
            this.deleteExtenderBreakpoint(extenderBreakpoint);
            JDebugger.getInstance().removeBreakpoint(extenderBreakpoint.getBreakpoint());
            return true;
        }
        return false;
    }

    synchronized void deleteExtenderBreakpoint(ExtenderBreakpoint breakpoint) {
        this.getExtenderBreakpoints();
        this.extenderBreakpoints.remove(breakpoint);
    }

    synchronized void addExtenderBreakpoint(ExtenderBreakpoint breakpoint) {
        this.getExtenderBreakpoints();
        this.extenderBreakpoints.add(breakpoint);
    }

    public boolean setEnableBreakpoint(DebuggerBreakpoint breakpoint, boolean enable) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Invalid breakpoint");
        }
        ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint(breakpoint);
        if (extenderBreakpoint != null) {
            extenderBreakpoint.enableBreakpoint(enable);
            return true;
        }
        return false;
    }

    public DebuggerBreakpoint.BreakpointState getBreakpointState(DebuggerBreakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Invalid breakpoint");
        }
        ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint(breakpoint);
        if (extenderBreakpoint != null) {
            return extenderBreakpoint.getActiveState();
        }
        return null;
    }

    public Icon getBreakpointIcon(DebuggerBreakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Invalid breakpoint");
        }
        ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint(breakpoint);
        if (extenderBreakpoint != null) {
            return extenderBreakpoint.getIcon();
        }
        return null;
    }

    public synchronized List<? extends DebuggerBreakpoint> getBreakpoints() {
        if (Breakpoint.breakpointsLoaded()) {
            List<ExtenderBreakpoint> currentBreakpoints = this.getExtenderBreakpoints();
            ArrayList<ExtenderBreakpoint> copy = new ArrayList<ExtenderBreakpoint>(currentBreakpoints.size());
            for (ExtenderBreakpoint extenderBreakpoint : currentBreakpoints) {
                copy.add(extenderBreakpoint);
            }
            return copy;
        }
        return null;
    }

    synchronized List<ExtenderBreakpoint> getExtenderBreakpoints() {
        if (this.extenderBreakpoints == null) {
            List<Breakpoint> breakpoints = Breakpoint.getExtenderBreakpoints(this.extenderID);
            this.extenderBreakpoints = new ArrayList<ExtenderBreakpoint>();
            for (Breakpoint breakpoint : breakpoints) {
                ExtenderBreakpoint extenderBp = new ExtenderBreakpoint(breakpoint);
                this.extenderBreakpoints.add(extenderBp);
            }
        }
        return this.extenderBreakpoints;
    }

    synchronized ExtenderBreakpoint getExtenderBreakpoint(Breakpoint breakpoint) {
        List<ExtenderBreakpoint> extenderBreakpoints = this.getExtenderBreakpoints();
        for (ExtenderBreakpoint extenderBreakpoint : extenderBreakpoints) {
            if (extenderBreakpoint.getBreakpoint() != breakpoint) continue;
            return extenderBreakpoint;
        }
        return null;
    }

    CustomDataProvider getCustomDataProvider() {
        if (this.customDataProvider == null) {
            this.customDataProvider = new CustomDataProvider();
        }
        return this.customDataProvider;
    }

    private ExtenderBreakpoint recognizeBreakpoint(DebuggerBreakpoint breakpoint) {
        if (breakpoint instanceof ExtenderBreakpoint) {
            return (ExtenderBreakpoint)breakpoint;
        }
        List<? extends DebuggerBreakpoint> extenderBreakpoints = this.getBreakpoints();
        if (extenderBreakpoints != null) {
            for (DebuggerBreakpoint debuggerBreakpoint : extenderBreakpoints) {
                if (!this.extender.breakpointsEqual(debuggerBreakpoint, breakpoint)) continue;
                return (ExtenderBreakpoint)debuggerBreakpoint;
            }
        }
        return null;
    }

    @Deprecated
    public void registerCustomBreakpointType(String customBreakpointType, DebuggerBreakpoint.BreakpointKind breakpointKind) {
        this.registerCustomBreakpointType(customBreakpointType, breakpointKind, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCustomBreakpointType(String customBreakpointType, DebuggerBreakpoint.BreakpointKind breakpointKind, DebuggerBreakpoint breakpointTemplate) {
        if (customBreakpointType == null || customBreakpointType.trim().length() == 0) {
            throw new IllegalArgumentException("Need valid custom breakpoint type");
        }
        Map<String, CustomBreakpointDetails> map = this.customBreakpointTypes;
        synchronized (map) {
            this.customBreakpointTypes.put(customBreakpointType, new CustomBreakpointDetails(customBreakpointType, breakpointKind, breakpointTemplate));
        }
        int bpType = 0;
        switch (breakpointKind) {
            case METHOD: {
                bpType = 1;
                break;
            }
            case FILE_LINE: {
                bpType = 0;
                break;
            }
            case URL_LINE: {
                bpType = 5;
                break;
            }
            case EXCEPTION: {
                bpType = 2;
            }
        }
        BreakpointSettings settings = breakpointTemplate != null ? this.createBreakpoint(breakpointTemplate).getBreakpointSettings() : null;
        BreakpointsWindow.addCustomBreakpointType(bpType, customBreakpointType, settings);
    }

    public DebuggerBreakpoint.BreakpointScope getDefaultBreakpointScope() {
        String defaultScope = BreakpointsWindowSettings.getInstance().getBreakpointScope();
        if (defaultScope.equals("workspace")) {
            return DebuggerBreakpoint.BreakpointScope.WORKSPACE;
        }
        if (defaultScope.equals("project")) {
            return DebuggerBreakpoint.BreakpointScope.PROJECT;
        }
        if (defaultScope.equals("global")) {
            return DebuggerBreakpoint.BreakpointScope.GLOBAL;
        }
        return DebuggerBreakpoint.BreakpointScope.WORKSPACE;
    }

    public boolean editBreakpoint(DebuggerBreakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("Invalid breakpoint");
        }
        ExtenderBreakpoint extenderBreakpoint = this.recognizeBreakpoint(breakpoint);
        if (extenderBreakpoint != null) {
            return JDebugger.getInstance().editBreakpoint(extenderBreakpoint.getBreakpoint());
        }
        return false;
    }

    public DebuggerBreakpoint getDefaultBreakpointSettings() {
        return new ExtenderBreakpoint(new Breakpoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean knowsCustomBreakpointType(String customBreakpointType) {
        Map<String, CustomBreakpointDetails> map = this.customBreakpointTypes;
        synchronized (map) {
            return this.customBreakpointTypes.get(customBreakpointType) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CustomBreakpointDetails> getCustomBreakpointTypes() {
        Map<String, CustomBreakpointDetails> map = this.customBreakpointTypes;
        synchronized (map) {
            return Collections.unmodifiableCollection(this.customBreakpointTypes.values());
        }
    }

    class CustomBreakpointDetails {
        String customBreakpointType;
        DebuggerBreakpoint.BreakpointKind kind;
        DebuggerBreakpoint breakpointTemplate;

        CustomBreakpointDetails(String customBreakpointType, DebuggerBreakpoint.BreakpointKind kind, DebuggerBreakpoint breakpointTemplate) {
            this.customBreakpointType = customBreakpointType;
            this.kind = kind;
            this.breakpointTemplate = breakpointTemplate;
        }

        int getBreakpointType() {
            switch (this.kind) {
                case METHOD: {
                    return 1;
                }
                case FILE_LINE: {
                    return 0;
                }
                case URL_LINE: {
                    return 5;
                }
                case EXCEPTION: {
                    return 2;
                }
            }
            return -1;
        }
    }
}

