/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Node;
import oracle.ide.runner.DebuggerInspectorExpressionProvider;
import oracle.ide.runner.ToolTipExpressionProvider;
import oracle.jdevimpl.runner.debug.JDebugger;

class ExpressionProvider {
    ExpressionProvider() {
    }

    static Set<String> getToolTipExpressions(CodeEditor codeEditor, int offset) {
        return ExpressionProvider.getExpressions(codeEditor, offset, true);
    }

    static Set<String> getInspectorExpressions(CodeEditor codeEditor, int offset) {
        return ExpressionProvider.getExpressions(codeEditor, offset, false);
    }

    private static Set<String> getExpressions(CodeEditor codeEditor, int offset, boolean forTooltip) {
        try {
            Node node = codeEditor.getContext().getNode();
            return ExpressionProvider.getExpressions(codeEditor, node, offset, forTooltip);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptySet();
        }
    }

    private static Set<String> getExpressions(CodeEditor codeEditor, Node node, int offset, boolean forToolTip) {
        String lineOfText;
        int selectionEnd;
        HashSet<String> expressions = new HashSet<String>();
        Object selectedText = null;
        int selectionStart = codeEditor.getSelectionStart();
        if (selectionStart != (selectionEnd = codeEditor.getSelectionEnd()) && selectionStart <= offset && offset <= selectionEnd) {
            expressions.add(codeEditor.getSelectedText());
            return expressions;
        }
        int line = codeEditor.getLineFromOffset(offset);
        int lineStart = codeEditor.getLineStartOffset(line);
        int lineEnd = codeEditor.getLineEndOffset(line);
        int offsetWithinLine = offset - lineStart;
        try {
            lineOfText = codeEditor.getText(lineStart, lineEnd - lineStart);
        }
        catch (Exception e) {
            lineOfText = "";
        }
        int lineOfTextLength = lineOfText.length();
        if (lineOfTextLength == 0 || offsetWithinLine < 0 || offsetWithinLine >= lineOfTextLength) {
            return expressions;
        }
        if (!forToolTip) {
            List<DebuggerInspectorExpressionProvider> providers = JDebugger.getInspectorExpressionProviders();
            for (DebuggerInspectorExpressionProvider provider : providers) {
                String expression;
                if (!provider.canProvideInspectorExpression(node) || (expression = provider.getInspectorExpression(lineOfText, offsetWithinLine)) == null) continue;
                ExpressionProvider.addExpression(expression, expressions);
            }
            if (!expressions.isEmpty()) {
                return expressions;
            }
        }
        List<ToolTipExpressionProvider> toolTipExpressionProviders = JDebugger.getToolTipExpressionProviders();
        for (int i = 0; i < toolTipExpressionProviders.size(); ++i) {
            ToolTipExpressionProvider toolTipExpressionProvider = toolTipExpressionProviders.get(i);
            try {
                if (!toolTipExpressionProvider.canUnderstand(node)) continue;
                boolean caseInsensitive = toolTipExpressionProvider.isLanguageCaseInsensitive();
                String expression = toolTipExpressionProvider.getExpression(lineOfText, offsetWithinLine);
                if (expression == null) continue;
                ExpressionProvider.addExpression(expression, expressions);
                if (!caseInsensitive) continue;
                ExpressionProvider.addExpression(expression.toUpperCase(), expressions);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (expressions.isEmpty()) {
            char[] ca = new char[lineOfTextLength];
            lineOfText.getChars(0, lineOfTextLength, ca, 0);
            int start = ExpressionProvider.findStartOfUnknownExpression(ca, lineOfTextLength, offsetWithinLine);
            int end = ExpressionProvider.findEndOfUnknownExpression(ca, lineOfTextLength, start);
            ExpressionProvider.addExpression(lineOfText.substring(start, end), expressions);
        }
        return expressions;
    }

    private static void addExpression(String expression, Set<String> expressions) {
        String trimmedExpression = JDebugger.trimExpression(expression);
        if (trimmedExpression.length() > 0) {
            expressions.add(trimmedExpression);
        }
    }

    private static int findStartOfUnknownExpression(char[] ca, int length, int offset) {
        for (int i = offset; 0 <= i && i < length; --i) {
            if (ExpressionProvider.isUnknownExpressionPart(ca[i])) continue;
            return i + 1;
        }
        return 0;
    }

    private static int findEndOfUnknownExpression(char[] ca, int length, int start) {
        for (int i = start; 0 <= i && i < length; ++i) {
            if (ExpressionProvider.isUnknownExpressionPart(ca[i])) continue;
            return i;
        }
        return length;
    }

    private static boolean isUnknownExpressionPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.' || c == '[' || c == ']';
    }
}

