/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.JDebugger;

final class EditWatchDialog
extends JPanel
implements DocumentListener,
ItemListener {
    private JEWTDialog dlg;
    private HistoryList expHistoryList;
    private JComboBox expComboBox;
    private JTextField expEditor;

    static String showEditWatchDialog(String title, String prompt, String expHistoryName, String exp) {
        EditWatchDialog panel = new EditWatchDialog(prompt, expHistoryName, exp);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.expEditor, (String)title);
        panel.setJEWTDialog(dlg);
        dlg.setOKButtonEnabled(panel.canOk());
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_deb_edit_watch_inspect_expdialog_html");
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            return panel.getExpression();
        }
        return null;
    }

    private EditWatchDialog(String prompt, String expHistoryName, String exp) {
        super(new GridBagLayout());
        if (exp == null) {
            exp = "";
        }
        JLabel expLabel = new JLabel();
        this.expHistoryList = Ide.loadHistoryList((String)expHistoryName);
        String[] choices = JDebugger.filterBlanksFromHistoryList(this.expHistoryList.getHistory());
        this.expComboBox = new JComboBox<String>(choices);
        this.expComboBox.setEditable(true);
        this.expEditor = (JTextField)this.expComboBox.getEditor().getEditorComponent();
        ResourceUtils.resLabel((JLabel)expLabel, (Component)this.expEditor, (String)prompt);
        JDebugger.selectHistoryString(this.expComboBox, exp);
        int y = 0;
        this.add((Component)expLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.expComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        IdeUtil.addComboBoxDocumentListener((JComboBox)this.expComboBox, (DocumentListener)this);
        this.expComboBox.addItemListener(this);
    }

    private void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
    }

    private void processChange() {
        this.dlg.setOKButtonEnabled(this.canOk());
    }

    private boolean canOk() {
        try {
            String exp = this.expEditor.getText();
            if (exp.trim().length() > 0 && Evaluator.validate(exp)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.processChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.processChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.processChange();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.processChange();
    }

    private String getExpression() {
        return this.expHistoryList.comboBoxGetSelectedItem(this.expComboBox);
    }
}

