/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.dialogs.BrowseHandler;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.runner.debug.DbgArb;

final class EditHeapClassDialog
extends JPanel
implements ActionListener,
DocumentListener {
    private JEWTDialog dlg;
    private Project jproject;
    private JTextField nameEditor;
    private JButton browseButton;
    private BrowseHandler browseHandler;
    private String lastSelectedItem;

    static String showEditHeapClassDialog(String title, String prompt, String name, Project jproject, String helpId) {
        EditHeapClassDialog panel = new EditHeapClassDialog(prompt, name, jproject);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.nameEditor, (String)title);
        panel.setJEWTDialog(dlg);
        dlg.setOKButtonEnabled(panel.canOk());
        dlg.setInitialFocus((Component)panel.nameEditor);
        panel.nameEditor.selectAll();
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, helpId);
        String selectedClass = null;
        boolean result = WizardLauncher.runDialog((JDialog)dlg);
        if (result) {
            selectedClass = panel.getClassName();
        }
        panel.browseHandler.dispose();
        return selectedClass;
    }

    private EditHeapClassDialog(String prompt, String name, Project jproject) {
        super(new GridBagLayout());
        this.jproject = jproject;
        if (name == null) {
            name = "";
        }
        JLabel nameLabel = new JLabel();
        this.nameEditor = new JTextField(name);
        this.nameEditor.getDocument().addDocumentListener(this);
        JavaManager javaManager = JavaManager.getJavaManager((Project)jproject);
        ActionListener doubleClicker = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditHeapClassDialog.this.dlg.closeDialog(false);
            }
        };
        this.browseHandler = BrowseHandler.createClassPackageBrowserPopup((JavaManager)javaManager, (JTextField)this.nameEditor, (ActionListener)doubleClicker);
        this.browseHandler.setCopyQualifiedClassNameToField(true);
        ResourceUtils.resLabel((JLabel)nameLabel, (Component)this.nameEditor, (String)prompt);
        this.browseButton = new JButton();
        this.browseButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.browseButton, (String)DbgArb.getString(635));
        int y = 0;
        this.add((Component)nameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.nameEditor, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.browseButton, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
        dlg.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && EditHeapClassDialog.this.veto()) {
                    throw new PropertyVetoException("no", evt);
                }
            }
        });
    }

    private void processChange() {
        this.dlg.setOKButtonEnabled(this.canOk());
        String selected = this.browseHandler.getSelectedItem();
        if (!this.nameEditor.getText().equals(selected)) {
            this.lastSelectedItem = selected;
        }
    }

    private boolean canOk() {
        try {
            return this.nameEditor.getText().length() > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean veto() {
        JavaManager javaManager;
        JavaClass javaClass;
        String className = this.getClassName();
        if (className.length() > 0 && (javaClass = (javaManager = JavaManager.getJavaManager((Project)this.jproject)).getClass(className)) == null) {
            String[] messages = new String[]{DbgArb.format(637, className), DbgArb.getString(638)};
            int answer = JOptionPane.showConfirmDialog(this, messages, DbgArb.format(636, this.dlg.getTitle()), 0);
            return answer != 0;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String s;
        Object source = e.getSource();
        if (source == this.browseButton && (s = ClassPackageBrowserV2.browseClassOrPackage((Component)this, (Project)this.jproject, (int)2)) != null) {
            this.nameEditor.setText(s);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.processChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.processChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.processChange();
    }

    private String getClassName() {
        String className = this.browseHandler.getSelectedItem();
        if (className == null) {
            className = this.nameEditor.getText();
        }
        if (className.indexOf(46) < 0 && className.endsWith("[]")) {
            String baseName = className.substring(0, className.length() - 2);
            if (this.lastSelectedItem != null && this.lastSelectedItem.endsWith("." + baseName)) {
                className = this.lastSelectedItem + "[]";
            }
        }
        return className;
    }
}

