/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.config.Preferences;
import oracle.ideri.util.Product;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class DebugWindowSettings
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "DebugWindowOptions";
    static final String START_RUNNING = "running";
    static final String START_STEPOVER = "stepover";
    static final String START_STEPINTO = "stepinto";
    private static final String TABLE_RESIZE_MODE = "tableResizeMode";
    private static final String CONTEXT_MENUS_ON_MAIN_MENU = "contextMenusOnMainMenu";
    private static final String USE_FILTERS = "useFilters";
    private static final String CONNECTION_RETRIES = "connectionRetries";
    private static final String TOOLTIP_IN_CODE_EDITOR = "toolTipInCodeEditor";
    private static final String TOOLBAR_IN_LOG_WINDOW = "toolbarInLogWindow";
    private static final String ACTION_BUTTONS_ON_TOOLBAR = "actionButtonsOnToolbar";
    private static final String PROMPT_FOR_DEBUGGER_HOST_FOR_DATABASE_DEBUGGING = "promptForDebuggerHostForDatabaseDebugging";
    private static final String LOCAL_PORT_RANGE = "localPortRange";
    private static final String LOCAL_PORT_RANGE_MIN = "localPortRangeMin";
    private static final String LOCAL_PORT_RANGE_MAX = "localPortRangeMax";
    private static final String START_OPTION = "startOption";
    private static final String DETECT_METHOD_EVAL_DEADLOCKS = "detectMethodEvaluationDeadlocks";

    public static DebugWindowSettings getInstance() {
        return DebugWindowSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    public DebugWindowSettings() {
        super(HashStructure.newInstance());
    }

    private DebugWindowSettings(HashStructure hs) {
        super(hs);
    }

    public static DebugWindowSettings getInstance(PropertyStorage ps) {
        return new DebugWindowSettings(DebugWindowSettings.findOrCreate((PropertyStorage)ps, (String)KEY_SETTINGS));
    }

    public int getTableResizeMode() {
        return this._hash.getInt(TABLE_RESIZE_MODE, 1);
    }

    public void setTableResizeMode(int tableResizeMode) {
        this._hash.putInt(TABLE_RESIZE_MODE, tableResizeMode);
    }

    public boolean isContextMenusOnMainMenu() {
        return this._hash.getBoolean(CONTEXT_MENUS_ON_MAIN_MENU, false);
    }

    public void setContextMenusOnMainMenu(boolean contextMenusOnMainMenu) {
        this._hash.putBoolean(CONTEXT_MENUS_ON_MAIN_MENU, contextMenusOnMainMenu);
    }

    public boolean isUseFilters() {
        return this._hash.getBoolean(USE_FILTERS, false);
    }

    public void setUseFilters(boolean useFilters) {
        this._hash.putBoolean(USE_FILTERS, useFilters);
    }

    public int getConnectionRetries() {
        return this._hash.getInt(CONNECTION_RETRIES, 90);
    }

    public void setConnectionRetries(int connectionRetries) {
        this._hash.putInt(CONNECTION_RETRIES, connectionRetries);
    }

    public boolean isShowToolTipInCodeEditor() {
        return this._hash.getBoolean(TOOLTIP_IN_CODE_EDITOR, true);
    }

    public void setShowToolTipInCodeEditor(boolean showToolTipInCodeEditor) {
        this._hash.putBoolean(TOOLTIP_IN_CODE_EDITOR, showToolTipInCodeEditor);
    }

    @Deprecated
    public boolean isShowToolbarInLogWindow() {
        return this._hash.getBoolean(TOOLBAR_IN_LOG_WINDOW, Product.isRaptor());
    }

    @Deprecated
    public void setShowToolbarInLogWindow(boolean showToolbarInLogWindow) {
        this._hash.putBoolean(TOOLBAR_IN_LOG_WINDOW, showToolbarInLogWindow);
    }

    public boolean isShowActionButtonsOnToolbar() {
        return this._hash.getBoolean(ACTION_BUTTONS_ON_TOOLBAR, Product.isRaptor());
    }

    public void setShowActionButtonsOnToolbar(boolean showActionButtonsOnToolbar) {
        this._hash.putBoolean(ACTION_BUTTONS_ON_TOOLBAR, showActionButtonsOnToolbar);
    }

    public boolean isPromptForDebuggerHostForDatabaseDebugging() {
        return this._hash.getBoolean(PROMPT_FOR_DEBUGGER_HOST_FOR_DATABASE_DEBUGGING, false);
    }

    public void setPromptForDebuggerHostForDatabaseDebugging(boolean promptForDebuggerHostForDatabaseDebugging) {
        this._hash.putBoolean(PROMPT_FOR_DEBUGGER_HOST_FOR_DATABASE_DEBUGGING, promptForDebuggerHostForDatabaseDebugging);
    }

    public boolean isLocalPortRange() {
        return this._hash.getBoolean(LOCAL_PORT_RANGE, false);
    }

    public void setLocalPortRange(boolean localPortRange) {
        this._hash.putBoolean(LOCAL_PORT_RANGE, localPortRange);
    }

    public int getLocalPortRangeMin() {
        return this._hash.getInt(LOCAL_PORT_RANGE_MIN, 4000);
    }

    public void setLocalPortRangeMin(int localPortRangeMin) {
        this._hash.putInt(LOCAL_PORT_RANGE_MIN, localPortRangeMin);
    }

    public int getLocalPortRangeMax() {
        return this._hash.getInt(LOCAL_PORT_RANGE_MAX, 4999);
    }

    public void setLocalPortRangeMax(int localPortRangeMax) {
        this._hash.putInt(LOCAL_PORT_RANGE_MAX, localPortRangeMax);
    }

    public String getStartOption() {
        return this._hash.getString(START_OPTION, START_RUNNING);
    }

    public void setStartOption(String startOption) {
        this._hash.putString(START_OPTION, startOption);
    }

    public boolean isDetectMethodEvalDeadlocks() {
        return this._hash.getBoolean(DETECT_METHOD_EVAL_DEADLOCKS, false);
    }

    public void setDetectMethodEvalDeadlocks(boolean detectIt) {
        this._hash.putBoolean(DETECT_METHOD_EVAL_DEADLOCKS, detectIt);
    }
}

