/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import oracle.ide.feedback.FeedbackManager;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;

class DataTipModel
implements oracle.javatools.ui.datatips.DataTipModel {
    private final DataPanel dataPanel;
    private final Object root = new Object();
    private final List<Integer> visibleColumns;
    private final DataItem[] children;

    DataTipModel(DataPanel dataPanel, DataItem[] children, List<Integer> visibleColumns, boolean prefetchChildValues) {
        this.dataPanel = dataPanel;
        this.visibleColumns = visibleColumns;
        this.children = children;
        if (prefetchChildValues) {
            for (DataItem child : children) {
                for (Integer i : this.visibleColumns) {
                    child.getValueOfColumn(i);
                }
            }
        }
    }

    public int getColumnCount() {
        return this.visibleColumns.size();
    }

    public String getColumnName(int column) {
        return DataPanel.getNameOfColumn(this.visibleColumns.get(column));
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    public Object getValueAt(Object node, int column) {
        return ((DataItem)node).getValueOfColumn(this.visibleColumns.get(column));
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }

    public Object getRoot() {
        return this.root;
    }

    public Object getChild(Object parent, int index) {
        try {
            if (parent == this.root) {
                return this.children[index];
            }
            return ((DataItem)parent).getChildNodes(false)[index];
        }
        catch (Exception ex) {
            FeedbackManager.reportException((Throwable)ex);
            return null;
        }
    }

    public int getChildCount(Object parent) {
        try {
            if (parent == this.root) {
                return this.children.length;
            }
            return ((DataItem)parent).getChildNodes(true).length;
        }
        catch (Exception ex) {
            FeedbackManager.reportException((Throwable)ex);
            return 0;
        }
    }

    public boolean isLeaf(Object node) {
        try {
            if (node == this.root) {
                return false;
            }
            return !((DataItem)node).mayHaveChildren();
        }
        catch (Exception ex) {
            FeedbackManager.reportException((Throwable)ex);
            return true;
        }
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        try {
            for (int i = 0; i < this.getChildCount(parent); ++i) {
                if (!this.getChild(parent, i).equals(child)) continue;
                return i;
            }
        }
        catch (Exception ex) {
            FeedbackManager.reportException((Throwable)ex);
        }
        return -1;
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }
}

