/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import oracle.ide.Ide;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverEvent;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverListener;
import oracle.javatools.ui.datatips.DataTip;
import oracle.javatools.ui.datatips.DataTipWindow;
import oracle.javatools.ui.datatips.TableCustomizer;
import oracle.javatools.ui.table.TableHelper;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataTipModel;

class DataTipDisplayer {
    private DataPanel dataPanel;
    private final DataItem dataItem;
    private final List<Integer> visibleColumns;
    private DataTipModel dataTipModel;

    DataTipDisplayer(DataPanel dataPanel, DataItem dataItem, List<Integer> visibleColumns) {
        this.dataPanel = dataPanel;
        this.dataItem = dataItem;
        this.visibleColumns = visibleColumns;
    }

    void prepareAndShowAsTooltip() {
        Point p = MouseInfo.getPointerInfo().getLocation();
        this.dataTipModel = new DataTipModel(this.dataPanel, new DataItem[]{this.dataItem}, this.visibleColumns, false);
        this.show(new Rectangle(p.x, p.y, 5, 5));
    }

    Hover prepareAndShowAsHover() {
        Point p = MouseInfo.getPointerInfo().getLocation();
        this.dataTipModel = new DataTipModel(this.dataPanel, new DataItem[]{this.dataItem}, this.visibleColumns, false);
        DataHover hover = new DataHover(new Rectangle(p.x, p.y, 5, 5));
        hover.showHover();
        return hover;
    }

    void prepareAndShowQuickInspect() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                DataItem[] children = DataTipDisplayer.this.dataItem.getChildNodes(true);
                if (children.length > 0) {
                    DataTipDisplayer.this.dataTipModel = new DataTipModel(DataTipDisplayer.this.dataPanel, children, DataTipDisplayer.this.visibleColumns, true);
                    DataTipDisplayer.this.show(DataTipDisplayer.this.dataPanel.getSelectedCellBoundsForScreen());
                }
            }
        });
        thread.start();
    }

    private void show(final Rectangle location) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DataTip dataTip = new DataTip((Frame)Ide.getMainWindow(), (oracle.javatools.ui.datatips.DataTipModel)DataTipDisplayer.this.dataTipModel);
                dataTip.setLocationRectangle(location);
                dataTip.setDismissOnMouseExit(true);
                dataTip.setTableCustomizer((TableCustomizer)new DataTableCustomizer());
                dataTip.setVisible(true);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private class DataHover
    implements Hover {
        private DataTip dataTip;
        private Collection<HoverListener> hoverListeners = new ArrayList<HoverListener>();
        private boolean hidden = false;
        private WindowListener windowL = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                e.getWindow().removeWindowListener(this);
                DataHover.this.hideHover();
            }
        };

        public DataHover(Rectangle location) {
            this.dataTip = new DataTip((Frame)Ide.getMainWindow(), (oracle.javatools.ui.datatips.DataTipModel)DataTipDisplayer.this.dataTipModel);
            this.dataTip.setDismissOnMouseExit(true);
            this.dataTip.setLocationRectangle(location);
            this.dataTip.setTableCustomizer((TableCustomizer)new DataTableCustomizer());
        }

        public void showHover() {
            this.dataTip.setVisible(true);
            this.dataTip.getBaseTipWindow().getWindow().addWindowListener(this.windowL);
        }

        public void hideHover() {
            if (this.hidden || this.dataTip == null) {
                return;
            }
            this.hidden = true;
            this.dataTip.setVisible(false);
            HoverEvent hoverEvent = HoverEvent.createHiddenHoverEvent();
            for (Object listener : this.hoverListeners.toArray()) {
                ((HoverListener)listener).hoverChange(hoverEvent);
            }
            this.hoverListeners.clear();
        }

        public HoverFlavor getFlavor() {
            return HoverFlavor.getFlavor((String)"data");
        }

        public void addHoverListener(HoverListener hoverListener) {
            this.hoverListeners.add(hoverListener);
        }

        public void removeHoverListener(HoverListener hoverListener) {
            this.hoverListeners.remove(hoverListener);
        }

        public boolean isPointWithinHover(Point p) {
            for (DataTipWindow tipWindow = this.dataTip.getBaseTipWindow(); tipWindow != null; tipWindow = tipWindow.getChildTipWindow()) {
                if (!tipWindow.getScreenBounds().contains(p)) continue;
                return true;
            }
            return false;
        }

        public boolean shouldHideHover(KeyEvent ke) {
            return ke.getKeyCode() != 38 && ke.getKeyCode() != 40 && ke.getKeyCode() != 37 && ke.getKeyCode() != 39;
        }
    }

    private class DataTableCustomizer
    implements TableCustomizer {
        private DataTableCustomizer() {
        }

        public void customizeTable(JTable table, Object node) {
            int i;
            JTableHeader tableHeader = new JTableHeader(table.getColumnModel());
            table.setTableHeader(tableHeader);
            table.setAutoResizeMode(0);
            Dimension screenD = Toolkit.getDefaultToolkit().getScreenSize();
            int maxWidth = screenD.width / DataTipDisplayer.this.visibleColumns.size();
            TableColumnModel columnModel = table.getColumnModel();
            for (i = 0; i < DataTipDisplayer.this.visibleColumns.size(); ++i) {
                columnModel.getColumn(i).setMaxWidth(maxWidth);
            }
            for (i = 0; i < DataTipDisplayer.this.visibleColumns.size(); ++i) {
                TableHelper.sizeColumnToContents((JTable)table, (int)i, (int)15);
            }
        }
    }
}

