/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DbgArb;

final class DataPanelSettingsPanel {
    private JCheckBox showColumnNameCheckBox = new JCheckBox();
    private JCheckBox showColumnQuickInspectCheckBox = new JCheckBox();
    private JCheckBox showColumnValueCheckBox = new JCheckBox();
    private JCheckBox showColumnActualTypeCheckBox = new JCheckBox();
    private JCheckBox showColumnDeclaredTypeCheckBox = new JCheckBox();
    private JCheckBox showColumnHexValueCheckBox = new JCheckBox();
    private JCheckBox showColumnAddressCheckBox = new JCheckBox();
    private JCheckBox showColumnIDCheckBox = new JCheckBox();
    private JCheckBox sortFieldsByNameCheckBox = new JCheckBox();
    private JCheckBox showPackagesCheckBox = new JCheckBox();
    private JCheckBox hideStaticFieldsCheckBox = new JCheckBox();
    private JCheckBox hideFinalFieldsCheckBox = new JCheckBox();
    private JCheckBox hideNullArrayElementsCheckBox = new JCheckBox();
    private JCheckBox hideSyntheticFieldsCheckBox = new JCheckBox();

    public DataPanelSettingsPanel() {
        ResourceUtils.resButton((AbstractButton)this.showColumnNameCheckBox, (String)DbgArb.getString(721));
        ResourceUtils.resButton((AbstractButton)this.showColumnQuickInspectCheckBox, (String)DbgArb.getString(915));
        ResourceUtils.resButton((AbstractButton)this.showColumnValueCheckBox, (String)DbgArb.getString(724));
        ResourceUtils.resButton((AbstractButton)this.showColumnActualTypeCheckBox, (String)DbgArb.getString(722));
        ResourceUtils.resButton((AbstractButton)this.showColumnDeclaredTypeCheckBox, (String)DbgArb.getString(723));
        ResourceUtils.resButton((AbstractButton)this.showColumnHexValueCheckBox, (String)DbgArb.getString(725));
        ResourceUtils.resButton((AbstractButton)this.showColumnAddressCheckBox, (String)DbgArb.getString(726));
        ResourceUtils.resButton((AbstractButton)this.showColumnIDCheckBox, (String)DbgArb.getString(727));
        ResourceUtils.resButton((AbstractButton)this.sortFieldsByNameCheckBox, (String)DbgArb.getString(731));
        ResourceUtils.resButton((AbstractButton)this.showPackagesCheckBox, (String)DbgArb.getString(738));
        ResourceUtils.resButton((AbstractButton)this.hideStaticFieldsCheckBox, (String)DbgArb.getString(733));
        ResourceUtils.resButton((AbstractButton)this.hideFinalFieldsCheckBox, (String)DbgArb.getString(734));
        ResourceUtils.resButton((AbstractButton)this.hideNullArrayElementsCheckBox, (String)DbgArb.getString(735));
        ResourceUtils.resButton((AbstractButton)this.hideSyntheticFieldsCheckBox, (String)DbgArb.getString(736));
    }

    JPanel makeChooseColumnsPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridLayout(0, 2, 0, 0));
        TitledBorder border = BorderFactory.createTitledBorder(RunMgrArb.getString(95));
        panel.setBorder(border);
        if (borderInsets != null) {
            Insets temp = border.getBorderInsets(panel);
            borderInsets.top = temp.top;
            borderInsets.left = temp.left;
            borderInsets.bottom = temp.bottom;
            borderInsets.right = temp.right;
        }
        panel.add(this.showColumnQuickInspectCheckBox);
        panel.add(this.showColumnNameCheckBox);
        panel.add(this.showColumnValueCheckBox);
        panel.add(this.showColumnHexValueCheckBox);
        panel.add(this.showColumnActualTypeCheckBox);
        panel.add(this.showColumnDeclaredTypeCheckBox);
        panel.add(this.showColumnAddressCheckBox);
        panel.add(this.showColumnIDCheckBox);
        return panel;
    }

    JPanel makeSortPanel(JCheckBox otherCheckBox) {
        JPanel panel = new JPanel(new GridLayout(0, 2, 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(DbgArb.getString(728)));
        panel.add(this.sortFieldsByNameCheckBox);
        if (otherCheckBox != null) {
            panel.add(otherCheckBox);
        }
        return panel;
    }

    JPanel makeShowPanel(JCheckBox otherCheckBox) {
        JPanel panel = new JPanel(new GridLayout(0, 2, 0, 0));
        panel.setBorder(BorderFactory.createTitledBorder(DbgArb.getString(729)));
        panel.add(this.showPackagesCheckBox);
        if (otherCheckBox != null) {
            panel.add(otherCheckBox);
        }
        return panel;
    }

    JPanel makeHidePanel(JCheckBox otherCheckBox) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(DbgArb.getString(730)));
        int y = 0;
        this.hideStaticFieldsCheckBox.setPreferredSize(new Dimension(0, this.hideStaticFieldsCheckBox.getPreferredSize().height));
        panel.add((Component)this.hideStaticFieldsCheckBox, new GridBagConstraints(0, y, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.hideFinalFieldsCheckBox.setPreferredSize(new Dimension(0, this.hideStaticFieldsCheckBox.getPreferredSize().height));
        panel.add((Component)this.hideFinalFieldsCheckBox, new GridBagConstraints(1, y++, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.hideNullArrayElementsCheckBox.setPreferredSize(new Dimension(0, this.hideStaticFieldsCheckBox.getPreferredSize().height));
        panel.add((Component)this.hideNullArrayElementsCheckBox, new GridBagConstraints(0, y, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.hideSyntheticFieldsCheckBox.setPreferredSize(new Dimension(0, this.hideStaticFieldsCheckBox.getPreferredSize().height));
        panel.add((Component)this.hideSyntheticFieldsCheckBox, new GridBagConstraints(1, y, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (otherCheckBox != null) {
            otherCheckBox.setPreferredSize(new Dimension(0, this.hideStaticFieldsCheckBox.getPreferredSize().height));
            panel.add((Component)otherCheckBox, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    void onEntry(DataPanelSettings dataPanelSettings) {
        this.showColumnQuickInspectCheckBox.setSelected(dataPanelSettings.getColumnVisible(7));
        this.showColumnNameCheckBox.setSelected(true);
        this.showColumnNameCheckBox.setEnabled(false);
        this.showColumnValueCheckBox.setSelected(dataPanelSettings.getColumnVisible(1));
        this.showColumnActualTypeCheckBox.setSelected(dataPanelSettings.getColumnVisible(2));
        this.showColumnDeclaredTypeCheckBox.setSelected(dataPanelSettings.getColumnVisible(3));
        this.showColumnHexValueCheckBox.setSelected(dataPanelSettings.getColumnVisible(4));
        this.showColumnAddressCheckBox.setSelected(dataPanelSettings.getColumnVisible(5));
        this.showColumnIDCheckBox.setSelected(dataPanelSettings.getColumnVisible(6));
        this.sortFieldsByNameCheckBox.setSelected(dataPanelSettings.isSortFieldsByName());
        this.showPackagesCheckBox.setSelected(dataPanelSettings.isShowPackages());
        this.hideStaticFieldsCheckBox.setSelected(dataPanelSettings.isHideStaticFields());
        this.hideFinalFieldsCheckBox.setSelected(dataPanelSettings.isHideFinalFields());
        this.hideNullArrayElementsCheckBox.setSelected(dataPanelSettings.isHideNullArrayElements());
        this.hideSyntheticFieldsCheckBox.setSelected(dataPanelSettings.isHideSyntheticFields());
    }

    void onExit(DataPanelSettings dataPanelSettings) throws TraversalException {
        dataPanelSettings.setColumnVisible(7, this.showColumnQuickInspectCheckBox.isSelected());
        dataPanelSettings.setColumnVisible(0, true);
        dataPanelSettings.setColumnVisible(1, this.showColumnValueCheckBox.isSelected());
        dataPanelSettings.setColumnVisible(2, this.showColumnActualTypeCheckBox.isSelected());
        dataPanelSettings.setColumnVisible(3, this.showColumnDeclaredTypeCheckBox.isSelected());
        dataPanelSettings.setColumnVisible(4, this.showColumnHexValueCheckBox.isSelected());
        dataPanelSettings.setColumnVisible(5, this.showColumnAddressCheckBox.isSelected());
        dataPanelSettings.setColumnVisible(6, this.showColumnIDCheckBox.isSelected());
        dataPanelSettings.setSortFieldsByName(this.sortFieldsByNameCheckBox.isSelected());
        dataPanelSettings.setShowPackages(this.showPackagesCheckBox.isSelected());
        dataPanelSettings.setHideStaticFields(this.hideStaticFieldsCheckBox.isSelected());
        dataPanelSettings.setHideFinalFields(this.hideFinalFieldsCheckBox.isSelected());
        dataPanelSettings.setHideNullArrayElements(this.hideNullArrayElementsCheckBox.isSelected());
        dataPanelSettings.setHideSyntheticFields(this.hideSyntheticFieldsCheckBox.isSelected());
    }
}

