/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.Ide;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

final class DataArrayRange {
    private static int defaultArrayRangeMax = 0;
    private DebuggingProcess debuggingProcess;
    private int start;
    private int count;

    DataArrayRange(DebuggingProcess debuggingProcess, DebugDataArrayInfo array) {
        this.debuggingProcess = debuggingProcess;
        this.start = array.getArrayStart();
        this.count = array.getArrayCount();
        int max = DataArrayRange.getDefaultArrayRangeMax();
        if (this.count == -1 || this.count > max) {
            this.count = max;
        }
    }

    DebuggingProcess getDebuggingProcess() {
        return this.debuggingProcess;
    }

    int getStart() {
        return this.start;
    }

    void setStart(int start) {
        this.start = start;
    }

    int getCount() {
        return this.count;
    }

    void setCount(int count) {
        this.count = count;
    }

    private static synchronized int getDefaultArrayRangeMax() {
        if (defaultArrayRangeMax == 0) {
            defaultArrayRangeMax = 20;
            String max = Ide.getProperty((String)"DebuggerDefaultArrayRangeMax");
            if (max != null) {
                try {
                    defaultArrayRangeMax = Integer.parseInt(max);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return defaultArrayRangeMax;
    }
}

