/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.ClassesWindowSettings;
import oracle.jdevimpl.runner.debug.DbgArb;

public final class ClassesWindowSettingsPanel
extends DefaultTraversablePanel
implements ItemListener {
    private JCheckBox showColumnNameCheckBox;
    private JCheckBox showColumnCountCheckBox;
    private JCheckBox showColumnMemoryCheckBox;
    private JCheckBox showColumnFilenameCheckBox;
    private JCheckBox showClassLoadersCheckBox;
    private JRadioButton showClassLoadersTreeRadio;
    private JRadioButton showClassLoadersListRadio;
    private JCheckBox showPackagesCheckBox;
    private JRadioButton showPackagesTreeRadio;
    private JRadioButton showPackagesListRadio;
    private JLabel sortLabel;
    private JComboBox sortColumnComboBox;
    private JCheckBox sortAscendingCheckBox;

    public ClassesWindowSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_classwinsetpanel_html");
        this.showColumnNameCheckBox = new JCheckBox();
        this.showColumnCountCheckBox = new JCheckBox();
        this.showColumnMemoryCheckBox = new JCheckBox();
        this.showColumnFilenameCheckBox = new JCheckBox();
        this.showClassLoadersCheckBox = new JCheckBox();
        this.showClassLoadersTreeRadio = new JRadioButton();
        this.showClassLoadersListRadio = new JRadioButton();
        this.showPackagesCheckBox = new JCheckBox();
        this.showPackagesTreeRadio = new JRadioButton();
        this.showPackagesListRadio = new JRadioButton();
        this.sortLabel = new JLabel();
        this.sortColumnComboBox = new JComboBox();
        this.sortAscendingCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.showColumnNameCheckBox, (String)DbgArb.getString(755));
        ResourceUtils.resButton((AbstractButton)this.showColumnCountCheckBox, (String)DbgArb.getString(756));
        ResourceUtils.resButton((AbstractButton)this.showColumnMemoryCheckBox, (String)DbgArb.getString(757));
        ResourceUtils.resButton((AbstractButton)this.showColumnFilenameCheckBox, (String)DbgArb.getString(758));
        ResourceUtils.resButton((AbstractButton)this.showClassLoadersCheckBox, (String)DbgArb.getString(750));
        this.showClassLoadersCheckBox.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this.showClassLoadersTreeRadio, (String)DbgArb.getString(751));
        ResourceUtils.resButton((AbstractButton)this.showClassLoadersListRadio, (String)DbgArb.getString(752));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.showClassLoadersTreeRadio);
        buttonGroup2.add(this.showClassLoadersListRadio);
        ResourceUtils.resButton((AbstractButton)this.showPackagesCheckBox, (String)DbgArb.getString(747));
        this.showPackagesCheckBox.addItemListener(this);
        ResourceUtils.resButton((AbstractButton)this.showPackagesTreeRadio, (String)DbgArb.getString(748));
        ResourceUtils.resButton((AbstractButton)this.showPackagesListRadio, (String)DbgArb.getString(749));
        ButtonGroup buttonGroup1 = new ButtonGroup();
        buttonGroup1.add(this.showPackagesTreeRadio);
        buttonGroup1.add(this.showPackagesListRadio);
        ResourceUtils.resLabel((JLabel)this.sortLabel, (Component)this.sortColumnComboBox, (String)DbgArb.getString(753));
        Object[] sortColumns = new String[]{DbgArb.getString(563), DbgArb.getString(564), DbgArb.getString(565), DbgArb.getString(566)};
        this.sortColumnComboBox.setModel(new NonNullableComboBoxModel(sortColumns));
        ResourceUtils.resButton((AbstractButton)this.sortAscendingCheckBox, (String)DbgArb.getString(754));
        this.setLayout(new GridBagLayout());
        int y = 0;
        Insets borderInsets = new Insets(0, 0, 0, 0);
        this.add(this.makeChooseColumnsPanel(borderInsets), new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add(this.makeMiscPanel(borderInsets), new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(15, 5, 0, 5), 0, 0));
        this.add(this.makeSortPanel(borderInsets), new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(15, 5, 0, 5), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
    }

    private JPanel makeChooseColumnsPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridLayout(0, 2, 0, 0));
        TitledBorder border = BorderFactory.createTitledBorder(RunMgrArb.getString(95));
        panel.setBorder(border);
        if (borderInsets != null) {
            Insets temp = border.getBorderInsets(panel);
            borderInsets.top = temp.top;
            borderInsets.left = temp.left;
            borderInsets.bottom = temp.bottom;
            borderInsets.right = temp.right;
        }
        panel.add(this.showColumnNameCheckBox);
        panel.add(this.showColumnCountCheckBox);
        panel.add(this.showColumnMemoryCheckBox);
        panel.add(this.showColumnFilenameCheckBox);
        return panel;
    }

    private JPanel makeMiscPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridLayout(0, 2, 0, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(0, borderInsets.left, 0, borderInsets.right));
        JPanel panel1 = new JPanel(new GridBagLayout());
        int y = 0;
        panel1.add((Component)this.showClassLoadersCheckBox, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel1.add((Component)new JLabel(), new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel1.add((Component)this.showClassLoadersTreeRadio, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 5), 0, 0));
        panel1.add((Component)this.showClassLoadersListRadio, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 5), 0, 0));
        panel.add(panel1);
        JPanel panel2 = new JPanel(new GridBagLayout());
        y = 0;
        panel2.add((Component)this.showPackagesCheckBox, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel2.add((Component)new JLabel(), new GridBagConstraints(1, y++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        panel2.add((Component)this.showPackagesTreeRadio, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 5), 0, 0));
        panel2.add((Component)this.showPackagesListRadio, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 5), 0, 0));
        panel.add(panel2);
        return panel;
    }

    private JPanel makeSortPanel(Insets borderInsets) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, borderInsets.left, 0, borderInsets.right));
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0);
        panel.add((Component)this.sortLabel, constraints);
        ++constraints.gridx;
        panel.add((Component)this.sortColumnComboBox, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        panel.add((Component)this.sortAscendingCheckBox, constraints);
        return panel;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.showClassLoadersCheckBox) {
            this.enableClassLoadersRadios();
        } else if (source == this.showPackagesCheckBox) {
            this.enablePackagesRadios();
        }
    }

    private void enableClassLoadersRadios() {
        boolean enable = this.showClassLoadersCheckBox.isSelected();
        this.showClassLoadersTreeRadio.setEnabled(enable);
        this.showClassLoadersListRadio.setEnabled(enable);
    }

    private void enablePackagesRadios() {
        boolean enable = this.showPackagesCheckBox.isSelected();
        this.showPackagesTreeRadio.setEnabled(enable);
        this.showPackagesListRadio.setEnabled(enable);
    }

    private ClassesWindowSettings getSettings(TraversableContext tc) {
        return ClassesWindowSettings.getInstance(tc.getPropertyStorage());
    }

    public void onEntry(TraversableContext tc) {
        ClassesWindowSettings settings = this.getSettings(tc);
        this.showColumnNameCheckBox.setSelected(true);
        this.showColumnNameCheckBox.setEnabled(false);
        this.showColumnCountCheckBox.setSelected(settings.getColumnVisible(1));
        this.showColumnMemoryCheckBox.setSelected(settings.getColumnVisible(2));
        this.showColumnFilenameCheckBox.setSelected(settings.getColumnVisible(3));
        this.showClassLoadersCheckBox.setSelected(settings.isShowClassLoaders());
        if (settings.isShowClassLoadersAsTree()) {
            this.showClassLoadersTreeRadio.setSelected(true);
        } else {
            this.showClassLoadersListRadio.setSelected(true);
        }
        this.enableClassLoadersRadios();
        this.showPackagesCheckBox.setSelected(settings.isShowPackages());
        if (settings.isShowPackagesAsTree()) {
            this.showPackagesTreeRadio.setSelected(true);
        } else {
            this.showPackagesListRadio.setSelected(true);
        }
        this.enablePackagesRadios();
        this.sortColumnComboBox.setSelectedIndex(settings.getSortColumn());
        this.sortAscendingCheckBox.setSelected(settings.isSortAscending());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        ClassesWindowSettings settings = this.getSettings(tc);
        settings.setColumnVisible(0, true);
        settings.setColumnVisible(1, this.showColumnCountCheckBox.isSelected());
        settings.setColumnVisible(2, this.showColumnMemoryCheckBox.isSelected());
        settings.setColumnVisible(3, this.showColumnFilenameCheckBox.isSelected());
        settings.setShowClassLoaders(this.showClassLoadersCheckBox.isSelected());
        settings.setShowClassLoadersAsTree(this.showClassLoadersTreeRadio.isSelected());
        settings.setShowPackages(this.showPackagesCheckBox.isSelected());
        settings.setShowPackagesAsTree(this.showPackagesTreeRadio.isSelected());
        int sortColumn = this.sortColumnComboBox.getSelectedIndex();
        if (sortColumn != -1) {
            settings.setSortColumn(sortColumn);
        }
        settings.setSortAscending(this.sortAscendingCheckBox.isSelected());
    }
}

