/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.config.Preferences;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class ClassesWindowSettings
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "ClassesWindowOptions";
    private static final String COLUMN_VISIBLE = "columnVisible";
    private static final String COLUMN_WIDTH = "columnWidth";

    static ClassesWindowSettings getInstance() {
        return ClassesWindowSettings.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    @Deprecated
    public ClassesWindowSettings() {
        super(HashStructure.newInstance());
    }

    private ClassesWindowSettings(HashStructure hs) {
        super(hs);
    }

    public static ClassesWindowSettings getInstance(PropertyStorage ps) {
        return new ClassesWindowSettings(ClassesWindowSettings.findOrCreate((PropertyStorage)ps, (String)KEY_SETTINGS));
    }

    public boolean isShowClassLoaders() {
        return this._hash.getBoolean("showClassLoaders", false);
    }

    public void setShowClassLoaders(boolean showClassLoaders) {
        this._hash.putBoolean("showClassLoaders", showClassLoaders);
    }

    public boolean isShowClassLoadersAsTree() {
        return this._hash.getBoolean("showClassLoadersAsTree", true);
    }

    public void setShowClassLoadersAsTree(boolean showClassLoadersAsTree) {
        this._hash.putBoolean("showClassLoadersAsTree", showClassLoadersAsTree);
    }

    public boolean isShowPackages() {
        return this._hash.getBoolean("showPackages", true);
    }

    public void setShowPackages(boolean showPackages) {
        this._hash.putBoolean("showPackages", showPackages);
    }

    public boolean isShowPackagesAsTree() {
        return this._hash.getBoolean("showPackagesAsTree", true);
    }

    public void setShowPackagesAsTree(boolean showPackagesAsTree) {
        this._hash.putBoolean("showPackagesAsTree", showPackagesAsTree);
    }

    public int getSortColumn() {
        return this._hash.getInt("sortColumn", 0);
    }

    public void setSortColumn(int sortColumn) {
        this._hash.putInt("sortColumn", sortColumn);
    }

    public boolean isSortAscending() {
        return this._hash.getBoolean("sortAscending", true);
    }

    public void setSortAscending(boolean sortAscending) {
        this._hash.putBoolean("sortAscending", sortAscending);
    }

    public void toggleSortAscending() {
        this.setSortAscending(!this.isSortAscending());
    }

    @Deprecated
    public boolean[] getColumnVisible() {
        boolean[] columnVisible = new boolean[4];
        for (int x = 0; x < 4; ++x) {
            columnVisible[x] = this.getColumnVisible(x);
        }
        return columnVisible;
    }

    @Deprecated
    public void setColumnVisible(boolean[] columnVisible) {
        for (int x = 0; x < columnVisible.length; ++x) {
            this.setColumnVisible(x, columnVisible[x]);
        }
    }

    boolean getColumnVisible(int columnIndex) {
        boolean defaultValue = columnIndex == 0 || columnIndex == 1;
        return this._hash.getBoolean(COLUMN_VISIBLE + columnIndex, defaultValue);
    }

    void setColumnVisible(int columnIndex, boolean columnVisible) {
        this._hash.putBoolean(COLUMN_VISIBLE + columnIndex, columnVisible);
    }

    @Deprecated
    public int[] getColumnWidth() {
        int[] columnWidth = new int[4];
        for (int x = 0; x < 4; ++x) {
            columnWidth[x] = this.getColumnWidth(x);
        }
        return columnWidth;
    }

    @Deprecated
    public void setColumnWidth(int[] columnWidth) {
        for (int x = 0; x < columnWidth.length; ++x) {
            this.setColumnWidth(x, columnWidth[x]);
        }
    }

    int getColumnWidth(int columnIndex) {
        return this._hash.getInt(COLUMN_WIDTH + columnIndex, 0);
    }

    void setColumnWidth(int columnIndex, int columnWidth) {
        this._hash.putInt(COLUMN_WIDTH + columnIndex, columnWidth);
    }

    public String getColumnOrder() {
        return this._hash.getString("columnOrder");
    }

    public void setColumnOrder(String columnOrder) {
        this._hash.putString("columnOrder", columnOrder);
    }
}

