/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.layout.Layout;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekHelper;
import oracle.ide.peek.Peekable;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.support.DebugBreakpoint;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.java.Context2ParserHelper;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BreakpointOptionsDialog;
import oracle.jdevimpl.runner.debug.BreakpointSettings;
import oracle.jdevimpl.runner.debug.BreakpointsWindowSettings;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.ExtenderManager;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.RunWhilePaused;
import oracle.jdevimpl.runner.debug.Utils;

final class BreakpointsWindow
extends DebuggerWindow
implements TreeExpansionListener,
TreeSelectionListener,
DragGestureListener,
DragSourceListener,
DropTargetListener,
Controller,
ContextMenuListener,
ColumnMenuListener,
PopupMenuListener {
    private BreakpointTreeTableModel model;
    private JFastTreeTable treeTable;
    private TreeSelectionModel treeSelectionModel;
    private JScrollPane scrollPane;
    private JPanel guiPanel;
    private String title;
    private Toolbar toolbar;
    private Workspace workspace;
    private Project project;
    private List[] breakpoints;
    private Object lastHighlight;
    private BreakpointsWindowSettings bpSettings;
    private int preferredVisibleRowCount = 6;
    private static final String REMOVE_INSTANCE_FILTER_CMD_PREFIX = "DebugBreakpointsRemoveInstanceFilter";
    private List removeInstanceFilterActions;
    private static IdeAction actionOptions;
    private static IdeAction actionEnable;
    private static IdeAction actionDisable;
    private static IdeAction actionRemove;
    private static IdeAction actionChangeScopeGlobal;
    private static IdeAction actionChangeScopeWorkspace;
    private static IdeAction actionChangeScopeProject;
    private static IdeAction actionGoTo;
    private static IdeAction actionEnableAll;
    private static IdeAction actionDisableAll;
    private static IdeAction actionRemoveAll;
    private static IdeAction actionExpandAll;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenu subMenuAdd;
    private static JMenuItem menuitemOptions;
    private static JMenuItem menuitemEnable;
    private static JMenuItem menuitemDisable;
    private static JMenuItem menuitemRemove;
    private static JMenu subMenuChangeScope;
    private static JMenuItem menuitemGoTo;
    private static JMenuItem menuitemEnableAll;
    private static JMenuItem menuitemDisableAll;
    private static JMenuItem menuitemRemoveAll;
    private static JMenuItem menuitemExpandAll;
    private static JMenuItem menuitemCollapseAll;
    private static JMenuItem menuitemSave;
    private static JMenuItem menuitemSettings;
    private static final int OPTIONS_CMD_ID;
    private static final int ENABLE_CMD_ID;
    private static final int DISABLE_CMD_ID;
    private static final int REMOVE_CMD_ID;
    private static final int CHANGE_SCOPE_GLOBAL_CMD_ID;
    private static final int CHANGE_SCOPE_WORKSPACE_CMD_ID;
    private static final int CHANGE_SCOPE_PROJECT_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int ENABLE_ALL_CMD_ID;
    private static final int DISABLE_ALL_CMD_ID;
    private static final int REMOVE_ALL_CMD_ID;
    private static final int EXPAND_ALL_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    private static final int SHOW_COL_TYPE_CMD_ID;
    private static final int SHOW_COL_STATUS_CMD_ID;
    private static final int SHOW_COL_SCOPE_CMD_ID;
    private static final int SHOW_COL_GROUP_CMD_ID;
    private static final int SHOW_COL_COND_CMD_ID;
    private static final int SHOW_COL_THREAD_CMD_ID;
    private static final int SHOW_COL_PASSCNT_CMD_ID;
    private static final int SHOW_COL_ACTION_CMD_ID;
    private static final int SHOW_COL_FILTERS_CMD_ID;
    static final int COLUMN_DESCRIPTION = 0;
    static final int COLUMN_TYPE = 1;
    static final int COLUMN_STATUS = 2;
    static final int COLUMN_SCOPE = 3;
    static final int COLUMN_GROUP = 4;
    static final int COLUMN_CONDITION = 5;
    static final int COLUMN_THREAD = 6;
    static final int COLUMN_PASSCOUNT = 7;
    static final int COLUMN_ACTION = 8;
    static final int COLUMN_INSTANCE_FILTERS = 9;
    static final int NUMBER_OF_COLUMNS = 10;
    private static final String SELECTED_COLUMN = "BreakpointsWindow.ColumnSelected";
    private TableColumn[] column = new TableColumn[10];
    private int[] columnDefaultWidth = new int[10];
    private boolean[] columnShowing = new boolean[10];
    private static DataFlavor breakpointFlavor;
    private static DataFlavor[] transferFlavors;
    static final String BREAKPOINTS_WINDOW_ID = "Debugger.BreakpointsWindow";
    private static Icon breakpointsTabIcon;
    private static LinkedHashMap<IdeAction, BreakpointSettings> addBreakpointActions;
    private static LinkedHashMap<IdeAction, JCheckBoxMenuItem> columnActions;
    private static MenuToolButton addBreakpointButton;
    private static Map<BreakpointSettings, Boolean> customBreakpointTypes;
    private static JMenu mainMenuAddBreakpointActionsMenu;
    private static List<IdeAction> actionsWithoutController;
    private boolean adjustColumnsAlreadyDone = false;

    BreakpointsWindow(Workspace workspace, Project project, List[] breakpoints) {
        super(BREAKPOINTS_WINDOW_ID);
        this.workspace = workspace;
        this.project = project;
        this.breakpoints = breakpoints;
        this.title = DbgArb.getString(380);
        JDebugger.getInstance().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        this.removeInstanceFilterActions = new ArrayList();
        BreakpointsWindow.makeActions();
        BreakpointsWindow.createAddBreakpointActions();
        this.setControllerForActions();
    }

    @Override
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.SOUTH;
    }

    @Override
    public void refresh() {
        this.everythingChanged();
    }

    public boolean installByDefault() {
        return true;
    }

    public void shutDown() {
        this.saveSettings();
    }

    private void loadSettings() {
        for (int i = 0; i < 10; ++i) {
            int width = this.bpSettings.getColumnWidth(i);
            if (width == 0) continue;
            this.adjustColumnsAlreadyDone = true;
            this.column[i].setPreferredWidth(width);
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String order = this.bpSettings.getColumnOrder();
        if (order != null) {
            for (int i = 0; i < 10; ++i) {
                String identifier;
                int comma = order.indexOf(44);
                if (comma != -1) {
                    identifier = order.substring(0, comma);
                    order = order.substring(comma + 1);
                } else {
                    identifier = order;
                }
                if (identifier.length() == 0) break;
                try {
                    int from = tableColumnModel.getColumnIndex(identifier);
                    if (from == i) continue;
                    this.treeTable.moveColumn(from, i);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private void breakpointsWindowSettingsChanged(boolean changed) {
        if (this.treeTable == null) {
            return;
        }
        for (int i = 1; i < 10; ++i) {
            boolean columnVisible = this.bpSettings.getColumnVisible(i);
            if (this.columnShowing[i] == columnVisible) continue;
            this.columnShowing[i] = columnVisible;
            if (columnVisible) {
                this.treeTable.addColumn(this.column[i]);
                continue;
            }
            this.treeTable.removeColumn(this.column[i]);
        }
        if (changed) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BreakpointsWindow.this.everythingChanged();
                }
            });
        }
        Dimension d = this.treeTable.getPreferredSize();
        d.height = this.treeTable.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.treeTable.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        this.scrollPane.setPreferredSize(d);
    }

    private void saveSettings() {
        if (this.treeTable == null) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            this.bpSettings.setColumnWidth(i, this.column[i].getWidth());
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String order = "";
        Enumeration<TableColumn> e = tableColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            order = order + column.getIdentifier() + ",";
        }
        this.bpSettings.setColumnOrder(order);
    }

    static synchronized void addContextMenuToMainMenu(Menubar menubar, JMenu subMenu) {
        BreakpointsWindow.makeActions();
        BreakpointsWindow.createAddBreakpointActions();
        float section = 1.0f;
        mainMenuAddBreakpointActionsMenu = menubar.createSubMenu(DbgArb.getString(421), DbgArb.getInteger(422));
        ArrayList<IdeAction> breakpointActionList = new ArrayList<IdeAction>(addBreakpointActions.keySet());
        BreakpointsWindow.sortBreakpointActions(breakpointActionList);
        for (IdeAction addBreakpointAction : breakpointActionList) {
            mainMenuAddBreakpointActionsMenu.add((Action)addBreakpointAction);
        }
        menubar.add((Component)mainMenuAddBreakpointActionsMenu, subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionOptions), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionEnable), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDisable), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemove), subMenu, section);
        JMenu subMenuChangeScope = menubar.createSubMenu(DbgArb.getString(410), DbgArb.getInteger(411));
        JMenuItem menuItemChangeScopeGlobal = menubar.createMenuItem((ToggleAction)actionChangeScopeGlobal);
        JMenuItem menuItemChangeScopeWorkspace = menubar.createMenuItem((ToggleAction)actionChangeScopeWorkspace);
        JMenuItem menuItemChangeScopeProject = menubar.createMenuItem((ToggleAction)actionChangeScopeProject);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(menuItemChangeScopeGlobal);
        buttonGroup.add(menuItemChangeScopeWorkspace);
        buttonGroup.add(menuItemChangeScopeProject);
        subMenuChangeScope.add(menuItemChangeScopeGlobal);
        subMenuChangeScope.add(menuItemChangeScopeWorkspace);
        subMenuChangeScope.add(menuItemChangeScopeProject);
        menubar.add((Component)subMenuChangeScope, subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoTo), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionEnableAll), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDisableAll), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemoveAll), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionExpandAll), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), subMenu, section);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), subMenu, section += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), subMenu, section);
    }

    static synchronized void addCustomBreakpointType(int bpType, String customTypeString, BreakpointSettings template) {
        BreakpointSettings bpSettings = template == null ? new BreakpointSettings() : template;
        bpSettings.setType(bpType);
        bpSettings.setCustomTypeString(customTypeString);
        if (customBreakpointTypes == null) {
            customBreakpointTypes = new HashMap<BreakpointSettings, Boolean>();
        }
        customBreakpointTypes.put(bpSettings, null);
        if (addBreakpointActions != null) {
            IdeAction newAction = BreakpointsWindow.createNewAddBreakpointAction(bpSettings);
            addBreakpointActions.put(newAction, bpSettings);
            if (mainMenuAddBreakpointActionsMenu != null) {
                mainMenuAddBreakpointActionsMenu.add((Action)newAction);
            }
            if (actionsWithoutController == null) {
                actionsWithoutController = new ArrayList<IdeAction>();
            }
            actionsWithoutController.add(newAction);
        }
    }

    public Component getGUI() {
        if (this.guiPanel == null) {
            this.bpSettings = BreakpointsWindowSettings.getInstance();
            this.createGUI();
            this.loadSettings();
            this.breakpointsWindowSettingsChanged(false);
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            this.everythingChanged();
            this.bpSettings.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent e) {
                    if (Utils.structureReallyChanged(e)) {
                        BreakpointsWindow.this.breakpointsWindowSettingsChanged(true);
                    }
                }
            });
        }
        return this.guiPanel;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_breakpointwindow_html");
    }

    public Controller getController() {
        return this;
    }

    public Context getContext(EventObject event) {
        BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model != null ? this.model.getSelectedBreakpointItem() : null;
        return ContextBuilder.buildContext((Element)breakpointItem, (View)this, event, this.workspace, this.project);
    }

    public int getDefaultVisibility(Layout layout) {
        if (JDebugger.isDebuggingLayout(layout)) {
            return 1;
        }
        return 0;
    }

    public String getTabName() {
        return this.title;
    }

    public Icon getTabIcon() {
        if (breakpointsTabIcon == null) {
            breakpointsTabIcon = OracleIcons.getIcon((String)"debugger/breakpoints.png");
        }
        return breakpointsTabIcon;
    }

    public String getTitleName() {
        return this.title;
    }

    public DropTargetListener getTabDropListener() {
        return this;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        this.model.branchExpanded(event.getPath());
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        this.model.branchCollapsed(event.getPath());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath[] treePaths = this.treeSelectionModel.getSelectionPaths();
        if (treePaths != null && treePaths.length > 0) {
            Object[] selections = new Object[treePaths.length];
            for (int i = 0; i < treePaths.length; ++i) {
                selections[i] = this.model.getInfoFromTreePath(treePaths[i]);
            }
            this.lastHighlight = selections;
        } else {
            this.lastHighlight = null;
        }
        Context context = new Context();
        this.update(actionOptions, context);
        this.update(actionRemove, context);
        this.update(actionEnable, context);
        this.update(actionDisable, context);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Point pt;
        BreakpointTreeTableModel.BreakpointItem breakpointItem;
        if (e.getDragAction() == 2 && (breakpointItem = this.model.getBreakpointItemForDrag(pt = e.getDragOrigin())) != null) {
            try {
                BufferedImage dragImage = new BufferedImage(1, 1, 6);
                dragImage.setRGB(0, 0, -16777216);
                Point imageOffset = new Point(0, 0);
                e.startDrag(null, dragImage, imageOffset, breakpointItem, this);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        this.checkDrag(e);
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        this.checkDrag(e);
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        this.checkDrop(e);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private void checkDrag(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(BreakpointsWindow.getBreakpointFlavor())) {
            e.acceptDrag(2);
            return;
        }
        if (e.isDataFlavorSupported(ClassesWindow.getClassFlavor())) {
            e.acceptDrag(1);
            return;
        }
        if (e.isDataFlavorSupported(DataItem.getHeapObjectFlavor())) {
            try {
                DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
                if (debuggingProcess != null) {
                    DebugBreakpoint dbp;
                    BreakpointTreeTableModel.BreakpointItem breakpointItem;
                    Point pt = null;
                    if (e.getDropTargetContext().getDropTarget().getComponent() == this.treeTable) {
                        pt = e.getLocation();
                    }
                    if (this.model.getColumnAtPoint(pt) == 9 && (breakpointItem = this.model.getBreakpointItemAtPoint(pt)) != null && breakpointItem.isBreakpoint() && (dbp = breakpointItem.getBreakpoint().getDebugBreakpoint(debuggingProcess)) != null) {
                        e.acceptDrag(1);
                        return;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        e.rejectDrag();
    }

    private void checkDrop(DropTargetDropEvent e) {
        if (e.isLocalTransfer()) {
            if (e.isDataFlavorSupported(BreakpointsWindow.getBreakpointFlavor())) {
                try {
                    Point pt = null;
                    if (e.getDropTargetContext().getDropTarget().getComponent() == this.treeTable) {
                        pt = e.getLocation();
                    }
                    String groupName = this.model.getGroupNameAtPoint(pt);
                    Transferable t = e.getTransferable();
                    BreakpointTreeTableModel.BreakpointItem breakpointItem = (BreakpointTreeTableModel.BreakpointItem)t.getTransferData(BreakpointsWindow.getBreakpointFlavor());
                    if (breakpointItem.isMulti()) {
                        List list = breakpointItem.getBreakpoints(null);
                        for (int i = list.size() - 1; i >= 0; --i) {
                            Breakpoint bp = (Breakpoint)list.get(i);
                            bp.setGroupName(groupName);
                        }
                    } else {
                        Breakpoint bp = breakpointItem.getBreakpoint();
                        bp.setGroupName(groupName);
                    }
                    this.everythingChanged();
                    e.acceptDrop(2);
                    e.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (Exception ex) {}
            } else if (e.isDataFlavorSupported(ClassesWindow.getClassFlavor())) {
                try {
                    String groupName;
                    Transferable t = e.getTransferable();
                    ClassesWindow.ClassFlavorData data = (ClassesWindow.ClassFlavorData)t.getTransferData(ClassesWindow.getClassFlavor());
                    String className = data.getName();
                    URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.workspace, this.project);
                    Breakpoint bp = new Breakpoint(ownerURL, 4, className);
                    Point pt = null;
                    if (e.getDropTargetContext().getDropTarget().getComponent() == this.treeTable) {
                        pt = e.getLocation();
                    }
                    if ((groupName = this.model.getGroupNameAtPoint(pt)) != null) {
                        bp.setGroupName(groupName);
                    }
                    this.addNewBreakpoint(bp);
                    JDebugger.getInstance().viewBreakpoints();
                    e.acceptDrop(1);
                    e.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (Exception ex) {}
            } else if (e.isDataFlavorSupported(DataItem.getHeapObjectFlavor())) {
                try {
                    DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
                    if (debuggingProcess != null) {
                        HashSet classNames;
                        DebugDataObjectInfo dataObject;
                        Transferable t;
                        Object o;
                        DebugBreakpoint dbp;
                        BreakpointTreeTableModel.BreakpointItem breakpointItem;
                        Point pt = null;
                        if (e.getDropTargetContext().getDropTarget().getComponent() == this.treeTable) {
                            pt = e.getLocation();
                        }
                        if (this.model.getColumnAtPoint(pt) == 9 && (breakpointItem = this.model.getBreakpointItemAtPoint(pt)) != null && breakpointItem.isBreakpoint() && (dbp = breakpointItem.getBreakpoint().getDebugBreakpoint(debuggingProcess)) != null && (o = (t = e.getTransferable()).getTransferData(DataItem.getHeapObjectFlavor())) instanceof DebugDataObjectInfo && dbp.isInstanceFilterAppropriate(dataObject = (DebugDataObjectInfo)o, classNames = new HashSet()) && !dbp.isInstanceFilterSet(dataObject)) {
                            dbp.addInstanceFilter(dataObject);
                            this.updateColumn(9);
                            e.acceptDrop(1);
                            e.getDropTargetContext().dropComplete(true);
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        e.rejectDrop();
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == GOTO_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                breakpointItem.showInSource();
            }
            return true;
        }
        if (cmdId == DISABLE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                breakpointItem.disable();
                this.updateColumn(2);
            }
            return true;
        }
        if (cmdId == ENABLE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                breakpointItem.enable();
                this.updateColumn(2);
            }
            return true;
        }
        if (cmdId == REMOVE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                JTree tree = this.treeTable.getTree();
                int row = tree.getRowForPath(this.treeSelectionModel.getLeadSelectionPath());
                breakpointItem.remove();
                this.everythingChanged(null);
                int count = tree.getRowCount();
                if (row < count) {
                    this.model.highlightRow(row);
                } else if (0 <= --row && row < count) {
                    this.model.highlightRow(row);
                }
            }
            return true;
        }
        if (cmdId == OPTIONS_CMD_ID) {
            int selectedColumn = 0;
            if (context != null) {
                selectedColumn = context.getInt(SELECTED_COLUMN);
            }
            this.editBreakpointDialog(selectedColumn);
            return true;
        }
        if (cmdId == CHANGE_SCOPE_GLOBAL_CMD_ID || cmdId == CHANGE_SCOPE_WORKSPACE_CMD_ID || cmdId == CHANGE_SCOPE_PROJECT_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                breakpointItem.changeScope(cmdId);
                this.updateColumn(3);
            }
            return true;
        }
        if (addBreakpointActions.containsKey(action)) {
            this.addBreakpointDialog(addBreakpointActions.get(action));
            return true;
        }
        if (cmdId == DISABLE_ALL_CMD_ID) {
            this.disableAll();
            this.updateColumn(2);
            return true;
        }
        if (cmdId == ENABLE_ALL_CMD_ID) {
            this.enableAll();
            this.updateColumn(2);
            return true;
        }
        if (cmdId == REMOVE_ALL_CMD_ID) {
            this.removeAll();
            this.everythingChanged();
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            String[] path = new String[]{DbgArb.getString(673), DbgArb.getString(690)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), path);
            return true;
        }
        if (cmdId == EXPAND_ALL_CMD_ID) {
            if (this.anyBreakpoints()) {
                this.model.expandAll();
            }
            return true;
        }
        if (cmdId == COLLAPSE_ALL_CMD_ID) {
            if (this.anyBreakpoints()) {
                this.model.collapseAll();
            }
            return true;
        }
        if (cmdId == SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (cmdId == 18) {
            Object o;
            int column;
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null && (column = this.treeTable.getSelectedColumn()) != -1 && (o = this.model.getValueAt(breakpointItem, column)) != null) {
                IdeUtil.copyToClipboard((String)o.toString());
            }
            return true;
        }
        if (this.removeInstanceFilterActions.contains(action)) {
            Long uniqueID = (Long)action.getValue("UserData");
            if (uniqueID != null) {
                BreakpointTreeTableModel.BreakpointItem breakpointItem;
                DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
                if (debuggingProcess != null && (breakpointItem = this.model.getSelectedBreakpointItem()) != null && breakpointItem.isBreakpoint()) {
                    final Breakpoint bp = breakpointItem.getBreakpoint();
                    final long id = uniqueID;
                    debuggingProcess.runWhilePaused(new RunWhilePaused(){

                        @Override
                        public void run(DebuggingProcess debuggingProcess, boolean live) {
                            DebugBreakpoint dbp;
                            if (live && (dbp = bp.getDebugBreakpoint(debuggingProcess)) != null) {
                                dbp.removeInstanceFilter(id);
                                BreakpointsWindow.this.updateColumn(9);
                            }
                        }
                    });
                }
                return true;
            }
        } else if (columnActions.containsKey(action)) {
            JCheckBoxMenuItem menuItem = columnActions.get(action);
            Integer columnIndex = (Integer)action.getValue("UserData");
            if (this.columnShowing[columnIndex]) {
                this.hideColumn(columnIndex);
                menuItem.setSelected(false);
            } else {
                this.showColumn(columnIndex);
                menuItem.setSelected(true);
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (actionsWithoutController != null) {
            BreakpointsWindow.setControllerForNewActions(this);
        }
        if (action.getValue("Debugger.actionOwner") == this && this.treeTable == null) {
            action.setEnabled(false);
            return true;
        }
        int cmdId = action.getCommandId();
        if (cmdId == GOTO_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                action.setEnabled(breakpointItem.canShowInSource());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == DISABLE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                if (breakpointItem.isGroup()) {
                    action.putValue("Name", (Object)DbgArb.getString(397));
                } else {
                    action.putValue("Name", (Object)DbgArb.getString(396));
                }
                action.setEnabled(breakpointItem.canDisable());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == ENABLE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                if (breakpointItem.isGroup()) {
                    action.putValue("Name", (Object)DbgArb.getString(400));
                } else {
                    action.putValue("Name", (Object)DbgArb.getString(399));
                }
                action.setEnabled(breakpointItem.canEnable());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == REMOVE_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                if (breakpointItem.isGroup()) {
                    action.putValue("Name", (Object)DbgArb.getString(403));
                } else {
                    action.putValue("Name", (Object)DbgArb.getString(402));
                }
                action.setEnabled(breakpointItem.canRemove());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == OPTIONS_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                if (breakpointItem.isGroup()) {
                    action.putValue("Name", (Object)DbgArb.getString(408));
                } else {
                    action.putValue("Name", (Object)DbgArb.getString(407));
                }
                action.setEnabled(breakpointItem.canEditOptions());
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        if (cmdId == CHANGE_SCOPE_GLOBAL_CMD_ID || cmdId == CHANGE_SCOPE_WORKSPACE_CMD_ID || cmdId == CHANGE_SCOPE_PROJECT_CMD_ID) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                action.setState(breakpointItem.isScope(cmdId));
                action.setEnabled(breakpointItem.canChangeScope(cmdId));
            } else {
                action.setState(false);
                action.setEnabled(false);
            }
            return true;
        }
        if (addBreakpointActions.containsKey(action)) {
            BreakpointSettings bpSettings = addBreakpointActions.get(action);
            if (customBreakpointTypes != null && customBreakpointTypes.containsKey(bpSettings)) {
                Boolean canCreate = customBreakpointTypes.get(bpSettings);
                if (canCreate == null) {
                    canCreate = BreakpointsWindow.checkCustomBreakpoint(bpSettings, this.workspace, this.project);
                }
                action.setEnabled(canCreate.booleanValue());
            } else {
                action.setEnabled(true);
            }
            return true;
        }
        if (cmdId == DISABLE_ALL_CMD_ID || cmdId == ENABLE_ALL_CMD_ID || cmdId == REMOVE_ALL_CMD_ID) {
            action.setEnabled(this.anyBreakpoints());
            return true;
        }
        if (cmdId == SETTINGS_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == EXPAND_ALL_CMD_ID || cmdId == COLLAPSE_ALL_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == SAVE_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == 18) {
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            int column = this.treeTable.getSelectedColumn();
            action.setEnabled(breakpointItem != null && column != -1);
            return true;
        }
        if (this.removeInstanceFilterActions.contains(action)) {
            Long uniqueID = (Long)action.getValue("UserData");
            if (uniqueID != null) {
                DebugBreakpoint dbp;
                BreakpointTreeTableModel.BreakpointItem breakpointItem;
                DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
                if (debuggingProcess != null && (breakpointItem = this.model.getSelectedBreakpointItem()) != null && breakpointItem.isBreakpoint() && (dbp = breakpointItem.getBreakpoint().getDebugBreakpoint(debuggingProcess)) != null) {
                    action.setEnabled(true);
                }
                return true;
            }
        } else if (columnActions.containsKey(action)) {
            JCheckBoxMenuItem menuItem = columnActions.get(action);
            Integer columnIndex = (Integer)action.getValue("UserData");
            if (this.columnShowing[columnIndex]) {
                menuItem.setSelected(true);
            } else {
                menuItem.setSelected(false);
            }
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        if (this.treeTable != null && (Helpers.contextMatchesSource(context, this.treeTable) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            this.addPopupMenuItemsForNew(popup, context);
            BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
            if (breakpointItem != null) {
                this.addPopupMenuItemsForBreakpointItem(popup, context);
            }
            this.addPopupMenuItemsForBreakpoints(popup, context);
            this.addPopupMenuItemsForTreeTable(popup, context);
            this.addPopupMenuItemsForCommon(popup, context);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    @Override
    public void showColumn(int index) {
        if (index != 0) {
            this.columnShowing[index] = true;
            if (this.bpSettings != null) {
                this.bpSettings.setColumnVisible(index, true);
            }
            this.treeTable.addColumn(this.column[index]);
        }
    }

    @Override
    public void hideColumn(int index) {
        if (index != 0) {
            this.columnShowing[index] = false;
            if (this.bpSettings != null) {
                this.bpSettings.setColumnVisible(index, false);
            }
            this.treeTable.removeColumn(this.column[index]);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        addBreakpointButton.removeAllPopupItems();
        List<IdeAction> validAddBreakpointActions = this.getValidAddBreakpointActions(new Context());
        for (IdeAction addBreakpointAction : validAddBreakpointActions) {
            addBreakpointButton.addPopupItem((ToggleAction)addBreakpointAction);
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    private void createGUI() {
        this.createTable();
        this.createScrollPane();
        this.toolbar = this.createToolbar();
        this.guiPanel = new JPanel(new BorderLayout());
        this.guiPanel.add((Component)this.toolbar, "North");
        this.guiPanel.add((Component)this.scrollPane, "Center");
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    private Toolbar createToolbar() {
        Toolbar toolbar = new Toolbar();
        toolbar.setPrimaryViewToolbar(true);
        addBreakpointButton = new MenuToolButton((ToggleAction)null);
        addBreakpointButton.addPopupMenuListener((PopupMenuListener)this);
        addBreakpointButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        addBreakpointButton.setToolTipText(DbgArb.getString(421));
        toolbar.add((Component)addBreakpointButton);
        toolbar.add((ToggleAction)actionOptions);
        toolbar.add((ToggleAction)actionRemove);
        toolbar.add((ToggleAction)actionEnable);
        toolbar.add((ToggleAction)actionDisable);
        toolbar.add(Box.createHorizontalGlue());
        Set<IdeAction> actions = columnActions.keySet();
        MenuToolButton columnButton = new MenuToolButton((ToggleAction)null);
        for (IdeAction columnAction : actions) {
            columnButton.add((Component)columnActions.get(columnAction));
        }
        columnButton.setIcon(OracleIcons.getIcon((String)"table.png"));
        columnButton.setToolTipText(DbgArb.getString(906));
        toolbar.add((Component)columnButton);
        toolbar.add((ToggleAction)actionSettings);
        return toolbar;
    }

    private void createScrollPane() {
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        Color background = this.treeTable.getBackground();
        this.scrollPane.setBackground(background);
        this.scrollPane.getViewport().setBackground(background);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BreakpointsWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BreakpointsWindow.this.showPopup(e);
                }
            }
        });
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BreakpointsWindow.this.adjustColumnsAfterResize();
            }
        });
        new DropTarget(this.scrollPane.getViewport(), 3, this);
        new DropTarget(this.scrollPane, 3, this);
    }

    private void createTable() {
        List modelRoot = Collections.synchronizedList(new ArrayList());
        this.model = new BreakpointTreeTableModel(modelRoot);
        this.treeTable = new PeekableTreeTable(this.model);
        this.treeTable.setKeySearchNavigable(true);
        this.treeTable.getAccessibleContext().setAccessibleName(this.getTitleName());
        this.treeTable.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set emptySet = Collections.emptySet();
        this.treeTable.setFocusTraversalKeys(0, emptySet);
        this.treeTable.setFocusTraversalKeys(1, emptySet);
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        for (int i = 0; i < 10; ++i) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnDefaultWidth[i] = this.column[i].getPreferredWidth();
            this.columnShowing[i] = true;
        }
        boolean[] showColumnInMenu = new boolean[10];
        Arrays.fill(showColumnInMenu, true);
        showColumnInMenu[0] = false;
        JDebugger.addColumnsMenu((JTable)this.treeTable, this, showColumnInMenu);
        this.column[7].setCellEditor(new PassCountEditor());
        this.treeTable.getSelectionModel().setSelectionMode(2);
        JTree tree = this.treeTable.getTree();
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        this.treeSelectionModel = tree.getSelectionModel();
        this.treeSelectionModel.setSelectionMode(4);
        tree.addTreeExpansionListener(this);
        tree.addTreeSelectionListener(this);
        tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (value instanceof BreakpointTreeTableModel.BreakpointItem) {
                    String accessibleDescription;
                    BreakpointTreeTableModel.BreakpointItem breakpointItem = (BreakpointTreeTableModel.BreakpointItem)value;
                    this.setIcon(breakpointItem.getIcon());
                    String tooltip = breakpointItem.getDescriptionColumnValue();
                    this.setToolTipText(tooltip);
                    AccessibleContext ac = this.getAccessibleContext();
                    String accessibleName = BreakpointsWindow.this.model.getAccessibleNameAt(breakpointItem, 0);
                    if (breakpointItem.mayHaveChildren()) {
                        accessibleName = JDebugger.fixTreeCellAccessibleName(accessibleName, expanded);
                    }
                    if (accessibleName != null) {
                        ac.setAccessibleName(accessibleName);
                    }
                    if ((accessibleDescription = tooltip) != null) {
                        ac.setAccessibleDescription(accessibleDescription);
                    }
                } else {
                    this.setIcon(null);
                    this.setToolTipText(null);
                }
                return this;
            }
        });
        this.treeTable.setDefaultRenderer(String.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String accessibleDescription;
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                String tooltip = value instanceof String ? (String)value : null;
                this.setToolTipText(tooltip);
                BreakpointTreeTableModel.BreakpointItem breakpointItem = BreakpointsWindow.this.model.getBreakpointItemForTreePath(BreakpointsWindow.this.treeTable.getTree().getPathForRow(row));
                int modelColumn = table.convertColumnIndexToModel(column);
                AccessibleContext ac = this.getAccessibleContext();
                String accessibleName = BreakpointsWindow.this.model.getAccessibleNameAt(breakpointItem, modelColumn);
                if (accessibleName != null) {
                    ac.setAccessibleName(accessibleName);
                }
                if ((accessibleDescription = tooltip) != null) {
                    ac.setAccessibleDescription(accessibleDescription);
                }
                return this;
            }
        });
        JTableHeader tableHeader = this.treeTable.getTableHeader();
        final TableCellRenderer headerRenderer = tableHeader.getDefaultRenderer();
        tableHeader.setDefaultRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (headerRenderer instanceof DefaultTableCellRenderer) {
                    DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)headerRenderer;
                    defaultTableCellRenderer.setHorizontalAlignment(2);
                }
                return headerRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BreakpointsWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    BreakpointsWindow.this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (JDebugger.isDoubleClickInTreeTable(BreakpointsWindow.this.treeTable, e)) {
                    Context context = BreakpointsWindow.this.getContext(e);
                    IdeAction action = actionGoTo;
                    int columnAtX = BreakpointsWindow.this.treeTable.getColumnModel().getColumnIndexAtX(e.getX());
                    int modelColumn = BreakpointsWindow.this.treeTable.convertColumnIndexToModel(columnAtX);
                    if (modelColumn == 2) {
                        BreakpointTreeTableModel.BreakpointItem breakpointItem = BreakpointsWindow.this.model.getSelectedBreakpointItem();
                        if (breakpointItem != null) {
                            if (breakpointItem.canDisable()) {
                                action = actionDisable;
                            } else if (breakpointItem.canEnable()) {
                                action = actionEnable;
                            }
                        }
                    } else if (modelColumn == 8 || modelColumn == 6 || modelColumn == 4 || modelColumn == 1 || modelColumn == 3 || modelColumn == 9) {
                        action = actionOptions;
                        context.setInt(BreakpointsWindow.SELECTED_COLUMN, modelColumn);
                    }
                    BreakpointsWindow.this.update(action, context);
                    if (action.isEnabled()) {
                        BreakpointsWindow.this.handleEvent(action, context);
                    }
                }
            }
        });
        this.treeTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                switch (key) {
                    case 127: {
                        Context context = BreakpointsWindow.this.getContext(e);
                        BreakpointsWindow.this.update(actionRemove, context);
                        if (!actionRemove.isEnabled()) break;
                        BreakpointsWindow.this.handleEvent(actionRemove, context);
                        e.consume();
                        break;
                    }
                    case 10: {
                        Context context = BreakpointsWindow.this.getContext(e);
                        BreakpointsWindow.this.update(actionGoTo, context);
                        if (!actionGoTo.isEnabled()) break;
                        BreakpointsWindow.this.handleEvent(actionGoTo, context);
                        e.consume();
                        break;
                    }
                }
            }
        });
        KeyStroke[] keyStrokes = new KeyStroke[]{KeyStroke.getKeyStroke(27, 0)};
        KeyUtil.removeKeyStrokesFromInputMaps((JComponent)this.treeTable, (KeyStroke[])keyStrokes);
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)this.treeTable, 2, this);
        new DropTarget((Component)this.treeTable, 3, this);
    }

    private void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, (JTable)this.treeTable);
    }

    private static void makeActions() {
        if (actionGoTo == null) {
            actionGoTo = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(405), null, (Integer)DbgArb.getInteger(406), null, null, (boolean)false);
            actionGoTo.setEnabled(false);
            actionDisable = IdeAction.get((int)DISABLE_CMD_ID, null, (String)DbgArb.getString(396), null, (Integer)DbgArb.getInteger(398), (Icon)OracleIcons.getIcon((String)"disabledbreakpoint.png"), null, (boolean)false);
            actionDisable.setEnabled(false);
            actionEnable = IdeAction.get((int)ENABLE_CMD_ID, null, (String)DbgArb.getString(399), null, (Integer)DbgArb.getInteger(401), (Icon)OracleIcons.getIcon((String)"unverifiedbreakpoint.png"), null, (boolean)false);
            actionEnable.setEnabled(false);
            actionRemove = IdeAction.get((int)REMOVE_CMD_ID, null, (String)DbgArb.getString(402), null, (Integer)DbgArb.getInteger(404), (Icon)OracleIcons.getIcon((String)"delete.png"), null, (boolean)false);
            actionRemove.setEnabled(false);
            actionOptions = IdeAction.get((int)OPTIONS_CMD_ID, null, (String)DbgArb.getString(407), null, (Integer)DbgArb.getInteger(409), (Icon)OracleIcons.getIcon((String)"edit.png"), null, (boolean)false);
            actionOptions.setEnabled(false);
            actionChangeScopeGlobal = IdeAction.get((int)CHANGE_SCOPE_GLOBAL_CMD_ID, null, (String)DbgArb.getString(412), null, (Integer)DbgArb.getInteger(413), null, null, (boolean)false);
            actionChangeScopeGlobal.putValue("Radio", (Object)Boolean.TRUE);
            actionChangeScopeGlobal.setEnabled(false);
            actionChangeScopeWorkspace = IdeAction.get((int)CHANGE_SCOPE_WORKSPACE_CMD_ID, null, (String)DbgArb.getString(414), null, (Integer)DbgArb.getInteger(415), null, null, (boolean)false);
            actionChangeScopeWorkspace.putValue("Radio", (Object)Boolean.TRUE);
            actionChangeScopeWorkspace.setEnabled(false);
            actionChangeScopeProject = IdeAction.get((int)CHANGE_SCOPE_PROJECT_CMD_ID, null, (String)DbgArb.getString(416), null, (Integer)DbgArb.getInteger(417), null, null, (boolean)false);
            actionChangeScopeProject.putValue("Radio", (Object)Boolean.TRUE);
            actionChangeScopeProject.setEnabled(false);
            actionDisableAll = IdeAction.get((int)DISABLE_ALL_CMD_ID, null, (String)DbgArb.getString(423), null, (Integer)DbgArb.getInteger(424), null, null, (boolean)false);
            actionDisableAll.setEnabled(false);
            actionEnableAll = IdeAction.get((int)ENABLE_ALL_CMD_ID, null, (String)DbgArb.getString(425), null, (Integer)DbgArb.getInteger(426), null, null, (boolean)false);
            actionEnableAll.setEnabled(false);
            actionRemoveAll = IdeAction.get((int)REMOVE_ALL_CMD_ID, null, (String)DbgArb.getString(427), null, (Integer)DbgArb.getInteger(428), null, null, (boolean)false);
            actionRemoveAll.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(102), null, (Integer)RunMgrArb.getInteger(103), (Icon)OracleIcons.getIcon((String)"settings.png"), null, (boolean)true);
            actionExpandAll = IdeAction.get((int)EXPAND_ALL_CMD_ID, null, (String)RunMgrArb.getString(96), null, (Integer)RunMgrArb.getInteger(97), (Icon)OracleIcons.getIcon((String)"expandall.png"), null, (boolean)false);
            actionExpandAll.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(98), null, (Integer)RunMgrArb.getInteger(99), (Icon)OracleIcons.getIcon((String)"collapseall.png"), null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(100), null, (Integer)RunMgrArb.getInteger(101), (Icon)OracleIcons.getIcon((String)"export.png"), null, (boolean)false);
            actionSave.setEnabled(false);
            BreakpointsWindow.createColumnActions();
        }
    }

    private static void createColumnActions() {
        columnActions = new LinkedHashMap();
        int[] cmdIds = new int[]{SHOW_COL_TYPE_CMD_ID, SHOW_COL_STATUS_CMD_ID, SHOW_COL_SCOPE_CMD_ID, SHOW_COL_GROUP_CMD_ID, SHOW_COL_COND_CMD_ID, SHOW_COL_THREAD_CMD_ID, SHOW_COL_PASSCNT_CMD_ID, SHOW_COL_ACTION_CMD_ID, SHOW_COL_FILTERS_CMD_ID};
        int[] strIds = new int[]{385, 386, 384, 387, 388, 389, 390, 391, 392};
        int[] columnIds = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        for (int x = 0; x < 9; ++x) {
            IdeAction action = IdeAction.get((int)cmdIds[x], null, (String)DbgArb.getString(strIds[x]), null, (Integer)-1, null, (Object)new Integer(columnIds[x]), (boolean)true);
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem((Action)action);
            columnActions.put(action, new JCheckBoxMenuItem((Action)action));
        }
    }

    private static synchronized IdeAction createNewAddBreakpointAction(BreakpointSettings bpSettings) {
        int mnemonic;
        boolean isCustomBp = bpSettings.getCustomTypeString() != null;
        String typeString = isCustomBp ? bpSettings.getCustomTypeString() : BreakpointSettings.getTypeString(bpSettings.getType());
        if (isCustomBp) {
            ArrayList<String> typeNameList = new ArrayList<String>();
            ArrayList<Integer> mnemonicList = new ArrayList<Integer>();
            for (IdeAction action : addBreakpointActions.keySet()) {
                typeNameList.add((String)action.getValue("Name"));
                mnemonicList.add((Integer)action.getValue("MnemonicKey"));
            }
            typeNameList.add(typeString);
            int len = mnemonicList.size();
            String[] typeNameArray = typeNameList.toArray(new String[len + 1]);
            char[] typeNameMnemonicArray = new char[len + 1];
            for (int x = 0; x < len; ++x) {
                typeNameMnemonicArray[x] = (char)((Integer)mnemonicList.get(x)).intValue();
            }
            typeNameMnemonicArray[len] = '\u0000';
            Helpers.findMnemonics(typeNameArray, typeNameMnemonicArray, len);
            mnemonic = typeNameMnemonicArray[len];
        } else {
            mnemonic = BreakpointSettings.getTypeStringMnemonic(bpSettings.getType());
        }
        int cmdId = Ide.findOrCreateCmdID((String)("DebugBreakpointsAdd" + typeString));
        IdeAction addBreakpointAction = IdeAction.get((int)cmdId, null, (String)typeString, null, (Integer)mnemonic, null, null, (boolean)false);
        return addBreakpointAction;
    }

    private static synchronized void createAddBreakpointActions() {
        if (addBreakpointActions == null) {
            int[] bpTypes = new int[]{0, 2, 1, 4, 5, 6};
            ArrayList<BreakpointSettings> breakpointTypes = new ArrayList<BreakpointSettings>();
            for (int bpType : bpTypes) {
                BreakpointSettings bpSettings = new BreakpointSettings();
                bpSettings.setType(bpType);
                breakpointTypes.add(bpSettings);
            }
            if (customBreakpointTypes != null) {
                breakpointTypes.addAll(customBreakpointTypes.keySet());
            }
            addBreakpointActions = new LinkedHashMap();
            for (BreakpointSettings bpSettings : breakpointTypes) {
                IdeAction action = BreakpointsWindow.createNewAddBreakpointAction(bpSettings);
                addBreakpointActions.put(action, bpSettings);
            }
        }
    }

    private void setControllerForActions() {
        IdeAction[] actions = new IdeAction[]{actionGoTo, actionDisable, actionEnable, actionRemove, actionOptions, actionChangeScopeGlobal, actionChangeScopeWorkspace, actionChangeScopeProject, actionDisableAll, actionEnableAll, actionRemoveAll, actionSettings, actionExpandAll, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(actions, this);
        Set<IdeAction> actionSet = addBreakpointActions.keySet();
        JDebugger.setControllerForActions(actionSet.toArray(new IdeAction[actionSet.size()]), this);
        actionSet = columnActions.keySet();
        JDebugger.setControllerForActions(actionSet.toArray(new IdeAction[actionSet.size()]), this);
    }

    private static synchronized void setControllerForNewActions(BreakpointsWindow bpWindow) {
        int len = actionsWithoutController.size();
        IdeAction[] actions = actionsWithoutController.toArray(new IdeAction[len]);
        JDebugger.setControllerForActions(actions, bpWindow);
        actionsWithoutController = null;
    }

    private void showPopup(MouseEvent e) {
        JDebugger.getInstance().showContextMenu(e, (DockableWindow)this, this.treeTable);
    }

    private void addPopupMenuItemsForNew(ContextMenu popup, Context context) {
        if (subMenuAdd == null) {
            subMenuAdd = popup.createSubMenu(DbgArb.getString(421), DbgArb.getInteger(422));
        }
        subMenuAdd.removeAll();
        List<IdeAction> validAddBreakpointActions = this.getValidAddBreakpointActions(context);
        for (IdeAction addBreakpointAction : validAddBreakpointActions) {
            subMenuAdd.add(popup.createMenuItem((ToggleAction)addBreakpointAction));
        }
        popup.add((Component)subMenuAdd, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_NEW_ITEM_CTXT_MENU);
    }

    private List<IdeAction> getValidAddBreakpointActions(Context context) {
        ArrayList<IdeAction> actions = new ArrayList<IdeAction>();
        for (IdeAction addBreakpointAction : addBreakpointActions.keySet()) {
            boolean addIt;
            BreakpointSettings bpSettings = addBreakpointActions.get(addBreakpointAction);
            boolean bl = addIt = customBreakpointTypes == null || !customBreakpointTypes.containsKey(bpSettings);
            if (!addIt) {
                Boolean canCreate = customBreakpointTypes.get(bpSettings);
                if (canCreate == null) {
                    canCreate = BreakpointsWindow.checkCustomBreakpoint(bpSettings, this.workspace, this.project);
                }
                addIt = canCreate;
            }
            if (!addIt) continue;
            actions.add(addBreakpointAction);
            this.update(addBreakpointAction, context);
        }
        BreakpointsWindow.sortBreakpointActions(actions);
        return actions;
    }

    private static void sortBreakpointActions(List<IdeAction> actions) {
        Collections.sort(actions, new Comparator<IdeAction>(){

            @Override
            public int compare(IdeAction o1, IdeAction o2) {
                String name1 = o1.getValue("Name").toString();
                String name2 = o2.getValue("Name").toString();
                return name1.compareTo(name2);
            }
        });
    }

    private void addPopupMenuItemsForBreakpointItem(ContextMenu popup, Context context) {
        BreakpointTreeTableModel.BreakpointItem breakpointItem;
        this.update(actionOptions, context);
        if (actionOptions.isEnabled()) {
            if (menuitemOptions == null) {
                menuitemOptions = popup.createMenuItem((ToggleAction)actionOptions);
            }
            popup.add((Component)menuitemOptions, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionEnable, context);
        if (actionEnable.isEnabled()) {
            if (menuitemEnable == null) {
                menuitemEnable = popup.createMenuItem((ToggleAction)actionEnable);
            }
            popup.add((Component)menuitemEnable, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionDisable, context);
        if (actionDisable.isEnabled()) {
            if (menuitemDisable == null) {
                menuitemDisable = popup.createMenuItem((ToggleAction)actionDisable);
            }
            popup.add((Component)menuitemDisable, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionRemove, context);
        if (actionRemove.isEnabled()) {
            if (menuitemRemove == null) {
                menuitemRemove = popup.createMenuItem((ToggleAction)actionRemove);
            }
            popup.add((Component)menuitemRemove, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        if ((breakpointItem = this.model.getSelectedBreakpointItem()) != null && breakpointItem.isBreakpoint()) {
            if (subMenuChangeScope == null) {
                subMenuChangeScope = popup.createSubMenu(DbgArb.getString(410), DbgArb.getInteger(411));
                JMenuItem menuitemChangeScopeGlobal = popup.createMenuItem((ToggleAction)actionChangeScopeGlobal);
                JMenuItem menuitemChangeScopeWorkspace = popup.createMenuItem((ToggleAction)actionChangeScopeWorkspace);
                JMenuItem menuitemChangeScopeProject = popup.createMenuItem((ToggleAction)actionChangeScopeProject);
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(menuitemChangeScopeGlobal);
                buttonGroup.add(menuitemChangeScopeWorkspace);
                buttonGroup.add(menuitemChangeScopeProject);
                subMenuChangeScope.add(menuitemChangeScopeGlobal);
                subMenuChangeScope.add(menuitemChangeScopeWorkspace);
                subMenuChangeScope.add(menuitemChangeScopeProject);
            }
            this.update(actionChangeScopeGlobal, context);
            this.update(actionChangeScopeWorkspace, context);
            this.update(actionChangeScopeProject, context);
            popup.add((Component)subMenuChangeScope, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
        this.update(actionGoTo, context);
        if (actionGoTo.isEnabled()) {
            if (menuitemGoTo == null) {
                menuitemGoTo = popup.createMenuItem((ToggleAction)actionGoTo);
            }
            popup.add((Component)menuitemGoTo, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.addRemoveInstanceFilterActions(popup, context);
    }

    private void addRemoveInstanceFilterActions(ContextMenu popup, Context context) {
        int length;
        long[] instanceFilters;
        DebugBreakpoint dbp;
        BreakpointTreeTableModel.BreakpointItem breakpointItem;
        this.removeInstanceFilterActions.clear();
        DebuggingProcess debuggingProcess = JDebugger.getInstance().getActiveDebuggingProcess();
        if (debuggingProcess != null && (breakpointItem = this.model.getSelectedBreakpointItem()) != null && breakpointItem.isBreakpoint() && (dbp = breakpointItem.getBreakpoint().getDebugBreakpoint(debuggingProcess)) != null && (instanceFilters = dbp.getInstanceFilters()) != null && (length = instanceFilters.length) > 0) {
            JMenu subMenu = popup.createSubMenu(DbgArb.getString(418), DbgArb.getInteger(419));
            int count = 0;
            for (int i = 0; i < length; ++i) {
                Long uniqueID = new Long(instanceFilters[i]);
                String label = DbgArb.format(420, Long.toString(instanceFilters[i]));
                int cmdId = Ide.findOrCreateCmdID((String)(REMOVE_INSTANCE_FILTER_CMD_PREFIX + count++));
                IdeAction action = IdeAction.get((int)cmdId, null, (String)label, null, null, null, (Object)uniqueID, (boolean)true);
                action.putValue("Name", (Object)label);
                action.putValue("UserData", (Object)uniqueID);
                action.addController((Controller)this);
                this.removeInstanceFilterActions.add(action);
                JMenuItem menuitem = popup.createMenuItem((ToggleAction)action);
                subMenu.add(menuitem);
            }
            popup.add((Component)subMenu, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForBreakpoints(ContextMenu popup, Context context) {
        this.update(actionEnableAll, context);
        if (actionEnableAll.isEnabled()) {
            if (menuitemEnableAll == null) {
                menuitemEnableAll = popup.createMenuItem((ToggleAction)actionEnableAll);
            }
            popup.add((Component)menuitemEnableAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
        this.update(actionDisableAll, context);
        if (actionDisableAll.isEnabled()) {
            if (menuitemDisableAll == null) {
                menuitemDisableAll = popup.createMenuItem((ToggleAction)actionDisableAll);
            }
            popup.add((Component)menuitemDisableAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
        this.update(actionRemoveAll, context);
        if (actionRemoveAll.isEnabled()) {
            if (menuitemRemoveAll == null) {
                menuitemRemoveAll = popup.createMenuItem((ToggleAction)actionRemoveAll);
            }
            popup.add((Component)menuitemRemoveAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForTreeTable(ContextMenu popup, Context context) {
        this.update(actionExpandAll, context);
        if (actionExpandAll.isEnabled()) {
            if (menuitemExpandAll == null) {
                menuitemExpandAll = popup.createMenuItem((ToggleAction)actionExpandAll);
            }
            popup.add((Component)menuitemExpandAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
        }
        this.update(actionCollapseAll, context);
        if (actionCollapseAll.isEnabled()) {
            if (menuitemCollapseAll == null) {
                menuitemCollapseAll = popup.createMenuItem((ToggleAction)actionCollapseAll);
            }
            popup.add((Component)menuitemCollapseAll, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForCommon(ContextMenu popup, Context context) {
        this.update(actionSave, context);
        if (actionSave.isEnabled()) {
            if (menuitemSave == null) {
                menuitemSave = popup.createMenuItem((ToggleAction)actionSave);
            }
            popup.add((Component)menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
        this.update(actionSettings, context);
        if (actionSettings.isEnabled()) {
            if (menuitemSettings == null) {
                menuitemSettings = popup.createMenuItem((ToggleAction)actionSettings);
            }
            popup.add((Component)menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToFile() {
        URL url;
        String dlgTitle = RunMgrArb.format(104, this.getTitleName());
        URLChooser chooser = DialogUtil.newURLChooser((Context)this.getContext());
        if (JDebugger.lastSavedFile != null) {
            chooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        chooser.setHelpID("f1_deb_exportdialog_html");
        if (chooser.showSaveDialog((Component)Ide.getMainWindow(), dlgTitle) == 0 && (url = chooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = url;
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            Exception exceptionOccurred = null;
            try {
                PrintWriter out;
                String suffixUpper = URLFileSystem.getSuffix((URL)url).toUpperCase();
                boolean html = suffixUpper.equals(".HTML") || suffixUpper.equals(".HTM");
                PrintWriter printWriter = out = html ? JDebugger.printHtmlHeader(url, this.getTitleName()) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)url)));
                if (this.anyBreakpoints()) {
                    this.model.save(out, html);
                }
                if (html) {
                    JDebugger.printHtmlFooter(out);
                }
                out.flush();
                out.close();
            }
            catch (Exception e) {
                exceptionOccurred = e;
            }
            finally {
                wc.hide();
            }
            if (exceptionOccurred != null) {
                String message = DbgArb.format(816, this.getTitleName(), URLFileSystem.getPlatformPathName((URL)url));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exceptionOccurred, (String)dlgTitle, (String)message, null);
            }
        }
    }

    void everythingChanged() {
        this.everythingChanged(this.lastHighlight);
    }

    private void everythingChanged(Object highlightInfo) {
        if (this.model != null) {
            this.model.updateBreakpoints(highlightInfo);
        }
        BreakpointsWindow.checkCustomBreakpoints(this.workspace, this.project);
    }

    private static synchronized void checkCustomBreakpoints(Workspace workspace, Project project) {
        if (customBreakpointTypes != null) {
            for (BreakpointSettings bpSettings : customBreakpointTypes.keySet()) {
                BreakpointsWindow.checkCustomBreakpoint(bpSettings, workspace, project);
            }
        }
    }

    private static synchronized boolean checkCustomBreakpoint(BreakpointSettings bpSettings, Workspace workspace, Project project) {
        boolean canCreate = ExtenderManager.getInstance().canCreateCustomBreakpoint(bpSettings.getTypeString(), workspace, project);
        customBreakpointTypes.put(bpSettings, canCreate);
        return canCreate;
    }

    void setBreakpoints(Workspace workspace, Project project, List[] breakpoints) {
        this.workspace = workspace;
        this.project = project;
        this.breakpoints = breakpoints;
        this.everythingChanged();
    }

    private TreePath getPathForLocation(Point p) {
        if (this.treeTable != null && this.treeTable.isEnabled()) {
            JTree tree = this.treeTable.getTree();
            int row = this.treeTable.rowAtPoint(p);
            return tree.getPathForRow(row);
        }
        return null;
    }

    private CodePeek peekAtLocation(Point location) {
        BreakpointTreeTableModel.BreakpointItem bpi;
        SwingUtilities.convertPointFromScreen(location, (Component)this.treeTable);
        TreePath tp = this.getPathForLocation(location);
        if (tp == null) {
            return null;
        }
        if (!this.treeTable.getTree().getPathBounds(tp).contains(location)) {
            return null;
        }
        Object o = tp.getLastPathComponent();
        if (o instanceof BreakpointTreeTableModel.BreakpointItem && (bpi = (BreakpointTreeTableModel.BreakpointItem)o).canShowInSource() && bpi.getInfo() instanceof Breakpoint) {
            Breakpoint bp = (Breakpoint)bpi.getInfo();
            int bpType = bp.getType();
            if (bpType == 0) {
                String pkg = bp.getPackage();
                String filename = bp.getFile();
                int line = bp.getLine();
                URL url = Source.findSourceFile(this.workspace, this.project, pkg, filename);
                if (url == null) {
                    Project proj = Context2ParserHelper.getProject((Context)this.getContext());
                    JavaManager javaManager = JavaManager.getJavaManager((Project)proj);
                    try {
                        int dot = filename.indexOf(46);
                        if (dot != -1) {
                            filename = filename.substring(0, dot);
                        }
                        String fqName = pkg != null && pkg.length() > 0 ? pkg + "." + filename : filename;
                        JavaClass javaClass = javaManager.getClass(fqName);
                        url = javaClass.getURL();
                    }
                    catch (NullPointerException npe) {
                        // empty catch block
                    }
                }
                if (url != null) {
                    return this.peekAtLocation(url, line, bp.getDescription(), this.treeTable.getTree().getRowBounds(this.treeTable.rowAtPoint(location)));
                }
            } else if (bpType == 5) {
                URL url = bp.getURL();
                int line = bp.getLine();
                return this.peekAtLocation(url, line, bp.getDescription(), this.treeTable.getTree().getRowBounds(this.treeTable.rowAtPoint(location)));
            }
        }
        return null;
    }

    private CodePeek peekAtLocation(URL url, int line, String labelText, Rectangle rect) {
        String peekText;
        int pad = 4;
        if ((peekText = PeekHelper.getPeekText((URL)url, (int)(--line), (int)4)) == null) {
            return null;
        }
        CodePeek peek = PeekHelper.createCodePeek((JComponent)this.treeTable, (String)url.getFile(), (String)peekText, (String)labelText, (Rectangle)rect);
        if (peek == null) {
            return null;
        }
        line = line < 4 ? line : 4;
        PeekHelper.addHighlight((CodePeek)peek, (int)line, (String)"enabled-breakpoint");
        peek.showPeek();
        this.treeTable.getTree().setToolTipText(null);
        return peek;
    }

    private void updateColumn(int column) {
        TableModel tableModel = this.treeTable.getModel();
        TableModelEvent event = new TableModelEvent(tableModel, 0, tableModel.getRowCount() - 1, column);
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableChanged(event);
        }
        if (column == 2) {
            this.updateIcons();
        } else if (column == 0) {
            this.model.fireChanged(this.lastHighlight);
        }
    }

    private void updateIcons() {
        TableModel tableModel = this.treeTable.getModel();
        TableModelEvent event = new TableModelEvent(tableModel, 0, tableModel.getRowCount() - 1, 0);
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableChanged(event);
        }
        this.model.fireChanged(this.lastHighlight);
    }

    void processSelectionChanged() {
        if (this.treeTable == null) {
            return;
        }
        this.updateColumn(2);
        this.updateColumn(7);
        this.updateColumn(9);
    }

    void breakpointDescriptionChanged() {
        if (this.treeTable != null) {
            this.updateColumn(0);
        }
    }

    void breakpointStatusChanged() {
        if (this.treeTable != null) {
            this.updateColumn(2);
        }
    }

    void breakpointInstanceFiltersChanged() {
        if (this.treeTable != null) {
            this.updateColumn(9);
        }
    }

    private void editBreakpointDialog(int selectedColumn) {
        int initialFocus = 0;
        switch (selectedColumn) {
            case 4: {
                initialFocus = 4;
                break;
            }
            case 8: {
                initialFocus = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                initialFocus = 2;
            }
        }
        BreakpointTreeTableModel.BreakpointItem breakpointItem = this.model.getSelectedBreakpointItem();
        if (breakpointItem != null) {
            if (breakpointItem.isMulti()) {
                this.editBreakpointDialog(breakpointItem.getBreakpoints(null), false, initialFocus);
            } else if (breakpointItem.isGroup()) {
                this.editBreakpointDialog(breakpointItem.getBreakpoints(null), true, initialFocus);
            } else {
                this.editBreakpointDialog(breakpointItem.getBreakpoint(), true, initialFocus);
            }
        }
    }

    private void editBreakpointDialog(List list, boolean group, int initialFocus) {
        String[] groupNames;
        Breakpoint[] breakpoints;
        BreakpointOptionsDialog bpDialog;
        if (list.size() > 0 && (bpDialog = BreakpointOptionsDialog.showBreakpointOptionsDialog(breakpoints = list.toArray(new Breakpoint[list.size()]), group, groupNames = this.getGroupNames(true), initialFocus)) != null) {
            final Object lastHighlight = this.lastHighlight;
            int length = breakpoints.length;
            for (int i = 0; i < length; ++i) {
                final Breakpoint bp = breakpoints[i];
                final boolean lastBp = i == length - 1;
                Runnable runAfter = new Runnable(){

                    @Override
                    public void run() {
                        ExtenderManager.getInstance().breakpointEdited(bp);
                        if (lastBp) {
                            BreakpointsWindow.this.everythingChanged(lastHighlight);
                        }
                    }
                };
                bp.pauseAndApplyChanges(runAfter);
            }
        }
    }

    private boolean editBreakpointDialog(final Breakpoint bp, final boolean highlightBP, int initialFocus) {
        URL ownerURL = bp.getOwnerURL();
        String[] groupNames = this.getGroupNames(true);
        BreakpointOptionsDialog bpDialog = BreakpointOptionsDialog.showBreakpointOptionsDialog(ownerURL, bp, bp.getBreakpointSettings(), groupNames, initialFocus);
        if (bpDialog != null) {
            Runnable runAfter = new Runnable(){

                @Override
                public void run() {
                    ExtenderManager.getInstance().breakpointEdited(bp);
                    if (highlightBP) {
                        BreakpointsWindow.this.everythingChanged(bp);
                    } else {
                        BreakpointsWindow.this.everythingChanged();
                    }
                }
            };
            bp.pauseAndApplyChanges(runAfter);
        }
        return bpDialog != null;
    }

    private void addBreakpointDialog(BreakpointSettings bpTemplate) {
        String[] groupNames;
        URL ownerURL = JDebugger.getNewBreakpointOwnerURL(this.workspace, this.project);
        BreakpointOptionsDialog bpDialog = BreakpointOptionsDialog.showBreakpointOptionsDialog(ownerURL, null, bpTemplate, groupNames = this.getGroupNames(true), 0);
        if (bpDialog != null) {
            Breakpoint bp = bpDialog.getBreakpoint();
            this.addNewBreakpoint(bp);
        }
    }

    private String[] getGroupNames(boolean addBlank) {
        ArrayList<String> groupNames = new ArrayList<String>();
        if (addBlank) {
            groupNames.add("");
        }
        this.getGroupNames(groupNames);
        Collections.sort(groupNames);
        int size = groupNames.size();
        return groupNames.toArray(new String[size]);
    }

    private void getGroupNames(List<String> groupNames) {
        int length = this.breakpoints.length;
        for (int i = 0; i < length; ++i) {
            for (Breakpoint bp : this.breakpoints[i]) {
                String groupName = bp.getGroupName();
                if (groupName.length() <= 0 || groupNames.contains(groupName)) continue;
                groupNames.add(groupName);
            }
        }
    }

    private List getBreakpointsForGroup(String groupName) {
        ArrayList<Breakpoint> list = new ArrayList<Breakpoint>();
        int length = this.breakpoints.length;
        for (int i = 0; i < length; ++i) {
            for (Breakpoint bp : this.breakpoints[i]) {
                if (!bp.getGroupName().equals(groupName)) continue;
                list.add(bp);
            }
        }
        return list;
    }

    void highlightBreakpoint(Breakpoint bp) {
        this.model.highlightBreakpoint(bp);
    }

    boolean editBreakpoint(Breakpoint bp) {
        return this.editBreakpointDialog(bp, false, 0);
    }

    void addNewBreakpoint(final Breakpoint bp) {
        Runnable runAfter = new Runnable(){

            @Override
            public void run() {
                BreakpointsWindow.this.everythingChanged();
                if (BreakpointsWindow.this.treeTable != null) {
                    BreakpointsWindow.this.highlightBreakpoint(bp);
                }
            }
        };
        JDebugger.getInstance().addBreakpoint(bp, runAfter);
    }

    private void disableAll() {
        int length = this.breakpoints.length;
        for (int i = 0; i < length; ++i) {
            for (Breakpoint bp : this.breakpoints[i]) {
                bp.setEnabled(false);
            }
        }
    }

    private void enableAll() {
        int length = this.breakpoints.length;
        for (int i = 0; i < length; ++i) {
            for (Breakpoint bp : this.breakpoints[i]) {
                bp.setEnabled(true);
            }
        }
    }

    private void removeAll() {
        ArrayList remove = new ArrayList();
        int length = this.breakpoints.length;
        for (int i = 0; i < length; ++i) {
            remove.addAll(this.breakpoints[i]);
        }
        for (Breakpoint bp : remove) {
            bp.removeBreakpoint();
        }
    }

    private boolean anyBreakpoints() {
        int length = this.breakpoints.length;
        for (int i = 0; i < length; ++i) {
            if (this.breakpoints[i].size() <= 0) continue;
            return true;
        }
        return false;
    }

    private static DataFlavor getBreakpointFlavor() {
        if (breakpointFlavor == null) {
            breakpointFlavor = new DataFlavor(BreakpointTreeTableModel.BreakpointItem.class, "Breakpoint");
        }
        return breakpointFlavor;
    }

    static /* synthetic */ DataFlavor[] access$2402(DataFlavor[] x0) {
        transferFlavors = x0;
        return x0;
    }

    static {
        OPTIONS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsOptions");
        ENABLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsEnable");
        DISABLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsDisable");
        REMOVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsRemove");
        CHANGE_SCOPE_GLOBAL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsChangeScopeGlobal");
        CHANGE_SCOPE_WORKSPACE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsChangeScopeWorkspace");
        CHANGE_SCOPE_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsChangeScopeProject");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsGoTo");
        ENABLE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsEnableAll");
        DISABLE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsDisableAll");
        REMOVE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsRemoveAll");
        EXPAND_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsExpandAll");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsSettings");
        SHOW_COL_TYPE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsShowColumnType");
        SHOW_COL_STATUS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsShowColumnStatus");
        SHOW_COL_SCOPE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsShowColumnScope");
        SHOW_COL_GROUP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsShowColumnGroup");
        SHOW_COL_COND_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsShowColumnCondition");
        SHOW_COL_THREAD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsShowColumnThread");
        SHOW_COL_PASSCNT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsShowColumnPassCount");
        SHOW_COL_ACTION_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsShowColumnAction");
        SHOW_COL_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugBreakpointsShowColumnInstanceFilters");
        breakpointFlavor = null;
        transferFlavors = null;
        breakpointsTabIcon = null;
    }

    private class PeekableTreeTable
    extends JFastTreeTable
    implements Peekable {
        public PeekableTreeTable(BreakpointTreeTableModel model) {
            super((TreeTableModel)model);
        }

        public Peek peek(Point p) {
            return BreakpointsWindow.this.peekAtLocation(p);
        }
    }

    private final class PassCountEditor
    extends DefaultCellEditor {
        PassCountEditor() {
            super(new JTextField(){

                @Override
                public void paste() {
                }
            });
            JTextField textField = (JTextField)this.getComponent();
            textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    char c = e.getKeyChar();
                    if ((c < '0' || c > '9') && c != '\b' && c != '\u007f' && c != '%' && c != '\'' && c != '$' && c != '#') {
                        e.consume();
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            int passCount = 0;
            BreakpointTreeTableModel.BreakpointItem breakpointItem = BreakpointsWindow.this.model.getBreakpointItemForTreePath(BreakpointsWindow.this.treeTable.getTree().getPathForRow(row));
            if (breakpointItem != null) {
                passCount = breakpointItem.getPassCount();
            }
            return super.getTableCellEditorComponent(table, new Integer(passCount), isSelected, row, column);
        }
    }

    private final class BreakpointTreeTableModel
    extends AbstractTreeTableModel {
        private List root;
        private List collapsed;

        BreakpointTreeTableModel(List root) {
            super((Object)root);
            this.root = root;
            this.collapsed = Collections.synchronizedList(new ArrayList());
        }

        void updateBreakpoints(Object highlight) {
            this.root.clear();
            int breakpointsLength = BreakpointsWindow.this.breakpoints.length;
            for (int i = 0; i < breakpointsLength; ++i) {
                for (Breakpoint bp : BreakpointsWindow.this.breakpoints[i]) {
                    String groupName = bp.getGroupName();
                    if (groupName.length() != 0) continue;
                    this.root.add(new BreakpointItem(bp));
                }
            }
            for (String groupName : BreakpointsWindow.this.getGroupNames(false)) {
                this.root.add(new BreakpointItem(groupName));
            }
            this.fireChanged(highlight);
        }

        void fireChanged(Object highlight) {
            TreePath rootTreePath = new TreePath(this.root);
            this.fireTreeStructureChanged((Object)this, rootTreePath.getPath(), null, null);
            this.expandBranches();
            this.restoreHighlight(highlight);
        }

        void highlightRow(int row) {
            TreePath treePath = BreakpointsWindow.this.treeTable.getTree().getPathForRow(row);
            Object highlight = this.getInfoFromTreePath(treePath);
            this.restoreHighlight(highlight);
        }

        void highlightBreakpoint(Breakpoint bp) {
            this.restoreHighlight(bp, true);
        }

        private void restoreHighlight(Object highlight) {
            this.restoreHighlight(highlight, false);
        }

        private void restoreHighlight(Object highlight, boolean scrollToVisible) {
            if (highlight != null) {
                BreakpointsWindow.this.lastHighlight = highlight;
                if (BreakpointsWindow.this.lastHighlight instanceof Object[]) {
                    Object[] highlights = (Object[])BreakpointsWindow.this.lastHighlight;
                    TreePath[] treePaths = new TreePath[highlights.length];
                    for (int i = highlights.length - 1; i >= 0; --i) {
                        treePaths[i] = this.makeVisible(highlights[i]);
                    }
                    JDebugger.getInstance().selectTreeTablePath(BreakpointsWindow.this.treeTable, treePaths, scrollToVisible);
                } else {
                    TreePath treePath = this.makeVisible(highlight);
                    JDebugger.getInstance().selectTreeTablePath(BreakpointsWindow.this.treeTable, treePath, scrollToVisible);
                }
            }
        }

        void expandBranches() {
            this.expandBranch(new TreePath(this.root));
        }

        private void expandBranch(TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            if (!this.collapsed.contains(node)) {
                BreakpointsWindow.this.treeTable.getTree().expandPath(treePath);
            }
            int count = this.getChildCount(node);
            for (int i = 0; i < count; ++i) {
                Object child = this.getChild(node, i);
                this.expandBranch(treePath.pathByAddingChild(child));
            }
        }

        TreePath makeVisible(Object info) {
            return this.makeVisible(new TreePath(this.root), info);
        }

        private TreePath makeVisible(TreePath treePath, Object info) {
            BreakpointItem breakpointItem;
            Object node = treePath.getLastPathComponent();
            if (node instanceof BreakpointItem && info.equals((breakpointItem = (BreakpointItem)node).getInfo())) {
                BreakpointsWindow.this.treeTable.getTree().makeVisible(treePath);
                return treePath;
            }
            int count = this.getChildCount(node);
            for (int i = 0; i < count; ++i) {
                Object child = this.getChild(node, i);
                TreePath result = this.makeVisible(treePath.pathByAddingChild(child), info);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        void branchExpanded(TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            this.collapsed.remove(node);
        }

        void branchCollapsed(TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            int i = this.collapsed.indexOf(node);
            if (i != -1) {
                this.collapsed.remove(i);
            }
            this.collapsed.add(0, node);
        }

        BreakpointItem getBreakpointItemForTreePath(TreePath treePath) {
            Object node;
            if (treePath != null && (node = treePath.getLastPathComponent()) instanceof BreakpointItem) {
                return (BreakpointItem)node;
            }
            return null;
        }

        BreakpointItem getSelectedBreakpointItem() {
            TreePath[] treePaths = BreakpointsWindow.this.treeTable.getTree().getSelectionPaths();
            if (treePaths == null) {
                return null;
            }
            int length = treePaths.length;
            if (length == 0) {
                return null;
            }
            if (length == 1) {
                return this.getBreakpointItemForTreePath(treePaths[0]);
            }
            ArrayList<BreakpointItem> list = new ArrayList<BreakpointItem>();
            for (int i = 0; i < length; ++i) {
                list.add(this.getBreakpointItemForTreePath(treePaths[i]));
            }
            return new BreakpointItem(list);
        }

        BreakpointItem getBreakpointItemForDrag(Point pt) {
            int row = BreakpointsWindow.this.treeTable.rowAtPoint(pt);
            if (BreakpointsWindow.this.treeTable.isRowSelected(row)) {
                BreakpointItem breakpointItem = this.getSelectedBreakpointItem();
                if (breakpointItem != null) {
                    if (breakpointItem.isMulti()) {
                        Iterator it = breakpointItem.getMultiBreakpointItems();
                        while (it.hasNext()) {
                            BreakpointItem bpItem = (BreakpointItem)it.next();
                            if (!bpItem.isGroup()) continue;
                            return null;
                        }
                    } else if (breakpointItem.getBreakpoint() == null) {
                        return null;
                    }
                }
                return breakpointItem;
            }
            return this.getBreakpointItemForTreePath(BreakpointsWindow.this.treeTable.getTree().getPathForRow(row));
        }

        int getColumnAtPoint(Point pt) {
            int col;
            if (pt != null && (col = BreakpointsWindow.this.treeTable.columnAtPoint(pt)) != -1) {
                return BreakpointsWindow.this.treeTable.convertColumnIndexToModel(col);
            }
            return -1;
        }

        BreakpointItem getBreakpointItemAtPoint(Point pt) {
            int row = BreakpointsWindow.this.treeTable.rowAtPoint(pt);
            return this.getBreakpointItemForTreePath(BreakpointsWindow.this.treeTable.getTree().getPathForRow(row));
        }

        String getGroupNameAtPoint(Point pt) {
            BreakpointItem breakpointItem;
            if (pt != null && (breakpointItem = this.getBreakpointItemAtPoint(pt)) != null) {
                return breakpointItem.getGroupName();
            }
            return null;
        }

        Object getInfoFromTreePath(TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            if (node instanceof BreakpointItem) {
                BreakpointItem breakpointItem = (BreakpointItem)node;
                return breakpointItem.getInfo();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void expandAll() {
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            try {
                this.expandAll(BreakpointsWindow.this.treeTable.getTree(), new TreePath(this.root));
            }
            finally {
                wc.hide();
            }
        }

        private void expandAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            tree.expandPath(treePath);
            int count = this.getChildCount(node);
            for (int i = 0; i < count; ++i) {
                Object child = this.getChild(node, i);
                this.expandAll(tree, treePath.pathByAddingChild(child));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void collapseAll() {
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            try {
                this.collapseAll(BreakpointsWindow.this.treeTable.getTree(), new TreePath(this.root));
            }
            finally {
                wc.hide();
            }
        }

        private void collapseAll(JTree tree, TreePath treePath) {
            Object node = treePath.getLastPathComponent();
            int count = this.getChildCount(node);
            for (int i = 0; i < count; ++i) {
                Object child = this.getChild(node, i);
                this.collapseAll(tree, treePath.pathByAddingChild(child));
            }
            if (!node.equals(this.root)) {
                tree.collapsePath(treePath);
            }
        }

        private void save(PrintWriter out, boolean html) {
            if (html) {
                out.println("<table border=\"1\">");
            }
            this.saveHeader(out, html);
            this.save(BreakpointsWindow.this.treeTable.getTree(), new TreePath(this.root), out, html, "");
            if (html) {
                out.println("</table>");
            }
        }

        private void saveHeader(PrintWriter out, boolean html) {
            StringBuffer sb = new StringBuffer();
            StringBuffer sb2 = new StringBuffer();
            if (html) {
                sb.append("<tr>");
            }
            TableColumnModel tableColumnModel = BreakpointsWindow.this.treeTable.getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                TableColumn column = e.nextElement();
                int i = column.getModelIndex();
                String columnName = this.getColumnName(i);
                if (html) {
                    sb.append("<th>");
                    columnName = IdeUtil.replaceHTMLReservedCharacters((String)columnName.toString());
                    sb.append(columnName);
                    sb.append("</th>");
                    continue;
                }
                sb.append(columnName);
                for (int ii = columnName.length(); ii >= 0; --ii) {
                    sb2.append('-');
                }
                if (!e.hasMoreElements()) continue;
                sb.append('\t');
                sb2.append('\t');
            }
            if (html) {
                sb.append("</tr>");
            }
            out.println(sb.toString());
            if (!html) {
                out.println(sb2.toString());
            }
        }

        private void save(JTree tree, TreePath treePath, PrintWriter out, boolean html, String indent) {
            if (tree.isVisible(treePath)) {
                Object node = treePath.getLastPathComponent();
                if (node instanceof BreakpointItem) {
                    BreakpointItem breakpointItem = (BreakpointItem)node;
                    StringBuffer sb = new StringBuffer();
                    if (html) {
                        sb.append("<tr>");
                    }
                    TableColumnModel tableColumnModel = BreakpointsWindow.this.treeTable.getColumnModel();
                    Enumeration<TableColumn> e = tableColumnModel.getColumns();
                    while (e.hasMoreElements()) {
                        TableColumn column = e.nextElement();
                        int i = column.getModelIndex();
                        Object columnValue = this.getValueAt(node, i);
                        if (html) {
                            String columnValueString;
                            sb.append("<td>");
                            if (i == 0) {
                                sb.append("<tt>");
                                if (indent != null) {
                                    sb.append(indent);
                                }
                                if (tree.isExpanded(treePath)) {
                                    sb.append("-&nbsp;");
                                } else if (breakpointItem.mayHaveChildren()) {
                                    sb.append("+&nbsp;");
                                } else {
                                    sb.append("&nbsp;&nbsp;");
                                }
                                sb.append("</tt>");
                            }
                            if ((columnValueString = IdeUtil.replaceHTMLReservedCharacters((String)columnValue.toString())).length() > 0) {
                                sb.append(columnValueString);
                            } else {
                                sb.append("&nbsp;");
                            }
                            sb.append("</td>");
                            continue;
                        }
                        if (i == 0) {
                            if (indent != null) {
                                sb.append(indent);
                            }
                            if (tree.isExpanded(treePath)) {
                                sb.append("- ");
                            } else if (breakpointItem.mayHaveChildren()) {
                                sb.append("+ ");
                            } else {
                                sb.append("  ");
                            }
                        }
                        sb.append(columnValue);
                        if (!e.hasMoreElements()) continue;
                        sb.append('\t');
                    }
                    if (html) {
                        sb.append("</tr>");
                    }
                    out.println(sb.toString());
                }
                if (node != this.root) {
                    indent = html ? indent + "&nbsp;&nbsp;&nbsp;&nbsp;" : indent + "    ";
                }
                int count = this.getChildCount(node);
                for (int i = 0; i < count; ++i) {
                    Object child = this.getChild(node, i);
                    this.save(tree, treePath.pathByAddingChild(child), out, html, indent);
                }
            }
        }

        public boolean isLeaf(Object node) {
            try {
                if (node instanceof List) {
                    return false;
                }
                BreakpointItem breakpointItem = (BreakpointItem)node;
                return !breakpointItem.mayHaveChildren();
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            return String.class;
        }

        public Object getChild(Object parent, int index) {
            try {
                if (parent instanceof List) {
                    return ((List)parent).get(index);
                }
                BreakpointItem breakpointItem = (BreakpointItem)parent;
                return breakpointItem.getChildNodes()[index];
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public int getChildCount(Object parent) {
            try {
                if (parent instanceof List) {
                    return ((List)parent).size();
                }
                BreakpointItem breakpointItem = (BreakpointItem)parent;
                return breakpointItem.countChildNodes();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }

        public int getColumnCount() {
            return 10;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return DbgArb.getString(383);
                }
                case 3: {
                    return DbgArb.getString(384);
                }
                case 1: {
                    return DbgArb.getString(385);
                }
                case 2: {
                    return DbgArb.getString(386);
                }
                case 4: {
                    return DbgArb.getString(387);
                }
                case 5: {
                    return DbgArb.getString(388);
                }
                case 6: {
                    return DbgArb.getString(389);
                }
                case 7: {
                    return DbgArb.getString(390);
                }
                case 8: {
                    return DbgArb.getString(391);
                }
                case 9: {
                    return DbgArb.getString(392);
                }
            }
            return "";
        }

        public Object getValueAt(Object node, int column) {
            try {
                if (node instanceof List) {
                    switch (column) {
                        case 0: {
                            return "root";
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            return "";
                        }
                    }
                    return null;
                }
                BreakpointItem breakpointItem = (BreakpointItem)node;
                switch (column) {
                    case 0: {
                        return breakpointItem.getDescriptionColumnValue();
                    }
                    case 3: {
                        return breakpointItem.getScopeColumnValue();
                    }
                    case 1: {
                        return breakpointItem.getTypeColumnValue();
                    }
                    case 2: {
                        return breakpointItem.getStatusColumnValue();
                    }
                    case 4: {
                        return breakpointItem.getGroupColumnValue();
                    }
                    case 5: {
                        return breakpointItem.getConditionColumnValue();
                    }
                    case 6: {
                        return breakpointItem.getThreadColumnValue();
                    }
                    case 7: {
                        return breakpointItem.getPassCountColumnValue();
                    }
                    case 8: {
                        return breakpointItem.getActionColumnValue();
                    }
                    case 9: {
                        return breakpointItem.getInstanceFiltersColumnValue();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        public void setValueAt(Object aValue, Object node, int column) {
            if (column == 5) {
                if (node instanceof BreakpointItem) {
                    BreakpointItem breakpointItem = (BreakpointItem)node;
                    breakpointItem.setConditionColumnValue(aValue.toString());
                    return;
                }
            } else if (column == 7 && node instanceof BreakpointItem) {
                String value = aValue.toString().trim();
                if (value.length() == 0) {
                    value = "0";
                }
                BreakpointItem breakpointItem = (BreakpointItem)node;
                try {
                    breakpointItem.setPassCount(Integer.parseInt(aValue.toString()));
                }
                catch (NumberFormatException nfe) {
                    breakpointItem.setPassCount(0);
                }
                return;
            }
            super.setValueAt(aValue, node, column);
        }

        public boolean isCellEditable(Object node, int column) {
            if (column == 7 || column == 5) {
                return true;
            }
            return super.isCellEditable(node, column);
        }

        private String getAccessibleNameAt(BreakpointItem breakpointItem, int column) {
            int id;
            if (breakpointItem.isBreakpoint()) {
                id = 381;
            } else if (breakpointItem.isGroup()) {
                id = 382;
            } else {
                return null;
            }
            String columnName = this.getColumnName(column);
            String value = (String)this.getValueAt(breakpointItem, column);
            if (value == null || value.length() == 0) {
                value = DbgArb.getString(842);
            }
            return DbgArb.format(id, columnName, value);
        }

        private final class BreakpointItem
        extends BaseElement
        implements Transferable {
            private Object info;
            private BreakpointItem[] children;
            private boolean removed;

            BreakpointItem(Object info) {
                this.info = info;
            }

            URL getOwnerURL() {
                if (this.info instanceof Breakpoint) {
                    return ((Breakpoint)this.info).getOwnerURL();
                }
                return null;
            }

            Object getInfo() {
                return this.info;
            }

            boolean isBreakpoint() {
                return this.info instanceof Breakpoint;
            }

            boolean isGroup() {
                return this.info instanceof String;
            }

            boolean isMulti() {
                return this.info instanceof List;
            }

            Iterator getMultiBreakpointItems() {
                if (this.info instanceof List) {
                    return ((List)this.info).iterator();
                }
                return null;
            }

            List getBreakpoints(List breakpoints) {
                block7: {
                    block6: {
                        if (breakpoints == null) {
                            breakpoints = new ArrayList<Object>();
                        }
                        if (!(this.info instanceof Breakpoint)) break block6;
                        if (breakpoints.contains(this.info)) break block7;
                        breakpoints.add(this.info);
                        break block7;
                    }
                    if (this.info instanceof String) {
                        BreakpointItem[] breakpointItems = this.getChildNodes();
                        int length = breakpointItems.length;
                        for (int i = 0; i < length; ++i) {
                            breakpointItems[i].getBreakpoints(breakpoints);
                        }
                    } else if (this.info instanceof List) {
                        List list = (List)this.info;
                        int size = list.size();
                        for (int i = 0; i < size; ++i) {
                            BreakpointItem breakpointItem = (BreakpointItem)list.get(i);
                            breakpointItem.getBreakpoints(breakpoints);
                        }
                    }
                }
                return breakpoints;
            }

            Breakpoint getBreakpoint() {
                if (this.info instanceof Breakpoint) {
                    return (Breakpoint)this.info;
                }
                return null;
            }

            String getGroupName() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getGroupName();
                }
                if (this.info instanceof String) {
                    return (String)this.info;
                }
                return null;
            }

            boolean canShowInSource() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    if (ExtenderManager.getInstance().isExtenderBreakpoint(bp)) {
                        return JDebugger.getInstance().canDebuggerExtenderShowBreakpointLocation(bp);
                    }
                    int bpType = bp.getType();
                    if (bpType == 0) {
                        return true;
                    }
                    if (bpType == 5) {
                        return true;
                    }
                }
                return false;
            }

            void showInSource() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    if (JDebugger.getInstance().debuggerExtenderShowBreakpointLocation(bp)) {
                        return;
                    }
                    int bpType = bp.getType();
                    if (bpType == 0) {
                        String pkg = bp.getPackage();
                        String filename = bp.getFile();
                        int line = bp.getLine();
                        Source.showSourceFile(BreakpointsWindow.this.workspace, BreakpointsWindow.this.project, pkg, null, filename, line, false);
                    } else if (bpType == 5) {
                        URL url = bp.getURL();
                        int line = bp.getLine();
                        Source.showSourceFile(BreakpointsWindow.this.workspace, BreakpointsWindow.this.project, url, line, false);
                    }
                }
            }

            boolean isScope(int cmdId) {
                if (this.info instanceof Breakpoint) {
                    URL ownerURL = this.getOwnerURL();
                    if (cmdId == CHANGE_SCOPE_GLOBAL_CMD_ID) {
                        return ownerURL == null;
                    }
                    if (cmdId == CHANGE_SCOPE_WORKSPACE_CMD_ID) {
                        return BreakpointsWindow.this.workspace != null && BreakpointsWindow.this.workspace.getURL().equals(ownerURL);
                    }
                    if (cmdId == CHANGE_SCOPE_PROJECT_CMD_ID) {
                        return BreakpointsWindow.this.project != null && BreakpointsWindow.this.project.getURL().equals(ownerURL);
                    }
                }
                return false;
            }

            boolean canChangeScope(int cmdId) {
                if (this.info instanceof Breakpoint && !((Breakpoint)this.info).isPersistent()) {
                    if (cmdId == CHANGE_SCOPE_GLOBAL_CMD_ID) {
                        return true;
                    }
                    if (cmdId == CHANGE_SCOPE_WORKSPACE_CMD_ID) {
                        return BreakpointsWindow.this.workspace != null;
                    }
                    if (cmdId == CHANGE_SCOPE_PROJECT_CMD_ID) {
                        return BreakpointsWindow.this.project != null;
                    }
                }
                return false;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            void changeScope(int cmdId) {
                URL newOwnerURL;
                if (!(this.info instanceof Breakpoint)) return;
                URL oldOwnerURL = this.getOwnerURL();
                if (cmdId == CHANGE_SCOPE_GLOBAL_CMD_ID) {
                    newOwnerURL = null;
                } else if (cmdId == CHANGE_SCOPE_WORKSPACE_CMD_ID) {
                    if (BreakpointsWindow.this.workspace == null || BreakpointsWindow.this.workspace == Ide.getDefaultWorkspace()) return;
                    newOwnerURL = BreakpointsWindow.this.workspace.getURL();
                } else {
                    if (cmdId != CHANGE_SCOPE_PROJECT_CMD_ID) return;
                    if (BreakpointsWindow.this.project == null || BreakpointsWindow.this.project == Ide.getDefaultProject()) return;
                    newOwnerURL = BreakpointsWindow.this.project.getURL();
                }
                if (oldOwnerURL == newOwnerURL) return;
                Breakpoint bp = (Breakpoint)this.info;
                Breakpoint.removeBreakpointFromOwner(bp);
                bp.setOwnerURL(newOwnerURL);
                Breakpoint.addBreakpointToOwner(bp);
                JDebugger.getInstance().updateActiveBreakpoints();
                ExtenderManager.getInstance().breakpointScopeChanged(bp);
            }

            boolean canDisable() {
                block4: {
                    block3: {
                        if (this.info instanceof Breakpoint) {
                            Breakpoint bp = (Breakpoint)this.info;
                            return bp.isEnabledNow();
                        }
                        if (!(this.info instanceof String)) break block3;
                        BreakpointItem[] breakpointItems = this.getChildNodes();
                        for (int i = breakpointItems.length - 1; i >= 0; --i) {
                            if (!breakpointItems[i].canDisable()) continue;
                            return true;
                        }
                        break block4;
                    }
                    if (!(this.info instanceof List)) break block4;
                    List list = (List)this.info;
                    for (int i = list.size() - 1; i >= 0; --i) {
                        BreakpointItem breakpointItem = (BreakpointItem)list.get(i);
                        if (!breakpointItem.canDisable()) continue;
                        return true;
                    }
                }
                return false;
            }

            void disable() {
                block6: {
                    block5: {
                        if (!(this.info instanceof Breakpoint)) break block5;
                        Breakpoint bp = (Breakpoint)this.info;
                        if (!bp.isEnabledNow()) break block6;
                        bp.setEnabled(false);
                        break block6;
                    }
                    if (this.info instanceof String) {
                        BreakpointItem[] breakpointItems = this.getChildNodes();
                        for (int i = breakpointItems.length - 1; i >= 0; --i) {
                            breakpointItems[i].disable();
                        }
                    } else if (this.info instanceof List) {
                        List list = (List)this.info;
                        for (int i = list.size() - 1; i >= 0; --i) {
                            BreakpointItem breakpointItem = (BreakpointItem)list.get(i);
                            breakpointItem.disable();
                        }
                    }
                }
            }

            boolean canEnable() {
                block4: {
                    block3: {
                        if (this.info instanceof Breakpoint) {
                            Breakpoint bp = (Breakpoint)this.info;
                            return !bp.isEnabledNow();
                        }
                        if (!(this.info instanceof String)) break block3;
                        BreakpointItem[] breakpointItems = this.getChildNodes();
                        for (int i = breakpointItems.length - 1; i >= 0; --i) {
                            if (!breakpointItems[i].canEnable()) continue;
                            return true;
                        }
                        break block4;
                    }
                    if (!(this.info instanceof List)) break block4;
                    List list = (List)this.info;
                    for (int i = list.size() - 1; i >= 0; --i) {
                        BreakpointItem breakpointItem = (BreakpointItem)list.get(i);
                        if (!breakpointItem.canEnable()) continue;
                        return true;
                    }
                }
                return false;
            }

            void enable() {
                block6: {
                    block5: {
                        if (!(this.info instanceof Breakpoint)) break block5;
                        Breakpoint bp = (Breakpoint)this.info;
                        if (bp.isEnabledNow()) break block6;
                        bp.setEnabled(true);
                        break block6;
                    }
                    if (this.info instanceof String) {
                        BreakpointItem[] breakpointItems = this.getChildNodes();
                        for (int i = breakpointItems.length - 1; i >= 0; --i) {
                            breakpointItems[i].enable();
                        }
                    } else if (this.info instanceof List) {
                        List list = (List)this.info;
                        for (int i = list.size() - 1; i >= 0; --i) {
                            BreakpointItem breakpointItem = (BreakpointItem)list.get(i);
                            breakpointItem.enable();
                        }
                    }
                }
            }

            boolean canRemove() {
                block4: {
                    block5: {
                        block3: {
                            if (!(this.info instanceof Breakpoint)) break block3;
                            Breakpoint bp = (Breakpoint)this.info;
                            if (!bp.isPersistent()) {
                                return true;
                            }
                            break block4;
                        }
                        if (!(this.info instanceof String)) break block5;
                        BreakpointItem[] breakpointItems = this.getChildNodes();
                        for (int i = breakpointItems.length - 1; i >= 0; --i) {
                            if (!breakpointItems[i].canRemove()) continue;
                            return true;
                        }
                        break block4;
                    }
                    if (!(this.info instanceof List)) break block4;
                    List list = (List)this.info;
                    for (int i = list.size() - 1; i >= 0; --i) {
                        BreakpointItem breakpointItem = (BreakpointItem)list.get(i);
                        if (!breakpointItem.canRemove()) continue;
                        return true;
                    }
                }
                return false;
            }

            void remove() {
                if (!this.removed) {
                    if (this.info instanceof Breakpoint) {
                        Breakpoint bp = (Breakpoint)this.info;
                        if (!bp.isPersistent()) {
                            bp.removeBreakpoint();
                        }
                    } else if (this.info instanceof String) {
                        BreakpointItem[] breakpointItems = this.getChildNodes();
                        for (int i = breakpointItems.length - 1; i >= 0; --i) {
                            breakpointItems[i].remove();
                        }
                    } else if (this.info instanceof List) {
                        List list = (List)this.info;
                        for (int i = list.size() - 1; i >= 0; --i) {
                            BreakpointItem breakpointItem = (BreakpointItem)list.get(i);
                            breakpointItem.remove();
                        }
                    }
                }
                this.removed = true;
            }

            boolean canEditOptions() {
                return true;
            }

            @Override
            public String getShortLabel() {
                return this.getDescriptionColumnValue();
            }

            @Override
            public Icon getIcon() {
                if (this.info instanceof Breakpoint) {
                    return ((Breakpoint)this.info).getIcon();
                }
                return null;
            }

            @Override
            public Object getData() {
                return this;
            }

            @Override
            public boolean mayHaveChildren() {
                return this.info instanceof String;
            }

            @Override
            public Iterator getChildren() {
                return Arrays.asList(this.getChildNodes()).iterator();
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                if (transferFlavors == null) {
                    BreakpointsWindow.access$2402(new DataFlavor[2]);
                    transferFlavors[0] = BreakpointsWindow.getBreakpointFlavor();
                    transferFlavors[1] = DataFlavor.stringFlavor;
                }
                return transferFlavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                if (flavor.equals(BreakpointsWindow.getBreakpointFlavor())) {
                    return true;
                }
                return flavor.equals(DataFlavor.stringFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (flavor.equals(BreakpointsWindow.getBreakpointFlavor())) {
                    return this;
                }
                if (flavor.equals(DataFlavor.stringFlavor)) {
                    return this.getShortLabel();
                }
                throw new UnsupportedFlavorException(flavor);
            }

            String getDescriptionColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getDescription();
                }
                if (this.info instanceof String) {
                    String groupName = (String)this.info;
                    return groupName;
                }
                return "";
            }

            String getScopeColumnValue() {
                if (this.info instanceof Breakpoint) {
                    URL ownerURL = this.getOwnerURL();
                    if (ownerURL == null) {
                        return DbgArb.getString(394);
                    }
                    return URLFileSystem.getFileName((URL)ownerURL);
                }
                return "";
            }

            String getTypeColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getTypeString();
                }
                return "";
            }

            String getStatusColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getStatusInfo();
                }
                return "";
            }

            String getGroupColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getGroupName();
                }
                return "";
            }

            String getConditionColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getCondition();
                }
                return "";
            }

            void setConditionColumnValue(String condition) {
                List list = this.getBreakpoints(null);
                for (int i = list.size() - 1; i >= 0; --i) {
                    Breakpoint bp = (Breakpoint)list.get(i);
                    bp.setCondition(condition);
                }
            }

            String getThreadColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    String threadName = bp.getThreadName();
                    if (threadName.length() > 0) {
                        return threadName;
                    }
                    String threadNameNot = bp.getThreadNameNot();
                    if (threadNameNot.length() > 0) {
                        return DbgArb.format(395, threadNameNot);
                    }
                }
                return "";
            }

            String getPassCountColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getPassCountInfo();
                }
                return "";
            }

            void setPassCount(int passCount) {
                List list = this.getBreakpoints(null);
                for (int i = list.size() - 1; i >= 0; --i) {
                    Breakpoint bp = (Breakpoint)list.get(i);
                    bp.setPassCount(passCount);
                }
            }

            int getPassCount() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getPassCount();
                }
                return 0;
            }

            String getActionColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getAction();
                }
                return "";
            }

            String getInstanceFiltersColumnValue() {
                if (this.info instanceof Breakpoint) {
                    Breakpoint bp = (Breakpoint)this.info;
                    return bp.getInstanceFilters();
                }
                return "";
            }

            int countChildNodes() {
                if (this.info instanceof String) {
                    return this.getChildNodes().length;
                }
                return 0;
            }

            BreakpointItem[] getChildNodes() {
                if (this.info instanceof String) {
                    if (this.children == null) {
                        String groupName = (String)this.info;
                        List groupBreakpoints = BreakpointsWindow.this.getBreakpointsForGroup(groupName);
                        int size = groupBreakpoints.size();
                        this.children = new BreakpointItem[size];
                        for (int i = 0; i < size; ++i) {
                            Breakpoint bp = (Breakpoint)groupBreakpoints.get(i);
                            this.children[i] = new BreakpointItem(bp);
                        }
                    }
                    return this.children;
                }
                return new BreakpointItem[0];
            }

            public int hashCode() {
                return this.info.hashCode();
            }

            public boolean equals(Object o) {
                if (o instanceof BreakpointItem) {
                    BreakpointItem other = (BreakpointItem)o;
                    return this.info.equals(other.info);
                }
                return false;
            }
        }
    }
}

