/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdevimpl.runner.RunConfigurationEditor;
import oracle.jdevimpl.runner.RunMgrArb;

public class RunConfigurationsPanel
extends ProjectSettingsTraversablePanel
implements ActionListener {
    private DefaultTableModel profilesModel;
    private List<RunConfiguration> profilesRunConfigurations;
    private List<String> profilesNames;
    private JTable profilesTable;
    private JButton editButton;
    private JButton newButton;
    private JButton deleteButton;
    private JButton restoreButton;
    private Project project;
    private boolean editingCustomProperties;
    private Map definedRunConfigurations;
    private static final String[] PROPERTY_KEYS = new String[]{"runConfigurationDefinitions", "runConfigurationList"};
    private RunConfigurationsTableCellEditor cellEditor;

    public RunConfigurationsPanel() {
        JLabel profilesLabel = new JLabel();
        this.profilesModel = new DefaultTableModel();
        this.profilesModel.setColumnCount(1);
        this.profilesRunConfigurations = new ArrayList<RunConfiguration>();
        this.profilesNames = new ArrayList<String>();
        this.profilesTable = new JTable(this.profilesModel);
        this.profilesTable.setTableHeader(null);
        this.profilesTable.setSelectionMode(0);
        this.profilesTable.setShowGrid(false);
        this.cellEditor = new RunConfigurationsTableCellEditor();
        this.profilesTable.getColumnModel().getColumn(0).setCellEditor(this.cellEditor);
        JScrollPane profilesScrollPane = new JScrollPane(this.profilesTable);
        JViewport viewport = profilesScrollPane.getViewport();
        profilesScrollPane.setOpaque(true);
        viewport.setOpaque(true);
        profilesScrollPane.setBackground(this.profilesTable.getBackground());
        viewport.setBackground(this.profilesTable.getBackground());
        Border border = profilesScrollPane.getBorder();
        if (border == null || border instanceof UIResource) {
            profilesScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
        }
        profilesScrollPane.setCorner("LOWER_RIGHT_CORNER", new JPanel());
        this.editButton = new JButton();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.restoreButton = new JButton();
        ResourceUtils.resLabel((JLabel)profilesLabel, (Component)this.profilesTable, (String)RunMgrArb.getString(7));
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)RunMgrArb.getString(8));
        ResourceUtils.resButton((AbstractButton)this.newButton, (String)RunMgrArb.getString(10));
        ResourceUtils.resButton((AbstractButton)this.deleteButton, (String)RunMgrArb.getString(11));
        ResourceUtils.resButton((AbstractButton)this.restoreButton, (String)RunMgrArb.getString(12));
        this.profilesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RunConfigurationsPanel.this.updateButtons();
            }
        });
        this.editButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.restoreButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.add(profilesLabel, new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add(profilesScrollPane, new GridBagConstraints(0, 1, 1, 0, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.editButton, new GridBagConstraints(1, 1, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.newButton, new GridBagConstraints(1, 2, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.deleteButton, new GridBagConstraints(1, 3, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.restoreButton, new GridBagConstraints(1, 4, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
    }

    public String getDataKey() {
        return RunConfigurations.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        if (RunConfigurationsPanel.isDefaultProject((Namespace)tc)) {
            this.setHelpID("f1_run_ppdefault_rundebug_html");
        } else if (RunConfigurationsPanel.editingUserProperties((Namespace)tc)) {
            this.setHelpID("f1_run_ppcustom_rundebug_html");
        } else {
            this.setHelpID("f1_run_pp_rundebug_html");
        }
        RunConfigurations runConfigurations = RunConfigurationsPanel.getRunConfigurations(tc);
        this.project = ProjectSettingsTraversablePanel.getProject((Namespace)tc);
        this.editingCustomProperties = ProjectSettingsTraversablePanel.editingUserProperties((Namespace)tc);
        this.loadFrom(runConfigurations);
    }

    public void onExit(TraversableContext tc) {
        this.cellEditor.cancelCellEditing();
        RunConfigurations runConfigurations = RunConfigurationsPanel.getRunConfigurations(tc);
        this.commitTo(runConfigurations);
    }

    private static RunConfigurations getRunConfigurations(TraversableContext tc) {
        return RunConfigurations.getInstance(RunConfigurationsPanel.getPropertyData((Namespace)tc));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.cellEditor.cancelCellEditing();
        Object source = e.getSource();
        if (source == this.editButton) {
            this.editRunConfiguration();
        } else if (source == this.newButton) {
            this.newRunConfiguration();
        } else if (source == this.deleteButton) {
            this.deleteRunConfiguration();
        } else if (source == this.restoreButton) {
            this.restoreRunConfiguration();
        }
    }

    private void loadFrom(RunConfigurations runConfigurations) {
        this.definedRunConfigurations = runConfigurations.getDefinedRunConfigurations();
        this.profilesRunConfigurations.clear();
        this.profilesNames.clear();
        for (int i = this.profilesModel.getRowCount() - 1; i >= 0; --i) {
            this.profilesModel.removeRow(i);
        }
        RunConfiguration[] runConfigs = runConfigurations.getVisibleRunConfigurations();
        int runConfigsLength = runConfigs.length;
        String activeName = RunConfigurations.getActiveName(this.project);
        int index = 0;
        for (int i = 0; i < runConfigsLength; ++i) {
            this.profilesModel.addRow(new Object[]{runConfigs[i].getName()});
            this.profilesRunConfigurations.add(runConfigs[i]);
            this.profilesNames.add(runConfigs[i].getName());
            if (!runConfigs[i].getName().equals(activeName)) continue;
            index = i;
        }
        if (index < this.profilesModel.getRowCount()) {
            this.profilesTable.getSelectionModel().setSelectionInterval(index, index);
        }
        this.updateButtons();
    }

    private void commitTo(RunConfigurations runConfigurations) {
        int size = this.profilesTable.getRowCount();
        RunConfiguration[] runConfigs = this.profilesRunConfigurations.toArray(new RunConfiguration[size]);
        for (int i = 0; i < this.profilesModel.getRowCount(); ++i) {
            runConfigs[i].setName((String)this.profilesModel.getValueAt(i, 0));
        }
        runConfigurations.setRunConfigurations(runConfigs, this.editingCustomProperties);
        RunConfiguration runConfiguration = this.getSelectedRunConfiguration();
        if (runConfiguration != null) {
            RunConfigurations.setActiveRunConfiguration(this.project, runConfiguration);
        }
    }

    private RunConfiguration getSelectedRunConfiguration() {
        int index = this.profilesTable.getSelectionModel().getMinSelectionIndex();
        if (index >= 0 && index < this.profilesRunConfigurations.size()) {
            return this.profilesRunConfigurations.get(index);
        }
        return null;
    }

    private void updateButtons() {
        RunConfiguration runConfiguration = this.getSelectedRunConfiguration();
        boolean runConfigurationSelected = runConfiguration != null;
        this.editButton.setEnabled(runConfigurationSelected);
        if (this.editingCustomProperties && runConfigurationSelected && !runConfiguration.isCustom()) {
            ResourceUtils.resButton((AbstractButton)this.editButton, (String)RunMgrArb.getString(9));
        } else {
            ResourceUtils.resButton((AbstractButton)this.editButton, (String)RunMgrArb.getString(8));
        }
        this.deleteButton.setEnabled(runConfigurationSelected && this.profilesTable.getRowCount() > 1);
        if (this.editingCustomProperties) {
            ResourceUtils.resButton((AbstractButton)this.restoreButton, (String)RunMgrArb.getString(12));
            boolean foundOne = false;
            for (String name : this.definedRunConfigurations.keySet()) {
                RunConfiguration runConfig = (RunConfiguration)((Object)this.definedRunConfigurations.get(name));
                if (runConfig.isCustom() || this.profilesNames.contains(name)) continue;
                foundOne = true;
                break;
            }
            this.restoreButton.setEnabled(foundOne);
        } else {
            ResourceUtils.resButton((AbstractButton)this.restoreButton, (String)RunMgrArb.getString(13));
            if (runConfigurationSelected && runConfiguration.getName().equals(RunConfiguration.getDefaultName())) {
                this.restoreButton.setEnabled(true);
            } else {
                this.restoreButton.setEnabled(false);
            }
        }
    }

    private void editRunConfiguration() {
        RunConfiguration runConfiguration = this.getSelectedRunConfiguration();
        if (runConfiguration != null) {
            this.editRunConfiguration(runConfiguration);
        }
    }

    private void editRunConfiguration(int index) {
        RunConfiguration runConfiguration = this.profilesRunConfigurations.get(index);
        this.editRunConfiguration(runConfiguration);
    }

    private void editRunConfiguration(RunConfiguration runConfiguration) {
        boolean allowEdit = !this.editingCustomProperties || runConfiguration.isCustom();
        RunConfigurationEditor runConfigurationEditor = new RunConfigurationEditor(runConfiguration, allowEdit);
        runConfigurationEditor.showDialog();
    }

    private void newRunConfiguration() {
        TreeSet<Object> usedNames = new TreeSet<Object>();
        usedNames.addAll(this.definedRunConfigurations.keySet());
        for (int i = this.profilesNames.size() - 1; i >= 0; --i) {
            usedNames.add(this.profilesNames.get(i));
        }
        RunConfiguration runConfiguration = this.getSelectedRunConfiguration();
        String name = runConfiguration != null ? runConfiguration.getName() : null;
        NewDialog newDialog = new NewDialog(name, usedNames);
        if ((name = newDialog.showDialog()) != null) {
            String profileName;
            int insertRow;
            RunConfiguration copyFrom = newDialog.getCopyFrom();
            RunConfiguration newRunConfiguration = new RunConfiguration(copyFrom, name, this.editingCustomProperties);
            name = newRunConfiguration.getName();
            for (insertRow = 0; insertRow < this.profilesNames.size() && (profileName = this.profilesNames.get(insertRow)).compareTo(name) <= 0; ++insertRow) {
            }
            if (insertRow < this.profilesNames.size()) {
                this.profilesModel.insertRow(insertRow, new Object[]{newRunConfiguration.getName()});
                this.profilesRunConfigurations.add(insertRow, newRunConfiguration);
                this.profilesNames.add(insertRow, newRunConfiguration.getName());
            } else {
                this.profilesModel.addRow(new Object[]{newRunConfiguration.getName()});
                this.profilesRunConfigurations.add(newRunConfiguration);
                this.profilesNames.add(newRunConfiguration.getName());
            }
            this.profilesTable.getSelectionModel().setSelectionInterval(insertRow, insertRow);
        }
    }

    private void deleteRunConfiguration() {
        int index = this.profilesTable.getSelectionModel().getMinSelectionIndex();
        if (index != -1) {
            this.profilesModel.removeRow(index);
            this.profilesRunConfigurations.remove(index);
            this.profilesNames.remove(index);
            if (index >= this.profilesModel.getRowCount()) {
                --index;
            }
            this.profilesTable.getSelectionModel().setSelectionInterval(index, index);
            this.updateButtons();
        }
    }

    private void restoreRunConfiguration() {
        if (this.editingCustomProperties) {
            Set keySet = this.definedRunConfigurations.keySet();
            TreeSet set = new TreeSet();
            set.addAll(keySet);
            for (String name : keySet) {
                RunConfiguration runConfig = (RunConfiguration)((Object)this.definedRunConfigurations.get(name));
                if (!runConfig.isCustom() && !this.profilesNames.contains(name)) continue;
                set.remove(name);
            }
            RestoreDialog restoreDialog = new RestoreDialog(set);
            String[] names = restoreDialog.showDialog();
            if (names != null) {
                int namesLength = names.length;
                for (int i = 0; i < namesLength; ++i) {
                    RunConfiguration runConfig = (RunConfiguration)((Object)this.definedRunConfigurations.get(names[i]));
                    this.profilesModel.addRow(new Object[]{names[i]});
                    this.profilesRunConfigurations.add(runConfig);
                    this.profilesNames.add(names[i]);
                }
                this.updateButtons();
            }
        } else {
            RunConfiguration runConfiguration = this.getSelectedRunConfiguration();
            if (runConfiguration != null) {
                runConfiguration.restoreDefaults();
            }
        }
    }

    private class RunConfigurationsTableCellEditor
    extends DefaultCellEditor {
        private Object currentValue;
        private boolean editing;

        RunConfigurationsTableCellEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentValue = value;
            this.editing = true;
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            if (!this.editing) {
                return true;
            }
            String newValue = this.getCellEditorValue().toString().trim();
            if (newValue.length() > 0 && (newValue.equals(this.currentValue.toString()) || !RunConfigurationsPanel.this.profilesNames.contains(newValue))) {
                this.editing = false;
                RunConfigurationsPanel.this.profilesNames.remove(this.currentValue.toString());
                RunConfigurationsPanel.this.profilesNames.add(newValue);
                RunConfiguration currentRunConfig = RunConfigurationsPanel.this.getSelectedRunConfiguration();
                if (currentRunConfig != null) {
                    currentRunConfig.setName(newValue);
                }
                return super.stopCellEditing();
            }
            return false;
        }

        @Override
        public void cancelCellEditing() {
            if (this.editing) {
                this.editing = false;
                super.cancelCellEditing();
            }
        }
    }

    class RestoreDialog
    extends JPanel
    implements ListSelectionListener {
        private JList list;
        private JEWTDialog dlg;

        RestoreDialog(Set set) {
            super(new GridBagLayout());
            JLabel listLabel = new JLabel();
            DefaultListModel model = new DefaultListModel();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                model.addElement(it.next());
            }
            this.list = new JList(model);
            this.list.setSelectionMode(2);
            JScrollPane listScrollPane = new JScrollPane(this.list);
            ResourceUtils.resLabel((JLabel)listLabel, (Component)this.list, (String)RunMgrArb.getString(22));
            this.list.addListSelectionListener(this);
            int y = 0;
            this.add((Component)listLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)listScrollPane, new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 1, new Insets(2, 5, 0, 5), 0, 0));
        }

        String[] showDialog() {
            String title = RunMgrArb.getString(21);
            JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.list, (String)title);
            this.setJEWTDialog(dlg);
            dlg.setOKButtonEnabled(this.canOk());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_run_restorerunconfig_html");
            if (WizardLauncher.runDialog((JDialog)dlg)) {
                return this.getItems();
            }
            return null;
        }

        private void setJEWTDialog(JEWTDialog dlg) {
            this.dlg = dlg;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.dlg.setOKButtonEnabled(this.canOk());
        }

        private boolean canOk() {
            return this.list.getSelectedIndex() != -1;
        }

        private String[] getItems() {
            Object[] values = this.list.getSelectedValues();
            int length = values.length;
            String[] names = new String[length];
            System.arraycopy(values, 0, names, 0, length);
            return names;
        }
    }

    class NewDialog
    extends JPanel
    implements DocumentListener {
        private JTextField nameTextField;
        private JComboBox copyFromComboBox;
        private JEWTDialog dlg;
        private Set usedNames;

        NewDialog(String name, Set usedNames) {
            super(new GridBagLayout());
            this.usedNames = usedNames;
            JLabel nameLabel = new JLabel();
            String suggestedName = name != null ? RunMgrArb.format(15, name) : "";
            this.nameTextField = new JTextField(suggestedName);
            JLabel copyFromLabel = new JLabel();
            int length = RunConfigurationsPanel.this.profilesNames.size() + 1;
            Object[] copyFromArray = new Object[length];
            copyFromArray[0] = RunMgrArb.getString(18);
            for (int i = 1; i < length; ++i) {
                copyFromArray[i] = RunConfigurationsPanel.this.profilesNames.get(i - 1);
            }
            this.copyFromComboBox = new JComboBox(new NonNullableComboBoxModel(copyFromArray));
            this.copyFromComboBox.setSelectedItem(name);
            ResourceUtils.resLabel((JLabel)nameLabel, (Component)this.nameTextField, (String)RunMgrArb.getString(16));
            ResourceUtils.resLabel((JLabel)copyFromLabel, (Component)this.copyFromComboBox, (String)RunMgrArb.getString(17));
            this.nameTextField.getDocument().addDocumentListener(this);
            int y = 0;
            this.add((Component)nameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.nameTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)copyFromLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            this.add((Component)this.copyFromComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        String showDialog() {
            String title = RunMgrArb.getString(14);
            JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.nameTextField, (String)title);
            this.setJEWTDialog(dlg);
            dlg.setOKButtonEnabled(this.canOk());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_run_copyrunconfig_html");
            if (WizardLauncher.runDialog((JDialog)dlg)) {
                return this.getNewName();
            }
            return null;
        }

        private void setJEWTDialog(JEWTDialog dlg) {
            this.dlg = dlg;
            dlg.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && NewDialog.this.veto()) {
                        throw new PropertyVetoException("no", evt);
                    }
                }
            });
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            this.dlg.setOKButtonEnabled(this.canOk());
        }

        private boolean canOk() {
            return this.nameTextField.getText().length() > 0;
        }

        private boolean veto() {
            String name = this.nameTextField.getText();
            if (this.usedNames.contains(name)) {
                MessageDialog.error((Component)this, (Object)RunMgrArb.format(20, name), (String)RunMgrArb.format(19, this.dlg.getTitle()), null);
                return true;
            }
            return false;
        }

        private String getNewName() {
            return this.nameTextField.getText();
        }

        private RunConfiguration getCopyFrom() {
            int index = this.copyFromComboBox.getSelectedIndex();
            if (index <= 0) {
                return null;
            }
            return (RunConfiguration)((Object)RunConfigurationsPanel.this.profilesRunConfigurations.get(index - 1));
        }
    }
}

