/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.model.DefaultDisplayable;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Starter;
import oracle.ide.util.ExecUtil;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JavaNode;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;

final class AddinStarterFactory
extends AbstractStarterFactory
implements JStarterFactory {
    private boolean conf;
    private static String[] addinClassNames = new String[]{"oracle.ide.addin.Addin", "oracle.ide.Addin", "oracle.ide.addin.Wizard", "oracle.ide.wizard.Wizard"};
    private static String defaultJavaLibraryPath = null;
    private static String[] ojvmSpecificOptions = new String[]{"-XOd", "-Xsinglecpu", "-Xheapbase100000000"};
    private static String[] hotspotSpecificOptions = new String[]{"-XX:MaxPermSize=128M", "-XX:+UseConcMarkSweepGC", "-XX:+UseParNewGC"};

    AddinStarterFactory(boolean conf) {
        this.conf = conf;
    }

    public String getName() {
        return RunMgrArb.getString(73);
    }

    public Object canStart(RunProcess runProcess, Node node, List errors) {
        if (runProcess instanceof JRunProcess) {
            String confFileName = null;
            if (this.conf) {
                confFileName = AddinStarterFactory.isConfTarget(node);
            } else if (AddinStarterFactory.isAddinTarget(runProcess, node, errors)) {
                confFileName = System.getProperty("ide.config_pathname");
            }
            if (confFileName != null && runProcess.canRun("Java", null, node, errors)) {
                try {
                    ConfFileInfo confFileInfo = new ConfFileInfo((JRunProcess)runProcess, confFileName);
                    return confFileInfo;
                }
                catch (ConfFileException cfe) {
                    String error = RunMgrArb.format(79, node.getShortLabel(), cfe.getConfFileName(), cfe.getDirective());
                    errors.add(error);
                }
                catch (Exception e) {
                    String error = RunMgrArb.format(78, node.getShortLabel(), confFileName);
                    errors.add(error);
                }
            }
        }
        return null;
    }

    public Starter createStarter(RunProcess runProcess, Node node, Object o) {
        try {
            JRunProcess jrunProcess = (JRunProcess)runProcess;
            ConfFileInfo confFileInfo = (ConfFileInfo)o;
            return new AddinStarter(jrunProcess, confFileInfo);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean enableRunDebugActions(Context context) {
        Node node;
        if (this.conf && (node = RunProcess.getContextNodeForRun((Context)context)) != null && AddinStarterFactory.isConfTarget(node) == null) {
            return false;
        }
        return super.enableRunDebugActions(context);
    }

    public Displayable getDisplayable(RunProcess runProcess, Context context, Node node, Object o) {
        return new DefaultDisplayable(){

            public String getShortLabel() {
                return RunMgrArb.getString(74);
            }

            public Icon getIcon() {
                return OracleIcons.getIcon((String)"extras/extension.png");
            }
        };
    }

    private static String isConfTarget(Node node) {
        URL url;
        if (node instanceof TextNode && (url = node.getURL()).getProtocol().equalsIgnoreCase("file") && URLFileSystem.getSuffix((URL)url).toUpperCase().equals(".CONF")) {
            return URLFileSystem.getPlatformPathName((URL)url);
        }
        return null;
    }

    private static boolean isAddinTarget(RunProcess runProcess, Node node, List errors) {
        if (node instanceof JavaNode) {
            Collection classes;
            JavaNode javaNode = (JavaNode)node;
            Project project = runProcess.getProject();
            JavaManager javaManager = JavaManager.getJavaManager((Project)project);
            JavaFile javaFile = javaManager.getFile(javaNode.getURL());
            if (javaFile != null && !(classes = javaFile.getClasses()).isEmpty()) {
                JavaClass[] addinClasses = new JavaClass[addinClassNames.length];
                for (int i = 0; i < addinClassNames.length; ++i) {
                    addinClasses[i] = javaManager.getClass(addinClassNames[i]);
                }
                for (JavaClass clazz : classes) {
                    if (clazz == null) continue;
                    String className = clazz.getName();
                    int classModifiers = clazz.getModifiers();
                    boolean addinClassFound = false;
                    boolean addinClassMatch = false;
                    int length = addinClassNames.length;
                    for (int i = 0; i < length; ++i) {
                        String error;
                        JavaClass addinClass = addinClasses[i];
                        if (addinClass == null) continue;
                        addinClassFound = true;
                        if (!addinClass.isAssignableFrom((JavaType)clazz)) continue;
                        addinClassMatch = true;
                        if (Modifier.isPublic(classModifiers)) {
                            if (!Modifier.isAbstract(classModifiers)) {
                                return true;
                            }
                            error = RunMgrArb.format(76, node.getShortLabel(), className);
                            errors.add(error);
                            continue;
                        }
                        error = RunMgrArb.format(75, node.getShortLabel(), className);
                        errors.add(error);
                    }
                    if (!addinClassFound || addinClassMatch || !Modifier.isPublic(classModifiers)) continue;
                    String error = RunMgrArb.format(77, node.getShortLabel(), className);
                    errors.add(error);
                }
            }
        }
        return false;
    }

    private static boolean getDirectiveAndValue(String s, String[] directiveAndValue) {
        if ((s = s.trim()).length() > 0 && s.charAt(0) != '#') {
            int space = s.indexOf(32);
            int tab = s.indexOf(9);
            int i = space == -1 ? tab : (tab == -1 ? space : Math.min(space, tab));
            if (i != -1) {
                directiveAndValue[0] = s.substring(0, i).toLowerCase();
                directiveAndValue[1] = s.substring(i + 1).trim();
                return true;
            }
        }
        return false;
    }

    private static String getProjectOutputDirectory(Project project) {
        URL url = JavaProject.getInstance((Project)project).getOutputDirectory();
        return URLFileSystem.getPlatformPathName((URL)url);
    }

    private static synchronized String getDefaultJavaLibraryPath(File confFile) {
        if (defaultJavaLibraryPath == null) {
            String remove;
            String jlp = System.getProperty("java.library.path");
            FastStringBuffer toBeRemoved = new FastStringBuffer();
            try {
                String s;
                FileInputStream fis = new FileInputStream(confFile);
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                String[] directiveAndValue = new String[2];
                while ((s = br.readLine()) != null) {
                    if (!AddinStarterFactory.getDirectiveAndValue(s, directiveAndValue)) continue;
                    String directive = directiveAndValue[0];
                    String value = directiveAndValue[1];
                    if (!directive.equals("addnativecodepath")) continue;
                    if (toBeRemoved.length() > 0) {
                        toBeRemoved.append(File.pathSeparator);
                    }
                    toBeRemoved.append(value.replace('/', File.separatorChar));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if ((remove = toBeRemoved.toString()).length() > 0 && jlp.endsWith(remove) && (jlp = jlp.substring(0, jlp.length() - remove.length())).endsWith(File.pathSeparator)) {
                jlp = jlp.substring(0, jlp.length() - 1);
            }
            if (ExecUtil.quoteArgs) {
                char charQuote = ExecUtil.argQuoteChar;
                int iQuote = 0;
                while ((iQuote = jlp.indexOf(charQuote, iQuote)) != -1) {
                    jlp = jlp.substring(0, iQuote) + jlp.substring(iQuote + 1);
                }
            }
            defaultJavaLibraryPath = jlp;
        }
        return defaultJavaLibraryPath;
    }

    static /* synthetic */ boolean access$400(String x0, String[] x1) {
        return AddinStarterFactory.getDirectiveAndValue(x0, x1);
    }

    private class AddinStarter
    extends JStarter {
        private ConfFileInfo confFileInfo;

        private AddinStarter(JRunProcess jrunProcess, ConfFileInfo confFileInfo) {
            super(jrunProcess, confFileInfo.getTarget());
            this.confFileInfo = confFileInfo;
        }

        public File getStartDirectory() {
            return this.confFileInfo.getBinDirectory();
        }

        @Override
        protected void addJavaOptions(List list) {
            super.addJavaOptions(list);
            list.addAll(this.confFileInfo.getJavaOptions());
        }

        @Override
        protected String getClassPath() {
            return null;
        }
    }

    private static class ConfFileInfo {
        private boolean is1013OrEarlier;
        private File binDirectory;
        private List javaOptions;
        private String mainClass;
        private String _javaVMValue;

        private ConfFileInfo(JRunProcess jrunProcess, String confFileName) throws Exception {
            String nativePath;
            File confFile = new File(confFileName);
            this.initIs1013OrEarlier(confFile);
            String bin = confFile.getParent();
            this.binDirectory = confFile.getParentFile();
            this.javaOptions = new ArrayList();
            FastStringBuffer cp = new FastStringBuffer();
            if (this.is1013OrEarlier) {
                cp.append(AddinStarterFactory.getProjectOutputDirectory(jrunProcess.getProject()));
            }
            FastStringBuffer np = new FastStringBuffer();
            if (this.is1013OrEarlier) {
                np.append(AddinStarterFactory.getDefaultJavaLibraryPath(confFile));
            }
            this.processConfiguration(confFile, bin, cp, np);
            if (this.mainClass == null || this.mainClass.length() == 0) {
                throw new Exception("Configuration file " + confFileName + " does not specify main class.");
            }
            if (this.is1013OrEarlier) {
                this.addJDKJars(jrunProcess.getProject(), cp);
            }
            this.removeJVMSpecificJavaOptions(jrunProcess, this._javaVMValue);
            if (this.is1013OrEarlier && (nativePath = np.toString()).length() > 0) {
                this.javaOptions.add("-Djava.library.path=" + nativePath);
            }
            String ideUserDir = this.getIdeUserDir(jrunProcess);
            if (this.is1013OrEarlier || ideUserDir != null && ideUserDir.length() > 0) {
                this.javaOptions.add("-Dide.user.dir=" + this.getIdeUserDir(jrunProcess));
            }
            this.javaOptions.add("-Dide.config_pathname=" + confFileName);
            if (this.is1013OrEarlier) {
                this.javaOptions.add("-Djava.class.path=.." + File.separator + "lib" + File.separator + "jdev-loader.jar");
            }
            String classPath = cp.toString();
            String processClassPath = (String)jrunProcess.getValue("Java", null, "ClassPath");
            if (processClassPath != null && processClassPath.length() != 0) {
                if (classPath.length() > 0) {
                    classPath = classPath + File.pathSeparator;
                }
                classPath = classPath + processClassPath;
            }
            if (classPath.length() > 0) {
                if (this.is1013OrEarlier) {
                    this.javaOptions.add("-Djdev.class.path=" + classPath);
                } else {
                    this.javaOptions.add("-Djava.class.path=" + classPath);
                }
            }
            if (this.is1013OrEarlier) {
                this.javaOptions.add("-Djava.system.class.loader=oracle.ideimpl.IdeClassLoader");
            }
            this.javaOptions.add("-Dlaunched.from.jdev=true");
        }

        /*
         * Exception decompiling
         */
        private void initIs1013OrEarlier(File confFile) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        private void processConfiguration(File confFile, String bin, FastStringBuffer cp, FastStringBuffer np) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void addJavaLibPath(String bin, String value, FastStringBuffer cp) {
            try {
                FilenameFilter filter;
                File[] jars;
                value = value.replace('/', File.separatorChar);
                File f = new File(value);
                if (!f.isAbsolute()) {
                    f = new File(bin, value);
                }
                if ((jars = f.listFiles(filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        String lowerName = name.toLowerCase();
                        return lowerName.endsWith(".jar") || lowerName.endsWith(".zip");
                    }
                })) != null) {
                    for (int i = jars.length - 1; i >= 0; --i) {
                        if (cp.length() > 0) {
                            cp.append(File.pathSeparator);
                        }
                        cp.append(value + File.separator + jars[i].getName());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void addJDKJars(Project project, FastStringBuffer cp) {
            URL sdkLibDir;
            JDK jdk = Helpers.getActiveJdkDefinition(project);
            if (jdk != null && (sdkLibDir = this.getSDKLibDir(jdk)) != null) {
                String s;
                URL dtJar;
                URLPath urlPath = new URLPath(2);
                URL toolsJar = URLFactory.newURL((URL)sdkLibDir, (String)"tools.jar");
                if (toolsJar != null) {
                    urlPath.add(toolsJar);
                }
                if ((dtJar = URLFactory.newURL((URL)sdkLibDir, (String)"dt.jar")) != null) {
                    urlPath.add(dtJar);
                }
                if ((s = urlPath.toString()) != null && s.length() > 0) {
                    if (cp.length() > 0) {
                        cp.append(File.pathSeparator);
                    }
                    cp.append(s);
                }
            }
        }

        private URL getSDKLibDir(JDK jdk) {
            URL sdkDir;
            URL sdkBinDir = jdk.getSDKBinDir();
            if (sdkBinDir != null && (sdkDir = URLFileSystem.getParent((URL)sdkBinDir)) != null) {
                URL sdkLibDir = URLFactory.newURL((URL)sdkDir, (String)"lib");
                return sdkLibDir;
            }
            return null;
        }

        private void removeJVMSpecificJavaOptions(JRunProcess jrunProcess, String setJavaVMValue) {
            JDK jdk = Helpers.getActiveJdkDefinition(jrunProcess.getProject());
            RunConfiguration runConfig = jrunProcess.getRunConfiguration();
            if (ModelUtil.areDifferent((Object)setJavaVMValue, (Object)runConfig.getVMName(jdk))) {
                if (runConfig.usingOJVM(jdk) || runConfig.usingMinimal(jdk) || runConfig.usingVanilla(jdk)) {
                    this.removeJavaOptions(hotspotSpecificOptions);
                } else {
                    this.removeJavaOptions(ojvmSpecificOptions);
                }
            }
        }

        private void removeJavaOptions(String[] optionsToRemove) {
            for (int i = optionsToRemove.length - 1; i >= 0; --i) {
                String option = optionsToRemove[i];
                while (this.javaOptions.contains(option)) {
                    this.javaOptions.remove(option);
                }
            }
        }

        private String getIdeUserDir(JRunProcess jrunProcess) {
            URL url = jrunProcess.getRunConfiguration().getRunDirectoryURL();
            if (url != null) {
                File startDir = new File(url.getPath());
                try {
                    return startDir.getCanonicalPath();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return "";
        }

        private String[] getTarget() {
            String[] target = new String[]{this.mainClass};
            return target;
        }

        private File getBinDirectory() {
            return this.binDirectory;
        }

        private List getJavaOptions() {
            return this.javaOptions;
        }
    }

    private static class ConfFileException
    extends RuntimeException {
        String confFileName;
        String directive;

        private ConfFileException(Throwable cause, String confFileName, String directive) {
            super(cause);
            this.confFileName = confFileName;
            this.directive = directive;
        }

        String getConfFileName() {
            return this.confFileName;
        }

        String getDirective() {
            return this.directive;
        }
    }
}

