/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIAnnotationInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIArb;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIMethodInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIStackFrameInfo;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugHasAnnotations;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

final class DebugJDIVariableInfo
extends JDIInformationProvider
implements DebugVariableInfo,
DebugHasAnnotations {
    DebugJDI dj;
    DebugJDIStackFrameInfo djsf;
    LocalVariable lv;
    int argumentPosition;
    boolean argument;
    boolean local;
    ObjectReference thisObject;
    int stoppedCount;
    private Value value;
    private int annotationCount = -1;
    private int hashCode;

    DebugJDIVariableInfo(DebugJDI dj, DebugJDIStackFrameInfo djsf, ObjectReference thisObject) {
        this.dj = dj;
        this.djsf = djsf;
        this.thisObject = thisObject;
        this.argument = true;
        this.argumentPosition = -1;
        this.stoppedCount = dj.stoppedCount;
    }

    DebugJDIVariableInfo(DebugJDI dj, DebugJDIStackFrameInfo djsf, LocalVariable lv, int argumentPosition) {
        this.dj = dj;
        this.djsf = djsf;
        this.lv = lv;
        this.argumentPosition = argumentPosition;
        this.argument = true;
        this.stoppedCount = dj.stoppedCount;
    }

    DebugJDIVariableInfo(DebugJDI dj, DebugJDIStackFrameInfo djsf, LocalVariable lv) {
        this.dj = dj;
        this.djsf = djsf;
        this.lv = lv;
        this.local = true;
        this.stoppedCount = dj.stoppedCount;
    }

    DebugJDIVariableInfo(DebugJDI dj, DebugJDIStackFrameInfo djsf, Value value, int argumentPosition) {
        this.dj = dj;
        this.djsf = djsf;
        this.argumentPosition = argumentPosition;
        this.value = value;
        this.argument = true;
        this.stoppedCount = dj.stoppedCount;
    }

    @Override
    public boolean hasExpired() {
        return this.stoppedCount != this.dj.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new DataExpiredException();
        }
    }

    @Override
    public DebugClassInfo getClassInfo() {
        DebugJDIClassInfo c;
        this.throwIfExpired();
        if (this.thisObject != null) {
            return this.dj.findClass(this.thisObject.referenceType());
        }
        try {
            DebugJDIClassInfo c2 = this.dj.findClassByType(this.lv != null ? this.lv.type() : this.value.type());
            if (c2 != null) {
                return c2;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Value v = null;
        if (this.lv.isVisible(this.djsf.sf)) {
            Value value = v = this.value == null ? this.djsf.sf.getValue(this.lv) : this.value;
        }
        if (v != null && (c = this.dj.findClassByType(v.type())) != null) {
            return c;
        }
        if (this.lv != null) {
            return this.dj.findClassByName(this.lv.typeName(), true);
        }
        return this.dj.findClassByName(v.type().name(), true);
    }

    @Override
    public String getGenericSignature() {
        if (this.lv != null) {
            return this.lv.genericSignature();
        }
        return null;
    }

    @Override
    public String getName() {
        this.throwIfExpired();
        if (this.thisObject != null) {
            return "this";
        }
        if (this.lv != null) {
            return this.lv.name();
        }
        if (this.value != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(DebugJDIArb.getString(7));
            sb.append(this.argumentPosition);
            return sb.toString();
        }
        assert (false) : "lv and value not set!";
        return "";
    }

    @Override
    public boolean isInScope() {
        this.throwIfExpired();
        if (this.thisObject != null) {
            return true;
        }
        if (this.lv != null) {
            return this.lv.isVisible(this.djsf.sf);
        }
        return true;
    }

    @Override
    public boolean isArgument() {
        return this.argument;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public boolean isReturn() {
        return false;
    }

    @Override
    public boolean isReturned() {
        return false;
    }

    @Override
    public DebugDataInfo getDataInfo() {
        this.throwIfExpired();
        if (this.thisObject != null) {
            return this.dj.makeData(this.thisObject, this);
        }
        Value v = null;
        if (this.lv != null) {
            if (this.lv.isVisible(this.djsf.sf)) {
                v = this.djsf.sf.getValue(this.lv);
            }
        } else {
            v = this.value;
        }
        if (v != null) {
            return this.dj.makeData(v, this);
        }
        return this.dj.makeNullData((DebugJDIClassInfo)this.getClassInfo(), this);
    }

    @Override
    public int getSlotSize() {
        String sig;
        String string = sig = this.lv != null ? this.lv.signature() : this.value.type().signature();
        if (sig.equals("J") || sig.equals("D")) {
            return 2;
        }
        return 1;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.thisObject != null ? ((Object)this.thisObject).hashCode() : (this.lv != null ? ((Object)this.lv).hashCode() : this.value.hashCode());
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIVariableInfo) {
            DebugJDIVariableInfo other = (DebugJDIVariableInfo)o;
            return this.dj.equals(other.dj) && (this.thisObject == null ? other.thisObject == null : ((Object)this.thisObject).equals(other.thisObject)) && (this.lv == null ? other.lv == null : ((Object)this.lv).equals(other.lv)) && (this.value == null ? other.value == null : this.value.equals(other.value));
        }
        return false;
    }

    @Override
    public int countAnnotations() {
        this.throwIfExpired();
        if (this.dj.isRIM()) {
            return 0;
        }
        if (this.argument && this.argumentPosition >= 0) {
            if (this.annotationCount < 0) {
                this.getAnnotations();
            }
            return this.annotationCount < 0 ? 0 : this.annotationCount;
        }
        return 0;
    }

    @Override
    public DebugAnnotationInfo[] getAnnotations() {
        this.throwIfExpired();
        if (this.argument && this.argumentPosition >= 0) {
            try {
                Method method;
                ObjectReference orMethodOrConstructor;
                if (this.dj.isSafeToGetAnnotations() && (orMethodOrConstructor = DebugJDIMethodInfo.getReflectedMethodOrConstructor(this.dj, method = this.djsf.sf.location().method())) != null) {
                    DebugAnnotationInfo[] result = this.getParameterAnnotations(orMethodOrConstructor);
                    this.annotationCount = result.length;
                    return result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new DebugJDIAnnotationInfo[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DebugJDIAnnotationInfo[] getParameterAnnotations(ObjectReference orMethod) {
        try {
            ClassType ctMethod = (ClassType)orMethod.referenceType();
            Method mGetParameterAnnotations = ctMethod.concreteMethodByName("getParameterAnnotations", "()[[Ljava/lang/annotation/Annotation;");
            if (mGetParameterAnnotations == null) return new DebugJDIAnnotationInfo[0];
            Object object = this.dj.methodCallLock;
            synchronized (object) {
                List prev = this.dj.tempDisableRequests();
                try {
                    ArrayReference arParameterAnnotations = null;
                    DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
                    if (dbgSettings.isDetectMethodEvalDeadlocks()) {
                        this.dj.startMethodEvaluationWorker();
                        DebugJDI.MethodEvaluationWorker worker = this.dj.methodEvaluationWorker;
                        worker.or = orMethod;
                        worker.methodEvaluationType = DebugJDI.MethodEvaluationType.VIRTUAL_CALL;
                        worker.dj = this.dj;
                        worker.m = mGetParameterAnnotations;
                        worker.argList = Collections.EMPTY_LIST;
                        try {
                            arParameterAnnotations = (ArrayReference)this.dj.evaluateMethodCheckForHang();
                        }
                        catch (Exception ex) {
                            DebugJDIAnnotationInfo[] debugJDIAnnotationInfoArray = null;
                            DebugJDIStackFrameInfo.rebuildCache(this.dj);
                            this.dj.tempReenableRequests(prev);
                            return debugJDIAnnotationInfoArray;
                        }
                    } else {
                        Log logger = JDebugger.logger;
                        if (logger.isEnabled()) {
                            ClassType ctClass = (ClassType)orMethod.referenceType();
                            logger.trace("Invoking method: {0}.{1}", (Object)(ctClass != null ? ctClass.name() : "<unknown>"), (Object)mGetParameterAnnotations.name());
                        }
                        int flag = DebugJDI.MULTI_THREADED_METHOD_EVALUATIONS ? 0 : 1;
                        arParameterAnnotations = (ArrayReference)orMethod.invokeMethod(this.dj.eventThread, mGetParameterAnnotations, Collections.EMPTY_LIST, flag);
                        if (logger.isEnabled()) {
                            logger.trace("Method return is {0}", (Object)(arParameterAnnotations == null ? "null" : "not null"));
                        }
                    }
                    if (arParameterAnnotations == null) return new DebugJDIAnnotationInfo[0];
                    if (this.argumentPosition >= arParameterAnnotations.length()) return new DebugJDIAnnotationInfo[0];
                    ArrayReference arAnnotations = (ArrayReference)arParameterAnnotations.getValue(this.argumentPosition);
                    if (arAnnotations == null) return new DebugJDIAnnotationInfo[0];
                    DebugJDIAnnotationInfo[] array = new DebugJDIAnnotationInfo[arAnnotations.length()];
                    int i = 0;
                    for (Value annotation : arAnnotations.getValues()) {
                        array[i] = new DebugJDIAnnotationInfo(this.dj, (ObjectReference)annotation);
                        ++i;
                    }
                    DebugJDIAnnotationInfo[] debugJDIAnnotationInfoArray = array;
                    return debugJDIAnnotationInfoArray;
                }
                finally {
                    DebugJDIStackFrameInfo.rebuildCache(this.dj);
                    this.dj.tempReenableRequests(prev);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new DebugJDIAnnotationInfo[0];
    }

    @Override
    public LocalVariable getJDILocalVariable() {
        return this.lv;
    }
}

