/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIHeapAncestorInsideHeap;
import oracle.jdevimpl.debugger.jdi.DebugJDIHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetAncestors;

final class DebugJDIHeapInfo
implements DebugHeapInfo {
    DebugJDI dj;
    DebugHeapSubset subset;
    int stoppedCount;
    DebugJDIHeapAncestorOutsideHeap[] heapAncestorsOutsideHeap;
    long[] heapAddresses;
    int[] depths;
    DebugJDIHeapAncestorInsideHeap[] heapAncestorsInsideHeap;
    private int hashCode;

    DebugJDIHeapInfo(DebugJDI dj, DebugHeapSubset subset, DebugJDIHeapAncestorOutsideHeap[] heapAncestorsOutsideHeap, long[] heapAddresses, int[] depths) {
        this.dj = dj;
        this.subset = subset;
        this.stoppedCount = dj.stoppedCount;
        this.heapAddresses = heapAddresses;
        this.depths = depths;
        ArrayList<DebugJDIHeapAncestorOutsideHeap> temp = new ArrayList<DebugJDIHeapAncestorOutsideHeap>();
        int maxDepth = -1;
        if (subset instanceof DebugHeapSubsetAncestors) {
            maxDepth = ((DebugHeapSubsetAncestors)subset).getDepth();
        }
        for (DebugJDIHeapAncestorOutsideHeap ancestor : heapAncestorsOutsideHeap) {
            long address = ancestor.getAddress();
            int depth = this.getDepth(address) + 1;
            if (maxDepth != -1 && depth > maxDepth) continue;
            ancestor.setDepth(depth);
            temp.add(ancestor);
        }
        this.heapAncestorsOutsideHeap = temp.toArray(new DebugJDIHeapAncestorOutsideHeap[temp.size()]);
    }

    @Override
    public boolean hasExpired() {
        return this.dj.stoppedCount != this.stoppedCount;
    }

    private void throwIfExpired() {
        if (this.hasExpired()) {
            throw new DataExpiredException();
        }
    }

    @Override
    public DebugHeapAncestorOutsideHeap[] getAncestorsOutsideHeap() {
        return this.heapAncestorsOutsideHeap;
    }

    @Override
    public DebugHeapAncestorInsideHeap[] getAncestorsInsideHeap() {
        if (this.heapAncestorsInsideHeap == null) {
            if (this.subset instanceof DebugHeapSubsetAncestors) {
                int length = this.heapAddresses.length;
                if (this.depths != null && this.depths.length == length) {
                    int i;
                    class HeapAddressAndDepth {
                        long heapAddress;
                        int depth;

                        HeapAddressAndDepth(long heapAddress, int depth) {
                            this.heapAddress = heapAddress;
                            this.depth = depth;
                        }
                    }
                    HeapAddressAndDepth[] a = new HeapAddressAndDepth[this.heapAddresses.length];
                    for (i = 0; i < length; ++i) {
                        a[i] = new HeapAddressAndDepth(this.heapAddresses[i], this.depths[i]);
                    }
                    Arrays.sort(a, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            return ((HeapAddressAndDepth)o1).depth - ((HeapAddressAndDepth)o2).depth;
                        }
                    });
                    this.heapAncestorsInsideHeap = new DebugJDIHeapAncestorInsideHeap[length];
                    for (i = 0; i < length; ++i) {
                        this.heapAncestorsInsideHeap[i] = new DebugJDIHeapAncestorInsideHeap(this.dj, a[i].heapAddress);
                        this.heapAncestorsInsideHeap[i].setDepth(a[i].depth);
                    }
                } else {
                    this.heapAncestorsInsideHeap = new DebugJDIHeapAncestorInsideHeap[0];
                }
            } else {
                this.heapAncestorsInsideHeap = new DebugJDIHeapAncestorInsideHeap[0];
            }
        }
        return this.heapAncestorsInsideHeap;
    }

    @Override
    public long[] getHeapAddresses() {
        return this.heapAddresses;
    }

    @Override
    public int[] getHeapAncestorDepths() {
        return this.depths;
    }

    @Override
    public int getDepth(long address) {
        if (this.subset instanceof DebugHeapSubsetAncestors) {
            int index;
            long searchedAddress = ((DebugHeapSubsetAncestors)this.subset).getAddress();
            if (address == searchedAddress) {
                return 0;
            }
            if (this.depths != null && (index = Arrays.binarySearch(this.heapAddresses, address)) >= 0) {
                return this.depths[index];
            }
        }
        return -1;
    }

    @Override
    public int getDepth(DebugDataCompositeInfo data) {
        return this.getDepth(data.getAddressOfObject());
    }

    @Override
    public DebugHeapObjectInfo[] getHeapObjects(int start, int count) {
        this.throwIfExpired();
        if (start == 0 && count == 0) {
            count = this.heapAddresses.length;
        }
        if (start + count > this.heapAddresses.length) {
            count = this.heapAddresses.length - start;
        }
        return this.dj.getHeapObjects(this.heapAddresses, start, count);
    }

    @Override
    public int countHeapObjects() {
        return this.heapAddresses.length;
    }

    @Override
    public DebugHeapSubset getHeapSubset() {
        return this.subset;
    }

    public int hashCode() {
        if (this.hashCode == 0 && this.subset != null) {
            this.hashCode = this.subset.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIHeapInfo) {
            DebugJDIHeapInfo other = (DebugJDIHeapInfo)o;
            return this.dj.equals(other.dj) && (this.subset == null ? other.subset == null : this.subset.equals(other.subset));
        }
        return false;
    }
}

