/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.connect.Connector;
import java.util.Map;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.runner.debug.DbgArb;

final class DebugJDIConnectArg
implements DebugConnectArg {
    int factory;
    Map<String, Connector.Argument> defArgs;
    private Connector.Argument arg;
    private String name;
    private String value;

    DebugJDIConnectArg(int factory, Map<String, Connector.Argument> defArgs, Connector.Argument arg) {
        this.factory = factory;
        this.defArgs = defArgs;
        this.arg = arg;
        this.name = arg.name();
        String defaultValue = DebugShared.getDefaultConnectArgValue(factory, this.name);
        if (defaultValue != null) {
            this.setValue(defaultValue);
        }
    }

    DebugJDIConnectArg(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.arg == null ? this.name : this.arg.label();
    }

    @Override
    public void setValue(String value) {
        if (this.arg == null) {
            this.value = value;
            return;
        }
        if (this.name.equals("timeout")) {
            try {
                int seconds = Integer.parseInt(value);
                int millis = seconds * 1000;
                value = Integer.toString(millis);
            }
            catch (Exception exception) {}
        } else if (this.name.equals("hostname") && (value == null || value.length() == 0)) {
            value = DbgArb.getString(205);
        }
        this.arg.setValue(value);
    }

    @Override
    public String getValue() {
        String value;
        String string = value = this.arg == null ? this.value : this.arg.value();
        if (this.name.equals("timeout")) {
            try {
                int millis = Integer.parseInt(value);
                int seconds = millis / 1000;
                value = Integer.toString(seconds);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    @Override
    public boolean allowBlank() {
        return this.arg == null ? true : !this.arg.mustSpecify();
    }
}

