/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.ClassType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ExceptionRequest;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointException;

final class DebugJDIBreakpointException
extends DebugJDIBreakpoint
implements DebugBreakpointException {
    String exception;
    boolean caught;
    boolean uncaught;

    DebugJDIBreakpointException(DebugJDI dj, String exception, boolean caught, boolean uncaught) {
        super(dj);
        this.exception = exception;
        this.caught = caught;
        this.uncaught = uncaught;
    }

    @Override
    public String getExceptionClassname() {
        return this.exception;
    }

    @Override
    public boolean getCaught() {
        return this.caught;
    }

    @Override
    public boolean getUncaught() {
        return this.uncaught;
    }

    @Override
    public void setExceptionClassname(String exception) {
        this.setExceptionClassname(exception, true, true);
    }

    @Override
    public void setExceptionClassname(String exception, boolean caught, boolean uncaught) {
        if (ModelUtil.areDifferent((Object)this.exception, (Object)exception) || this.caught != caught || this.uncaught != uncaught) {
            this.prepareForChange();
            this.exception = exception;
            this.caught = caught;
            this.uncaught = uncaught;
            this.afterChange();
        }
    }

    @Override
    String getClassPrepareFilter() {
        return this.exception;
    }

    @Override
    boolean verify(ReferenceType rt) {
        ClassType superClass;
        boolean identified = false;
        String rtName = rt.name();
        if (this.exception.equals(rtName)) {
            this.exceptionIdentified(rt);
            identified = true;
        } else if (this.exception.equals("java.lang.Exception") && rtName.equals("$Oracle.Builtin.EXCEPTION") && rt instanceof ClassType && (superClass = ((ClassType)rt).superclass()) != null && superClass.name().equals("java.lang.Throwable")) {
            this.exceptionIdentified(rt);
            identified = true;
        }
        return identified;
    }

    private void exceptionIdentified(ReferenceType rt) {
        ExceptionRequest er = this.dj.erm.createExceptionRequest(rt, this.caught, this.uncaught);
        this.setOptions(er);
        this.addRequest(er);
    }
}

