/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.util.Encodings;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.net.EncoderUtils;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

final class MozillaFireFoxJavaScriptFileSystemHelper
extends URLFileSystemHelper {
    public static final String DBG_PROTOCOL = "ide.dbg";
    public static final String DBG_MOZILLA_FIREFOX_PATH = "mozillafirefox/";
    public static final String DBG_MOZILLA_QUERY = "source=";
    private Map<URL, MozillaFireFoxSourceInfo> urlToInfo = new HashMap<URL, MozillaFireFoxSourceInfo>();
    private static MozillaFireFoxJavaScriptFileSystemHelper instance;

    static synchronized MozillaFireFoxJavaScriptFileSystemHelper getInstance(boolean create) {
        if (instance == null && create) {
            instance = new MozillaFireFoxJavaScriptFileSystemHelper();
            URLFileSystem.registerHelper((String)DBG_PROTOCOL, (URLFileSystemHelper)instance);
        }
        return instance;
    }

    private MozillaFireFoxJavaScriptFileSystemHelper() {
    }

    private static String getHostPart(DebugMozillaFireFoxJavaScript vm) {
        String w = "";
        w = w + vm.getConnectedHost();
        return w;
    }

    private static String getPortPart(DebugMozillaFireFoxJavaScript vm) {
        String p = "port:";
        p = p + vm.getConnectedPort();
        return p;
    }

    private static String getInitialPath(DebugMozillaFireFoxJavaScript vm) {
        String path = DBG_MOZILLA_FIREFOX_PATH;
        path = path + MozillaFireFoxJavaScriptFileSystemHelper.getHostPart(vm);
        path = path + ":";
        path = path + MozillaFireFoxJavaScriptFileSystemHelper.getPortPart(vm);
        path = path + ":";
        path = path + "/";
        return path;
    }

    private URL makeURL(DebugMozillaFireFoxJavaScript vm, String source) {
        String path = MozillaFireFoxJavaScriptFileSystemHelper.getInitialPath(vm);
        URL url = URLFactory.newURL((String)DBG_PROTOCOL, (String)(path + "/" + source));
        return url;
    }

    URL getURL(DebugMozillaFireFoxJavaScript vm, String source) {
        URL url = this.makeURL(vm, source);
        if (this.urlToInfo.containsKey(url)) {
            return url;
        }
        return null;
    }

    static String getSourceName(URL url) {
        try {
            String query;
            if (url.getProtocol().equals(DBG_PROTOCOL) && url.getPath().startsWith(DBG_MOZILLA_FIREFOX_PATH) && (query = url.getQuery()).startsWith(DBG_MOZILLA_QUERY)) {
                String sourceName = query.substring(DBG_MOZILLA_QUERY.length());
                sourceName = EncoderUtils.decodeString((String)sourceName, (String)Encodings.getDefaultEncoding());
                return sourceName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    URL addSourceName(DebugMozillaFireFoxJavaScript vm, String source, int scriptPointer) {
        URL url = this.makeURL(vm, source);
        MozillaFireFoxSourceInfo info = this.urlToInfo.get(url);
        if (info == null) {
            info = new MozillaFireFoxSourceInfo();
            this.urlToInfo.put(url, info);
        }
        info.setSourceName(source, vm.getConnectedHost(), vm.getConnectedPort(), vm, scriptPointer);
        if (info.getSourceString() == null) {
            this.fetchSource(url);
        }
        if (info.getSourceString() != null && info.getSourceString().length() == 0) {
            url = null;
        }
        if (url != null) {
            this.updateSource(url, vm);
        }
        return url;
    }

    void updateSources(DebuggingProcess debuggingProcess) {
        DebugVirtualMachine vm = debuggingProcess.getVM();
        if (!(vm instanceof DebugMozillaFireFoxJavaScript)) {
            return;
        }
        String initialPath = MozillaFireFoxJavaScriptFileSystemHelper.getInitialPath((DebugMozillaFireFoxJavaScript)vm);
        for (Map.Entry<URL, MozillaFireFoxSourceInfo> entry : this.urlToInfo.entrySet()) {
            URL url = entry.getKey();
            String path = url.getPath();
            if (!path.startsWith(initialPath)) continue;
            MozillaFireFoxSourceInfo info = entry.getValue();
            if (info.wasCleared() && vm != null) {
                String methodName = MozillaFireFoxJavaScriptFileSystemHelper.getSourceName(url);
            }
            this.updateSource(url, (DebugMozillaFireFoxJavaScript)vm);
        }
    }

    void removeStaleSources() {
        for (MozillaFireFoxSourceInfo info : this.urlToInfo.values()) {
            if (info.sourceName == null || info.vm.isConnected()) continue;
            info.clear();
        }
    }

    private void updateSource(URL url, DebugMozillaFireFoxJavaScript vm) {
        final Node node = NodeFactory.find((URL)url);
        if (node != null) {
            vm.addNode(node);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RevertNodeCommand.reload((Node)node);
                }
            });
        }
    }

    private synchronized MozillaFireFoxSourceInfo fetchSource(URL url) {
        MozillaFireFoxSourceInfo info = this.urlToInfo.get(url);
        try {
            if (info != null && info.sourceName != null && (info.source == null || info.source.length() == 0)) {
                String source = this.getSource(info.sourceName, info.vm, info.hostStr, info.portStr, info.scriptPointer);
                if (source == null || source.length() == 0) {
                    source = "";
                }
                info.setSource(source == null ? "" : source);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    private synchronized boolean sourceExists(URL url) {
        MozillaFireFoxSourceInfo info = this.fetchSource(url);
        return info != null ? info.sourceExists() : false;
    }

    public boolean canRead(URL url) {
        return this.sourceExists(url);
    }

    public boolean canWrite(URL url) {
        return false;
    }

    public boolean canCreate(URL url) {
        return false;
    }

    public boolean canDelete(URL url) {
        return false;
    }

    public boolean isValid(URL url) {
        return this.sourceExists(url);
    }

    public boolean exists(URL url) {
        return this.sourceExists(url);
    }

    public Icon getDefaultIcon(URL url) {
        return OracleIcons.getIcon((String)"method.png");
    }

    public synchronized long getLength(URL url) {
        MozillaFireFoxSourceInfo info = this.fetchSource(url);
        return info != null ? info.getSourceLength() : 0;
    }

    public URL getParent(URL url) {
        return null;
    }

    public boolean isReadOnly(URL url) {
        return true;
    }

    public synchronized long lastModified(URL url) {
        MozillaFireFoxSourceInfo info = this.fetchSource(url);
        return info != null ? info.time : -1L;
    }

    public synchronized InputStream openInputStream(URL url) throws IOException {
        MozillaFireFoxSourceInfo info = this.fetchSource(url);
        byte[] bytes = info != null ? info.getSourceBytes() : new byte[]{};
        return new ByteArrayInputStream(bytes);
    }

    public OutputStream openOutputStream(URL url) throws IOException {
        throw new UnknownServiceException();
    }

    public synchronized Reader createReader(URL url, String encoding) throws IOException {
        MozillaFireFoxSourceInfo info = this.fetchSource(url);
        return new StringReader(info != null ? info.getSourceString() : "");
    }

    private String getSource(String sourceName, DebugVirtualMachine debugVirtualMachine, String hostStr, String portStr, int scriptPointer) {
        if (debugVirtualMachine instanceof DebugMozillaFireFoxJavaScript) {
            return ((DebugMozillaFireFoxJavaScript)debugVirtualMachine).getSourceForURL(sourceName, scriptPointer);
        }
        return null;
    }

    void removeCachedInfo(URL url) {
        if (this.urlToInfo != null) {
            this.urlToInfo.remove(url);
        }
    }

    void removeCachedInfo() {
        if (this.urlToInfo != null) {
            this.urlToInfo.clear();
        }
    }

    static class MozillaFireFoxSourceInfo {
        String sourceName;
        String hostStr;
        String portStr;
        long time = -1L;
        String source;
        DebugVirtualMachine vm;
        int scriptPointer = 0;

        MozillaFireFoxSourceInfo() {
        }

        private void setSourceName(String sourceName, String hostStr, String portStr, DebugVirtualMachine vm, int scriptPointer) {
            this.sourceName = sourceName;
            this.hostStr = hostStr;
            this.portStr = portStr;
            this.vm = vm;
            this.scriptPointer = scriptPointer;
        }

        private void clear() {
            this.sourceName = null;
            this.hostStr = null;
            this.portStr = null;
            this.time = -1L;
            this.scriptPointer = 0;
        }

        private boolean wasCleared() {
            return this.sourceName == null;
        }

        private void setSource(String source) {
            this.time = new Date().getTime();
            this.source = source;
        }

        private boolean sourceExists() {
            return this.source != null;
        }

        private int getSourceLength() {
            return this.source != null ? this.source.length() : 0;
        }

        private byte[] getSourceBytes() {
            return this.source != null ? this.source.getBytes() : new byte[]{};
        }

        private String getSourceString() {
            return this.source;
        }
    }
}

