/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.jdevimpl.debugger.javascript.DebugJavaScriptArb;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxDataInfo;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxDataObjectInfo;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavScriptLocation;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxProperty;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxVariableInfo;
import oracle.jdevimpl.debugger.javascript.event.MozillaFireFoxFetchFramesRequest;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;

public class DebugMozillaFireFoxJavaScriptStackFrameInfo
implements DebugStackFrameInfo {
    private boolean expired = false;
    private int frameNumber;
    private DebugLocation location;
    private MozillaFireFoxFetchFramesRequest.StackFrameInfo sfi = null;
    private DebugMozillaFireFoxJavaScript debugger;
    private List<DebugMozillaFireFoxVariableInfo> variableInfos = null;
    private Map<String, DebugMozillaFireFoxVariableInfo> variableInfosMap = null;

    DebugMozillaFireFoxJavaScriptStackFrameInfo(int index, MozillaFireFoxFetchFramesRequest.StackFrameInfo sfi, DebugMozillaFireFoxJavaScript debugger) {
        this.frameNumber = index;
        this.sfi = sfi;
        this.debugger = debugger;
    }

    public void setExpired(boolean nV) {
        this.expired = nV;
        this.sfi = null;
        this.frameNumber = -1;
        this.location = null;
        if (nV) {
            if (this.variableInfos != null) {
                Iterator<DebugMozillaFireFoxVariableInfo> iter = this.variableInfos.iterator();
                while (iter.hasNext()) {
                    iter.next().setExpired(nV);
                }
            }
            this.variableInfos = null;
            this.variableInfosMap = null;
        }
    }

    @Override
    public boolean hasExpired() {
        return this.expired;
    }

    @Override
    public int getFrameNumber() {
        return this.frameNumber;
    }

    @Override
    public DebugLocation getLocation() {
        if (this.location == null) {
            this.location = new DebugMozillaFireFoxJavScriptLocation(this);
        }
        return this.location;
    }

    @Override
    public DebugVariableInfo[] listArguments() {
        return new DebugVariableInfo[0];
    }

    @Override
    public DebugVariableInfo[] listLocals() {
        this.fillLocalVars();
        if (this.variableInfos == null) {
            return new DebugVariableInfo[0];
        }
        return this.variableInfos.toArray(new DebugMozillaFireFoxVariableInfo[this.variableInfos.size()]);
    }

    @Override
    public DebugVariableInfo getVariable(String name) {
        if (this.variableInfosMap == null) {
            return null;
        }
        return this.variableInfosMap.get(name);
    }

    @Override
    public DebugStackSlotInfo[] listSlots() {
        return new DebugStackSlotInfo[0];
    }

    @Override
    public int getLanguage() {
        return 16;
    }

    @Override
    public boolean popBackToHere() {
        return false;
    }

    public String getFileName() {
        if (this.sfi != null) {
            return this.sfi.scriptName;
        }
        return null;
    }

    public int getLine() {
        if (this.sfi != null) {
            return this.sfi.line;
        }
        return 0;
    }

    public int getPc() {
        if (this.sfi != null) {
            return this.sfi.pc;
        }
        return -1;
    }

    DebugVirtualMachine getDebugger() {
        return this.debugger;
    }

    public DebugClassInfo getClassInfo() {
        return this.getLocation().getClassInfo();
    }

    public String getMethodName() {
        return this.sfi.methodName == null ? DebugJavaScriptArb.getString(11) : this.sfi.methodName;
    }

    public boolean isNative() {
        return this.sfi.isNative;
    }

    public long getStackFrameId() {
        if (this.sfi != null) {
            return this.sfi.stackFrameId;
        }
        return -1L;
    }

    public long getThisValueId() {
        if (this.sfi != null) {
            return this.sfi.thisValueId;
        }
        return -1L;
    }

    public String getThisString() {
        if (this.sfi != null) {
            return this.sfi.thisVlaueStr;
        }
        return null;
    }

    public int getThisType() {
        if (this.sfi != null) {
            return this.sfi.thisType;
        }
        return 5;
    }

    private void fillLocalVars() {
        if (this.variableInfos != null) {
            return;
        }
        this.variableInfos = new ArrayList<DebugMozillaFireFoxVariableInfo>();
        this.variableInfosMap = new HashMap<String, DebugMozillaFireFoxVariableInfo>();
        DebugMozillaFireFoxVariableInfo thisInfo = new DebugMozillaFireFoxVariableInfo(this, "this", true, 0, this.sfi.thisVlaueStr, this.sfi.thisType, this.sfi.thisValueId, false, false);
        this.variableInfos.add(thisInfo);
        this.variableInfosMap.put(thisInfo.getName(), thisInfo);
        DebugMozillaFireFoxVariableInfo globalInfo = new DebugMozillaFireFoxVariableInfo(this, DebugJavaScriptArb.getString(15), true, 1, this.sfi.globalVlaueStr, this.sfi.globalType, this.sfi.globalValueId, false, false);
        this.variableInfos.add(globalInfo);
        this.variableInfosMap.put(globalInfo.getName(), globalInfo);
        if (this.sfi != null && this.sfi.funValueId != 0L) {
            DebugFieldInfo[] props;
            DebugMozillaFireFoxVariableInfo funInfo = new DebugMozillaFireFoxVariableInfo(this, this.sfi.methodName, true, 2, "", 3, this.sfi.funValueId, false, false);
            this.variableInfos.add(funInfo);
            this.variableInfosMap.put(funInfo.getName(), funInfo);
            DebugDataInfo dataInfo = funInfo.getDataInfo();
            if (dataInfo != null && dataInfo instanceof DebugMozillaFireFoxDataObjectInfo && (props = ((DebugMozillaFireFoxDataObjectInfo)dataInfo).getFields(Integer.MAX_VALUE)) instanceof DebugMozillaFireFoxProperty[]) {
                DebugMozillaFireFoxProperty[] propsProperties = (DebugMozillaFireFoxProperty[])props;
                for (int i = 0; i < propsProperties.length; ++i) {
                    DebugMozillaFireFoxProperty prop = propsProperties[i];
                    if ((prop.getAccess() & 0x10) == 0 && (prop.getAccess() & 0x20) == 0) continue;
                    DebugMozillaFireFoxDataInfo di = (DebugMozillaFireFoxDataInfo)prop.getDataInfo();
                    DebugMozillaFireFoxVariableInfo localVarInfo = new DebugMozillaFireFoxVariableInfo(this, di.getName(), true, -1, di.getValue(), di.getType(), prop.getId(), (prop.getAccess() & 0x10) != 0, (prop.getAccess() & 0x20) != 0);
                    this.variableInfos.add(localVarInfo);
                    this.variableInfosMap.put(localVarInfo.getName(), localVarInfo);
                }
            }
        }
    }
}

