/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.javascript;

import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxClassLoaderInfo;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxDataInfo;
import oracle.jdevimpl.debugger.javascript.DebugMozillaFireFoxJavaScript;
import oracle.jdevimpl.debugger.javascript.MozillaFireFoxJavaScriptFileSystemHelper;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

public class DebugMozillaFireFoxClassInfo
implements DebugClassInfo {
    private static final boolean DEBUG = false;
    private String name;
    private int count;
    private DebugMozillaFireFoxClassLoaderInfo classLoaderInfo;
    private String fileName;
    private boolean isObject = false;
    private DebugMozillaFireFoxJavaScript debugger;

    public DebugMozillaFireFoxClassInfo(String name, int count, DebugMozillaFireFoxClassLoaderInfo classLoaderInfo, DebugMozillaFireFoxJavaScript debugger) {
        this.name = name;
        this.count = count;
        this.classLoaderInfo = classLoaderInfo;
        this.fileName = name;
        this.debugger = debugger;
    }

    public DebugMozillaFireFoxClassInfo(int type, DebugMozillaFireFoxClassInfo classInfo, DebugMozillaFireFoxJavaScript debugger) {
        this.setNameFromType(type);
        this.count = -1;
        if (classInfo != null) {
            this.classLoaderInfo = (DebugMozillaFireFoxClassLoaderInfo)classInfo.getClassLoader();
            this.fileName = classInfo.getFileName();
        }
        this.debugger = debugger;
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPackage() {
        return "";
    }

    @Override
    public String getPackagePath() {
        return "";
    }

    @Override
    public String getNameWithoutPackage() {
        return this.name;
    }

    @Override
    public String getGenericSignature() {
        return null;
    }

    @Override
    public int getAccess() {
        return 0;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return !this.isObject;
    }

    @Override
    public boolean isObject() {
        return this.isObject;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public int getSizeOfObject() {
        return 0;
    }

    @Override
    public long countObjectsOfClass() {
        return this.count;
    }

    @Override
    public int countMemoryOfClass() {
        return 0;
    }

    @Override
    public DebugDataObjectInfo getClassObject() {
        return null;
    }

    @Override
    public DebugDataObjectInfo getClassLoaderObject() {
        return null;
    }

    @Override
    public DebugClassLoaderInfo getClassLoader() {
        return this.classLoaderInfo;
    }

    @Override
    public String getPrimarySourceFilename() {
        return this.getSourceFilename();
    }

    @Override
    public String getSourceFilename() {
        URL url = this.getSourceNameUrl();
        return url == null ? "" : url.getFile();
    }

    @Override
    public DebugClassInfo getSuperClass(int level) {
        return null;
    }

    @Override
    public int getMethodCount() {
        return 0;
    }

    @Override
    public DebugMethodInfo[] getMethods() {
        return new DebugMethodInfo[0];
    }

    @Override
    public int getStaticFieldCount() {
        return 0;
    }

    @Override
    public DebugFieldInfo[] getStaticFields() {
        return new DebugFieldInfo[0];
    }

    @Override
    public DebugFieldInfo getStaticField(int index) {
        return null;
    }

    @Override
    public int getStaticFieldCount(int classLevel) {
        return 0;
    }

    @Override
    public DebugFieldInfo[] getStaticFields(int classLevel) {
        return new DebugFieldInfo[0];
    }

    @Override
    public DebugFieldInfo getStaticField(int classLevel, int index) {
        return null;
    }

    @Override
    public int getStaticFieldCount(int classLevel, boolean noFinal) {
        return 0;
    }

    @Override
    public DebugFieldInfo[] getStaticFields(int classLevel, boolean noFinal) {
        return new DebugFieldInfo[0];
    }

    @Override
    public DebugFieldInfo getStaticField(int classLevel, boolean noFinal, int index) {
        return null;
    }

    @Override
    public DebugFieldInfo getStaticField(String name) {
        return null;
    }

    @Override
    public int getFieldCount(int classLevel) {
        return 0;
    }

    @Override
    public DebugFieldInfo[] getFields(int classLevel) {
        return new DebugFieldInfo[0];
    }

    @Override
    public DebugFieldInfo getField(int classLevel, int index) {
        return null;
    }

    @Override
    public int getFieldCount(int classLevel, boolean noFinal) {
        return 0;
    }

    @Override
    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal) {
        return new DebugFieldInfo[0];
    }

    @Override
    public DebugFieldInfo getField(int classLevel, boolean noFinal, int index) {
        return null;
    }

    @Override
    public int getFieldCount(int classLevel, boolean noFinal, boolean noStatic) {
        return 0;
    }

    @Override
    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal, boolean noStatic) {
        return new DebugFieldInfo[0];
    }

    @Override
    public DebugFieldInfo getField(int classLevel, boolean noFinal, boolean noStatic, int index) {
        return null;
    }

    @Override
    public boolean isDebuggable() {
        return true;
    }

    @Override
    public void setDebuggable(boolean debuggable) {
    }

    @Override
    public boolean isObfuscated() {
        return false;
    }

    @Override
    public boolean isCodeCoverage() {
        return false;
    }

    @Override
    public void setCodeCoverage(boolean codeCoverage) {
    }

    @Override
    public void discardCodeCoverage() {
    }

    @Override
    public double getCodeCoverageRatio() {
        return 0.0;
    }

    @Override
    public DebugClassInfo[] getInterfaces() {
        return new DebugClassInfo[0];
    }

    @Override
    public DebugClassInfo[] getInterfaces(int classLevel) {
        return new DebugClassInfo[0];
    }

    @Override
    public int getLanguage() {
        return 16;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public DebugFieldInfo[] getEnumConstants() {
        return new DebugFieldInfo[0];
    }

    public URL getSourceNameUrl() {
        URL newUrl;
        URL url = URLFactory.newURL((String)this.name);
        if (url != null && url.getProtocol().equals("file")) {
            return url;
        }
        url = MozillaFireFoxJavaScriptFileSystemHelper.getInstance(true).addSourceName(this.debugger, this.name, 0);
        if (!(url != null && url.getProtocol().equals("file") || (newUrl = URLFactory.newURL((String)this.name)) == null)) {
            String file = newUrl.getFile();
            URL htmlRoot = J2eeSettings.getInstance((Project)Ide.getActiveProject()).getHtmlRootDirectory();
            while (true) {
                URL u;
                if ((u = URLFactory.newURL((URL)htmlRoot, (String)("." + file))) != null && URLFileSystem.exists((URL)u)) {
                    return u;
                }
                int index = file.indexOf("/", 1);
                if (index == -1) break;
                file = file.substring(index);
            }
        }
        return url;
    }

    public String getFileName() {
        return this.fileName;
    }

    private void setNameFromType(int type) {
        switch (type) {
            case 0: {
                this.name = "boolean";
                break;
            }
            case 1: {
                this.name = "double";
                break;
            }
            case 2: {
                this.name = "int";
                break;
            }
            case 3: {
                this.name = "function";
                break;
            }
            case 4: {
                this.name = "null";
                break;
            }
            case 5: {
                this.name = "object";
                break;
            }
            case 6: {
                this.name = "string";
                break;
            }
            case 7: {
                this.name = "void";
                break;
            }
            default: {
                this.name = "unknown";
            }
        }
        this.isObject = DebugMozillaFireFoxDataInfo.isObject(type);
    }

    @Override
    public int getConstantPoolCount() {
        return 0;
    }

    @Override
    public byte[] getConstantPool() {
        return new byte[0];
    }
}

