/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.Project;
import oracle.ide.net.JarUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunMgrArb;
import oracle.jdevimpl.runner.xslt.XSLTConfiguration;

public class RunConfigurations
extends HashStructureAdapter {
    public static final String DATA_KEY = RunConfigurations.class.getName();
    public static final String RUN_CONFIGURATION_DEFINITIONS = "runConfigurationDefinitions";
    public static final String RUN_CONFIGURATION_LIST = "runConfigurationList";
    private static final String ACTIVE_NAME = "activeName";

    public RunConfigurations(HashStructure hash) {
        super(hash);
    }

    private static HashStructure getRunConfigurationsProperties(PropertyStorage propertyData) {
        return RunConfigurations.findOrCreate((PropertyStorage)propertyData, (String)DATA_KEY);
    }

    public static RunConfigurations getInstance(PropertyStorage propertyStorage) {
        return new RunConfigurations(RunConfigurations.getRunConfigurationsProperties(propertyStorage));
    }

    public static void projectCreated(Project project) {
        RunConfigurations.migrate(project, true);
    }

    public static void projectMigrating(Project project) {
        RunConfigurations.migrate(project, true);
    }

    public static void projectCheck(final Project project) {
        if (!JarUtil.isJarURL((URL)project.getURL())) {
            project.getProperties().applyBatchChanges(new Runnable(){

                @Override
                public void run() {
                    RunConfigurations.migrate(project, true);
                    RunConfigurations.migrate(project, false);
                }
            });
        }
    }

    private static void migrate(Project project, boolean shared) {
        HashStructure projectProperties;
        HashStructure hashStructure = projectProperties = shared ? project.getSharedPropertiesOnly() : project.getUserPropertiesOnly();
        if (projectProperties != null && !projectProperties.containsKey(DATA_KEY)) {
            String singleRunConfigurationDataKey = RunConfiguration.class.getName();
            HashStructure runConfigurationHashStructure = projectProperties.getHashStructure(singleRunConfigurationDataKey);
            if (runConfigurationHashStructure != null) {
                projectProperties.remove(singleRunConfigurationDataKey);
            } else if (shared) {
                runConfigurationHashStructure = HashStructure.newInstance();
            }
            String singleXSLTConfigurationDataKey = XSLTConfiguration.class.getName();
            HashStructure xsltConfigurationHashStructure = projectProperties.getHashStructure(singleXSLTConfigurationDataKey);
            if (xsltConfigurationHashStructure != null) {
                projectProperties.remove(singleXSLTConfigurationDataKey);
                if (runConfigurationHashStructure != null) {
                    runConfigurationHashStructure.putHashStructure(XSLTConfiguration.DATA_KEY, xsltConfigurationHashStructure);
                }
            }
            if (runConfigurationHashStructure != null) {
                RunConfiguration runConfiguration = new RunConfiguration(runConfigurationHashStructure);
                String name = shared ? RunMgrArb.getString(0) : RunMgrArb.getString(1);
                runConfiguration.setName(name);
                runConfiguration.setCustom(!shared);
                RunConfigurations.addRunConfiguration(project, runConfiguration);
            }
        }
    }

    public static void addRunConfiguration(Project project, RunConfiguration runConfiguration) {
        boolean custom = runConfiguration.isCustom();
        String name = runConfiguration.getName();
        HashStructure runConfigurationHashStructure = runConfiguration.getProperties();
        HashStructure projectProperties = custom ? project.getUserPropertiesOnly() : project.getSharedPropertiesOnly();
        HashStructure runConfigurationsProperties = projectProperties.getOrCreateHashStructure(DATA_KEY);
        HashStructure runConfigurationDefinitions = runConfigurationsProperties.getOrCreateHashStructure(RUN_CONFIGURATION_DEFINITIONS);
        runConfigurationDefinitions.putHashStructure(name, runConfigurationHashStructure);
        ListStructure runConfigurationList = runConfigurationsProperties.getOrCreateListStructure(RUN_CONFIGURATION_LIST);
        runConfigurationList.add((Object)name);
    }

    private HashStructure getRunConfigurationDefinitions() {
        return this._hash.getOrCreateHashStructure(RUN_CONFIGURATION_DEFINITIONS);
    }

    private ListStructure getRunConfigurationList() {
        return this._hash.getOrCreateListStructure(RUN_CONFIGURATION_LIST);
    }

    public static String getActiveName(Project project) {
        if (project == null || project.getUserPropertiesOnly() == null || project.getUserPropertiesOnly().getOrCreateHashStructure(DATA_KEY) == null) {
            return RunMgrArb.getString(0);
        }
        HashStructure customProjectProperties = project.getUserPropertiesOnly();
        HashStructure customRunConfigurations = customProjectProperties.getOrCreateHashStructure(DATA_KEY);
        String activeName = customRunConfigurations.getString(ACTIVE_NAME);
        RunConfigurations runConfigurations = RunConfigurations.getInstance((PropertyStorage)project);
        ListStructure runConfigurationList = runConfigurations.getRunConfigurationList();
        HashStructure runConfigurationDefinitions = runConfigurations.getRunConfigurationDefinitions();
        if (activeName == null || !runConfigurationList.contains((Object)activeName) || !runConfigurationDefinitions.containsKey(activeName)) {
            activeName = RunMgrArb.getString(1);
        }
        if (activeName == null || !runConfigurationList.contains((Object)activeName) || !runConfigurationDefinitions.containsKey(activeName)) {
            activeName = RunMgrArb.getString(0);
        }
        if (activeName == null || !runConfigurationList.contains((Object)activeName) || !runConfigurationDefinitions.containsKey(activeName)) {
            int size = runConfigurationList.size();
            for (int i = 0; i < size; ++i) {
                String name = (String)runConfigurationList.get(i);
                if (!runConfigurationDefinitions.containsKey(name)) continue;
                activeName = name;
                customRunConfigurations.putString(ACTIVE_NAME, activeName);
                break;
            }
        }
        return activeName;
    }

    private static void setActiveName(Project project, String activeName) {
        HashStructure customProjectProperties = project.getUserPropertiesOnly();
        HashStructure customRunConfigurations = customProjectProperties.getOrCreateHashStructure(DATA_KEY);
        customRunConfigurations.putString(ACTIVE_NAME, activeName);
    }

    public Map getDefinedRunConfigurations() {
        HashMap<String, RunConfiguration> map = new HashMap<String, RunConfiguration>();
        HashStructure runConfigurationDefinitions = this.getRunConfigurationDefinitions();
        for (String name : runConfigurationDefinitions.keySet()) {
            HashStructure runConfigurationHashStructure = runConfigurationDefinitions.getHashStructure(name);
            RunConfiguration runConfiguration = new RunConfiguration(runConfigurationHashStructure);
            map.put(name, runConfiguration);
        }
        return map;
    }

    public RunConfiguration[] getVisibleRunConfigurations() {
        ArrayList<RunConfiguration> list = new ArrayList<RunConfiguration>();
        ListStructure runConfigurationList = this.getRunConfigurationList();
        HashStructure runConfigurationDefinitions = this.getRunConfigurationDefinitions();
        for (int i = runConfigurationList.size() - 1; i >= 0; --i) {
            String name = (String)runConfigurationList.get(i);
            HashStructure runConfigurationHashStructure = runConfigurationDefinitions.getHashStructure(name);
            if (runConfigurationHashStructure != null) {
                RunConfiguration runConfiguration = new RunConfiguration(runConfigurationHashStructure);
                list.add(0, runConfiguration);
                continue;
            }
            runConfigurationList.remove(i);
        }
        return list.toArray(new RunConfiguration[list.size()]);
    }

    public void setRunConfigurations(RunConfiguration[] runConfigs, boolean editingCustomProperties) {
        HashStructure runConfigurationDefinitions = this.getRunConfigurationDefinitions();
        ArrayList<String> tempList = new ArrayList<String>();
        int size = runConfigs.length;
        for (int i = 0; i < size; ++i) {
            String name = runConfigs[i].getName();
            tempList.add(name);
            if (runConfigurationDefinitions.containsKey(name)) continue;
            runConfigurationDefinitions.putHashStructure(name, runConfigs[i].getProperties());
        }
        Collections.sort(tempList);
        ListStructure runConfigurationList = this.getRunConfigurationList();
        runConfigurationList.mirror(tempList);
        String[] names = runConfigurationDefinitions.keySet().toArray(new String[runConfigurationDefinitions.size()]);
        for (int i = names.length - 1; i >= 0; --i) {
            String name = names[i];
            HashStructure runConfigurationHashStructure = runConfigurationDefinitions.getHashStructure(name);
            RunConfiguration runConfiguration = new RunConfiguration(runConfigurationHashStructure);
            if (runConfiguration.isCustom() != editingCustomProperties || tempList.contains(name)) continue;
            runConfigurationDefinitions.remove(name);
        }
    }

    public static boolean isActiveRunConfiguration(Project project, RunConfiguration runConfiguration) {
        return RunConfigurations.getActiveName(project).equals(runConfiguration.getName());
    }

    public static void setActiveRunConfiguration(Project project, RunConfiguration runConfiguration) {
        RunConfigurations.setActiveName(project, runConfiguration.getName());
    }

    private static RunConfiguration getRunConfigurationByName(Project project, String name, boolean createTemp) {
        RunConfigurations runConfigurations = RunConfigurations.getInstance((PropertyStorage)project);
        HashStructure runConfigurationDefinitions = runConfigurations.getRunConfigurationDefinitions();
        HashStructure runConfigurationHashStructure = runConfigurationDefinitions.getHashStructure(name);
        if (runConfigurationHashStructure == null) {
            if (createTemp) {
                runConfigurationHashStructure = HashStructure.newInstance();
            } else {
                return null;
            }
        }
        RunConfiguration runConfiguration = new RunConfiguration(runConfigurationHashStructure);
        return runConfiguration;
    }

    public static RunConfiguration getRunConfigurationByName(Project project, String name) {
        return RunConfigurations.getRunConfigurationByName(project, name, false);
    }

    public static RunConfiguration getActiveRunConfiguration(Project project) {
        String name = RunConfigurations.getActiveName(project);
        return RunConfigurations.getRunConfigurationByName(project, name, true);
    }
}

