/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.GridBagConstraints2;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.HistoryList;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.JDebugger;

public final class RemoteConnectDialog {
    private JEWTDialog dlg;
    private JPanel panel = new JPanel(new GridBagLayout());
    private Listener listener = new Listener();
    private int count;
    private String[] names;
    private String[] values;
    private boolean[] allowBlanks;
    private boolean[] save;
    private JLabel[] labels;
    private HistoryList[] historyLists;
    private JComboBox[] comboBoxes;
    private JTextField[] editors;
    private JCheckBox saveCheckBox;
    private JCheckBox attachToDebugWithPid = null;
    private JCheckBox attachToLiveWithPid = null;
    private boolean[] isAttachPid = null;
    private int subIndex = -1;
    private static final String HistoryNamePrefix = "RemoteConnect";

    public static boolean showRemoteConnectDialog(String title, String[] names, String[] values, boolean[] allowBlanks) {
        return RemoteConnectDialog.showRemoteConnectDialog(title, names, values, allowBlanks, null, null, null);
    }

    public static boolean showRemoteConnectDialog(String title, String[] names, String[] values, boolean[] allowBlanks, String helpId) {
        return RemoteConnectDialog.showRemoteConnectDialog(title, names, values, allowBlanks, null, helpId, null);
    }

    public static boolean showRemoteConnectDialog(String title, String[] names, String[] values, boolean[] allowBlanks, boolean[] save) {
        return RemoteConnectDialog.showRemoteConnectDialog(title, names, values, allowBlanks, save, null, null);
    }

    public static boolean showRemoteConnectDialog(String title, String[] names, String[] values, boolean[] allowBlanks, boolean[] save, String helpId) {
        return RemoteConnectDialog.showRemoteConnectDialog(title, names, values, allowBlanks, save, helpId, null);
    }

    public static boolean showRemoteConnectDialog(String title, String[] names, String[] values, boolean[] allowBlanks, boolean[] save, String helpId, boolean[] isAttachPid) {
        int count = names.length;
        if (values.length != count) {
            throw new IllegalArgumentException("values.length must equal names.length");
        }
        if (allowBlanks.length != count) {
            throw new IllegalArgumentException("allowBlanks.length must equal names.length");
        }
        if (save != null && save.length != 1) {
            throw new IllegalArgumentException("save.length must be 1");
        }
        RemoteConnectDialog rcd = new RemoteConnectDialog(names, values, allowBlanks, save, isAttachPid);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)rcd.panel, (Component)rcd.getInitialFocus(), (String)title);
        rcd.setJEWTDialog(dlg);
        rcd.setLabels();
        dlg.setOKButtonEnabled(rcd.canOk());
        if (helpId != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)rcd.panel, helpId);
        }
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            rcd.finish();
            return true;
        }
        return false;
    }

    private RemoteConnectDialog(String[] names, String[] values, boolean[] allowBlanks, boolean[] save, boolean[] isAttachPid) {
        int jdiAttachMethodIndex = -1;
        int substr = 0;
        for (int n = 0; n < names.length; ++n) {
            if (!names[n].equals("jdi_attach_method:")) continue;
            jdiAttachMethodIndex = n;
            ++substr;
            this.subIndex = n;
            break;
        }
        this.count = names.length;
        this.names = names;
        this.values = values;
        this.allowBlanks = allowBlanks;
        this.save = save;
        this.isAttachPid = isAttachPid;
        int y = 0;
        this.labels = new JLabel[this.count - substr];
        this.comboBoxes = new JComboBox[this.count - substr];
        this.editors = new JTextField[this.count - substr];
        this.historyLists = new HistoryList[this.count - substr];
        int substract = 0;
        for (int i = 0; i < this.count; ++i) {
            if (i == jdiAttachMethodIndex) {
                ++substract;
                continue;
            }
            this.labels[i - substract] = new JLabel();
            this.historyLists[i - substract] = Ide.loadHistoryList((String)(HistoryNamePrefix + names[i]));
            String[] choices = JDebugger.filterBlanksFromHistoryList(this.historyLists[i - substract].getHistory());
            this.comboBoxes[i - substract] = new JComboBox<String>(choices);
            this.comboBoxes[i - substract].setEditable(true);
            this.editors[i - substract] = (JTextField)this.comboBoxes[i - substract].getEditor().getEditorComponent();
            this.comboBoxes[i - substract].addActionListener(this.listener);
            JDebugger.selectHistoryString(this.comboBoxes[i - substract], values[i - substract]);
            IdeUtil.addComboBoxDocumentListener((JComboBox)this.comboBoxes[i - substract], (DocumentListener)this.listener);
            this.comboBoxes[i - substract].addItemListener(this.listener);
            this.panel.add((Component)this.labels[i - substract], new GridBagConstraints2(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
            this.panel.add((Component)this.comboBoxes[i - substract], new GridBagConstraints2(1, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        if (save != null) {
            this.saveCheckBox = new JCheckBox();
            ResourceUtils.resButton((AbstractButton)this.saveCheckBox, (String)RunMgrArb.getString(21));
            this.panel.add((Component)this.saveCheckBox, new GridBagConstraints2(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        }
        this.panel.add((Component)new JLabel(), new GridBagConstraints2(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private Component getInitialFocus() {
        if (this.editors.length > 0) {
            return this.editors[0];
        }
        return null;
    }

    private void setJEWTDialog(JEWTDialog dlg) {
        this.dlg = dlg;
    }

    private void setLabels() {
        int mn;
        int buttonMask;
        int mn2;
        ArrayList<Integer> mnemonics = new ArrayList<Integer>();
        if (this.saveCheckBox != null && (mn2 = this.saveCheckBox.getMnemonic()) != 0) {
            mnemonics.add(new Integer(mn2));
        }
        if (this.attachToDebugWithPid != null && (mn2 = this.attachToDebugWithPid.getMnemonic()) != 0) {
            mnemonics.add(new Integer(mn2));
        }
        if (this.attachToLiveWithPid != null && (mn2 = this.attachToLiveWithPid.getMnemonic()) != 0) {
            mnemonics.add(new Integer(mn2));
        }
        if (((buttonMask = this.dlg.getButtonMask()) & 1) != 0 && (mn = this.dlg.getButtonMnemonic(1)) != 0) {
            mnemonics.add(new Integer(mn));
        }
        if ((buttonMask & 2) != 0 && (mn = this.dlg.getButtonMnemonic(2)) != 0) {
            mnemonics.add(new Integer(mn));
        }
        if ((buttonMask & 4) != 0 && (mn = this.dlg.getButtonMnemonic(4)) != 0) {
            mnemonics.add(new Integer(mn));
        }
        if ((buttonMask & 8) != 0 && (mn = this.dlg.getButtonMnemonic(8)) != 0) {
            mnemonics.add(new Integer(mn));
        }
        int substract = 0;
        for (int i = 0; i < this.count; ++i) {
            if (this.names[i].equals("jdi_attach_method:")) {
                ++substract;
                continue;
            }
            String n = this.names[i];
            for (int ic = 0; ic < n.length(); ++ic) {
                Integer m;
                char c = n.charAt(ic);
                if (c >= 'a' && c <= 'z') {
                    c = (char)(c - 32);
                }
                if ((c < 'A' || c > 'Z') && (c < '0' || c > '9') || mnemonics.contains(m = new Integer(c))) continue;
                mnemonics.add(m);
                n = n.substring(0, ic) + "&" + n.substring(ic);
                break;
            }
            ResourceUtils.resLabel((JLabel)this.labels[i - substract], (Component)this.editors[i - substract], (String)RunMgrArb.format(20, n));
        }
    }

    private void enableOk() {
        this.dlg.setOKButtonEnabled(this.canOk());
    }

    private boolean canOk() {
        int substract = 0;
        for (int i = 0; i < this.count; ++i) {
            String value;
            if (i == this.subIndex) {
                ++substract;
                continue;
            }
            if (this.allowBlanks[i - substract] || (value = this.editors[i - substract].getText()).length() != 0) continue;
            return false;
        }
        return true;
    }

    private void finish() {
        int substract = 0;
        for (int i = 0; i < this.count; ++i) {
            if (i == this.subIndex) {
                ++substract;
                ++substract;
            }
            HistoryList list = this.historyLists[i - substract];
            String s = list.comboBoxGetSelectedItem(this.comboBoxes[i - substract]);
            this.values[i - substract] = s.trim();
        }
        if (this.save != null) {
            this.save[0] = this.saveCheckBox.isSelected();
        }
        if (this.attachToDebugWithPid != null) {
            this.isAttachPid[1] = this.attachToDebugWithPid.isSelected();
        }
        if (this.attachToLiveWithPid != null) {
            this.isAttachPid[2] = this.attachToLiveWithPid.isSelected();
        }
    }

    class Listener
    implements ActionListener,
    DocumentListener,
    ItemListener {
        Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (RemoteConnectDialog.this.attachToDebugWithPid != null && RemoteConnectDialog.this.attachToDebugWithPid == source) {
                if (RemoteConnectDialog.this.attachToLiveWithPid != null && RemoteConnectDialog.this.attachToLiveWithPid.isSelected()) {
                    RemoteConnectDialog.this.attachToLiveWithPid.setSelected(false);
                }
                if (RemoteConnectDialog.this.attachToDebugWithPid.isSelected()) {
                    RemoteConnectDialog.this.comboBoxes[0].setSelectedItem(null);
                    RemoteConnectDialog.this.comboBoxes[0].setEnabled(false);
                } else {
                    RemoteConnectDialog.this.comboBoxes[0].setEnabled(true);
                }
                return;
            }
            if (RemoteConnectDialog.this.attachToLiveWithPid != null && RemoteConnectDialog.this.attachToLiveWithPid == source) {
                if (RemoteConnectDialog.this.attachToDebugWithPid != null && RemoteConnectDialog.this.attachToDebugWithPid.isSelected()) {
                    RemoteConnectDialog.this.attachToDebugWithPid.setSelected(false);
                }
                if (RemoteConnectDialog.this.attachToLiveWithPid.isSelected()) {
                    RemoteConnectDialog.this.comboBoxes[0].setSelectedItem(null);
                    RemoteConnectDialog.this.comboBoxes[0].setEnabled(false);
                } else {
                    RemoteConnectDialog.this.comboBoxes[0].setEnabled(true);
                }
                return;
            }
            int substract = 0;
            for (int i = 0; i < RemoteConnectDialog.this.count; ++i) {
                if (i == RemoteConnectDialog.this.subIndex) {
                    ++substract;
                    continue;
                }
                if (source != RemoteConnectDialog.this.comboBoxes[i - substract]) continue;
                RemoteConnectDialog.this.editors[i - substract].setText((String)RemoteConnectDialog.this.comboBoxes[i - substract].getSelectedItem());
                break;
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            RemoteConnectDialog.this.enableOk();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            RemoteConnectDialog.this.enableOk();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            RemoteConnectDialog.this.enableOk();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            RemoteConnectDialog.this.enableOk();
        }
    }
}

