/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.lang.reflect.Constructor;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.panels.MetaTraversable;
import oracle.ide.panels.NavigableContext;
import oracle.ide.util.Namespace;
import oracle.javatools.util.ModelUtil;

public class Navigable
extends MetaTraversable {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final String DEFAULT_CHILD_COMPARATOR_KEY = "Navigable.DEFAULT_CHILD_COMPARATOR_KEY";
    public static final Comparator NAVIGABLE_COMPARATOR = new NavigableComparator();
    private String _shortLabel;
    private String _rawShortLabel;
    private Navigable[] _childNavigables;
    private int _displayStyle;
    private Comparator _childComparator;
    private transient Namespace _dataScope;

    protected Navigable(String shortLabel) {
        this(shortLabel, null, null);
    }

    public Navigable(String shortLabel, Class traversableClass) {
        this(shortLabel, traversableClass, null);
    }

    public Navigable(String shortLabel, Class traversableClass, Navigable[] childNavigables) {
        super(traversableClass);
        this._rawShortLabel = shortLabel;
        this._childNavigables = childNavigables;
    }

    public Navigable(String shortLabel, Class traversableClass, Class[] constructorArgTypes, Object[] constructorArgs, Navigable[] childNavigables) {
        super(traversableClass, constructorArgTypes, constructorArgs);
        this._rawShortLabel = shortLabel;
        this._childNavigables = childNavigables;
    }

    protected Navigable() {
    }

    @Override
    public Object copyTo(Object target) {
        Navigable copy;
        if (target == null) {
            try {
                Class<?> targetClass = this.getClass();
                Constructor<?> ctor = targetClass.getDeclaredConstructor(null);
                ctor.setAccessible(true);
                copy = (Navigable)ctor.newInstance(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                copy = new Navigable(null);
            }
        } else {
            copy = (Navigable)target;
        }
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(Navigable copy) {
        super.copyToImpl(copy);
        copy._shortLabel = this._shortLabel;
        copy._rawShortLabel = this._rawShortLabel;
        if (this._childNavigables != null) {
            int n = this._childNavigables.length;
            Navigable[] navigables = new Navigable[n];
            for (int i = 0; i < n; ++i) {
                Navigable nav = this._childNavigables[i];
                navigables[i] = nav != null ? (Navigable)nav.copyTo(null) : null;
            }
            copy._childNavigables = navigables;
        } else {
            copy._childNavigables = null;
        }
        copy._childComparator = this._childComparator;
    }

    public String getShortLabel() {
        if (this._shortLabel == null) {
            this._shortLabel = StringUtils.stripMnemonic((String)this._rawShortLabel);
        }
        return this._shortLabel;
    }

    public String getRawShortLabel() {
        return this._rawShortLabel;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public String toString() {
        return this.getShortLabel();
    }

    public int getDisplayStyle() {
        return this._displayStyle;
    }

    public void setDisplayStyle(int displayStyle) {
        if (displayStyle < 0 || displayStyle > 2) {
            throw new IllegalArgumentException();
        }
        this._displayStyle = displayStyle;
    }

    public void setShortLabel(String shortLabel) {
        this._shortLabel = shortLabel;
    }

    public void setChildComparator(Comparator customComparator) {
        this._childComparator = customComparator;
    }

    protected Comparator getChildComparator() {
        return this._childComparator;
    }

    public Navigable[] getChildren() {
        return this.getChildNavigables();
    }

    public DefaultMutableTreeNode createTreeNode(NavigableContext nc) {
        this.setDataScope(nc.getScope());
        DefaultMutableTreeNode treeNode = this.createTreeNodeImpl(nc);
        return treeNode;
    }

    public DefaultMutableTreeNode createDetailRootNode(NavigableContext nc) {
        DefaultMutableTreeNode detailRoot = new DefaultMutableTreeNode();
        this.appendDetailNavigables(detailRoot, nc);
        return detailRoot;
    }

    public void addChildNavigable(Navigable childNavigable) {
        if (this._childNavigables == null || this._childNavigables.length == 0) {
            this._childNavigables = new Navigable[]{childNavigable};
        } else {
            int n = this._childNavigables.length;
            Navigable[] newChildNavigables = new Navigable[n + 1];
            System.arraycopy(this._childNavigables, 0, newChildNavigables, 0, n);
            newChildNavigables[n] = childNavigable;
            this.setChildNavigables(newChildNavigables);
        }
    }

    void lazyLoadChildNavigables(DefaultMutableTreeNode parent, NavigableContext nc) {
        if (nc != null && nc.displayDetailNodesAsChildren()) {
            this.appendDetailNavigables(parent, nc);
        }
        this.appendChildNavigables(parent, nc);
    }

    protected void setDataScope(Namespace dataScope) {
        this._dataScope = dataScope;
    }

    protected Navigable[] getChildNavigables() {
        return this._childNavigables;
    }

    protected void setChildNavigables(Navigable[] childNavigables) {
        this._childNavigables = childNavigables;
    }

    protected Navigable[] getDetailNavigables() {
        return null;
    }

    protected DefaultMutableTreeNode createTreeNodeImpl(NavigableContext nc) {
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(this);
        if (this.mayHaveChildren(nc)) {
            treeNode.add(new DefaultMutableTreeNode(nc, false));
        }
        return treeNode;
    }

    protected void appendChildNavigables(DefaultMutableTreeNode parent, NavigableContext nc) {
        Navigable[] childNavigables = this.getChildNavigables();
        this.appendChildNodes(parent, childNavigables, nc);
    }

    protected void appendChildNodes(DefaultMutableTreeNode parent, Navigable[] children, NavigableContext nc) {
        if (children == null) {
            return;
        }
        Comparator comparator = this._childComparator != null || nc == null ? this._childComparator : (Comparator)nc.getScope().find(DEFAULT_CHILD_COMPARATOR_KEY);
        for (Navigable child : Navigable.sortNavigables(children, comparator)) {
            DefaultMutableTreeNode childNode;
            if (child == null || (childNode = child.createTreeNode(nc)) == null) continue;
            parent.insert(childNode, parent.getChildCount());
        }
    }

    protected void appendDetailNavigables(DefaultMutableTreeNode parent, NavigableContext nc) {
        Navigable[] detailNavigables = this.getDetailNavigables();
        this.appendChildNodes(parent, detailNavigables, nc);
    }

    protected static Navigable[] sortNavigables(Navigable[] navigables, Comparator comparator) {
        if (comparator == null || navigables == null || navigables.length < 2) {
            return navigables;
        }
        int size = navigables.length;
        Navigable[] sortedNavigables = new Navigable[size];
        System.arraycopy(navigables, 0, sortedNavigables, 0, size);
        Arrays.sort(sortedNavigables, comparator);
        return sortedNavigables;
    }

    protected boolean mayHaveChildren(NavigableContext nc) {
        Navigable[] details;
        Navigable[] children = this.getChildNavigables();
        if (children != null && children.length > 0) {
            return true;
        }
        return nc.displayDetailNodesAsChildren() && (details = this.getDetailNavigables()) != null && details.length > 0;
    }

    Namespace getDataScope() {
        return this._dataScope;
    }

    public static class NavigableComparator
    implements Comparator {
        protected static final Collator COLLATOR = Collator.getInstance();
        private String _firstItemLabel;

        public NavigableComparator() {
        }

        public NavigableComparator(String firstItemLabel) {
            this();
            this.setFirstItemLabel(firstItemLabel);
        }

        public void setFirstItemLabel(String firstItemLabel) {
            this._firstItemLabel = firstItemLabel;
        }

        public String getFirstItemLabel() {
            return this._firstItemLabel;
        }

        public int compare(Object o1, Object o2) {
            String label1 = ((Navigable)o1).getShortLabel();
            String label2 = ((Navigable)o2).getShortLabel();
            if (this._firstItemLabel != null) {
                if (ModelUtil.areEqual((Object)label1, (Object)this._firstItemLabel)) {
                    return ModelUtil.areEqual((Object)label2, (Object)this._firstItemLabel) ? 0 : -1;
                }
                if (ModelUtil.areEqual((Object)label2, (Object)this._firstItemLabel)) {
                    return 1;
                }
            }
            if (label1 == label2) {
                return 0;
            }
            if (label1 == null) {
                return -1;
            }
            if (label2 == null) {
                return 1;
            }
            return COLLATOR.compare(label1, label2);
        }
    }
}

