/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.xdiffer;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.MessageDigest;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.VxxString;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLText;
import org.apache.log4j.Category;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CMDomHash {
    private static Category s_log = Category.getInstance(CMDomHash.class);
    private static String s_property_hash = "DOMHash";
    private static String s_digest_algo = "MD5";
    private static String s_unicodebigunmarked = "UnicodeBigUnmarked";
    private MessageDigest m_md;
    private boolean m_logicalCompare;

    public CMDomHash() {
        block2: {
            this.m_logicalCompare = false;
            try {
                this.m_md = MessageDigest.getInstance(s_digest_algo);
            }
            catch (Exception e) {
                if (!s_log.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
    }

    void setLogicalCompare(boolean logical) {
        this.m_logicalCompare = logical;
    }

    public byte[] getDOMHash(Node node) {
        return this.getDOMHash(node, false);
    }

    public byte[] getDOMHash(Node node, boolean checkDef) {
        byte[] retValue = null;
        switch (node.getNodeType()) {
            case 3: {
                retValue = this.getDigestTextNode((XMLText)node);
                break;
            }
            case 1: {
                retValue = this.getDigestElementNode((XMLElement)node, checkDef);
            }
        }
        return retValue;
    }

    public byte[] getDigestTextNode(XMLText node, boolean logicalText) {
        try {
            String text = node.getData().trim();
            if (logicalText) {
                text = VxxString.getLogicalSQLString(VxxString.insertSpacesForParenthesis(text));
            }
            this.m_md.update((byte)0);
            this.m_md.update((byte)0);
            this.m_md.update((byte)0);
            this.m_md.update((byte)3);
            this.m_md.update(text.getBytes(s_unicodebigunmarked));
            return this.m_md.digest();
        }
        catch (Exception e) {
            if (s_log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public byte[] getDigestTextNode(XMLText node) {
        return this.getDigestTextNode(node, false);
    }

    public byte[] getDigestElementNode(XMLElement node) {
        return this.getDigestElementNode(node, false);
    }

    public byte[] getDigestElementNode(XMLElement node, boolean checkDef) {
        try {
            String tagName = node.getTagName();
            boolean condition = false;
            if (this.m_logicalCompare) {
                condition = "CONDITION".equals(tagName);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(1);
            dos.write(tagName.getBytes(s_unicodebigunmarked));
            dos.write(0);
            dos.write(0);
            NodeList nl = node.getChildNodes();
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                Node n = nl.item(i);
                if (checkDef && n != null && n.getNodeType() == 1 && !"TRUE".equalsIgnoreCase(((XMLElement)n).getAttribute("COMPUTE_CONSTR_DEF"))) continue;
                if (condition && n != null && n.getNodeType() == 3) {
                    dos.write(this.getDigestTextNode((XMLText)n, true));
                    continue;
                }
                dos.write(this.getDOMHash(n));
            }
            dos.close();
            this.m_md.update(baos.toByteArray());
            return this.m_md.digest();
        }
        catch (Exception e) {
            if (s_log.isDebugEnabled()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static boolean hashValueEquals(byte[] hash1, byte[] hash2) {
        int l1 = hash1.length;
        int l2 = hash2.length;
        if (l1 != l2) {
            return false;
        }
        for (int i = 0; i < l1; ++i) {
            if (hash1[i] == hash2[i]) continue;
            return false;
        }
        return true;
    }
}

