/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletContext;
import javax.xml.parsers.ParserConfigurationException;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.CLOB;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.ApplyDiffListener;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.ApplyOneDiffResult;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMConnection;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMXMLUtils;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMXSLTransformInfo;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMXSLUtils;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.DDLUtils;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorClient;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessorSettings;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLDbLinkAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLIndexAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLIndexColumnsAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLMViewAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLMViewLogAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLPartitionsAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLProcAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLProfileAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLRbSegmentAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLRoleAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLSegmentAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLSequenceAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLSynonymAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLTSDatafileAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLTableAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLTableColumnsAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLTableConstraintsAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLTableIOTAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLTablespaceAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLTriggerAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLUserAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLViewAccessor;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.CMDiff;
import oracle.sysman.dbTarget.db.changemgr.emo.xdiffer.CMDomHash;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class XMLAccessor {
    private static final short UNITS_BYTES = 1;
    private static final short UNITS_KBYTES = 2;
    private static final short UNITS_MBYTES = 3;
    private static final short UNITS_GBYTES = 4;
    private static final short UNITS_TBYTES = 5;
    private XMLAccessorClient m_accessorClient = null;
    private boolean m_noRealDiffs = false;
    private String m_nonSxmlALterDDL = null;
    private boolean m_matchByDef = false;
    private boolean m_logicalCompare = true;
    private boolean m_ignHighValues = false;
    private boolean m_ignPtng = false;
    private ApplyDiffListener m_applyDiffListener = null;
    private CMDomHash m_dh = new CMDomHash();
    private XMLDocument m_diffDocument = null;
    private String m_compatibleVersion = null;
    private boolean m_appendStatistics = false;
    private int m_objectType = -1;
    private XMLNode m_xmlNode = null;
    private XMLNode m_xmlRoot = null;
    private HashMap m_schemaMap = null;
    private static String VALUE_1 = "value1";
    private static String EXPECTED_VALUE = "expected_value";
    private static String EXCLUDED = "excluded";
    private static String SRC = "src";
    private static String OLD_SRC = "1";
    private static String NEW_SRC = "2";
    private static String XPATH = "xpath";
    public static final String MDAPI_TABLE = "TABLE";
    public static final String MDAPI_INDEX = "INDEX";
    public static final String MDAPI_VIEW = "VIEW";
    public static final String MDAPI_TRIGGER = "TRIGGER";
    public static final String MDAPI_SYNONYM = "SYNONYM";
    public static final String MDAPI_PACKAGE = "PACKAGE";
    public static final String MDAPI_PACKAGE_SPEC = "PACKAGE_SPEC";
    public static final String MDAPI_PACKAGE_BODY = "PACKAGE_BODY";
    public static final String MDAPI_PROCEDURE = "PROCEDURE";
    public static final String MDAPI_FUNCTION = "FUNCTION";
    public static final String MDAPI_SEQUENCE = "SEQUENCE";
    public static final String MDAPI_DB_LINK = "DB_LINK";
    public static final String MDAPI_MATERIALIZED_VIEW = "MATERIALIZED_VIEW";
    public static final String MDAPI_MATERIALIZED_VIEW_LOG = "MATERIALIZED_VIEW_LOG";
    public static final String MDAPI_CLUSTER = "CLUSTER";
    public static final String MDAPI_TABLESPACE = "TABLESPACE";
    public static final String MDAPI_ROLLBACK_SEGMENT = "ROLLBACK_SEGMENT";
    public static final String MDAPI_USER = "USER";
    public static final String MDAPI_ROLE = "ROLE";
    public static final String MDAPI_PROFILE = "PROFILE";
    public static final String MDAPI_TYPE = "TYPE";
    private static String[] s_xformParams = new String[]{"PRETTY", "TABLESPACE", "PHYSICAL_PROPERTIES", "SEGMENT_ATTRIBUTES", "STORAGE", "CONSTRAINTS", "REF_CONSTRAINTS", "LRG", "SQLTERMINATOR", "BODY", "SPECIFICATION", "CM_MODE", "PRS_DDL", "PRS_CLAUSE_TYPE", "PRS_NAME", "FORCE", "PARAM_NOT_USED_2", "PARAM_NOT_USED_3", "PARAM_NOT_USED_4", "PRS_XPATH", "PRS_ALTERABLE", "MATCH_CONSTR_BY_DEFINITION", "IGNORE_NAME_DIFFERENCES", "USING_INDEX", "IGNORE_TBLCOL_NUM", "STATISTICS", "COMMENTS", "CONSTRAINTS_AS_ALTER", "PARTITIONING", "REUSE", "EMIT_SCHEMA"};
    protected static final String NS_PREFIX = "sxml:";
    protected static final String SEP = "/sxml:";
    protected static String X_COLUMN_LIST = "sxml:COL_LIST/sxml:COL_LIST_ITEM";
    protected static String X_NAME = "sxml:NAME";
    private static String NONE = "*none*";
    public static final int DDL_CREATE_LEFT = 1;
    public static final int DDL_CREATE_RIGHT = 2;
    public static final int DDL_ALTER_LEFT_TO_RIGHT = 3;
    public static final int DDL_ALTER_RIGHT_TO_LEFT = 4;
    public static final int DDL_DROP = 5;
    private static final HashMap s_MBDListNames = new HashMap();
    private static String s_getOneSchemaObjSXML;
    private static String s_getOneDepSchemaObjSXML;
    private static String s_getOneNonSchemaObjSXML;
    private static String s_getOneDepNonSchemaObjSXML;
    private static String s_getOneSchemaObjXML;
    private static String s_getOneDepSchemaObjXML;
    private static String s_getOneNonSchemaObjXML;
    private static String s_getOneDepNonSchemaObjXML;
    public static final String DIFF_NODES_PATTERN = "(//*[@src='1' and not (@no_diff)] | //*[@src='2' and not (@no_diff)] | //*[@value1 and not (@no_diff)])";
    protected static final String s_alterItemPath = "/sxml:ALTER_XML/sxml:ALTER_LIST/sxml:ALTER_LIST_ITEM";
    protected static final String s_sqlItemPath = "sxml:SQL_LIST/sxml:SQL_LIST_ITEM/sxml:TEXT";
    protected static final String s_notAlterablePath = "/sxml:ALTER_XML/sxml:ALTER_LIST/sxml:ALTER_LIST_ITEM/sxml:PARSE_LIST/sxml:PARSE_LIST_ITEM[sxml:ITEM=\"NOT_ALTERABLE\"]";

    public int getChangeMode() {
        if (this.m_accessorClient != null) {
            return this.m_accessorClient.getChangeMode();
        }
        return 0;
    }

    protected XMLAccessor() {
    }

    protected XMLAccessor(XMLAccessorClient client) {
        this.setAccessorClient(client);
    }

    protected XMLAccessor(XMLNode xmlDoc, XMLAccessorClient client) throws XMLAccessorException {
        this.setAccessorClient(client);
        this.initialize(xmlDoc);
    }

    protected void setAccessorClient(XMLAccessorClient client) {
        this.m_accessorClient = client;
        if (client != null && client instanceof XMLAccessorSettings) {
            XMLAccessorSettings xas = (XMLAccessorSettings)client;
            this.m_matchByDef = !xas.getMatchConstraintsByName();
            this.m_logicalCompare = xas.getLogicalCompare();
            this.m_ignHighValues = xas.getIgnoreHighValues();
            this.m_ignPtng = xas.getIgnorePartitioning();
        }
    }

    protected void setXmlNode(XMLNode node) {
        this.m_xmlNode = node;
    }

    protected XMLNode getXmlNode() {
        return this.m_xmlNode;
    }

    protected final XMLNode getXmlRoot() {
        return this.m_xmlRoot;
    }

    protected void setXmlRoot(XMLNode root) {
        this.m_xmlRoot = root;
    }

    protected HashMap getSchemaMap() {
        return this.m_schemaMap;
    }

    public void setXmlDoc(XMLNode xmlDoc) throws XMLAccessorException {
        String p = SEP + this.getTypePathElement();
        XMLNode topNode = XMLAccessor.getNode(xmlDoc, p);
        if (topNode == null) {
            throw new XMLAccessorException("Unable to find top node using path " + p);
        }
        this.m_xmlNode = topNode;
    }

    public void printXmlRoot(PrintStream ps) {
        try {
            this.m_xmlRoot.print((OutputStream)ps);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public XMLDocument getDocument() {
        if (this.m_xmlRoot instanceof XMLDocument) {
            return (XMLDocument)this.m_xmlRoot;
        }
        return null;
    }

    public static XMLAccessor getXMLAccessorForType(int type, XMLAccessorClient client) {
        XMLAccessor xa = null;
        switch (type) {
            case 17: {
                xa = new XMLRoleAccessor();
                break;
            }
            case 4: {
                xa = new XMLSynonymAccessor();
                break;
            }
            case 16: {
                xa = new XMLUserAccessor();
                break;
            }
            case 18: {
                xa = new XMLProfileAccessor();
                break;
            }
            case 3: {
                xa = new XMLTriggerAccessor();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: {
                xa = new XMLProcAccessor();
                break;
            }
            case 14: {
                xa = new XMLTablespaceAccessor();
                break;
            }
            case 15: {
                xa = new XMLRbSegmentAccessor();
                break;
            }
            case 104: {
                xa = new XMLTSDatafileAccessor();
                break;
            }
            case 2: {
                xa = new XMLViewAccessor();
                break;
            }
            case 9: {
                xa = new XMLSequenceAccessor();
                break;
            }
            case 10: {
                xa = new XMLDbLinkAccessor();
                break;
            }
            case 0: {
                xa = new XMLTableAccessor();
                break;
            }
            case 100: {
                xa = new XMLTableColumnsAccessor();
                break;
            }
            case 102: {
                xa = new XMLTableConstraintsAccessor();
                break;
            }
            case 101: {
                xa = new XMLSegmentAccessor();
                break;
            }
            case 103: {
                xa = new XMLTableIOTAccessor();
                break;
            }
            case 200: {
                xa = new XMLPartitionsAccessor();
                break;
            }
            case 1: {
                xa = new XMLIndexAccessor();
                break;
            }
            case 300: {
                xa = new XMLIndexColumnsAccessor();
                break;
            }
            case 301: {
                xa = new XMLSegmentAccessor();
                break;
            }
            case 11: {
                xa = new XMLMViewAccessor();
                break;
            }
            case 12: {
                xa = new XMLMViewLogAccessor();
                break;
            }
        }
        if (xa != null) {
            xa.setAccessorClient(client);
            xa.m_objectType = type;
        }
        return xa;
    }

    public static XMLAccessor getXMLAccessorForType(int type, XMLNode xmlNode) throws XMLAccessorException {
        return XMLAccessor.getXMLAccessorForType(type, xmlNode, null);
    }

    public static XMLAccessor getXMLAccessorForType(int type, XMLNode xmlNode, XMLAccessorClient client) throws XMLAccessorException {
        XMLAccessor xa = XMLAccessor.getXMLAccessorForType(type, client);
        xa.initialize(xmlNode);
        return xa;
    }

    public static int MDAPITypeToIntType(String tName) {
        int oType = -1;
        if (tName.equals(MDAPI_TABLE)) {
            oType = 0;
        } else if (tName.equals(MDAPI_INDEX)) {
            oType = 1;
        } else if (tName.equals(MDAPI_VIEW)) {
            oType = 2;
        } else if (tName.equals(MDAPI_TRIGGER)) {
            oType = 3;
        } else if (tName.equals(MDAPI_SYNONYM)) {
            oType = 4;
        } else if (tName.equals(MDAPI_PACKAGE_SPEC)) {
            oType = 5;
        } else if (tName.equals(MDAPI_PACKAGE_BODY)) {
            oType = 6;
        } else if (tName.equals(MDAPI_PROCEDURE)) {
            oType = 7;
        } else if (tName.equals(MDAPI_FUNCTION)) {
            oType = 8;
        } else if (tName.equals(MDAPI_SEQUENCE)) {
            oType = 9;
        } else if (tName.equals(MDAPI_DB_LINK)) {
            oType = 10;
        } else if (tName.equals(MDAPI_MATERIALIZED_VIEW)) {
            oType = 11;
        } else if (tName.equals(MDAPI_MATERIALIZED_VIEW_LOG)) {
            oType = 12;
        } else if (tName.equals(MDAPI_CLUSTER)) {
            oType = 13;
        } else if (tName.equals(MDAPI_TABLESPACE)) {
            oType = 14;
        } else if (tName.equals(MDAPI_ROLLBACK_SEGMENT)) {
            oType = 15;
        } else if (tName.equals(MDAPI_USER)) {
            oType = 16;
        } else if (tName.equals(MDAPI_ROLE)) {
            oType = 17;
        } else if (tName.equals(MDAPI_PROFILE)) {
            oType = 18;
        } else if (tName.equals(MDAPI_TYPE)) {
            oType = 19;
        }
        return oType;
    }

    public static String intTypeToMDAPIType(int oType) {
        String tName = null;
        switch (oType) {
            case 0: {
                tName = MDAPI_TABLE;
                break;
            }
            case 1: {
                tName = MDAPI_INDEX;
                break;
            }
            case 2: {
                tName = MDAPI_VIEW;
                break;
            }
            case 3: {
                tName = MDAPI_TRIGGER;
                break;
            }
            case 4: {
                tName = MDAPI_SYNONYM;
                break;
            }
            case 5: {
                tName = MDAPI_PACKAGE_SPEC;
                break;
            }
            case 6: {
                tName = MDAPI_PACKAGE_BODY;
                break;
            }
            case 7: {
                tName = MDAPI_PROCEDURE;
                break;
            }
            case 8: {
                tName = MDAPI_FUNCTION;
                break;
            }
            case 9: {
                tName = MDAPI_SEQUENCE;
                break;
            }
            case 10: {
                tName = MDAPI_DB_LINK;
                break;
            }
            case 11: {
                tName = MDAPI_MATERIALIZED_VIEW;
                break;
            }
            case 12: {
                tName = MDAPI_MATERIALIZED_VIEW_LOG;
                break;
            }
            case 13: {
                tName = MDAPI_CLUSTER;
                break;
            }
            case 14: {
                tName = MDAPI_TABLESPACE;
                break;
            }
            case 15: {
                tName = MDAPI_ROLLBACK_SEGMENT;
                break;
            }
            case 16: {
                tName = MDAPI_USER;
                break;
            }
            case 17: {
                tName = MDAPI_ROLE;
                break;
            }
            case 18: {
                tName = MDAPI_PROFILE;
                break;
            }
            case 19: {
                tName = MDAPI_TYPE;
                break;
            }
            default: {
                tName = "***UNKNOWN TYPE***";
            }
        }
        return tName;
    }

    public static boolean sxmlSupported(int objType) {
        boolean supported = true;
        switch (objType) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 18: 
            case 19: {
                supported = false;
            }
        }
        return supported;
    }

    public boolean sxmlSupported() {
        return XMLAccessor.sxmlSupported(this.getObjType());
    }

    public static void setTransformParams(XSLProcessor proc, int paramsFlags, String versionStr) throws XSLException {
        proc.resetParams();
        for (int i = 0; i <= 30; ++i) {
            String pValue = null;
            int flag = 1 << i;
            if ((paramsFlags & flag) != 0) {
                switch (flag) {
                    case 128: 
                    case 2048: 
                    case 4096: 
                    case 8192: 
                    case 16384: 
                    case 524288: 
                    case 0x100000: 
                    case 0x200000: 
                    case 0x400000: 
                    case 0x1000000: 
                    case 0x2000000: 
                    case 0x4000000: 
                    case 0x8000000: 
                    case 0x20000000: {
                        pValue = "1";
                        break;
                    }
                    default: {
                        pValue = "0";
                    }
                }
                proc.setParam("", s_xformParams[i], (Object)pValue);
                continue;
            }
            if (flag != 256) continue;
            proc.setParam("", s_xformParams[i], (Object)"1");
        }
        if (versionStr != null) {
            proc.setParam("", "VERSION", (Object)versionStr);
        }
    }

    protected XMLAccessorClient getAccessorClient() {
        return this.m_accessorClient;
    }

    public void initialize(XMLNode xmlNode) throws XMLAccessorException {
        this.m_xmlRoot = xmlNode;
        this.setXmlDoc(xmlNode);
        this.initializeAll();
    }

    public void initializeAll() throws XMLAccessorException {
    }

    public void initFromDatabase(CMConnection dbConn, String objSchema, String objName) throws SQLException, XMLAccessorException {
        this.initFromDatabase(dbConn, objSchema, objName, false);
    }

    public void initFromDatabase(CMConnection dbConn, String objSchema, String objName, boolean forDiffing) throws SQLException, XMLAccessorException {
        XMLDocument xmlDoc = this.sxmlSupported() ? this.getSXMLDocFromDB(dbConn, this.getTypePathElement(), objSchema, objName, forDiffing) : this.getFullXMLDocFromDB(dbConn, XMLAccessor.intTypeToMDAPIType(this.m_objectType), objSchema, objName, true);
        if (xmlDoc != null) {
            this.initialize((XMLNode)xmlDoc);
        }
    }

    public void releaseXML() {
        this.m_xmlRoot = null;
        this.m_diffDocument = null;
    }

    public void revert() {
        DDLUtils.prepDiffDocForCreateDDL(this.getXmlRoot(), 1);
    }

    public final void applySchemaMap(HashMap schemaMap) {
        this.applySchemaMap(schemaMap, this.getChangeMode());
    }

    public void applySchemaMap(HashMap schemaMap, int changeMode) {
    }

    public ApplyOneDiffResult[] applyDiffs(XMLDocument diffDoc) throws XMLAccessorException {
        int numDiffs;
        ApplyOneDiffResult[] results = null;
        NodeList diffs = XMLAccessor.selectNodes((XMLNode)diffDoc, DIFF_NODES_PATTERN);
        if (diffs != null && (numDiffs = diffs.getLength()) > 0) {
            results = new ApplyOneDiffResult[numDiffs];
            for (int i = 0; i < numDiffs; ++i) {
                XMLElement diffNode = (XMLElement)diffs.item(i);
                String diffXpath = diffNode.getAttribute("xpath");
                StringBuffer tgtXpath = new StringBuffer();
                if (this.nonempty(diffXpath)) {
                    String[] diffXpathElems = diffXpath.substring(1).split("/");
                    int numElems = diffXpathElems.length;
                    XMLElement tgtNode = (XMLElement)this.getXmlRoot();
                    XMLElement tgtParent = null;
                    int stepsToParent = 0;
                    XMLDocument currDiffNode = diffDoc;
                    for (int j = 0; j < numElems; ++j) {
                        ApplyOneDiffResult odr;
                        boolean isDiffNode;
                        String modPath;
                        XMLElement nextDiffNode;
                        String pathElement = diffXpathElems[j];
                        boolean wasMatchByDef = false;
                        if (tgtNode != null) {
                            tgtParent = tgtNode;
                            if (this.isMatchByDefList(tgtNode)) {
                                if ((tgtNode = this.getMatchingElement((XMLElement)currDiffNode, tgtNode, pathElement)) != null) {
                                    wasMatchByDef = true;
                                }
                            } else {
                                tgtNode = (XMLElement)XMLAccessor.getNode((XMLNode)tgtNode, pathElement);
                            }
                            if (tgtNode == null) {
                                tgtNode = this.findAlternateElement(tgtParent, pathElement);
                                if (tgtNode != null) {
                                    tgtXpath.append("/").append("sxml").append(":").append(tgtNode.getNodeName());
                                }
                            } else {
                                tgtXpath.append("/").append(pathElement);
                            }
                        }
                        currDiffNode = wasMatchByDef ? ((nextDiffNode = (XMLElement)XMLAccessor.getNode((XMLNode)currDiffNode, modPath = pathElement.replaceFirst("\\[\\@NAME=", "[@TARGET_NAME="))) == null ? (XMLElement)XMLAccessor.getNode((XMLNode)currDiffNode, pathElement) : nextDiffNode) : (XMLElement)XMLAccessor.getNode((XMLNode)currDiffNode, pathElement);
                        if (currDiffNode == null) {
                            throw new XMLAccessorException("Failed to find diff node for " + pathElement + " in path " + diffXpath);
                        }
                        boolean bl = isDiffNode = j == numElems - 1;
                        if (tgtNode != null) {
                            if (!isDiffNode) continue;
                            results[i] = odr = this.applyDiffToTgtNode((XMLElement)currDiffNode, tgtNode, tgtXpath.toString());
                            continue;
                        }
                        if (isDiffNode) {
                            results[i] = odr = this.applyDiffToTgtParent((XMLElement)currDiffNode, tgtParent, tgtXpath.toString(), stepsToParent);
                            continue;
                        }
                        ++stepsToParent;
                    }
                    continue;
                }
                String msg = "No xpath found for diff node:\n";
                try {
                    StringWriter sw = new StringWriter();
                    diffNode.print(new PrintWriter(sw));
                    msg = msg + sw.toString() + "\nDiff doc:\n";
                    sw = new StringWriter();
                    diffDoc.print(new PrintWriter(sw));
                    msg = msg + sw.toString();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw new XMLAccessorException(msg);
            }
        }
        return results;
    }

    public static boolean hasDiffs(XMLDocument doc) {
        boolean hd = false;
        if (doc != null) {
            NodeList diffs = XMLAccessor.selectNodes((XMLNode)doc, DIFF_NODES_PATTERN);
            boolean bl = hd = diffs != null && diffs.getLength() > 0;
            if (!hd) {
                diffs = doc.getElementsByTagName("MDAPIDDL");
                hd = diffs != null && diffs.getLength() > 0;
            }
        }
        return hd;
    }

    public static boolean isAlterable(XMLDocument alterDoc) {
        NodeList alterItems = CMXMLUtils.selectNodes((XMLNode)alterDoc, s_notAlterablePath);
        boolean ia = alterItems == null || alterItems.getLength() == 0;
        return ia;
    }

    protected XMLElement findAlternateElement(XMLElement parent, String path) {
        return null;
    }

    protected ApplyOneDiffResult applyDiffToTgtNode(XMLElement diffNode, XMLElement tgtNode, String xpath) throws XMLAccessorException {
        int diffType = this.getDiffType(diffNode);
        ApplyOneDiffResult odr = new ApplyOneDiffResult(diffType);
        odr.setXpath(xpath);
        odr.setDiffNode((XMLNode)diffNode);
        odr.setTargetNode((XMLNode)tgtNode);
        switch (diffType) {
            case 2: {
                if (CMDomHash.hashValueEquals(this.m_dh.getDOMHash((Node)diffNode), this.m_dh.getDOMHash((Node)tgtNode))) {
                    odr.setConflictType(2);
                    this.resolveConflict(odr);
                    break;
                }
                odr.setConflictType(3);
                if (!this.resolveConflict(odr)) break;
                XMLNode diffParent = (XMLNode)tgtNode.getParentNode();
                Node importNode = ((XMLDocument)this.getXmlRoot()).importNode((Node)diffNode, true);
                try {
                    diffParent.insertBefore(importNode, (Node)tgtNode);
                    diffParent.removeChild((Node)tgtNode);
                    break;
                }
                catch (DOMException de) {
                    throw new XMLAccessorException("DOMException: " + de.toString(), de);
                }
            }
            case 1: {
                this.markForRemoval(tgtNode);
                if (CMDomHash.hashValueEquals(this.m_dh.getDOMHash((Node)diffNode), this.m_dh.getDOMHash((Node)tgtNode))) {
                    odr.setConflictType(0);
                } else {
                    odr.setConflictType(3);
                }
                if (this.resolveConflict(odr)) break;
                this.markExcluded(diffNode);
                break;
            }
            case 3: {
                String oldDiffValue = diffNode.getAttribute("value1");
                String currDiffValue = XMLAccessor.selectTextValue((XMLNode)diffNode, ".");
                String tgtValue = XMLAccessor.selectTextValue((XMLNode)tgtNode, ".");
                if (tgtValue.equals(oldDiffValue)) {
                    int tgtDiffType = this.getDiffType(tgtNode);
                    if (tgtDiffType == 0) {
                        odr.setConflictType(0);
                    } else if (tgtDiffType == 3) {
                        odr.setConflictType(6);
                    }
                } else if (currDiffValue.equals(tgtValue)) {
                    odr.setConflictType(4);
                } else {
                    odr.setConflictType(5);
                    tgtNode.setAttribute(EXPECTED_VALUE, tgtValue);
                }
                if (!this.resolveConflict(odr)) break;
                this.modifyElement(tgtNode, currDiffValue);
                tgtNode.setAttribute(XPATH, xpath);
                break;
            }
            default: {
                throw new XMLAccessorException("Found DIFF_NONE or unknown for a diff node");
            }
        }
        return odr;
    }

    protected ApplyOneDiffResult applyDiffToTgtParent(XMLElement diffNode, XMLElement tgtParent, String xpath, int stepsToParent) throws XMLAccessorException {
        int diffType = this.getDiffType(diffNode);
        ApplyOneDiffResult odr = new ApplyOneDiffResult(diffType);
        odr.setXpath(xpath);
        odr.setDiffNode((XMLNode)diffNode);
        switch (diffType) {
            case 2: {
                odr.setConflictType(0);
                XMLElement diffParent = diffNode;
                while (stepsToParent-- > 0) {
                    diffParent = (XMLNode)diffParent.getParentNode();
                }
                Node importNode = ((XMLDocument)this.getXmlRoot()).importNode((Node)diffParent, true);
                try {
                    tgtParent.appendChild(importNode);
                }
                catch (DOMException de) {
                    throw new XMLAccessorException("DOMException: " + de.toString(), de);
                }
                if (this.resolveConflict(odr)) break;
                this.markExcluded((XMLElement)importNode);
                break;
            }
            case 1: 
            case 3: {
                odr.setConflictType(1);
                this.resolveConflict(odr);
                break;
            }
            default: {
                throw new XMLAccessorException("Found DIFF_NONE or unknown for a diff node");
            }
        }
        return odr;
    }

    protected int getDiffType(XMLElement diffNode) {
        int dType = 0;
        String srcSide = diffNode.getAttribute("src");
        if (this.nonempty(srcSide)) {
            if (srcSide.equals("1")) {
                dType = 1;
            } else if (srcSide.equals("2")) {
                dType = 2;
            }
        } else {
            String value1 = diffNode.getAttribute("value1");
            if (this.nonempty(value1)) {
                dType = 3;
            }
        }
        return dType;
    }

    protected void markForRemoval(XMLElement ele) throws XMLAccessorException {
        int diffType = this.getDiffType(ele);
        if (diffType == 0) {
            ele.setAttribute("src", "1");
        } else if (diffType != 1) {
            throw new XMLAccessorException("XMLAccessorException: Found diff type " + diffType + " when trying to mark node for removal.");
        }
    }

    protected void markExcluded(XMLElement ele) {
        ele.setAttribute(EXCLUDED, "1");
    }

    protected void modifyElement(XMLElement ele, String newValue) {
        XMLElement parent;
        XMLAccessor.setTextValue((XMLNode)ele, ".", newValue, 0, true);
        if (ele.getNodeName().equals("COL_NUM") && (parent = (XMLElement)ele.getParentNode()) != null && parent.hasAttribute("col-num")) {
            parent.setAttribute("col-num", newValue);
        }
    }

    private boolean isMatchByDefList(XMLElement e) {
        boolean isMBD = false;
        if (e != null && this.m_matchByDef) {
            isMBD = s_MBDListNames.containsKey(e.getNodeName());
        }
        return isMBD;
    }

    private XMLElement getMatchingElement(XMLElement diffList, XMLElement tgtList, String pathElement) {
        XMLElement match = null;
        if (diffList != null && tgtList != null) {
            String childPath;
            NodeList tgtItems;
            String modPath = pathElement.replaceFirst("\\[\\@NAME=", "[@TARGET_NAME=");
            XMLElement diffItem = (XMLElement)XMLAccessor.getNode((XMLNode)diffList, modPath);
            if (diffItem == null) {
                diffItem = (XMLElement)XMLAccessor.getNode((XMLNode)diffList, pathElement);
            }
            if (diffItem != null && (tgtItems = XMLAccessor.selectNodes((XMLNode)tgtList, childPath = NS_PREFIX + (String)s_MBDListNames.get(diffList.getNodeName()))) != null && tgtItems.getLength() > 0) {
                for (int i = 0; i < tgtItems.getLength(); ++i) {
                    XMLElement tgtItem = (XMLElement)tgtItems.item(i);
                    if (!CMDomHash.hashValueEquals(this.m_dh.getDOMHash((Node)diffItem, true), this.m_dh.getDOMHash((Node)tgtItem, true))) continue;
                    match = tgtItem;
                    break;
                }
            }
        }
        return match;
    }

    public boolean compareDefinition(XMLDocument defn) throws XMLAccessorException {
        return this.compareDefinition(defn, false, null);
    }

    public boolean compareDefinition(XMLDocument defn, boolean mutateDefn) throws XMLAccessorException {
        return this.compareDefinition(defn, mutateDefn, null);
    }

    public boolean compareDefinition(XMLDocument defn, HashMap schemaMap) throws XMLAccessorException {
        return this.compareDefinition(defn, false, schemaMap);
    }

    public boolean compareDefinition(XMLDocument defn, boolean mutateDefn, HashMap schemaMap) throws XMLAccessorException {
        this.m_schemaMap = schemaMap;
        boolean hasDiffs = false;
        boolean hasRealDiffs = false;
        boolean logicalCompare = this.m_logicalCompare;
        boolean ignHighValues = this.m_ignHighValues;
        boolean ignPartitioning = this.m_ignPtng;
        if (this.sxmlSupported()) {
            this.m_diffDocument = mutateDefn ? defn : (XMLDocument)defn.cloneNode(true);
            CMDiff differ = new CMDiff(logicalCompare, ignHighValues, ignPartitioning);
            differ.setUsingSxml(true);
            if (schemaMap != null && schemaMap.size() > 0) {
                XMLDocument defnClone = (XMLDocument)defn.cloneNode(true);
                XMLAccessor mapAcc = XMLAccessor.getXMLAccessorForType(this.getObjType(), (XMLNode)defnClone, this.getAccessorClient());
                mapAcc.applySchemaMap(schemaMap, 1);
                CMDiff differ2 = new CMDiff(logicalCompare, ignHighValues, ignPartitioning);
                differ2.setCountStatDiffs(this.getAppendStatistics());
                differ2.setUsingSxml(true);
                differ2.setDocuments((Node)this.getDocument(), (Node)defnClone);
                try {
                    hasRealDiffs = differ2.diff();
                    this.m_noRealDiffs = !hasRealDiffs;
                }
                catch (NullPointerException npe) {
                    throw new XMLAccessorException("NullPointerException while diffing", npe);
                }
            }
            differ.setDocuments((Node)this.getDocument(), (Node)this.m_diffDocument);
            differ.setCountStatDiffs(this.getAppendStatistics());
            try {
                hasDiffs = differ.diff();
            }
            catch (NullPointerException npe) {
                throw new XMLAccessorException("NullPointerException while diffing", npe);
            }
            if ((hasDiffs || differ.ignoredDiffFound()) && differ.getCMDiffTree(1) != null) {
                differ.getCMDiffTree(1).applyDiffToXml(this.getDocument(), this.m_diffDocument);
            }
        } else {
            CMXSLTransformInfo xformInfo = this.getTransformInfo(8, this.getObjType(), null);
            if (xformInfo != null) {
                XSLStylesheet ss = xformInfo.getStylesheet();
                XSLProcessor proc = xformInfo.getProcessor();
                XMLDocumentFragment thisCmxmlDoc = null;
                XMLDocumentFragment otherCmxmlDoc = null;
                XMLDocument mappedDefn = null;
                CMDiff differ = null;
                try {
                    thisCmxmlDoc = proc.processXSL(ss, this.getDocument());
                    otherCmxmlDoc = proc.processXSL(ss, defn);
                    if (schemaMap != null && schemaMap.size() > 0) {
                        mappedDefn = this.getMappedFullXML(defn, schemaMap);
                        XMLDocumentFragment mappedOtherCmxmlDoc = proc.processXSL(ss, mappedDefn);
                        CMDiff differ2 = new CMDiff(logicalCompare, ignHighValues, ignPartitioning);
                        differ2.setUsingSxml(false);
                        differ2.setDocuments((Node)thisCmxmlDoc, (Node)mappedOtherCmxmlDoc);
                        hasRealDiffs = differ2.diff();
                        this.m_noRealDiffs = !hasRealDiffs;
                    }
                    differ = new CMDiff(logicalCompare, ignHighValues, ignPartitioning);
                    differ.setUsingSxml(false);
                    differ.setDocuments((Node)thisCmxmlDoc, (Node)otherCmxmlDoc);
                    hasDiffs = differ.diff();
                }
                catch (XSLException xsle) {
                    throw new XMLAccessorException("Generating CMXML and diffing", xsle);
                }
                if (hasDiffs) {
                    int flags = 0;
                    if (this.m_accessorClient != null) {
                        flags = this.m_accessorClient.getTransformParamFlags(this.getObjType(), 0);
                        String thisDDL = this.generateDDL(0, flags |= 0x100, this.getDocument());
                        String otherDDL = this.generateDDL(0, flags, defn);
                        differ.setDDLs(otherDDL, thisDDL);
                        try {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            differ.writeDiffXML(1, bos);
                            String diffStr = bos.toString("UTF-8");
                            StringReader r = new StringReader(diffStr);
                            this.m_diffDocument = (XMLDocument)CMXMLUtils.parseXMLDocument(r, false, false);
                        }
                        catch (IOException ioe) {
                            throw new XMLAccessorException("Writing and parsing Diff CMXML", ioe);
                        }
                        catch (ParserConfigurationException pce) {
                            throw new XMLAccessorException("Writing and parsing Diff CMXML", pce);
                        }
                        catch (SAXException se) {
                            throw new XMLAccessorException("Writing and parsing Diff CMXML", se);
                        }
                        if (mappedDefn != null) {
                            this.m_nonSxmlALterDDL = this.generateDDL(0, flags, mappedDefn);
                        }
                    }
                }
            }
        }
        if (schemaMap != null && schemaMap.size() > 0) {
            return hasRealDiffs;
        }
        return hasDiffs;
    }

    protected boolean resolveConflict(ApplyOneDiffResult odr) {
        if (this.m_applyDiffListener != null) {
            this.m_applyDiffListener.applyDiffResult(odr, this);
        }
        return odr.getDoChange();
    }

    public void registerApplyDiffListener(ApplyDiffListener adl) {
        this.m_applyDiffListener = adl;
    }

    public XMLDocument getDifferencesDocument() {
        return this.m_diffDocument;
    }

    protected abstract String getTypePathElement();

    protected String getTypeNameForDDL() {
        return this.getTypePathElement();
    }

    protected int getObjType() {
        return this.m_objectType;
    }

    protected boolean isDependentType() {
        return false;
    }

    protected boolean canHaveStats() {
        return false;
    }

    protected Vector getColumnNamesVector(NodeList columns) {
        Vector<String> nameVector = null;
        int numCols = 0;
        if (columns != null && (numCols = columns.getLength()) > 0) {
            nameVector = new Vector<String>(numCols);
            for (int i = 0; i < numCols; ++i) {
                nameVector.addElement(XMLAccessor.getColumnName(columns.item(i)));
            }
        }
        return nameVector;
    }

    public static String getColumnName(Node col) {
        return XMLAccessor.selectTextValue((XMLNode)col, X_NAME);
    }

    static int calculateExtent(int value, int scale) {
        int extent = 0;
        switch (scale) {
            case 3: {
                extent = value * 0x100000;
                break;
            }
            case 2: {
                extent = value * 1024;
                break;
            }
            case 1: {
                extent = value;
            }
        }
        return extent;
    }

    protected static String selectTextValue(XMLNode node, String path) {
        return CMXMLUtils.selectTextValue(node, path);
    }

    protected String selectTextValue(String path) {
        return CMXMLUtils.selectTextValue(this.getXmlNode(), path);
    }

    protected static String[] selectTextValues(XMLNode node, String path) {
        return CMXMLUtils.selectTextValues(node, path);
    }

    protected String[] selectTextValues(String path) {
        return CMXMLUtils.selectTextValues(this.getXmlNode(), path);
    }

    protected static boolean nodeExists(XMLNode node, String path) {
        return CMXMLUtils.nodeExists(node, path);
    }

    protected boolean nodeExists(String path) {
        return CMXMLUtils.nodeExists(this.getXmlNode(), path);
    }

    protected static XMLNode getNode(XMLNode node, String path) {
        return CMXMLUtils.getNode(node, path);
    }

    protected XMLNode getNode(String path) {
        return CMXMLUtils.getNode(this.getXmlNode(), path);
    }

    protected static NodeList selectNodes(XMLNode node, String path) {
        return CMXMLUtils.selectNodes(node, path);
    }

    protected NodeList selectNodes(String path) {
        return CMXMLUtils.selectNodes(this.getXmlNode(), path);
    }

    protected static void setTextValue(XMLNode node, String path, String newValue, int changeMode) {
        XMLAccessor.setTextValue(node, path, newValue, changeMode, false);
    }

    protected static void setTextValue(XMLNode node, String path, String newValue, int changeMode, boolean overwriteOldDiff) {
        XMLNode tgtNode;
        if (changeMode == 1) {
            CMXMLUtils.setRelativeTextNodeValue(node, path, newValue);
        } else if (changeMode == 0 && (tgtNode = XMLAccessor.getNode(node, path)) != null) {
            String oldValue = CMXMLUtils.selectTextValue(tgtNode, ".");
            CMXMLUtils.setRelativeTextNodeValue(tgtNode, null, newValue);
            NamedNodeMap attrs = tgtNode.getAttributes();
            Attr valueAtt = (Attr)attrs.getNamedItem(VALUE_1);
            if (valueAtt == null) {
                try {
                    valueAtt = ((XMLDocument)tgtNode.getOwnerDocument()).createAttribute(VALUE_1);
                    valueAtt.setValue(oldValue);
                    attrs.setNamedItem(valueAtt);
                }
                catch (DOMException de) {}
            } else if (overwriteOldDiff) {
                valueAtt.setValue(oldValue);
            }
        }
    }

    protected void setTextValue(String path, String newValue) {
        XMLAccessor.setTextValue(this.getXmlNode(), path, newValue, this.getChangeMode());
    }

    protected void setTextValue(String path, String newValue, int changeMode) {
        XMLAccessor.setTextValue(this.getXmlNode(), path, newValue, changeMode);
    }

    protected static void createNode(XMLNode baseNode, String path, String nodeName, int changeMode) {
        if (changeMode == 1) {
            CMXMLUtils.createNode(baseNode, path, nodeName, null);
        } else if (changeMode == 0) {
            XMLNode newNode = CMXMLUtils.createNode(baseNode, path, nodeName, null);
            NamedNodeMap attrs = newNode.getAttributes();
            try {
                Attr srcAtt = ((XMLDocument)newNode.getOwnerDocument()).createAttribute(SRC);
                srcAtt.setValue(NEW_SRC);
                attrs.setNamedItem(srcAtt);
            }
            catch (DOMException de) {
                // empty catch block
            }
        }
    }

    protected void createNode(String path, String nodeName) {
        XMLAccessor.createNode(this.getXmlNode(), path, nodeName, this.getChangeMode());
    }

    protected static void createTextNode(XMLNode baseNode, String path, String nodeName, String textValue, int changeMode) {
        if (changeMode == 1) {
            CMXMLUtils.createNode(baseNode, path, nodeName, textValue);
        } else if (changeMode == 0) {
            XMLNode newNode = CMXMLUtils.createNode(baseNode, path, nodeName, textValue);
            NamedNodeMap attrs = newNode.getAttributes();
            try {
                Attr srcAtt = ((XMLDocument)newNode.getOwnerDocument()).createAttribute(SRC);
                srcAtt.setValue(NEW_SRC);
                attrs.setNamedItem(srcAtt);
            }
            catch (DOMException de) {
                // empty catch block
            }
        }
    }

    protected void createTextNode(String path, String nodeName, String textValue) {
        XMLAccessor.createTextNode(this.getXmlNode(), path, nodeName, textValue, this.getChangeMode());
    }

    protected static void removeNode(XMLNode node, String path, int changeMode) {
        if (changeMode == 1) {
            CMXMLUtils.removeNode(node, path);
        } else if (changeMode == 0) {
            XMLNode theNode = XMLAccessor.getNode(node, path);
            XMLAccessor.markAsRemoved(theNode);
        }
    }

    protected void removeNode(String path) {
        XMLAccessor.removeNode(this.getXmlNode(), path, this.getChangeMode());
    }

    protected static void markAsRemoved(XMLNode node) {
        if (node != null) {
            NamedNodeMap attrs = node.getAttributes();
            try {
                Attr srcAtt = ((XMLDocument)node.getOwnerDocument()).createAttribute(SRC);
                srcAtt.setValue(OLD_SRC);
                attrs.setNamedItem(srcAtt);
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
    }

    public String getName() {
        return this.selectTextValue(this.getNamePath());
    }

    public String getQuotedFullName() {
        return this.getQuotedName();
    }

    public String getQuotedName() {
        return "\"" + this.getName() + "\"";
    }

    public void setObjectName(String newName) {
        this.setTextValue(this.getNamePath(), newName);
    }

    protected String getNamePath() {
        return X_NAME;
    }

    protected String nin(String s) {
        return s == null ? NONE : s;
    }

    protected static String YorN(boolean b) {
        return b ? "Y" : "N";
    }

    protected boolean nonempty(String s) {
        return s != null && !s.equals("");
    }

    public String toString() {
        return this.getTypePathElement() + ":\n  Name: " + this.getName() + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMLDocument getSXMLDocFromDB(CMConnection dbConn, String mdapiType, String objSchema, String objName, boolean forDiffing) throws SQLException, XMLAccessorException {
        this.m_compatibleVersion = DDLUtils.getTargetCompatibleVersion(dbConn);
        boolean is11 = dbConn.isVersionEqualOrHigher("11.1.0.0.0");
        XMLDocument sxmlDoc = null;
        if (is11 && !forDiffing) {
            OracleCallableStatement stmt = null;
            try {
                CLOB objClob = null;
                stmt = objSchema != null ? (OracleCallableStatement)dbConn.prepareCall(this.getOneSchemaObjSXML()) : (OracleCallableStatement)dbConn.prepareCall(this.getOneNonSchemaObjSXML());
                stmt.setString(2, mdapiType);
                stmt.setString(3, objName);
                if (objSchema != null) {
                    stmt.setString(4, objSchema);
                }
                stmt.registerOutParameter(1, 2005);
                stmt.execute();
                objClob = stmt.getCLOB(1);
                if (objClob != null) {
                    Reader r = objClob.characterStreamValue();
                    sxmlDoc = (XMLDocument)CMXMLUtils.parseXMLDocument(r);
                }
                CMConnection.close((Statement)stmt);
                return sxmlDoc;
            }
            catch (SQLException se) {
                throw se;
                catch (Throwable t) {
                    t.printStackTrace();
                    return sxmlDoc;
                }
            }
            finally {
                CMConnection.close(stmt);
            }
        }
        XMLDocument fullXmlDoc = this.getFullXMLDocFromDB(dbConn, mdapiType, objSchema, objName, false);
        int objType = XMLAccessor.MDAPITypeToIntType(mdapiType);
        CMXSLTransformInfo xformInfo = this.getTransformInfo(3, objType, null);
        if (fullXmlDoc == null) return sxmlDoc;
        if (xformInfo == null) return sxmlDoc;
        XSLStylesheet ss = xformInfo.getStylesheet();
        XSLProcessor proc = xformInfo.getProcessor();
        int flags = 0;
        if (this.m_accessorClient != null) {
            flags = this.m_accessorClient.getTransformParamFlags(objType, 3);
        } else if (objType == 16 || objType == 10) {
            flags += 128;
        }
        if (forDiffing) {
            flags |= 0x800;
        }
        try {
            XMLAccessor.setTransformParams(proc, flags, this.m_compatibleVersion);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            proc.processXSL(ss, fullXmlDoc, (OutputStream)bos);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            return (XMLDocument)CMXMLUtils.parseXMLDocument(bis, true);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return sxmlDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XMLDocument getFullXMLDocFromDB(CMConnection dbConn, String mdapiType, String objSchema, String objName, boolean forDDL) throws SQLException {
        XMLDocument fullXmlDoc;
        OracleCallableStatement stmt;
        block8: {
            stmt = null;
            fullXmlDoc = null;
            try {
                CLOB objClob = null;
                stmt = objSchema != null ? (OracleCallableStatement)dbConn.prepareCall(this.getOneSchemaObjXML()) : (OracleCallableStatement)dbConn.prepareCall(this.getOneNonSchemaObjXML());
                stmt.setString(2, mdapiType);
                stmt.setString(3, objName);
                if (objSchema != null) {
                    stmt.setString(4, objSchema);
                }
                stmt.registerOutParameter(1, 2005);
                stmt.execute();
                objClob = stmt.getCLOB(1);
                if (objClob == null) break block8;
                Reader r = objClob.characterStreamValue();
                fullXmlDoc = (XMLDocument)CMXMLUtils.parseXMLDocument(r, !forDDL, false);
            }
            catch (SQLException se) {
                block9: {
                    if (se.getErrorCode() != 31603 && se.getErrorCode() != 31608) break block9;
                    XMLDocument xMLDocument = null;
                    CMConnection.close((Statement)stmt);
                    return xMLDocument;
                }
                try {
                    throw se;
                    catch (Throwable t) {
                        t.printStackTrace();
                        return fullXmlDoc;
                    }
                }
                finally {
                    CMConnection.close(stmt);
                }
            }
        }
        CMConnection.close((Statement)stmt);
        return fullXmlDoc;
    }

    public String getDDL(int ddlType) throws XMLAccessorException {
        return this.getDDL(ddlType, null);
    }

    public String getDDL(int ddlType, HashMap schemaMap) throws XMLAccessorException {
        return this.getDDL(ddlType, schemaMap, false);
    }

    public String getDDLForExecution(int ddlType, HashMap schemaMap) throws XMLAccessorException {
        return this.getDDL(ddlType, schemaMap, true);
    }

    public String getDDLForExecution(int ddlType) throws XMLAccessorException {
        return this.getDDL(ddlType, null, true);
    }

    public String getDDL(int ddlType, HashMap schemaMap, boolean forExecution) throws XMLAccessorException {
        XMLDocument defn;
        boolean noDDL = false;
        XMLDocument xMLDocument = defn = this.m_diffDocument != null ? this.m_diffDocument : this.getDocument();
        if (defn == null) {
            throw new XMLAccessorException("Unable to generate DDL because there is no definition document.");
        }
        String ddl = null;
        if (ddlType == 1 || ddlType == 2) {
            ddl = this.getCreateDDL(defn, ddlType, schemaMap);
        } else if (ddlType == 3 || ddlType == 4) {
            if (XMLAccessor.hasDiffs(defn) && !this.m_noRealDiffs) {
                if (this.sxmlSupported() && this.getObjType() != 10) {
                    CMXSLTransformInfo ti = XMLAccessor.createXslTransformInfo(6, this.getObjType(), this.m_accessorClient.getXslRoot(), this.m_accessorClient.getServletContext());
                    int flags = this.m_accessorClient.getTransformParamFlags(this.getObjType(), 6);
                    XMLDocument clonedDefn = defn;
                    if (ddlType == 4) {
                        clonedDefn = (XMLDocument)defn.cloneNode(true);
                        DDLUtils.flipXmlDoc(clonedDefn, this.getObjType());
                    } else {
                        HashMap sMap = this.getSchemaMap();
                        if (sMap != null && sMap.size() > 0) {
                            clonedDefn = (XMLDocument)defn.cloneNode(true);
                            XMLAccessor mapAcc = XMLAccessor.getXMLAccessorForType(this.getObjType(), (XMLNode)clonedDefn, this.getAccessorClient());
                            mapAcc.applySchemaMap(sMap);
                        }
                    }
                    String alterXML = DDLUtils.generateDDL(this.getObjType(), clonedDefn, 6, flags, ti, null);
                    XMLDocument alterDoc = null;
                    try {
                        StringReader r = new StringReader(alterXML);
                        alterDoc = (XMLDocument)CMXMLUtils.parseXMLDocument(r);
                        r.close();
                    }
                    catch (Throwable t) {
                        throw new XMLAccessorException("Caught Throwable while parsing Alter XML document.", t);
                    }
                    if (alterDoc != null) {
                        if (XMLAccessor.isAlterable(alterDoc)) {
                            int whichSide;
                            String statsDDL;
                            NodeList alterItems = CMXMLUtils.selectNodes((XMLNode)alterDoc, s_alterItemPath);
                            if (alterItems != null) {
                                StringBuffer alterSB = new StringBuffer();
                                for (int i = 0; i < alterItems.getLength(); ++i) {
                                    XMLNode alterItem = (XMLNode)alterItems.item(i);
                                    String[] ddlsArray = CMXMLUtils.selectTextValues(alterItem, s_sqlItemPath);
                                    if (ddlsArray == null) continue;
                                    for (int j = 0; j < ddlsArray.length; ++j) {
                                        alterSB.append(ddlsArray[j]).append(";\n");
                                    }
                                }
                                ddl = alterSB.toString();
                            }
                            if (this.getAppendStatistics() && (statsDDL = this.getCreateDDL(clonedDefn, whichSide = ddlType == 3 ? 2 : 1, schemaMap, true)) != null) {
                                ddl = ddl != null ? ddl + "\n" + statsDDL : statsDDL;
                            }
                        } else {
                            int whichSide = ddlType == 3 ? 2 : 1;
                            String dropDDL = "";
                            if (this.getObjType() != 2 && this.getObjType() != 3) {
                                dropDDL = this.getDropDDL() + "\n";
                            }
                            ddl = dropDDL + this.getCreateDDL(clonedDefn, whichSide, schemaMap);
                        }
                    }
                } else if (this.getObjType() == 10) {
                    int whichSide = ddlType == 3 ? 2 : 1;
                    ddl = this.getDropDDL() + "\n" + this.getCreateDDL(defn, whichSide, schemaMap) + ";";
                } else if (this.m_nonSxmlALterDDL != null && ddlType == 3) {
                    ddl = this.m_nonSxmlALterDDL;
                } else {
                    NodeList ddls = defn.getElementsByTagName("MDAPIDDL");
                    if (ddls != null && ddls.getLength() >= 2) {
                        int whichItem = ddlType == 3 ? 0 : 1;
                        Node ddlNode = ddls.item(whichItem);
                        XMLText ddlCdata = (XMLText)ddlNode.getChildNodes().item(0);
                        ddl = ddlCdata.getData();
                        HashMap sMap = this.getSchemaMap();
                        if (sMap != null && sMap.size() > 0) {
                            if (sMap.size() != 1) {
                                throw new XMLAccessorException("Schema map must contain exactly one entry mapping source schema to destination schema.");
                            }
                            String sourceOwner = null;
                            String destOwner = null;
                            Set entries = sMap.entrySet();
                            Iterator entItr = entries.iterator();
                            Map.Entry entry = entItr.next();
                            if (ddlType == 3) {
                                sourceOwner = (String)entry.getKey();
                                destOwner = (String)entry.getValue();
                            } else {
                                sourceOwner = (String)entry.getValue();
                                destOwner = (String)entry.getKey();
                            }
                            ddl = ddl.replaceFirst("\"" + sourceOwner + "\"", "\"" + destOwner + "\"");
                        }
                    }
                }
            } else if (schemaMap != null && ddlType == 3) {
                ddl = this.getCreateDDL(defn, 1, schemaMap);
            } else {
                ddl = "No modifications found.";
                noDDL = true;
            }
        } else if (ddlType == 5) {
            ddl = this.getDropDDL();
        }
        if (!noDDL && forExecution) {
            if (this.isCommentableType()) {
                int cmtOn;
                StringBuffer ddlSB = new StringBuffer(ddl);
                boolean modified = false;
                int startAt = 0;
                while ((cmtOn = ddlSB.indexOf("COMMENT ON", startAt)) >= 0) {
                    int cmtStart = ddlSB.indexOf("'", cmtOn) + 1;
                    int cmtEnd = ddlSB.indexOf("';\n", cmtStart);
                    if (cmtEnd < 0) {
                        cmtEnd = ddlSB.lastIndexOf("';");
                    }
                    modified |= this.escapeSingleQuotes(ddlSB, cmtStart, cmtEnd);
                    startAt = cmtOn + 10;
                }
                if (modified) {
                    ddl = ddlSB.toString();
                }
            }
            if (this.isPLSQLType()) {
                int lastSemi = ddl.lastIndexOf(";");
                ddl = ddl.substring(0, lastSemi + 1) + "\n/";
            }
        }
        return ddl;
    }

    private boolean escapeSingleQuotes(StringBuffer ddlSB, int startAt, int endAt) {
        boolean modified = false;
        for (int i = startAt; i < endAt; ++i) {
            char ch = ddlSB.charAt(i);
            if (ch != '\'') continue;
            ddlSB.insert(i, '\'');
            ++i;
            ++endAt;
            modified = true;
        }
        return modified;
    }

    protected boolean isCommentableType() {
        return false;
    }

    private String getCreateDDL(XMLDocument defn, int whichSide, HashMap schemaMap) throws XMLAccessorException {
        return this.getCreateDDL(defn, whichSide, schemaMap, false);
    }

    private String getCreateDDL(XMLDocument defn, int whichSide, HashMap schemaMap, boolean statsOnly) throws XMLAccessorException {
        String ddl = null;
        int transform = this.sxmlSupported() ? 4 : 0;
        CMXSLTransformInfo ti = XMLAccessor.createXslTransformInfo(transform, this.getObjType(), this.m_accessorClient.getXslRoot(), this.m_accessorClient.getServletContext());
        int flags = this.m_accessorClient.getTransformParamFlags(this.getObjType(), transform);
        if (this.sxmlSupported()) {
            String statsDDL;
            if (this.m_diffDocument != null && XMLAccessor.hasDiffs(defn)) {
                XMLDocument origDefn = (XMLDocument)defn.cloneNode(true);
                DDLUtils.prepDiffDocForCreateDDL((XMLNode)origDefn, whichSide == 1 ? 1 : 2);
                defn = origDefn;
            } else if (schemaMap != null && whichSide == 1) {
                XMLDocument defnClone = (XMLDocument)defn.cloneNode(true);
                XMLAccessor mapAcc = XMLAccessor.getXMLAccessorForType(this.getObjType(), (XMLNode)defnClone, this.getAccessorClient());
                mapAcc.applySchemaMap(schemaMap, 1);
                defn = defnClone;
            }
            if (this.getAppendStatistics() && this.canHaveStats()) {
                flags &= 0xFDFFFFFF;
            }
            if (!statsOnly) {
                ddl = DDLUtils.generateDDL(this.getObjType(), defn, transform, flags, ti, null);
            }
            if (this.getAppendStatistics() && this.canHaveStats() && (statsDDL = DDLUtils.generateDDL(this.getObjType(), defn, transform, flags |= 0x2000000, ti, null)) != null) {
                ddl = ddl != null ? ddl + "\n" + statsDDL : statsDDL;
            }
        } else if (this.m_diffDocument != null && XMLAccessor.hasDiffs(defn)) {
            NodeList ddls = defn.getElementsByTagName("MDAPIDDL");
            if (ddls != null && ddls.getLength() >= 2) {
                int whichItem = whichSide == 1 ? 1 : 0;
                Node ddlNode = ddls.item(whichItem);
                XMLText ddlCdata = (XMLText)ddlNode.getChildNodes().item(0);
                ddl = ddlCdata.getData();
            }
        } else {
            if (schemaMap != null && whichSide == 1) {
                defn = this.getMappedFullXML(defn, schemaMap);
            }
            if (this.isPLSQLType()) {
                flags |= 0x100;
            }
            ddl = DDLUtils.generateDDL(this.getObjType(), defn, transform, flags, ti, null);
        }
        return ddl;
    }

    protected boolean isPLSQLType() {
        return false;
    }

    private XMLDocument getMappedFullXML(XMLDocument defn, HashMap schemaMap) throws XMLAccessorException {
        XMLDocument mappedDefn = null;
        if (defn != null && schemaMap != null) {
            CMXSLTransformInfo modXformInfo = this.getTransformInfo(5, this.getObjType(), null);
            XSLStylesheet modSs = modXformInfo.getStylesheet();
            XSLProcessor modProc = modXformInfo.getProcessor();
            Set entries = schemaMap.entrySet();
            Iterator entItr = entries.iterator();
            int remapIndex = 1;
            try {
                while (entItr.hasNext()) {
                    Map.Entry entry = entItr.next();
                    modProc.setParam("", "REMAP_SCHEMAO" + remapIndex, (Object)("\"" + (String)entry.getKey() + "\""));
                    modProc.setParam("", "REMAP_SCHEMAN" + remapIndex++, (Object)("\"" + (String)entry.getValue() + "\""));
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                modProc.processXSL(modSs, defn, (OutputStream)bos);
                String s = bos.toString("UTF-8");
                StringReader r = new StringReader(s);
                boolean ignoreWS = this.sxmlSupported();
                mappedDefn = (XMLDocument)CMXMLUtils.parseXMLDocument(r, ignoreWS, false);
            }
            catch (IOException ioe) {
                throw new XMLAccessorException("Mapping Full XML", ioe);
            }
            catch (ParserConfigurationException pce) {
                throw new XMLAccessorException("Mapping Full XML", pce);
            }
            catch (SAXException se) {
                throw new XMLAccessorException("Mapping Full XML", se);
            }
            catch (XSLException xsle) {
                throw new XMLAccessorException("Mapping Full XML", xsle);
            }
        }
        return mappedDefn;
    }

    public String getDropDDL() {
        StringBuffer sb = new StringBuffer("DROP ").append(this.getTypeNameForDDL()).append(" ").append(this.getQuotedFullName()).append(";");
        return new String(sb);
    }

    public void setAppendStatistics(boolean appendStats) {
        this.m_appendStatistics = appendStats;
    }

    public boolean getAppendStatistics() {
        return this.m_appendStatistics;
    }

    public String generateDDL(int transform, int transformParams) {
        return this.generateDDL(transform, transformParams, (XMLDocument)this.m_xmlRoot);
    }

    public String generateDDL(int transform, int transformParams, XMLDocument theDoc) {
        String theDDL = null;
        CMXSLTransformInfo transformInfo = this.getTransformInfo(transform, this.getObjType(), null);
        String versionStr = this.m_compatibleVersion;
        if (transformInfo != null) {
            theDDL = DDLUtils.generateDDL(this.getObjType(), theDoc, transform, transformParams, transformInfo, versionStr);
        }
        return theDDL;
    }

    public String generateDDL(int transform, int transformParams, String xslRoot) {
        String theDDL = null;
        CMXSLTransformInfo transformInfo = this.getTransformInfo(transform, this.getObjType(), xslRoot);
        String versionStr = this.m_compatibleVersion;
        if (transformInfo != null) {
            theDDL = DDLUtils.generateDDL(this.getObjType(), (XMLDocument)this.m_xmlRoot, transform, transformParams, transformInfo, versionStr);
        }
        return theDDL;
    }

    public String[] generateDDLs(int transformParams) {
        String[] theDDLs = null;
        String theDDL = this.generateDDL(4, transformParams | 0x1000);
        if (theDDL != null && theDDL.length() > 0) {
            try {
                theDDLs = theDDL.split("\\\\\\{\\]\\`C");
            }
            catch (PatternSyntaxException pse) {
                // empty catch block
            }
        }
        return theDDLs;
    }

    private CMXSLTransformInfo getTransformInfo(int transform, int objType, String xslRoot) {
        if (xslRoot != null) {
            return XMLAccessor.createXslTransformInfo(transform, objType, xslRoot, null);
        }
        if (this.m_accessorClient != null) {
            return XMLAccessor.createXslTransformInfo(transform, objType, this.m_accessorClient.getXslRoot(), this.m_accessorClient.getServletContext());
        }
        return null;
    }

    public static CMXSLTransformInfo createXslTransformInfo(int transform, int objType, String xslRoot, ServletContext context) {
        if (transform == 4 && objType == 102) {
            objType = 0;
        }
        CMXSLTransformInfo xformInfo = null;
        String ssName = null;
        String xslDir = null;
        boolean useSysResource = false;
        if (context != null) {
            xslDir = CMXSLUtils.WEBAPPS_XSL_PATH + CMXSLUtils.FILE_SEPARATER;
        } else if (xslRoot != null) {
            xslDir = xslRoot + CMXSLUtils.WEBAPPS_XSL_PATH + CMXSLUtils.FILE_SEPARATER;
        } else {
            xslDir = "WEB-INF/xsls/";
            useSysResource = true;
        }
        switch (transform) {
            case 0: {
                ssName = CMXSLUtils.getStyleSheetName(objType, false, false);
                break;
            }
            case 1: {
                ssName = CMXSLUtils.getStyleSheetName(objType, false, true);
                break;
            }
            case 2: {
                ssName = CMXSLUtils.getStyleSheetName(objType, true, false);
                break;
            }
            case 3: {
                ssName = CMXSLUtils.getSxmlStyleSheetName(objType);
                break;
            }
            case 4: {
                ssName = CMXSLUtils.getSxmlToDdlStyleSheetName(objType);
                break;
            }
            case 5: {
                ssName = CMXSLUtils.getModifyFullXmlStyleSheetName(objType);
                break;
            }
            case 6: {
                ssName = CMXSLUtils.getAlterSxmlStyleSheetName(objType);
                break;
            }
            case 7: {
                ssName = CMXSLUtils.getAlterSxmlToDdlStyleSheetName(objType);
                break;
            }
            case 8: {
                ssName = CMXSLUtils.getCmxmlStyleSheetName(objType);
                xslDir = useSysResource ? xslDir + "cmxsl/" : xslDir + "cmxsl" + CMXSLUtils.FILE_SEPARATER;
            }
        }
        String xslPath = xslDir + ssName;
        URL xslURL = null;
        DOMParser parser = null;
        Object bos = null;
        try {
            parser = new DOMParser();
            parser.setPreserveWhitespace(true);
            xslURL = context != null ? CMXMLUtils.getResource(context, xslPath) : CMXMLUtils.createURL(xslPath, useSysResource);
            parser.parse(xslURL);
            XSLProcessor proc = new XSLProcessor();
            proc.setBaseURL(xslURL);
            proc.showWarnings(true);
            XSLStylesheet ss = proc.newXSLStylesheet(parser.getDocument());
            if (ss != null) {
                xformInfo = new CMXSLTransformInfo(ss, proc);
            } else {
                System.out.println("Unable to get transform info for obj type " + objType + ", stylesheet " + xslPath);
            }
        }
        catch (Throwable t) {
            System.out.println("Caught something while trying to get transform info for transform " + transform + ", obj type " + objType + ", stylesheet " + xslPath);
            t.printStackTrace();
        }
        return xformInfo;
    }

    private String getOneSchemaObjSXML() {
        if (!this.isDependentType()) {
            return s_getOneSchemaObjSXML;
        }
        return s_getOneDepSchemaObjSXML;
    }

    private String getOneNonSchemaObjSXML() {
        if (!this.isDependentType()) {
            return s_getOneNonSchemaObjSXML;
        }
        return s_getOneDepNonSchemaObjSXML;
    }

    private String getOneSchemaObjXML() {
        if (!this.isDependentType()) {
            return s_getOneSchemaObjXML;
        }
        return s_getOneDepSchemaObjXML;
    }

    private String getOneNonSchemaObjXML() {
        if (!this.isDependentType()) {
            return s_getOneNonSchemaObjXML;
        }
        return s_getOneDepNonSchemaObjXML;
    }

    static {
        s_MBDListNames.put("UNIQUE_KEY_CONSTRAINT_LIST", "UNIQUE_KEY_CONSTRAINT_LIST_ITEM");
        s_MBDListNames.put("PRIMARY_KEY_CONSTRAINT_LIST", "PRIMARY_KEY_CONSTRAINT_LIST_ITEM");
        s_MBDListNames.put("FOREIGN_KEY_CONSTRAINT_LIST", "FOREIGN_KEY_CONSTRAINT_LIST_ITEM");
        s_MBDListNames.put("CHECK_CONSTRAINT_LIST", "CHECK_CONSTRAINT_LIST_ITEM");
        s_getOneSchemaObjSXML = "begin ? := dbms_metadata.get_sxml(?, ?, ?); end;";
        s_getOneDepSchemaObjSXML = "begin ? := dbms_metadata.get_dependent_sxml(?, ?, ?); end;";
        s_getOneNonSchemaObjSXML = "begin ? := dbms_metadata.get_sxml(?, ?); end;";
        s_getOneDepNonSchemaObjSXML = "begin ? := dbms_metadata.get_dependent_sxml(?, ?); end;";
        s_getOneSchemaObjXML = "begin ? := dbms_metadata.get_xml(?, ?, ?); end;";
        s_getOneDepSchemaObjXML = "begin ? := dbms_metadata.get_dependent_xml(?, ?, ?); end;";
        s_getOneNonSchemaObjXML = "begin ? := dbms_metadata.get_xml(?, ?); end;";
        s_getOneDepNonSchemaObjXML = "begin ? := dbms_metadata.get_dependent_xml(?, ?); end;";
    }
}

