/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.gui;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.gui.ScratchWorksheetNode;
import oracle.dbtools.util.Resource;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.extension.WorksheetNode;
import oracle.ide.Context;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Node;
import oracle.ide.view.View;

public abstract class AScratchWorksheet
extends Worksheet {
    private static final Logger LOGGER = Logger.getLogger(AScratchWorksheet.class.getName());
    private Node m_node = null;

    protected void initContext() {
        Context context = Context.newIdeContext((View)this.getViewWithoutDecoration());
        this.m_node = AScratchWorksheet.getTempNode();
        context.setNode(this.m_node);
        this.setContext(context);
    }

    public Node getNode() {
        return this.m_node;
    }

    public synchronized void setContext(Context context) {
        super.setContext(context);
        if (context != null) {
            Node node = context.getNode();
            this.m_node = node instanceof WorksheetNode ? (WorksheetNode)node : null;
        }
    }

    public static WorksheetNode getTempNode() {
        ScratchWorksheetNode scratchWorksheetNode = null;
        try {
            File file = File.createTempFile("wks", ".worksheet", Resource.raptorUserTmp);
            file.deleteOnExit();
            scratchWorksheetNode = new ScratchWorksheetNode(file.toURL());
            scratchWorksheetNode.setConnectionName("");
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, iOException.getLocalizedMessage());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getLocalizedMessage());
        }
        return scratchWorksheetNode;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_translationscratchedit_html");
    }
}

