/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import oracle.dbtools.util.encoding.Decoder;
import oracle.dbtools.util.encoding.Encoder;
import oracle.dbtools.util.encoding.Encoding;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.dbtools.util.encoding.MimeType;

public class NullEncoding
extends Encoding
implements Decoder,
Encoder {
    public NullEncoding(EncodingType encodingType, MimeType mimeType) {
        super(encodingType, mimeType);
    }

    public void copyReader(Reader reader, Writer writer) throws IOException {
        int n = reader.read();
        while (n != -1) {
            writer.write(n);
            n = reader.read();
        }
        writer.flush();
    }

    public void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = inputStream.read();
        while (n != -1) {
            outputStream.write(n);
            n = inputStream.read();
        }
        outputStream.flush();
    }

    @Override
    public void decodeStream(Object object, Object object2) throws IOException {
        if (object instanceof InputStream) {
            this.copyStream((InputStream)object, (OutputStream)object2);
        } else {
            this.copyReader((Reader)object, (Writer)object2);
        }
    }

    @Override
    public void encodeStream(Object object, Object object2) throws IOException {
        this.decodeStream(object, object2);
    }

    @Override
    public long getDecodeLength(long l) {
        return l;
    }

    @Override
    public long getEncodeLength(long l) {
        return l;
    }

    @Override
    public int getDecodeBlocksize() {
        return 1;
    }

    @Override
    public int getEncodeBlocksize() {
        return 1;
    }
}

