/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.encoding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import oracle.dbtools.util.encoding.Decoder;
import oracle.dbtools.util.encoding.Encoder;
import oracle.dbtools.util.encoding.Encoding;
import oracle.dbtools.util.encoding.EncodingException;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.dbtools.util.encoding.MimeType;

public class BASE64Encoding
extends Encoding
implements Decoder,
Encoder {
    private static char[] map1;
    private static byte[] map2;

    public BASE64Encoding(MimeType mimeType) {
        super(EncodingType.ENCODING_BASE64, mimeType);
    }

    public char[] encodeToCharArray(byte[] byArray) throws IOException, EncodingException {
        return this.encodeToCharArray(byArray, -1, null);
    }

    public char[] encodeToCharArray(byte[] byArray, int n, String string) throws IOException, EncodingException {
        return this.encodeToString(byArray, n, string).toCharArray();
    }

    public String encodeToString(byte[] byArray) throws IOException, EncodingException {
        return this.encodeToString(byArray, -1, null);
    }

    public String encodeToString(byte[] byArray, int n, String string) throws IOException, EncodingException {
        StringWriter stringWriter = new StringWriter();
        this.encode(new ByteArrayInputStream(byArray), stringWriter, n, string);
        return stringWriter.toString();
    }

    public long getEncodeLength(byte[] byArray, int n, String string) {
        return this.getEncodeLength(byArray.length, n, string);
    }

    public long getEncodeLength(long l, int n, String string) {
        long l2 = (l + 2L) / 3L * 4L;
        long l3 = 0L;
        if (n > 0 && string != null) {
            int n2 = string.length();
            l3 = l2 / (long)n * (long)n2;
            if (l2 % (long)n == 0L) {
                l3 -= (long)n2;
            }
        }
        return l2 + l3;
    }

    @Override
    public long getEncodeLength(long l) {
        return this.getEncodeLength(l, -1, null);
    }

    public void encode(InputStream inputStream, Writer writer) throws IOException, EncodingException {
        this.encode(inputStream, writer, -1, null);
    }

    public void encode(InputStream inputStream, Writer writer, int n, String string) throws IOException, EncodingException {
        long l = 0L;
        long l2 = 0L;
        int n2 = inputStream.read();
        while (n2 != -1) {
            ++l;
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            if (n3 == -1) {
                n3 = 0;
            } else {
                n3 &= 0xFF;
                ++l;
            }
            if (n4 == -1) {
                n4 = 0;
            } else {
                n4 &= 0xFF;
                ++l;
            }
            int n5 = n2 >>> 2;
            int n6 = (n2 & 3) << 4 | n3 >>> 4;
            int n7 = (n3 & 0xF) << 2 | n4 >>> 6;
            int n8 = n4 & 0x3F;
            BASE64Encoding.writeChar(writer, map1[n5], l2++, n, string);
            BASE64Encoding.writeChar(writer, map1[n6], l2++, n, string);
            long l3 = (l * 4L + 2L) / 3L;
            if (l2 < l3) {
                BASE64Encoding.writeChar(writer, map1[n7], l2++, n, string);
            }
            if (l2 < l3) {
                BASE64Encoding.writeChar(writer, map1[n8], l2++, n, string);
            }
            n2 = inputStream.read();
        }
        long l4 = (l + 2L) / 3L * 4L;
        long l5 = l4 - l2;
        for (long i = 0L; i < l5; ++i) {
            BASE64Encoding.writeChar(writer, 61, l2++, n, string);
        }
        writer.flush();
    }

    private static void writeChar(Writer writer, int n, long l, int n2, String string) throws IOException {
        if (n2 > 0 && l > 0L && string != null && l % (long)n2 == 0L) {
            writer.write(string);
        }
        writer.write(n);
    }

    public byte[] decodeToByteArray(char[] cArray) throws EncodingException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.decode(new CharArrayReader(cArray), byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] decodeToByteArray(String string) throws EncodingException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.decode(new StringReader(string), byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public long getDecodeLength(String string) throws EncodingException {
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            ++l;
            if (string.charAt(i) != '=') continue;
            ++l2;
        }
        return this.getDecodeLength(l) - l2;
    }

    @Override
    public long getDecodeLength(long l) throws EncodingException {
        if (l % 4L != 0L) {
            throw new EncodingException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        return l * 3L / 4L;
    }

    public long getDecodeLength(char[] cArray) throws EncodingException {
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            ++l;
            if (cArray[i] != '=') continue;
            ++l2;
        }
        return this.getDecodeLength(l) - l2;
    }

    @Override
    public int getDecodeBlocksize() {
        return 4;
    }

    @Override
    public int getEncodeBlocksize() {
        return 3;
    }

    public void decode(Reader reader, OutputStream outputStream) throws EncodingException, IOException {
        int n = BASE64Encoding.readChar(reader);
        while (n != -1) {
            int n2 = BASE64Encoding.readChar(reader);
            int n3 = BASE64Encoding.readChar(reader);
            int n4 = BASE64Encoding.readChar(reader);
            if (n4 == -1) {
                throw new EncodingException("Length of Base64 encoded input is not a multiple of 4.");
            }
            int n5 = n3;
            int n6 = n4;
            if ((char)n3 == '=') {
                n3 = 65;
            }
            if ((char)n4 == '=') {
                n4 = 65;
            }
            if (n > 127 || n2 > 127 || n3 > 127 || n4 > 127) {
                throw new EncodingException("Illegal character in Base64 encoded input.");
            }
            byte by = map2[n];
            byte by2 = map2[n2];
            byte by3 = map2[n3];
            byte by4 = map2[n4];
            if (by < 0 || by2 < 0 || by3 < 0 || by4 < 0) {
                throw new EncodingException("Illegal character in Base64 encoded input.");
            }
            int n7 = by << 2 | by2 >>> 4;
            int n8 = (by2 & 0xF) << 4 | by3 >>> 2;
            int n9 = (by3 & 3) << 6 | by4;
            outputStream.write(n7);
            if ((char)n5 != '=') {
                outputStream.write(n8);
            }
            if ((char)n6 != '=') {
                outputStream.write(n9);
            }
            n = BASE64Encoding.readChar(reader);
        }
        outputStream.flush();
    }

    private static int readChar(Reader reader) throws IOException {
        int n = reader.read();
        while (n != -1 && Character.isWhitespace((char)n)) {
            n = reader.read();
        }
        return n;
    }

    public Object decodeBuffer(Object object) throws EncodingException, IOException {
        if (object == null) {
            return null;
        }
        return this.decodeToByteArray((String)object);
    }

    @Override
    public void decodeStream(Object object, Object object2) throws EncodingException, IOException {
        this.decode((Reader)object, (OutputStream)object2);
    }

    public Object encodeBuffer(Object object) throws EncodingException, IOException {
        return this.encodeToString((byte[])object);
    }

    @Override
    public void encodeStream(Object object, Object object2) throws EncodingException, IOException {
        this.encode((InputStream)object, (Writer)object2);
    }

    static {
        int n;
        map1 = new char[64];
        int n2 = 0;
        for (n = 65; n <= 90; n = (int)((char)(n + 1))) {
            BASE64Encoding.map1[n2++] = n;
        }
        for (n = 97; n <= 122; n = (int)((char)(n + 1))) {
            BASE64Encoding.map1[n2++] = n;
        }
        for (n = 48; n <= 57; n = (int)((char)(n + 1))) {
            BASE64Encoding.map1[n2++] = n;
        }
        BASE64Encoding.map1[n2++] = 43;
        BASE64Encoding.map1[n2++] = 47;
        map2 = new byte[128];
        for (n2 = 0; n2 < map2.length; ++n2) {
            BASE64Encoding.map2[n2] = -1;
        }
        for (n2 = 0; n2 < 64; ++n2) {
            BASE64Encoding.map2[BASE64Encoding.map1[n2]] = (byte)n2;
        }
    }
}

