/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

public class XLIFFHelper {
    private XMLDocument _document;
    private DOMParser _parser;
    private String _name;

    public void setBaseDocName(String string) {
        this._name = string;
        this._document = null;
        this._parser = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() {
        InputStream inputStream = null;
        try {
            String string = Locale.getDefault() + ".xliff";
            String string2 = this._name.substring(0, this._name.lastIndexOf(".")) + "_" + string;
            inputStream = this.getClass().getResourceAsStream(string2);
            if (inputStream == null && string.lastIndexOf("_") > 0) {
                String string3 = string.substring(0, string.lastIndexOf("_")) + ".xliff";
                string2 = this._name.substring(0, this._name.lastIndexOf(".")) + "_" + string3;
                inputStream = this.getClass().getResourceAsStream(string2);
            }
            if (inputStream == null) {
                return;
            }
            if (this._parser == null) {
                this._parser = new DOMParser();
            } else {
                this._parser.reset();
            }
            this._parser.setPreserveWhitespace(false);
            this._parser.parse(inputStream);
            this._document = this._parser.getDocument();
        }
        catch (XMLParseException xMLParseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, xMLParseException.getStackTrace()[0].toString(), xMLParseException);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getTranslation(String string) {
        if (!System.getProperty("user.language").equalsIgnoreCase("en")) {
            if (this._document == null && this._name != null) {
                this.open();
            }
            try {
                String string2 = "file/body/trans-unit[source = '" + string + "']/target";
                if (this._document != null && string != null && string.length() > 0) {
                    XMLNode xMLNode = (XMLNode)this._document.getFirstChild();
                    XMLNode xMLNode2 = (XMLNode)xMLNode.selectSingleNode(string2);
                    if (xMLNode2 != null) {
                        return xMLNode2.getTextContent();
                    }
                    return string;
                }
                return string;
            }
            catch (XSLException xSLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, xSLException.getStackTrace()[0].toString(), xSLException);
            }
            catch (DOMException dOMException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dOMException.getStackTrace()[0].toString(), dOMException);
            }
        }
        return string;
    }
}

