/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query.db;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.raptor.query.db.QueryItem;

public class QueryDB {
    private static QueryDB INSTANCE;
    private Object LOCK = new Object();
    private long SEQ = 0L;
    private HashMap<String, Long> QI_CHECKSUM_CACHE = new HashMap();
    private HashMap<Long, QueryItem> QI_CACHE = new HashMap();

    public static synchronized QueryDB getDatabase() {
        if (INSTANCE == null) {
            INSTANCE = new QueryDB();
        }
        return INSTANCE;
    }

    private QueryDB() {
    }

    public QueryItem getNewQueryItem() {
        QueryItem queryItem = new QueryItem();
        this.put(queryItem);
        return queryItem;
    }

    public QueryItem get(long l) {
        return this.QI_CACHE.get(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(QueryItem queryItem) {
        Object object = this.LOCK;
        synchronized (object) {
            if (queryItem.getPk() == null) {
                queryItem.setPk(this.SEQ++);
            }
            this.QI_CACHE.put(queryItem.getPk(), queryItem);
            if (queryItem.getChecksum() != null) {
                this.QI_CHECKSUM_CACHE.put(queryItem.getChecksum(), queryItem.getPk());
            }
        }
    }

    public long truncate() {
        int n = this.QI_CACHE.size();
        this.QI_CACHE.clear();
        return n;
    }

    public long getRowCount() {
        return this.QI_CACHE.size();
    }

    private Set<Map.Entry<Long, QueryItem>> getAllRows() {
        return this.QI_CACHE.entrySet();
    }

    public QueryItem findSharedQuery(String string) {
        QueryItem queryItem = null;
        Set<Map.Entry<Long, QueryItem>> set = this.QI_CACHE.entrySet();
        QueryItem queryItem2 = null;
        for (Map.Entry<Long, QueryItem> entry : set) {
            queryItem2 = entry.getValue();
            if (queryItem2.getId() == null || !queryItem2.getId().equals(string)) continue;
            queryItem = queryItem2;
            break;
        }
        return queryItem;
    }

    public boolean containsChecksum(String string) {
        return this.QI_CHECKSUM_CACHE.containsKey(string);
    }

    public synchronized long getNextSeq() {
        return this.SEQ++;
    }
}

