/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query;

import com.sleepycat.je.Transaction;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.PlsqlCYK;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.raptor.query.QueryUtils;
import oracle.dbtools.raptor.query.db.QueryDB;
import oracle.dbtools.raptor.query.db.QueryItem;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.javatools.util.Version;
import org.w3c.dom.Node;

public final class Query
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NO_ID = "THIS_QUERY_HAS_NO_ID";
    private Version m_minversion;
    private Version m_maxversion;
    private String[] m_requiredFeatures;
    private long _itemID = -1L;
    private String _checksum;
    private String _id;
    private long _dbaID = -1L;

    public static Query getQuery(Node node) {
        return Query.getQuery(node, null, null);
    }

    public static Query getQuery(Node node, XLIFFHelper xLIFFHelper, Transaction transaction) {
        return QueryUtils.getQuery(node, xLIFFHelper, transaction);
    }

    public static List<Query> getQueries(Node node) {
        return Query.getQueries(node, null);
    }

    public static List<Query> getQueries(Node node, Transaction transaction) {
        return QueryUtils.getQueries(node, transaction);
    }

    protected Query(Node node) {
        this.init();
        this.buildQuery(node, null, null);
    }

    protected Query(Node node, XLIFFHelper xLIFFHelper, Transaction transaction) {
        this.init();
        this.buildQuery(node, xLIFFHelper, transaction);
    }

    public Query() {
        this.init();
    }

    public Query(long l) {
        this._itemID = l;
    }

    public Query(String string) {
        this._checksum = string;
    }

    private QueryItem getItem() {
        QueryItem queryItem = QueryDB.getDatabase().get(this._itemID);
        if (queryItem == null) {
            queryItem = new QueryItem();
            if (this._itemID != -1L) {
                queryItem.setPk(this._itemID);
            }
        }
        return queryItem;
    }

    private void init() {
        this._itemID = QueryDB.getDatabase().getNextSeq();
    }

    public long getItemPK() {
        return this._itemID;
    }

    public Set<String> getRequiredObjects() {
        return this.getItem().getReqs();
    }

    public String[] getRequiredFeatures() {
        return this.getItem().getRequiredFeatures();
    }

    public void setRequiredFeatures(String[] stringArray) {
        this.getItem().setRequiredFeatures(stringArray);
    }

    public void setMinversion(Version version) {
        QueryItem queryItem = this.getItem();
        queryItem.setMin(version.toCanonicalString());
        QueryDB.getDatabase().put(queryItem);
        this.m_minversion = version;
    }

    public Version getMinversion() {
        if (this.m_minversion == null) {
            String string = this.getItem().getMin();
            this.m_minversion = string == null ? null : new Version(string);
        }
        return this.m_minversion;
    }

    public void setMaxversion(Version version) {
        QueryItem queryItem = this.getItem();
        queryItem.setMax(version.toCanonicalString());
        QueryDB.getDatabase().put(queryItem);
        this.m_maxversion = version;
    }

    public Version getMaxversion() {
        if (this.m_maxversion == null) {
            String string = this.getItem().getMax();
            this.m_maxversion = string == null ? null : new Version(string);
        }
        return this.m_maxversion;
    }

    public void setSql(String string) {
        QueryItem queryItem = this.getItem();
        queryItem.setSql(string);
        QueryDB.getDatabase().put(queryItem);
    }

    public String getSql() {
        return this.getItem().getSql();
    }

    private List<Bind> getRawBinds() {
        List<Bind> list = this.getItem().getBinds();
        if (list == null) {
            list = new ArrayList<Bind>();
        }
        return list;
    }

    public void setBinds(List<Bind> list) {
        QueryItem queryItem = this.getItem();
        queryItem.setBinds(list);
        QueryDB.getDatabase().put(queryItem);
    }

    public Map<String, Object> getBindMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Bind bind : this.getRawBinds()) {
            hashMap.put(bind.getName(), bind.getValue());
        }
        return hashMap;
    }

    public List<Bind> getBinds() {
        if (this.getItem().getSql() == null) {
            return this.getRawBinds();
        }
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(this.getItem().getSql());
        if (this.getRawBinds().size() >= arrayList.size()) {
            ArrayList<Bind> arrayList2 = new ArrayList<Bind>();
            block0: for (Bind bind : this.getRawBinds()) {
                for (Bind bind2 : arrayList) {
                    if (!bind2.getName().equals(bind.getName())) continue;
                    arrayList2.add(bind);
                    continue block0;
                }
            }
            return arrayList2;
        }
        return arrayList;
    }

    public List<Bind> getReportBinds() {
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(this.getItem().getSql());
        if (this.getRawBinds().size() >= arrayList.size()) {
            return this.getRawBinds();
        }
        return arrayList;
    }

    public void addBind(Bind bind) {
        QueryItem queryItem = this.getItem();
        if (queryItem.getBinds() == null) {
            queryItem.setBinds(new ArrayList<Bind>());
        }
        String string = bind.getName();
        boolean bl = false;
        for (Bind bind2 : queryItem.getBinds()) {
            if (bind2.getName() != string) continue;
            bl = true;
            break;
        }
        if (!bl) {
            queryItem.getBinds().add(bind);
        }
        QueryDB.getDatabase().put(queryItem);
    }

    public void setOptionalBinds(List<Bind> list) {
        QueryItem queryItem = this.getItem();
        queryItem.setOptBinds(list);
        QueryDB.getDatabase().put(queryItem);
    }

    public List<Bind> getOptionalBinds() {
        return this.getItem().getOptBinds();
    }

    protected void addOptionalBind(Bind bind) {
        QueryItem queryItem = this.getItem();
        if (queryItem.getOptBinds() == null) {
            queryItem.setOptBinds(new ArrayList<Bind>());
        }
        String string = bind.getName();
        boolean bl = false;
        for (Bind bind2 : queryItem.getOptBinds()) {
            if (bind2.getName() != string) continue;
            bl = true;
            break;
        }
        if (!bl) {
            queryItem.getOptBinds().add(bind);
        }
        QueryDB.getDatabase().put(queryItem);
    }

    public HashMap<String, Object> getBindValues() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<Bind> arrayList = Parser.getInstance().getBinds(this.getItem().getSql());
        if (this.getRawBinds().isEmpty()) {
            this.getItem().setBinds(arrayList);
        }
        if (this.getItem().getBinds().isEmpty()) {
            return hashMap;
        }
        for (int i = 0; i < this.getRawBinds().size(); ++i) {
            Object object = null;
            String string = this.getRawBinds().get(i).getName();
            String string2 = this.getRawBinds().get(i).getValue();
            String string3 = this.getRawBinds().get(i).getType();
            if (string2 != null && string2.equals("NULL_VALUE")) {
                object = DBUtil.NULL_VALUE;
                hashMap.put(string, object);
            } else if (string.startsWith("SQLDEVPREF")) {
                object = "target";
                hashMap.put(string, object);
            } else {
                object = string2;
                hashMap.put(string, object);
            }
            if (string3 == null || !string3.equalsIgnoreCase("substitution")) continue;
            this.handleSubstitution(string, object);
        }
        return hashMap;
    }

    private void handleSubstitution(String string, Object object) {
        if (this.getItem().getSql().indexOf("&" + string) != -1 && object instanceof String) {
            String string2 = this.getItem().getSql();
            string2 = string2.replaceAll("&" + string, (String)object);
            this.getItem().setSql(string2);
        }
    }

    public void setCols(List<Column> list) {
        QueryItem queryItem = this.getItem();
        queryItem.setCols(list);
        QueryDB.getDatabase().put(queryItem);
    }

    public List<Column> getCols() {
        List<Column> list = this.getItem().getCols();
        if (list == null) {
            list = new ArrayList<Column>();
        }
        return list;
    }

    protected void addColumn(Column column) {
        QueryItem queryItem = this.getItem();
        if (queryItem.getCols() == null) {
            queryItem.setCols(new ArrayList<Column>());
        }
        String string = column.getID();
        boolean bl = false;
        for (Column column2 : queryItem.getCols()) {
            if (string == null || column2.getID() != string) continue;
            bl = true;
            break;
        }
        if (!bl) {
            queryItem.getCols().add(column);
        }
        QueryDB.getDatabase().put(queryItem);
    }

    public HashMap<String, Object> getColValues() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.getCols().isEmpty()) {
            return hashMap;
        }
        for (int i = 0; i < this.getCols().size(); ++i) {
            String string = this.getCols().get(i).getName();
            hashMap.put(string, this.getCols().get(i));
        }
        return hashMap;
    }

    public void buildQuery(Node node, XLIFFHelper xLIFFHelper, Transaction transaction) {
        Object object;
        ArrayList<Bind> arrayList;
        String[] stringArray;
        String string;
        QueryItem queryItem = this.getItem();
        if (queryItem == null) {
            queryItem = new QueryItem();
            if (this._itemID != -1L) {
                queryItem.setPk(this._itemID);
            }
        }
        if ((string = XMLHelper.getNodeValue((Node)node, (String)"nodisplay")) != null) {
            stringArray = string.split(",");
            arrayList = new ArrayList();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add((Bind)((Object)stringArray[i]));
            }
            queryItem.setSkipCols(arrayList);
        }
        stringArray = QueryUtils.getNodeCols(node);
        queryItem.setCols((List<Column>)stringArray);
        arrayList = QueryUtils.getNodeBinds(node, "optionalBinds", xLIFFHelper);
        queryItem.setOptBinds(arrayList);
        List<Bind> list = QueryUtils.getNodeBinds(node, xLIFFHelper);
        queryItem.setBinds(list);
        queryItem.setId(XMLHelper.getAttributeNode((Node)node, (String)"id"));
        this._id = queryItem.getId();
        if (this._id == null) {
            this._id = NO_ID;
        }
        String string2 = XMLHelper.getAttributeNode((Node)node, (String)"minversion");
        queryItem.setMin(string2);
        String string3 = XMLHelper.getAttributeNode((Node)node, (String)"requiredAccessObjects");
        if (string3 != null) {
            object = new HashSet();
            Collections.addAll(object, string3.split(","));
            queryItem.setReqs((Set<String>)object);
        }
        queryItem.setRequiredFeatures((object = XMLHelper.getAttributeNode((Node)node, (String)"requiredFeatures")) != null ? ((String)object).split(",") : null);
        String string4 = XMLHelper.getAttributeNode((Node)node, (String)"maxversion");
        queryItem.setMax(string4);
        String string5 = XMLHelper.getNodeValue((Node)node, (String)"sql");
        if (string5 != null) {
            queryItem.setSql(string5);
        }
        queryItem.setConstrained(Boolean.parseBoolean(XMLHelper.getAttributeNode((Node)XMLHelper.getChildNode((Node)node, (String)"sql"), (String)"constrained")));
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            String string6 = new String(messageDigest.digest(node.getTextContent().getBytes()));
            queryItem.setChecksum(string6);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.getLogger(Query.class.getName()).log(Level.SEVERE, null, noSuchAlgorithmException);
        }
        QueryDB.getDatabase().put(queryItem);
    }

    public void setSkipCols(String string) {
        String[] stringArray = string.split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        this.setSkipCols(arrayList);
    }

    public void setSkipCols(List<String> list) {
        QueryItem queryItem = this.getItem();
        queryItem.setSkipCols(list);
        QueryDB.getDatabase().put(queryItem);
    }

    public List<String> getSkipCols() {
        return this.getItem().getSkipCols();
    }

    public void setCheckSum(String string) {
        QueryItem queryItem = this.getItem();
        queryItem.setChecksum(string);
        QueryDB.getDatabase().put(queryItem);
    }

    public String getCheckSum() {
        return this.getItem().getChecksum();
    }

    public boolean isConstrained() {
        return this.getItem().isConstrained();
    }

    public void setConstrained(boolean bl) {
        QueryItem queryItem = this.getItem();
        queryItem.setConstrained(bl);
        QueryDB.getDatabase().put(queryItem);
    }

    public Set<String> getReqs() {
        return this.getItem().getReqs();
    }

    public void setReqs(Set<String> set) {
        QueryItem queryItem = this.getItem();
        queryItem.setReqs(set);
        QueryDB.getDatabase().put(queryItem);
    }

    public String getIndent(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "\t";
        }
        return string;
    }

    public String toXML(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getIndent(n) + "<query");
        if (this.m_minversion != null) {
            stringBuilder.append(" minversion=\"" + this.m_minversion + "\"");
        }
        if (this.m_maxversion != null) {
            stringBuilder.append(" maxversion=\"" + this.m_maxversion + "\"");
        }
        if (this.getItem().getReqs() != null) {
            Iterator<Column> iterator = new StringBuilder();
            for (String string : this.getItem().getReqs()) {
                ((StringBuilder)((Object)iterator)).append(string);
                ((StringBuilder)((Object)iterator)).append(",");
            }
            ((StringBuilder)((Object)iterator)).deleteCharAt(((StringBuilder)((Object)iterator)).length() - 1);
            stringBuilder.append(" requiredAccessObjects=\"" + iterator + "\"");
        }
        stringBuilder.append(">\n");
        stringBuilder.append(this.getIndent(n + 1) + "<sql><![CDATA[" + this.getItem().getSql() + "]]></sql>\n");
        if (this.getRawBinds() != null && this.getRawBinds().size() > 0) {
            stringBuilder.append(this.getIndent(n + 1) + "<binds>\n");
            for (Bind bind : this.getRawBinds()) {
                stringBuilder.append(bind.toXML(n + 2));
            }
            stringBuilder.append(this.getIndent(n + 1) + "</binds>\n");
        }
        if (this.getCols() != null && this.getCols().size() > 0) {
            stringBuilder.append(this.getIndent(n + 1) + "<columns>\n");
            for (Column column : this.getCols()) {
                stringBuilder.append(column.toXML(n + 2));
            }
            stringBuilder.append(this.getIndent(n + 1) + "</columns>\n");
        }
        stringBuilder.append(this.getIndent(n) + "</query>\n");
        return stringBuilder.toString();
    }

    public String getID() {
        if (this._id == null && this._id != NO_ID) {
            this._id = this.getItem().getId();
        }
        return this._id;
    }

    public void setID(String string) {
        this._id = string;
        QueryItem queryItem = this.getItem();
        queryItem.setId(string);
        QueryDB.getDatabase().put(queryItem);
    }

    public Query dbaVersion() {
        Query query = null;
        if (this._dbaID == -1L) {
            QueryItem queryItem = this.getQueryItem();
            QueryItem queryItem2 = new QueryItem();
            queryItem2.setReqs(new HashSet<String>());
            if (queryItem.getReqs() != null) {
                queryItem2.getReqs().addAll(queryItem.getReqs());
            }
            queryItem2.setSql(queryItem.getSql());
            if (queryItem2.getSql() == null) {
                return null;
            }
            List<LexerToken> list = Query.lex(queryItem2.getSql());
            ParseNode parseNode = Query.parse(list);
            Map<Integer, String> map = Query.getAllTablePos(parseNode, list);
            if (map.size() == 0) {
                return null;
            }
            for (Integer n : map.keySet()) {
                queryItem2.setSql(queryItem2.getSql().substring(0, n) + "Dba_" + queryItem2.getSql().substring(n + "Dba_".length()));
                queryItem2.getReqs().add("Dba_" + map.get(n).substring("Dba_".length()));
            }
            queryItem2.setBinds(queryItem.getBinds());
            queryItem2.setCols(queryItem.getCols());
            queryItem2.setConstrained(queryItem.isConstrained());
            queryItem2.setId(queryItem.getId());
            queryItem2.setMax(queryItem.getMax());
            queryItem2.setMin(queryItem.getMin());
            queryItem2.setOptBinds(queryItem.getOptBinds());
            queryItem2.setSkipCols(queryItem.getSkipCols());
            if (!queryItem2.getSql().equals(this.getSql())) {
                query = new Query();
                queryItem2.setPk(query.getItemPK());
                this._dbaID = queryItem2.getPk();
                QueryDB.getDatabase().put(queryItem2);
            }
        } else {
            query = new Query(this._dbaID);
        }
        return query;
    }

    public QueryItem getQueryItem() {
        return this.getItem();
    }

    private static List<LexerToken> lex(String string) {
        return LexerToken.parse((String)string);
    }

    private static PlsqlCYK getCYK() {
        return PlsqlCYK.getInstance();
    }

    private static ParseNode parse(List<LexerToken> list) {
        Matrix matrix = Query.getCYK().initArray1(list);
        TreeMap treeMap = new TreeMap();
        Query.getCYK().closure(matrix, 0, list.size() + 1, treeMap, -1);
        return Query.getCYK().forest(list, matrix);
    }

    private static Map<Integer, String> getAllTablePos(ParseNode parseNode, List<LexerToken> list) {
        int n = Query.getCYK().getSymbol("from_table_reference_or_subquery");
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        block0: for (ParseNode parseNode2 : parseNode.children()) {
            if (parseNode2.contains(n) && parseNode2.to - parseNode2.from < 5) {
                int n2 = -1;
                for (LexerToken lexerToken : list) {
                    String string;
                    if (parseNode2.from > ++n2 || n2 >= parseNode2.to || !(string = lexerToken.content.toLowerCase()).startsWith("all_")) continue;
                    hashMap.put(lexerToken.begin, string);
                    continue block0;
                }
                continue;
            }
            hashMap.putAll(Query.getAllTablePos(parseNode2, list));
        }
        return hashMap;
    }

    public String toString() {
        return this.getSql();
    }

    public static void main(String[] stringArray) {
        Query query = new Query();
        query.setSql("select * from (\nSELECT o.OBJECT_NAME, o.OBJECT_ID ,'' short_name, decode(bitand(t.property, 32), 32, 'YES', 'NO') partitioned,\n              decode(bitand(t.property, 64), 64, 'IOT',\n             decode(bitand(t.property, 512), 512, 'IOT_OVERFLOW',\n             decode(bitand(t.flags, 536870912), 536870912, 'IOT_MAPPING', null))) iot_type, \n       o.OWNER OBJECT_OWNER, o.CREATED, o.LAST_DDL_TIME, O.GENERATED, O.TEMPORARY, case when xt.obj# is null then 'N' else 'Y' end EXTERNAL\n  FROM SYS.ALL_OBJECTS O ,sys.tab$ t, sys.external_tab$ xt\n  WHERE O.OWNER = :SCHEMA\n  and   o.object_id = t.obj#(+)\n  and   o.object_id = xt.obj#(+)\n  AND O.OBJECT_TYPE = 'TABLE' \nunion all\nSELECT OBJECT_NAME, OBJECT_ID , syn.SYNONYM_NAME short_NAME, decode(bitand(t.property, 32), 32, 'YES', 'NO') partitioned,\n              decode(bitand(t.property, 64), 64, 'IOT',\n             decode(bitand(t.property, 512), 512, 'IOT_OVERFLOW',\n             decode(bitand(t.flags, 536870912), 536870912, 'IOT_MAPPING', null))) iot_type, \n     SYN.TABLE_OWNER OBJECT_OWNER, o.CREATED, o.LAST_DDL_TIME, O.GENERATED, O.TEMPORARY, case when xt.obj# is null then 'N' else 'Y' end EXTERNAL\n            FROM SYS.ALL_OBJECTS O, sys.user_synonyms syn,sys.tab$ t, sys.external_tab$ xt\n            WHERE  syn.table_owner = o.owner\n            and    syn.TABLE_NAME = o.object_NAME\n            and    o.object_id = t.obj#\n                and   o.object_id = xt.obj#(+)\n            and    o.object_type = 'TABLE'\n            and    :INCLUDE_SYNS = 1\n            and    :SCHEMA = USER)");
        query.setSkipCols(new ArrayList<String>());
    }
}

