/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;

public class SetTiming
extends AForAllStmtsCommand {
    private long start;
    private long _runningTotal = 0L;
    private IRaptorTaskProgressUpdater _currentTPU = null;
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_TIMING;

    public SetTiming() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean isListenerOn(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        return true;
    }

    @Override
    public void beginEvent(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        super.beginEvent(connection, scriptRunnerContext, iSQLCommand);
        if (iSQLCommand.getStmtSubType() != null && iSQLCommand.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_SHOW)) {
            Boolean bl = Boolean.FALSE;
            if (this.isCmdOn()) {
                bl = Boolean.TRUE;
            }
            scriptRunnerContext.putProperty("script.runner.context.timing", bl);
        }
    }

    @Override
    public void doBeginWatcher(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getStmtClass() == SQLCommand.StmtType.G_C_PLSQL || iSQLCommand.getStmtClass() == SQLCommand.StmtType.G_C_SQL) {
            this.start = System.currentTimeMillis();
        }
    }

    @Override
    public void doEndWatcher(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getStmtClass() == SQLCommand.StmtType.G_C_PLSQL || iSQLCommand.getStmtClass() == SQLCommand.StmtType.G_C_SQL) {
            long l = System.currentTimeMillis();
            long l2 = l - this.start;
            this.handleScriptTiming(scriptRunnerContext, l2);
            Object[] objectArray = new Object[]{l2};
            long l3 = l - this.start;
            long l4 = l3 % 1000L;
            long l5 = l3 / 1000L;
            long l6 = l5 % 60L;
            long l7 = l5 / 60L;
            long l8 = l7 % 60L;
            long l9 = l7 / 60L;
            String string = this.leadingZeroIfLessThanTen(l9) + ":" + this.leadingZeroIfLessThanTen(l8) + ":" + this.leadingZeroIfLessThanTen(l6) + "." + this.leadingTwoZerosIfLessThanTen(l4);
            String string2 = MessageFormat.format("Elapsed: {0}\n", string);
            try {
                if (this.m_isCmdOn) {
                    scriptRunnerContext.getOutputStream().write(ScriptRunnerContext.stringToByteArrayForScriptRunner(string2));
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    private void handleScriptTiming(ScriptRunnerContext scriptRunnerContext, long l) {
        if (scriptRunnerContext != null && scriptRunnerContext.getTaskProgressUpdater() != null && scriptRunnerContext.getTaskProgressUpdater().getDescriptor() != null) {
            if (this._currentTPU != scriptRunnerContext.getTaskProgressUpdater()) {
                this._currentTPU = scriptRunnerContext.getTaskProgressUpdater();
                this._runningTotal = 0L;
            }
            this._runningTotal += l;
            scriptRunnerContext.getTaskProgressUpdater().getDescriptor().overrideElapseTime(this._runningTotal);
        }
    }

    String leadingZeroIfLessThanTen(long l) {
        String string = "";
        if (l < 10L) {
            string = "0";
        }
        return string + l;
    }

    String leadingTwoZerosIfLessThanTen(long l) {
        String string = "";
        if (l < 100L) {
            string = "0";
        }
        if (l < 10L) {
            string = "00";
        }
        return string + l;
    }
}

