/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.sql.NUMBER;

public class SetNumberformat
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_NUMBERFORMAT;

    public SetNumberformat() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        if (iSQLCommand.getProperty("prop_file_string") != null) {
            String string = iSQLCommand.getSql();
            string = string.trim().replaceAll("^(?i:set\\s+num)(?i:f|fo|for|form|forma|format)\\s+", "").trim();
            string = string.replaceAll("['\"]", "");
            NUMBER nUMBER = new NUMBER(10);
            if (string.length() >= 0) {
                try {
                    if (string.length() > 0) {
                        nUMBER.toFormattedText(string, null);
                    }
                    scriptRunnerContext.putProperty("script.runner.setnumformat", string);
                }
                catch (SQLException sQLException) {
                    if (sQLException.getMessage().equalsIgnoreCase("Unimplemented method called")) {
                        scriptRunnerContext.putProperty("script.runner.setnumformat", string);
                    }
                    String string2 = MessageFormat.format(ScriptRunnerDbArb.getString("NUMFORMAT_ILLEGAL"), "\"" + string + "\"");
                    try {
                        scriptRunnerContext.getOutputStream().write(string2.getBytes());
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(this.getClass().toString()).log(Level.WARNING, "Failed to set the Number width");
                    }
                }
            }
        }
        return true;
    }
}

