/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.util.ArrayList;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.jdbc.OracleConnection;

public class SetAppinfo
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_APPINFO;

    public SetAppinfo() {
        super(m_cmdStmtSubType);
    }

    @Override
    public boolean doHandleCmd(Connection connection, ScriptRunnerContext scriptRunnerContext, ISQLCommand iSQLCommand) {
        String string = (String)iSQLCommand.getProperty("prop_file_string");
        if (string != null && !string.toLowerCase().equals("on") && !string.toLowerCase().equals("off")) {
            string = iSQLCommand.getSql().trim().replaceFirst("^[Ss][Ee][Tt]\\s+[^\\s]+", "").trim();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
                string = string.substring(1, string.length() - 1);
            }
            if (string.startsWith("'") && string.endsWith("'") && string.length() > 1) {
                string = string.substring(1, string.length() - 1);
            }
            if (string == null || string.equals("")) {
                scriptRunnerContext.write(Messages.getString("APPINFONULL"));
            } else {
                arrayList.add(string);
                DBUtil.getInstance(connection).execute("BEGIN DBMS_APPLICATION_INFO.SET_MODULE(:1,null); END;", arrayList);
            }
        } else if (iSQLCommand.getProperty("prop_status_boolean") != null) {
            scriptRunnerContext.putProperty("script.runner.appinfo", (Boolean)iSQLCommand.getProperty("prop_status_boolean"));
            if (Boolean.valueOf(iSQLCommand.getProperty("prop_status_boolean").equals(new Boolean(false))).booleanValue()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(SQLPLUS.PRODUCT_NAME);
                DBUtil.getInstance(connection).execute("BEGIN DBMS_APPLICATION_INFO.SET_MODULE(:1,null); END;", arrayList);
            } else if (Boolean.valueOf(iSQLCommand.getProperty("prop_status_boolean").equals(new Boolean(true))).booleanValue()) {
                ArrayList arrayList = (ArrayList)scriptRunnerContext.getProperty("script.runner.appinfo.arraylist");
                if (arrayList.size() != 0) {
                    SetAppinfo.setAppinfo(scriptRunnerContext, scriptRunnerContext.getCurrentConnection(), (String)arrayList.get(arrayList.size() - 1), arrayList.size());
                } else {
                    SetAppinfo.setAppinfo(scriptRunnerContext, scriptRunnerContext.getCurrentConnection(), SQLPLUS.PRODUCT_NAME, 0);
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public static void setAppinfo(ScriptRunnerContext scriptRunnerContext, Connection connection, String string, Integer n) {
        if (scriptRunnerContext.getCurrentConnection() instanceof OracleConnection && scriptRunnerContext.getProperty("script.runner.appinfo") != null && Boolean.valueOf(scriptRunnerContext.getProperty("script.runner.appinfo").equals(new Boolean(true))).booleanValue()) {
            DBUtil dBUtil = DBUtil.getInstance(scriptRunnerContext.getCurrentConnection());
            Integer n2 = n;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(new Integer(n2));
            arrayList.add(string);
            if (n.equals(0)) {
                arrayList = new ArrayList();
                arrayList.add(SQLPLUS.PRODUCT_NAME);
                dBUtil.execute("BEGIN DBMS_APPLICATION_INFO.SET_MODULE(:1,null);END;", arrayList);
            } else {
                dBUtil.execute("DECLARE\n  inN numeric := :1;\n  --inN NUMERIC := 1;\n  inC varchar2(1000) := :2;\n  --inC  VARCHAR2(1000) := '1234567891123456789212345678931234567894123456789';\n  inNtoC NUMERIC        := inN;\n  inNC   VARCHAR2(1000) := inN;\n  toUse  VARCHAR2(1000);\nBEGIN\n  IF (inN<10) THEN\n    inNC:='0'||TO_CHAR(inN);\n  ELSE\n    inNC:=TO_CHAR(inN);\n  END IF;\n  --size is 48 bytes\n  toUse             :=(inNC||' '||inC);\n  \n  IF (lengthB(toUse))>48 THEN\n    DECLARE\n      p_work VARCHAR2(1000);\n      p_bsize NUMBER      := (48-lengthb((inNC||'<')));\n      v_work  VARCHAR2(1000);\n      v_bsize NUMBER(10);\n    BEGIN\n      p_work := inC;\n      IF LENGTHB(p_work) <= p_bsize THEN\n        inC              := p_work;\n      ELSE\n        v_work                              := p_work;\n        v_work                              := LTRIM(SUBSTRB(v_work, - p_bsize));\n        inC := v_work;\n      END IF;\n    END;\n    toUse:=(inNC||'<')||inC;\n  END IF;\n  DBMS_APPLICATION_INFO.SET_MODULE(toUse,null);\nEND;", arrayList);
            }
        }
    }
}

