/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.IScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.Messages;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.BottomTitle;
import oracle.dbtools.raptor.newscriptrunner.commands.SetSpool;
import oracle.dbtools.raptor.newscriptrunner.commands.TopTitle;
import oracle.dbtools.raptor.query.Bind;
import oracle.ide.model.Node;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public class ScriptRunnerContext
implements IScriptRunnerContext,
Cloneable {
    public static final String TOTAL_CMD_COUNT = "total_cmd_count";
    public static final String CURRENT_CMD_COUNT = "current_cmd_count";
    public static final String OUT_STREAM_WRAPPER = "output_stream_wrapper";
    public static final int FEEDBACK_ON = -1;
    public static final int FEEDBACK_OFF = -2;
    public static final String LAST_ERR_TYPE = "sqldev.last.err.type";
    public static final String LAST_ERR_NAME = "sqldev.last.err.name";
    public static final String ERR_ENCOUNTERED = "sqldev.error";
    public static final String ERR_MESSAGE = "sqldev.last.err.message";
    public static final String ERR_MESSAGE_SQLCODE = "sqldev.last.err.message.forsqlcode";
    public static final String BASE_URL = "script.runner.base.url";
    public static final String NODE_URL = "script.runner.node.url";
    public static final String SYSTEM_OUT = "script.runner.using.systemout";
    public static final String DBCONFIG_GLOGIN = "DBConfig.GLOGIN";
    public static final String DBCONFIG_GLOGIN_FILE = "DBConfig.GLOGIN_FILE";
    public static final String DBCONFIG_DEFAULT_PATH = "DBConfig.DEFAULT_PATH";
    public static final String SPOOLOUTBUFFER = "Spool.out.buffer";
    public static final String POPUPBINDS = "f9.popup.binds";
    public static final String APPINFO = "script.runner.appinfo";
    public static final String APPINFOARRAYLIST = "script.runner.appinfo.arraylist";
    public static final String ARRAYSIZE = "script.runner.arraysize";
    public static final String AUTOCOMMITCOUNTER = "script.runner.autocommit.counter";
    public static final String AUTOCOMMITSETTING = "script.runner.autocommit.setting";
    public static final String ERR_FOR_AUTOCOMMIT = "script.runner.autocommit.errorFlag";
    public static final String COPYCOMMIT = "script.runner.copycommit";
    public static final String CHECKBOXAUTOCOMMIT = "script.runner.autocommit.checkbox";
    public static final String LASTSETSERVEROUTPUT = "script.runner.lastsetserveroutput";
    public static final String REINIT_ON_EXIT = "script.runner.reinitOnExit";
    public static final Long AUTOCOMMITON = new Long(-1L);
    public static final Long AUTOCOMMITOFF = new Long(-2L);
    public static final int VERIFY_OFF = -3;
    public static final int VERIFY_ON = -4;
    public static final int AUTOPRINT_OFF = -5;
    public static final int AUTOPRINT_ON = -6;
    public static final String DBPROPS = "sqldev.script.runner.connection.properties";
    public static final String AUTOTRACE_CTXTRACESTATE = "AUTOTRACE_STATE";
    public static final String AUTOTRACE_CTXTRACETYPE = "AUTOTRACE_TYPE";
    public static final String AUTOTRACE_AUTO_EXPLAIN = "EXPLAIN";
    public static final String AUTOTRACE_AUTO_STAT = "STATISTICS";
    public static final String AUTOTRACE_AUTO_ALL = "ALL";
    public static final String AUTOTRACE_AUTO_NONE = "NONE";
    public static final String SHOWSERVEROUTPUT = "script.runner.context.serveroutput";
    public static final String SHOWTIMING = "script.runner.context.timing";
    public static final String SHOWAUTOPRINT = "script.runner.context.autoprint";
    public static final String SETNULL = "script.runner.setnull";
    public static final String SETNUMWIDTH = "script.runner.setnumwidth";
    public static final String SETNUMFORMAT = "script.runner.setnumformat";
    public static final String SETPAGESIZE = "script.runner.setpagesize";
    public static final String SETLINESIZE = "script.runner.setlinesize";
    public static final String SETLONG = "script.runner.setlong";
    public static final String SETCOLSEP = "script.runner.setcolsep";
    public static final String SETHEADING = "script.runner.setheading";
    public static final String SETHEADSEP = "script.runner.setheadsep";
    public static final String SETHEADSEPCHAR = "script.runner.setheadsepchar";
    public static final String SETWRAP = "script.runner.setwrap";
    public static final String TTITLE_ON = "ON";
    public static final String TTITLE_OFF = "OFF";
    public static final String BTITLE_ON = "ON";
    public static final String BTITLE_OFF = "OFF";
    public static final String RESTRICTION_LEVEL_INTEGER = "script.runner.restrictionlevel";
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private Connection baseConnection = null;
    private boolean closeConnection = false;
    private boolean topLevel = false;
    private Map<String, String> map = null;
    private Map<String, String> columnMap = null;
    private boolean exited = false;
    private boolean returnExited = false;
    private int osError = 0;
    private int sqlError = 0;
    private boolean escape = false;
    private char escapeChar = (char)92;
    private char substitutionChar = (char)38;
    private boolean substitutionOn = true;
    private boolean scanOn = true;
    private char terminateChar = (char)46;
    private URL _lastUrl = null;
    private Map<String, Object> _props = new HashMap<String, Object>();
    private boolean supressOutput = false;
    private int feedback = -1;
    private Object _outputComp;
    private BasicEditorPane _editor;
    private boolean _verify = true;
    private boolean _echo = false;
    private int _autoprint = -5;
    private Map<String, Bind> varMap = null;
    private PrintWriter _errWriter;
    private IRaptorTaskProgressUpdater m_taskProgressUpdater = null;
    private boolean m_isRunScript = true;
    private Connection m_currentConnection = null;
    private String m_encodingOverride = null;
    private static String s_outputEncoding = "UTF-8";
    private boolean dbmsOutputEnable = false;
    private StringBuffer m_dbmsOutput = null;
    private Map<String, String> m_nlsMap = null;
    private boolean m_isConsumerRunning = false;
    private HashMap<String, Savepoint> savepoints = null;
    public Node node = null;
    private HashMap<String, ArrayList<String>> m_formatCmdList = new HashMap();
    private TopTitle m_tTitle = null;
    private BottomTitle m_bTitle = null;
    private String m_tTitleCmd = "";
    private String m_bTitleCmd = "";
    private boolean m_tTitleFlag = false;
    private boolean m_bTitleFlag = false;
    private String m_EditorText = "";
    ArrayList<ISQLCommand> m_executedCommandList = new ArrayList();
    private int m_scriptStartIndex = 0;
    private int m_scriptEndIndex = 0;

    public ArrayList<ISQLCommand> getExecutedCommandList() {
        return this.m_executedCommandList;
    }

    public String getScriptText() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (ScriptRunnerContext.this.m_scriptStartIndex != -1) {
                        ScriptRunnerContext.this._editor.setSelectionStart(ScriptRunnerContext.this.m_scriptStartIndex);
                        ScriptRunnerContext.this._editor.setSelectionEnd(ScriptRunnerContext.this.m_scriptEndIndex);
                        ScriptRunnerContext.this.m_EditorText = ScriptRunnerContext.this._editor.getSelectedText();
                    } else if (((BasicDocument)ScriptRunnerContext.this._editor.getDocument()).getTextBuffer().getLength() < 5000000) {
                        ScriptRunnerContext.this.m_EditorText = ScriptRunnerContext.this._editor.getText().replaceAll("\r\n", "\n");
                    } else {
                        ScriptRunnerContext.this.m_EditorText = null;
                    }
                }
                catch (ExpiredTextBufferException expiredTextBufferException) {
                    ScriptRunnerContext.this.m_EditorText = null;
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, interruptedException.getStackTrace()[0].toString(), interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, invocationTargetException.getStackTrace()[0].toString(), invocationTargetException);
        }
        return this.m_EditorText;
    }

    public void setScriptText(int n, int n2) {
        this.m_scriptStartIndex = n;
        this.m_scriptEndIndex = n2;
    }

    public boolean isRunScript() {
        return this.m_isRunScript;
    }

    public void setIsRunScript(boolean bl) {
        this.m_isRunScript = bl;
    }

    public ScriptRunnerContext() {
        this.reInitClear();
    }

    public void reInitOnExit() {
        Boolean bl = (Boolean)this.getProperty(REINIT_ON_EXIT);
        if (bl != null && bl.equals(Boolean.FALSE)) {
            this.reInitNoExit();
        } else {
            this.reInitClear();
        }
    }

    public void reInitClear() {
        this.closeConnection = false;
        this.topLevel = false;
        this.map = Collections.synchronizedMap(new HashMap());
        this.varMap = Collections.synchronizedMap(new HashMap());
        this.columnMap = Collections.synchronizedMap(new HashMap());
        this.returnExited = this.exited;
        this.exited = false;
        this.osError = 0;
        this.sqlError = 0;
        this.escape = false;
        this.substitutionChar = (char)38;
        this.substitutionOn = true;
        this.scanOn = true;
        this._errWriter = null;
        this.stopSpool();
        this.setFeedback(6);
        this.putProperty(POPUPBINDS, new HashMap());
        this.putProperty(APPINFO, new Boolean(false));
        this.putProperty(APPINFOARRAYLIST, new ArrayList());
        this.putProperty(AUTOCOMMITSETTING, AUTOCOMMITOFF);
        this.putProperty(AUTOCOMMITCOUNTER, new Long(0L));
        this.putProperty(COPYCOMMIT, "0");
        this.putProperty(SETPAGESIZE, new Integer(-1));
        this.putProperty(SETLINESIZE, new Integer(-1));
        this.putProperty(SETLONG, new Integer(80));
        this.putProperty(SETHEADING, "ON");
        this.putProperty(SETHEADSEP, "ON");
        this.putProperty(SETHEADSEPCHAR, "|");
        this.putProperty(SETWRAP, "ON");
        this.putProperty(SETCOLSEP, " ");
        this.putProperty(SETNUMWIDTH, new Integer(10));
        this.putProperty(SETNUMFORMAT, "");
    }

    public void reInitNoExit() {
        this.closeConnection = false;
        this.topLevel = false;
        this._errWriter = null;
        this.exited = false;
        this.putProperty(APPINFOARRAYLIST, new ArrayList());
        this.stopSpool();
    }

    public void stopSpool() {
        new SetSpool().stopSpool(this);
    }

    public PrintWriter getErrWriter() {
        return this._errWriter;
    }

    public void setErrWriter(PrintWriter printWriter) {
        this._errWriter = printWriter;
    }

    public static String getOutputEncoding() {
        return s_outputEncoding;
    }

    public void setNLSMap(Map<String, String> map) {
        this.m_nlsMap = map;
    }

    public Map<String, String> getNLSMap() {
        return this.m_nlsMap;
    }

    public static void setOutputEncoding(String string) {
        s_outputEncoding = string;
    }

    public static byte[] stringToByteArrayForScriptRunner(String string) {
        try {
            return string.getBytes(ScriptRunnerContext.getOutputEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    public Connection getBaseConnection() {
        return this.baseConnection;
    }

    public void setBaseConnection(Connection connection) {
        this.baseConnection = connection;
    }

    public boolean getExited() {
        return this.exited;
    }

    public void setExited(boolean bl) {
        this.exited = bl;
    }

    public boolean getReturnExited() {
        return this.returnExited;
    }

    public void setReturnExited(boolean bl) {
        this.returnExited = bl;
    }

    public boolean getEscape() {
        return this.escape;
    }

    public void setEscape(boolean bl) {
        this.escape = bl;
    }

    public boolean getCloseConnection() {
        return this.closeConnection;
    }

    public void setCloseConnection(boolean bl) {
        this.closeConnection = bl;
    }

    public boolean getTopLevel() {
        return this.topLevel;
    }

    public void setTopLevel(boolean bl) {
        this.topLevel = bl;
    }

    public int getOsError() {
        return this.osError;
    }

    public void setOsError(int n) {
        this.osError = n;
    }

    public int getSqlError() {
        return this.sqlError;
    }

    public void setSqlError(int n) {
        this.sqlError = n;
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public void setMap(Map<String, String> map) {
        this.map = map;
    }

    public Map<String, String> getColumnMap() {
        return this.columnMap;
    }

    public void setColumnMap(Map<String, String> map) {
        this.columnMap = map;
    }

    public char getSubstitutionChar() {
        return this.substitutionChar;
    }

    public void setSubstitutionChar(char c) {
        this.substitutionChar = c;
    }

    public boolean getSubstitutionOn() {
        return this.substitutionOn;
    }

    public void setSubstitutionOn(boolean bl) {
        this.substitutionOn = bl;
    }

    public boolean getScanOn() {
        return this.scanOn;
    }

    public void setScanOn(boolean bl) {
        this.scanOn = bl;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char c) {
        this.escapeChar = c;
    }

    public char getTerminateChar() {
        return this.terminateChar;
    }

    public void setTerminateChar(char c) {
        this.terminateChar = c;
    }

    private String getDirFromFileURL(URL uRL) throws IOException {
        if (uRL == null) {
            return null;
        }
        File file = new File(uRL.getFile());
        String string = file.getCanonicalPath();
        try {
            if (!file.isDirectory()) {
                if (!file.exists() || string.indexOf(File.separator) == -1) {
                    throw new IOException(Messages.getString("ScriptRunnerContext.14") + string);
                }
                string = string.substring(0, string.lastIndexOf(File.separator));
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        return string;
    }

    public String getLastDirName() throws IOException {
        if (this._lastUrl == null) {
            throw new IOException("_lastUrl==null");
        }
        return this.getDirFromFileURL(this._lastUrl);
    }

    public String getLastNodeDirName() throws IOException {
        try {
            URL uRL = (URL)this.getProperty(NODE_URL);
            if (uRL == null || !uRL.getProtocol().equals("file")) {
                return null;
            }
            return this.getDirFromFileURL(uRL);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public URL getLastUrl() {
        return this._lastUrl;
    }

    public void setLastUrl(URL uRL) {
        this._lastUrl = uRL;
    }

    public void putProperty(String string, Object object) {
        this._props.put(string, object);
    }

    public Object getProperty(String string) {
        return this._props.get(string);
    }

    public Map<String, Object> getProperties() {
        return this._props;
    }

    public void setProperties(Map<String, Object> map) {
        this._props = map;
    }

    public WrapListenBufferOutputStream getOutputStream() {
        return (WrapListenBufferOutputStream)this._props.get(OUT_STREAM_WRAPPER);
    }

    public void setOutputStreamWrapper(BufferedOutputStream bufferedOutputStream) {
        if (this.getOutputStream() == null) {
            if (bufferedOutputStream instanceof WrapListenBufferOutputStream) {
                this._props.put(OUT_STREAM_WRAPPER, bufferedOutputStream);
            } else {
                this._props.put(OUT_STREAM_WRAPPER, new WrapListenBufferOutputStream((OutputStream)bufferedOutputStream, this));
            }
        } else {
            try {
                BufferedOutputStream bufferedOutputStream2 = bufferedOutputStream;
                while (bufferedOutputStream2 instanceof WrapListenBufferOutputStream) {
                    bufferedOutputStream2 = ((WrapListenBufferOutputStream)bufferedOutputStream2).getMainStream();
                }
                this.getOutputStream().replaceMainStream(bufferedOutputStream2);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    public boolean isOutputSupressed() {
        return this.supressOutput;
    }

    public void setSupressOutput(boolean bl) {
        this.supressOutput = bl;
    }

    public void setFeedback(int n) {
        this.feedback = n;
    }

    public int getFeedback() {
        return this.feedback;
    }

    public void setOutputComponenet(Object object) {
        this._outputComp = object;
    }

    public Object getOutputComponent() {
        return this._outputComp;
    }

    public void setEditorComponenet(BasicEditorPane basicEditorPane) {
        this._editor = basicEditorPane;
    }

    public BasicEditorPane getEditorComponenet() {
        return this._editor;
    }

    public void write(String string) {
        if (this.isConsumerRunning()) {
            try {
                this.getOutputStream().write(ScriptRunnerContext.stringToByteArrayForScriptRunner(string));
            }
            catch (IOException iOException) {
                this.logger.log(Level.SEVERE, Messages.getString("ScriptRunnerContext.15"), iOException);
            }
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "The following was not written to the Script Runner Result Window as the outputStream was closed:" + string);
        }
    }

    public void setVerify(boolean bl) {
        this._verify = bl;
    }

    public boolean isVerifyOn() {
        return this._verify;
    }

    public void setEcho(boolean bl) {
        this._echo = bl;
    }

    public boolean isEchoOn() {
        return this._echo;
    }

    public Map<String, Bind> getVarMap() {
        return this.varMap;
    }

    public void setVarMap(Map<String, Bind> map) {
        this.varMap = map;
    }

    public int get_autoprint() {
        return this._autoprint;
    }

    public void set_autoprint(int n) {
        this._autoprint = n;
    }

    @Override
    public IRaptorTaskProgressUpdater getTaskProgressUpdater() {
        return this.m_taskProgressUpdater;
    }

    public void setTaskProgressUpdater(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) {
        this.m_taskProgressUpdater = iRaptorTaskProgressUpdater;
    }

    public void setCurrentConnection(Connection connection) {
        this.m_currentConnection = connection;
    }

    public Connection getCurrentConnection() {
        return this.m_currentConnection;
    }

    public String getEncodingOverride() {
        return this.m_encodingOverride;
    }

    public void setEncodingOverride(String string) {
        this.m_encodingOverride = string;
    }

    public void updateColumn(String[] stringArray, String[] stringArray2) throws SQLException {
        Map<String, String> map = this.getColumnMap();
        if (map.size() == 0 || stringArray2 == null) {
            return;
        }
        for (int i = 1; i < stringArray.length; ++i) {
            String string;
            String string2 = stringArray[i];
            String string3 = stringArray2[i];
            if (string3 == null) {
                string3 = "";
            }
            if ((string = map.get(string2.toUpperCase())) == null) continue;
            this.getMap().put(string.toUpperCase(), string3);
        }
    }

    public void enableDbmsOutput() {
        this.dbmsOutputEnable = true;
    }

    public void setdbmsEnable(boolean bl) {
        this.dbmsOutputEnable = bl;
    }

    public boolean isDbmsEnabled() {
        return this.dbmsOutputEnable;
    }

    public void clearDbmsFlags() {
        this.dbmsOutputEnable = false;
    }

    public void pushDbmsOutput(String string) {
        if (this.m_dbmsOutput == null) {
            this.m_dbmsOutput = new StringBuffer();
        }
        this.m_dbmsOutput.append(string);
    }

    public String popDbmsOutput() {
        if (this.m_dbmsOutput == null) {
            return null;
        }
        String string = this.m_dbmsOutput.toString();
        this.m_dbmsOutput = null;
        return string;
    }

    public void writeDisconnectWarning() {
        this.write(Messages.getString("WRITEDISCONNECTWARNING") + "\n");
        try {
            this.getOutputStream().flush();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public void closeCurrentConnection() {
        try {
            if (this.getCurrentConnection() != this.getBaseConnection() && !this.getCurrentConnection().isClosed()) {
                this.getCurrentConnection().commit();
                this.getCurrentConnection().close();
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    public void consumerRuning(boolean bl) {
        this.m_isConsumerRunning = bl;
    }

    public boolean isConsumerRunning() {
        if (!this.m_isConsumerRunning) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.m_isConsumerRunning;
    }

    public void addSavepoint(Savepoint savepoint) {
        if (this.savepoints == null) {
            this.savepoints = new HashMap();
        }
        try {
            this.savepoints.put(savepoint.getSavepointName(), savepoint);
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    public HashMap<String, Savepoint> getSavePoints() {
        return this.savepoints;
    }

    public void setSavepoints(HashMap<String, Savepoint> hashMap) {
        this.savepoints = hashMap;
    }

    public Savepoint getSavepoint(String string) {
        if (this.savepoints != null) {
            return this.savepoints.get(string);
        }
        return null;
    }

    public HashMap<String, ArrayList<String>> getStoredFormatCmds() {
        return this.m_formatCmdList;
    }

    public void setStoredFormatCmds(HashMap<String, ArrayList<String>> hashMap) {
        this.m_formatCmdList = hashMap;
    }

    public String getTTitleCmd() {
        return this.m_tTitleCmd;
    }

    public void setTTitleCmd(String string) {
        this.m_tTitleCmd = string;
    }

    public String getBTitleCmd() {
        return this.m_bTitleCmd;
    }

    public void setBTitleCmd(String string) {
        this.m_bTitleCmd = string;
    }

    public boolean getBTitleFlag() {
        return this.m_bTitleFlag;
    }

    public void setBTitleFlag(boolean bl) {
        this.m_bTitleFlag = bl;
    }

    public void setTTitle(TopTitle topTitle) {
        this.m_tTitle = topTitle;
    }

    public TopTitle getTTitle() {
        return this.m_tTitle;
    }

    public void setBTitle(BottomTitle bottomTitle) {
        this.m_bTitle = bottomTitle;
    }

    public BottomTitle getBTitle() {
        return this.m_bTitle;
    }

    public void setTTitleFlag(boolean bl) {
        this.m_tTitleFlag = bl;
    }

    public boolean getTTitleFlag() {
        return this.m_tTitleFlag;
    }

    public ScriptRunnerContext clone() {
        ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
        scriptRunnerContext.set_autoprint(this.get_autoprint());
        scriptRunnerContext.setTTitleFlag(this.getTTitleFlag());
        scriptRunnerContext.setBTitleFlag(this.getBTitleFlag());
        scriptRunnerContext.setBTitle(this.getBTitle());
        scriptRunnerContext.setTTitle(this.getTTitle());
        scriptRunnerContext.setBTitleCmd(this.getBTitleCmd());
        scriptRunnerContext.setTTitleCmd(this.getTTitleCmd());
        scriptRunnerContext.setStoredFormatCmds(this.getStoredFormatCmds());
        scriptRunnerContext.setSavepoints(this.getSavePoints());
        scriptRunnerContext.consumerRuning(false);
        scriptRunnerContext.setdbmsEnable(this.isDbmsEnabled());
        scriptRunnerContext.setEncodingOverride(this.getEncodingOverride());
        scriptRunnerContext.setCurrentConnection(this.getCurrentConnection());
        scriptRunnerContext.set_autoprint(this.get_autoprint());
        scriptRunnerContext.setVarMap(this.getVarMap());
        scriptRunnerContext.setVerify(this.isVerifyOn());
        scriptRunnerContext.setEcho(this.isEchoOn());
        scriptRunnerContext.setFeedback(this.getFeedback());
        scriptRunnerContext.setSupressOutput(this.isOutputSupressed());
        scriptRunnerContext.setProperties(this.getProperties());
        scriptRunnerContext.setLastUrl(this.getLastUrl());
        scriptRunnerContext.setTerminateChar(this.getTerminateChar());
        scriptRunnerContext.setEscapeChar(this.getEscapeChar());
        scriptRunnerContext.setScanOn(this.getScanOn());
        scriptRunnerContext.setSubstitutionChar(this.getSubstitutionChar());
        scriptRunnerContext.setSubstitutionOn(this.getSubstitutionOn());
        scriptRunnerContext.setMap(this.getMap());
        scriptRunnerContext.setColumnMap(this.getColumnMap());
        scriptRunnerContext.setSqlError(this.getSqlError());
        scriptRunnerContext.setOsError(this.getOsError());
        scriptRunnerContext.setCloseConnection(this.getCloseConnection());
        scriptRunnerContext.setEscape(this.getEscape());
        scriptRunnerContext.setReturnExited(this.getReturnExited());
        scriptRunnerContext.setBaseConnection(this.getBaseConnection());
        scriptRunnerContext.setNLSMap(this.getNLSMap());
        return scriptRunnerContext;
    }
}

