/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.log.LogPage;
import oracle.javatools.dialogs.progress.ProgressPanel;
import oracle.javatools.editor.BasicEditorPane;

public class OutputRedirector
extends Thread {
    private Logger logger = Logger.getLogger(OutputRedirector.class.getName());
    private PipedInputStream _in;
    private Document _text;
    private String _line = "";
    private BufferedReader _reader;
    private final int DISPLAY_NUMBER_OF_LINES = 50;
    private BasicEditorPane _editor;
    private LogPage _logPage;
    private ProgressPanel _progress;
    private Exception stopRunning;
    private boolean doStop = false;
    public static final String OUTPUTREADER_ENCODING = "UTF-8";

    public OutputRedirector(PipedInputStream pipedInputStream, LogPage logPage) {
        this(pipedInputStream, null, null, logPage);
    }

    public OutputRedirector(PipedInputStream pipedInputStream, Document document, BasicEditorPane basicEditorPane) {
        this(pipedInputStream, document, basicEditorPane, null);
    }

    public OutputRedirector(PipedInputStream pipedInputStream, Document document, BasicEditorPane basicEditorPane, LogPage logPage) {
        this._in = pipedInputStream;
        this._text = document;
        this._editor = basicEditorPane;
        this._logPage = logPage;
        try {
            this._reader = new BufferedReader(new InputStreamReader((InputStream)this._in, OUTPUTREADER_ENCODING));
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block40: {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if (this._editor != null) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            OutputRedirector.this._editor.setEditable(true);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    this.logger.log(Level.SEVERE, "run", interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.logger.log(Level.SEVERE, "run", invocationTargetException);
                }
            }
            while (this._line != null) {
                for (int i = 0; i <= 50 && !bl; ++i) {
                    if (this.doStop) {
                        throw this.stopRunning;
                    }
                    this._line = this._reader.readLine();
                    if (this._line == null) break;
                    if (this._line.trim().equals("force_print")) {
                        this._line = "";
                        bl = true;
                    }
                    if (bl) continue;
                    stringBuffer.append(this._line + "\n");
                }
                if (this._text != null) {
                    this._text.insertString(this._text.getLength(), stringBuffer.toString(), null);
                }
                if (!(this._logPage == null || bl && stringBuffer.length() <= 0)) {
                    this._logPage.log((Object)(stringBuffer.toString() + "\n"));
                }
                if (this._progress != null) {
                    final String string = stringBuffer.toString();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (string.length() > 0 && string.length() > 40) {
                                OutputRedirector.this._progress.setMessage(string.substring(0, 40));
                            } else if (string.length() > 0) {
                                OutputRedirector.this._progress.setMessage(string);
                            }
                        }
                    });
                }
                stringBuffer = null;
                stringBuffer = new StringBuffer();
                this.moveToLastRow();
                bl = false;
            }
            try {
                if (this._text != null) {
                    this._text.insertString(this._text.getLength(), stringBuffer.toString(), null);
                }
                if (this._logPage != null) {
                    this._logPage.log((Object)(stringBuffer.toString() + "\n"));
                }
            }
            catch (BadLocationException badLocationException) {
                this.logger.log(Level.SEVERE, "run", badLocationException);
            }
            this.moveToLastRow();
            if (this._editor != null) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            OutputRedirector.this._editor.setEditable(false);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    this.logger.log(Level.SEVERE, "run", interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.logger.log(Level.SEVERE, "run", invocationTargetException);
                }
            }
            break block40;
            catch (Exception exception) {
                try {
                    this.logger.info("Output Pipe finished");
                }
                catch (Throwable throwable) {
                    try {
                        if (this._text != null) {
                            this._text.insertString(this._text.getLength(), stringBuffer.toString(), null);
                        }
                        if (this._logPage != null) {
                            this._logPage.log((Object)(stringBuffer.toString() + "\n"));
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        this.logger.log(Level.SEVERE, "run", badLocationException);
                    }
                    this.moveToLastRow();
                    if (this._editor != null) {
                        try {
                            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                        }
                        catch (InterruptedException interruptedException) {
                            this.logger.log(Level.SEVERE, "run", interruptedException);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            this.logger.log(Level.SEVERE, "run", invocationTargetException);
                        }
                    }
                    throw throwable;
                }
                try {
                    if (this._text != null) {
                        this._text.insertString(this._text.getLength(), stringBuffer.toString(), null);
                    }
                    if (this._logPage != null) {
                        this._logPage.log((Object)(stringBuffer.toString() + "\n"));
                    }
                }
                catch (BadLocationException badLocationException) {
                    this.logger.log(Level.SEVERE, "run", badLocationException);
                }
                this.moveToLastRow();
                if (this._editor != null) {
                    try {
                        SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.log(Level.SEVERE, "run", interruptedException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        this.logger.log(Level.SEVERE, "run", invocationTargetException);
                    }
                }
            }
        }
    }

    public void moveToLastRow() {
        if (this._editor != null) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        OutputRedirector.this._editor.setCaretPositionCenter(OutputRedirector.this._editor.getDocument().getLength());
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                this.logger.log(Level.SEVERE, "run", interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.logger.log(Level.SEVERE, "run", invocationTargetException);
            }
        }
    }

    public void setProgressPanel(ProgressPanel progressPanel) {
        this._progress = progressPanel;
    }

    public void setLogPage(LogPage logPage) {
        this._logPage = logPage;
    }

    public void stopRun() {
        this.doStop = true;
    }
}

