/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;

public class TxtFormatter
extends ResultsFormatter {
    public static final String TYPE = "TEXT";
    public static final String EXT = "tsv";
    public static final String DEFAULT_DELIMITER = "\t";
    public static final String KEY_HEADER = "EXPORT_TXT_HEADER";
    public static final String KEY_DELIMITER = "EXPORT_TXT_DELIMITER";
    public static final String KEY_REC_TERM = "EXPORT_TXT_REC_TERM";
    public static final String KEY_ENCLOSURES = "EXPORT_TXT_ENCLOSURES";
    public static final String KEY_ENCL_LEFT = "EXPORT_TXT_ENCL_LEFT";
    public static final String KEY_ENCL_RIGHT = "EXPORT_TXT_ENCL_RIGHT";
    public static final String KEY_ENCL_RIGHT_DOUBLE = "EXPORT_TXT_ENCL_RIGHT_DOUBLE";
    private boolean _isHeader;

    public TxtFormatter() {
        super(TYPE, Messages.getString("TxtFormatter.0"), EXT);
    }

    @Override
    public void start() throws IOException {
        if (this.isHeader()) {
            int n = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                String string = this.getColumnName(i);
                if (i < n - 1) {
                    this.write(this.getEnclosureLeft() + string + this.getEnclosureRight() + this.getDelimiter());
                    continue;
                }
                this.write(this.getEnclosureLeft() + string + this.getEnclosureRight());
            }
            this.write(this.getLineTerminator());
        }
    }

    @Override
    public void startRow() throws IOException {
    }

    @Override
    public void printColumn(Object object, int n, int n2) throws IOException {
        String string = "";
        String string2 = null;
        String string3 = null;
        int n3 = this.getDataType(n);
        if (n3 == 1 || n3 == -16 || n3 == -1 || n3 == -15 || n3 == -9 || n3 == 12 || n3 == 2005) {
            string2 = this.getEnclosureLeft();
            string3 = this.getEnclosureRight();
        } else {
            string2 = "";
            string3 = "";
        }
        if (object != null && n == 0) {
            string = string2 + this.cleanString(this.getValue(object).toString()) + string3;
        } else if (object == null && n == 0) {
            string = string2 + string3;
        } else if (object != null && n > 0) {
            string = this.getDelimiter() + string2 + this.cleanString(this.getValue(object).toString()) + string3;
        } else if (object == null && n > 0) {
            string = this.getDelimiter() + string2 + string3;
        }
        this.write(string);
    }

    @Override
    public void endRow() throws IOException {
        this.write(this.getLineTerminator());
    }

    @Override
    public void end() throws IOException {
    }

    @Override
    public void setTableName(String string) {
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    @Override
    public boolean isHeaderOptionSupported() {
        return true;
    }

    @Override
    public void isHeader(boolean bl) {
        this._isHeader = bl;
    }

    @Override
    public boolean isHeader() {
        return this._isHeader;
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterConfigurable() {
        return false;
    }

    @Override
    public String getDefaultDelimiter() {
        return DEFAULT_DELIMITER;
    }

    @Override
    public boolean isEnclosuresSupported() {
        return true;
    }

    @Override
    public String getHeaderConfigKey() {
        return KEY_HEADER;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    @Override
    public String getDelimiterConfigKey() {
        return KEY_DELIMITER;
    }

    @Override
    public String getEnclosuresConfigKey() {
        return KEY_ENCLOSURES;
    }

    @Override
    public String getEnclosureLeftConfigKey() {
        return KEY_ENCL_LEFT;
    }

    @Override
    public String getEnclosureRightConfigKey() {
        return KEY_ENCL_RIGHT;
    }

    @Override
    public String getEnclosureRightDoubleConfigKey() {
        return KEY_ENCL_RIGHT_DOUBLE;
    }
}

