/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.controls.IProgressFeedback;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.util.ZipOutputHandler;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;

public abstract class ResultsFormatter
implements IResultFormatter {
    private static final Logger LOGGER = Logger.getLogger(ResultsFormatter.class.getName());
    protected final int FLUSH_EVERY_N_WRITE = 20;
    public static final int CONTINUE = 0;
    public static final int CANCEL_WITH_MSG = 1;
    public static final int CANCEL = 2;
    protected int _writeTracker = 0;
    private ResultsFormatterWrapper m_wrapper;
    protected int _format;
    protected Writer _out;
    protected ZipOutputHandler _zipper;
    private ArrayList<String> m_addToControllingFile = new ArrayList();
    protected IProgressFeedback _feedback;
    protected String _type;
    protected String _filter;
    protected String _ext;
    protected Boolean _prompt = false;
    protected Object _dbObject;
    protected String _EOLChars;
    protected String _EOLCharsString;
    protected String _delimiter;
    protected boolean _isEnclosed = true;
    protected String _enclosureLeft = "\"";
    protected String _enclosureRight;
    protected String _replacableEnclosureRight = this._enclosureRight = "\"";
    protected boolean _isEnclosureRightDoubled = true;
    protected String _nullValue = "";
    protected String _validationMessage;
    private OutputStream _outStream;
    private String _enc;
    private String _fileName;
    private IRaptorTaskProgressUpdater _updater;

    @Override
    public Object getDbObject() {
        return this._dbObject;
    }

    @Override
    public void setDbObject(Object object) {
        this._dbObject = object;
    }

    public ResultsFormatter(String string, String string2, String string3) {
        this._type = string;
        this._ext = string3;
        this._filter = string2;
    }

    @Override
    public void startExport() {
    }

    @Override
    public void finishExport() {
    }

    @Override
    public boolean isColumnListFilterable() {
        return true;
    }

    @Override
    public boolean isTextEditorReadable() {
        return true;
    }

    @Override
    public boolean isStandardEncodings() {
        return true;
    }

    @Override
    public String[] getEncodings() {
        return null;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setFileName(String string) {
        this._fileName = string;
    }

    @Override
    public String getEncode() {
        return this._enc;
    }

    @Override
    public void setEncode(String string) {
        this._enc = string;
    }

    @Override
    public Boolean getPromptForTable() {
        return this._prompt;
    }

    @Override
    public void setPromptForTable(Boolean bl) {
        this._prompt = bl;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getExt() {
        return this._ext;
    }

    @Override
    public String getFilter() {
        return this._filter;
    }

    @Override
    public void setDataProvider(ResultsFormatterWrapper resultsFormatterWrapper) {
        this.m_wrapper = resultsFormatterWrapper;
        resultsFormatterWrapper.setParent(this);
    }

    protected ResultsFormatterWrapper getWrapper() {
        return this.m_wrapper;
    }

    protected String getColumnName(int n) {
        return this.m_wrapper.getColumnName(n);
    }

    protected int getColumnSize(int n) {
        return this.m_wrapper.getColumnSize(n);
    }

    protected int getColumnCount() {
        return this.m_wrapper.getColumnCount();
    }

    public void print(Writer writer) {
        this.print(writer, null);
    }

    public void print(Writer writer, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) {
        this._out = writer;
        this._updater = iRaptorTaskProgressUpdater;
        this.print();
    }

    @Override
    public boolean isStreamHandler() {
        return false;
    }

    @Override
    public void flushStream() {
    }

    @Override
    public void closeStream() {
    }

    @Override
    public int validateOptions() {
        return 0;
    }

    @Override
    public String getValidationMessage() {
        return this._validationMessage;
    }

    @Override
    public void setValidationMessage(String string) {
        this._validationMessage = string;
    }

    @Override
    public boolean allowsLobs() {
        return false;
    }

    @Override
    public boolean isHeaderOptionSupported() {
        return false;
    }

    @Override
    public void isHeader(boolean bl) {
    }

    @Override
    public boolean isHeader() {
        return false;
    }

    @Override
    public String getHeaderConfigKey() {
        return "";
    }

    @Override
    public boolean isSeparateDataFileSupported() {
        return false;
    }

    @Override
    public boolean isSeparateDataFile() {
        return false;
    }

    @Override
    public void isSeparateDataFile(boolean bl) {
    }

    @Override
    public String getSeparateDataFileConfigKey() {
        return "";
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return false;
    }

    @Override
    public void setLineTerminator(String string) {
        this._EOLChars = string;
    }

    public void setLineTerminatorString(String string) {
        this._EOLCharsString = string;
    }

    public String getLineTerminatorString() {
        return this._EOLCharsString;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return "";
    }

    @Override
    public boolean isDelimiterSupported() {
        return false;
    }

    @Override
    public boolean isDelimiterConfigurable() {
        return false;
    }

    @Override
    public String getDefaultDelimiter() {
        return "";
    }

    @Override
    public String getDelimiter() {
        return this._delimiter;
    }

    @Override
    public void setDelimiter(String string) {
        this._delimiter = string;
    }

    @Override
    public String getDelimiterConfigKey() {
        return "";
    }

    @Override
    public boolean isEnclosuresSupported() {
        return false;
    }

    public void setEnclosures(boolean bl, String string, String string2, boolean bl2) {
        this._isEnclosed = bl;
        this._enclosureLeft = string;
        this._enclosureRight = string2;
        this._replacableEnclosureRight = this.handleSpecialEnclosure(string2);
        this._isEnclosureRightDoubled = bl2;
    }

    @Override
    public void isEnclosed(boolean bl) {
        this._isEnclosed = bl;
    }

    @Override
    public boolean isEnclosed() {
        return this._isEnclosed;
    }

    @Override
    public String getEnclosureLeft() {
        return this._enclosureLeft;
    }

    @Override
    public void setEnclosureLeft(String string) {
        this._enclosureLeft = string;
    }

    @Override
    public String getEnclosureRight() {
        return this._enclosureRight;
    }

    @Override
    public void setEnclosureRight(String string) {
        this._enclosureLeft = string;
    }

    @Override
    public String getEnclosuresConfigKey() {
        return "";
    }

    @Override
    public String getEnclosureLeftConfigKey() {
        return "";
    }

    @Override
    public String getEnclosureRightConfigKey() {
        return "";
    }

    @Override
    public String getEnclosureRightDoubleConfigKey() {
        return "";
    }

    @Override
    public boolean isEnclosureRightDoubleConfigurable() {
        return true;
    }

    @Override
    public boolean isTableNameSupported() {
        return false;
    }

    @Override
    public boolean isDataNameSupported() {
        return false;
    }

    @Override
    public String getDataName() {
        return "";
    }

    @Override
    public void setDataName(String string) {
    }

    @Override
    public String getDataNameConfigKey() {
        return "";
    }

    @Override
    public boolean isQuerySupported() {
        return false;
    }

    @Override
    public boolean isQuerySaved() {
        return false;
    }

    @Override
    public void isQuerySaved(boolean bl) {
    }

    @Override
    public String getQueryName() {
        return "";
    }

    @Override
    public void setQueryName(String string) {
    }

    @Override
    public String getQueryConfigKey() {
        return "";
    }

    @Override
    public String getQueryNameConfigKey() {
        return "";
    }

    public boolean isTruncateSupported() {
        return false;
    }

    public boolean isTruncate() {
        return false;
    }

    public void isTruncate(boolean bl) {
    }

    @Override
    public void printWithDialog() {
        final ResultsFormatter resultsFormatter = this;
        ProgressRunnable progressRunnable = new ProgressRunnable(){

            protected void doCancel() {
                super.doCancel();
                resultsFormatter.interrupt();
            }

            protected Object doWork() throws Exception {
                resultsFormatter.print();
                if (ResultsFormatter.this._out != null) {
                    ResultsFormatter.this._out.close();
                }
                return null;
            }
        };
        IProgressFeedback iProgressFeedback = new IProgressFeedback(){

            @Override
            public void feedback(String string) {
                Log.status(string);
            }
        };
        resultsFormatter.setFeedback(iProgressFeedback);
        progressRunnable.setTitle(Messages.getString("ResultsFormatter.14"));
        progressRunnable.setCancelable(true);
        try {
            progressRunnable.start(true);
        }
        catch (ProgressException progressException) {
            LOGGER.log(Level.WARNING, progressException.getStackTrace()[0].toString(), progressException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print() {
        int n = 0;
        try {
            if (this._updater != null) {
                this.m_wrapper.print(this._updater);
            } else {
                this.m_wrapper.print();
            }
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof CancellationException) {
                Log.status(Messages.getString("ResultsFormatter.15"));
            } else {
                LOGGER.log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getMessage(), exception);
        }
        finally {
            if (this._out != null) {
                try {
                    this._out.flush();
                }
                catch (IOException iOException) {}
            }
        }
        return n;
    }

    protected void write(String string) throws IOException {
        if (string != null) {
            if (this._zipper != null) {
                this._zipper.writeEntryText(string);
            } else if (this._out != null) {
                this._out.write(string);
            }
            this.checkAndFlush();
        }
    }

    protected void checkAndFlush() throws IOException {
        if (this._writeTracker < 20) {
            ++this._writeTracker;
        } else {
            if (this._out != null) {
                this._out.flush();
            }
            this._writeTracker = 0;
        }
    }

    protected void addToControllingFile(String string) {
        this.m_addToControllingFile.add(string);
    }

    public ArrayList<String> getAddToControllingFile() {
        ArrayList<String> arrayList = this.m_addToControllingFile;
        this.m_addToControllingFile = new ArrayList();
        return arrayList;
    }

    @Override
    public void log(String string) {
        if (this._updater != null) {
            this._updater.getDescriptor().setMessage(string);
        } else if (this._feedback != null) {
            this._feedback.feedback(string);
        }
    }

    @Override
    public Writer getOutWriter() {
        return this._out;
    }

    @Override
    public void setOutWriter(Writer writer) {
        this._zipper = null;
        this._out = writer;
    }

    @Override
    public OutputStream getOutputStream() {
        return this._outStream;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this._outStream = outputStream;
        if (this._out == null && this._enc != null) {
            try {
                this._out = new OutputStreamWriter(outputStream, this._enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this._out = new OutputStreamWriter(outputStream);
            }
        }
    }

    @Override
    public void setZipper(ZipOutputHandler zipOutputHandler) {
        this._zipper = zipOutputHandler;
        this._out = null;
    }

    @Override
    public ZipOutputHandler getZipper() {
        return this._zipper;
    }

    public IProgressFeedback getFeedback() {
        return this._feedback;
    }

    public void setFeedback(IProgressFeedback iProgressFeedback) {
        this._feedback = iProgressFeedback;
    }

    public void setUpdater(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) {
        this._updater = iRaptorTaskProgressUpdater;
    }

    public void interrupt() {
    }

    public ResultsFormatterWrapper getResultsFormatterWrapper() {
        return this.m_wrapper;
    }

    protected Object getValue(Object object) {
        return this.m_wrapper.getValue(object);
    }

    public int getDataType(int n) {
        int n2 = -1;
        try {
            n2 = this.m_wrapper.getDataType(n);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return n2;
    }

    public String getTimeStampFormat() {
        return NLSUtils.getTimeStampFormat(this.m_wrapper.getConnection());
    }

    public String getTimeStampTZFormat() {
        return NLSUtils.getTimeStampWithTimeZoneFormat(this.m_wrapper.getConnection());
    }

    public String getDateFormat() {
        return NLSUtils.getDateFormat(this.m_wrapper.getConnection());
    }

    public String getFormattedDATE(Object object) {
        return NLSUtils.format(this.m_wrapper.getConnection(), object);
    }

    public String enclosureRightDouble(String string) {
        return string.replaceAll(this._replacableEnclosureRight, this._replacableEnclosureRight + this._replacableEnclosureRight);
    }

    public String handleSpecialEnclosure(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ')') {
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public Connection getConnection() {
        return this.m_wrapper.getConnection();
    }

    @Override
    public String getLineTerminator() {
        if (this._EOLChars == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOLChars = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOLChars;
    }

    public boolean doPrint(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) {
        ResultsFormatter resultsFormatter = this;
        boolean bl = false;
        try {
            resultsFormatter.setUpdater(iRaptorTaskProgressUpdater);
            iRaptorTaskProgressUpdater.checkCanProceed();
            resultsFormatter.print();
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof CancellationException) {
                Log.status(Messages.getString("ResultsFormatter.15"));
            }
            LOGGER.log(Level.WARNING, executionException.getStackTrace()[0].toString(), executionException);
        }
        return bl;
    }

    public String cleanString(String string) {
        StringBuilder stringBuilder = new StringBuilder("");
        Character c = Character.valueOf('\"');
        for (int i = 0; i < string.length(); ++i) {
            Character c2 = Character.valueOf(string.charAt(i));
            stringBuilder = c2.equals(c) ? stringBuilder.append("\"\"") : stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public void close() {
        if (this.m_wrapper != null) {
            this.m_wrapper.close();
        }
    }
}

