/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import com.itextpdf.text.FontFactory;
import java.util.ArrayList;
import oracle.dbtools.raptor.format.PDFFormatOptions;
import oracle.ide.ceditor.options.FontManager;
import oracle.javatools.util.PlatformUtils;

public class ReportFonts {
    private static String[] _fontList = null;
    private static String _fontPath = null;

    public static boolean isFontAvailable(String string) {
        if (FontFactory.isRegistered((String)string)) {
            return true;
        }
        return ReportFonts.isDefaultJavaLogicalFont(string);
    }

    public static boolean isDefaultJavaLogicalFont(String string) {
        return string.equals("Serif") || string.equals("SansSerif") || string.equals("Monospaced") || string.equals("Dialog") || string.equals("DialogInput");
    }

    public static void registerFonts(String string) {
        ReportFonts.getAllFonts(string);
    }

    public static String[] getAllFonts(String string) {
        if (_fontList == null || _fontPath != string) {
            ReportFonts.initFontDirectories(string);
            String[] stringArray = FontManager.getInstance().getAllFontFamilies();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : stringArray) {
                if (!ReportFonts.isFontAvailable(string2)) continue;
                arrayList.add(string2);
            }
            _fontPath = string;
            _fontList = new String[arrayList.size()];
            arrayList.toArray(_fontList);
        }
        return _fontList;
    }

    private static void initFontDirectories(String string) {
        FontFactory.registerDirectories();
        if (string != null && !string.isEmpty()) {
            ArrayList<String> arrayList = PDFFormatOptions.getFontDirectories(string);
            for (String string2 : arrayList) {
                FontFactory.registerDirectory((String)string2, (boolean)PlatformUtils.isLinux());
            }
        }
    }

    public static String getDefaultFontName() {
        return ReportFonts.getDefaultFontName(null);
    }

    public static String getDefaultFontName(String string) {
        String string2 = null;
        if (_fontList == null) {
            ReportFonts.getAllFonts(string);
            if (_fontList == null) {
                // empty if block
            }
        }
        if (PlatformUtils.isWindows()) {
            if (ReportFonts.isFontAvailable("Times New Roman")) {
                string2 = "Times New Roman";
            }
        } else if (PlatformUtils.isLinux()) {
            if (ReportFonts.isFontAvailable("Courier")) {
                string2 = "Courier";
            }
        } else if (PlatformUtils.isMac() && ReportFonts.isFontAvailable("Times New Roman")) {
            string2 = "Times New Roman";
        }
        if (string2 == null) {
            string2 = _fontList == null || _fontList.length == 0 ? "Times New Roman" : _fontList[0];
        }
        return string2;
    }
}

