/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.ide.Ide;
import oracle.ide.util.GuidGen;
import oracle.javatools.dialogs.MessageDialog;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.xdb.XMLType;

public class LoaderFormatter
extends ResultsFormatter {
    private static final Logger LOGGER = Logger.getLogger(LoaderFormatter.class.getName());
    public static final String TYPE = "LOADER";
    public static final String EXT = "ctl";
    public static final String EXT_DAT = "ldr";
    public static final String KEY_SEPARATE_DATA_FILE = "SEPARATE_DATA_FILE";
    public static final String KEY_DELIMITER = "EXPORT_LDR_DELIMITER";
    public static final String KEY_REC_TERM = "EXPORT_LDR_REC_TERM";
    public static final String KEY_ENCLOSURES = "EXPORT_LDR_ENCLOSURES";
    public static final String KEY_ENCL_LEFT = "EXPORT_LDR_ENCL_LEFT";
    public static final String KEY_ENCL_RIGHT = "EXPORT_LDR_ENCL_RIGHT";
    public static final String KEY_ENCL_RIGHT_DOUBLE = "EXPORT_LDR_ENCL_RIGHT_DOUBLE";
    boolean do_header = false;
    boolean blobClobWarning = false;
    boolean rowWritten = false;
    String tableName = null;
    StringBuilder header;
    StringBuilder row;
    private Set<String> s = new HashSet<String>();
    private List<Object> colIsNullObject = new ArrayList<Object>();
    private int indentNum;
    private boolean columnOutputted = false;
    private boolean headerStarted = false;
    private boolean _isSeparateDataFile = false;
    private String ldr_delim = "|";
    private String ldr_leftEnc = "\"";
    private String ldr_rightEnc = "\"";
    private String _ldrEOLChars;
    private String _ctlEOLChars;
    private Integer numRows = 0;
    private ArrayList<String> _createdFiles = new ArrayList();
    int spin = 0;

    public LoaderFormatter() {
        super(TYPE, Messages.getString("LoaderFormatter.3"), EXT_DAT);
    }

    @Override
    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean allowsHeader() {
        return false;
    }

    @Override
    public void setLineTerminator(String string) {
        this._ldrEOLChars = string;
    }

    @Override
    public void start() throws IOException {
        this.do_header = true;
        this.rowWritten = false;
        this.header = new StringBuilder();
        this.blobClobWarning = false;
        if (this._delimiter != null) {
            this.ldr_delim = this._delimiter;
        }
        if (this._enclosureLeft != null) {
            this.ldr_leftEnc = this._enclosureLeft;
        }
        if (this._enclosureRight != null) {
            this.ldr_rightEnc = this._enclosureRight;
        }
        this.s = new HashSet<String>();
        this.spin = 0;
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.s.add(this.getColumnName(i).replaceAll("\"", "").toUpperCase());
        }
    }

    private String getNewName(String string) {
        String string2 = null;
        while (this.s.contains(string2 = "L_" + this.spin)) {
            ++this.spin;
        }
        this.s.add(string2);
        ++this.spin;
        return string2;
    }

    private String getVarrayInfo(String string, Object object, List<Object> list) {
        String string2 = "";
        for (int i = 0; i < this.indentNum; ++i) {
            string2 = string2 + "  ";
        }
        String string3 = string2 + "(" + this.getLineTerminator();
        try {
            list.add(0, new Integer(0));
            ARRAY aRRAY = (ARRAY)object;
            Datum[] datumArray = aRRAY.getOracleArray();
            int n = aRRAY.getBaseType();
            if (n == 2002) {
                if (datumArray[0] != null) {
                    string3 = string3 + string2 + "  " + string + " COLUMN OBJECT" + this.getLineTerminator();
                    ++this.indentNum;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    string3 = string3 + this.getColumnObjectInfo(datumArray[0], arrayList);
                    list.add(0, arrayList);
                    --this.indentNum;
                } else {
                    list.add(0, new Integer(1));
                }
            } else if (n == 2003) {
                if (datumArray[0] != null) {
                    ArrayDescriptor arrayDescriptor = aRRAY.getDescriptor();
                    int n2 = arrayDescriptor.getArrayType();
                    String string4 = "";
                    string4 = n2 == 2 ? "NESTED TABLE" : "VARRAY";
                    string3 = string3 + string2 + "  " + string + " " + string4 + " TERMINATED BY '" + this.ldr_delim + "/'" + this.getLineTerminator();
                    ++this.indentNum;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    string3 = string3 + this.getVarrayInfo(string, datumArray[0], arrayList);
                    list.add(0, arrayList);
                    --this.indentNum;
                } else {
                    list.add(0, new Integer(1));
                }
            } else {
                string3 = string3 + string2 + "  " + string + this.getDateFormat(n) + this.getLineTerminator();
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return string3 + string2 + ")" + this.getLineTerminator();
    }

    private String getColumnObjectInfo(Object object, List<Object> list) {
        String string = "";
        boolean bl = false;
        for (int i = 0; i < this.indentNum; ++i) {
            string = string + "  ";
        }
        String string2 = string + "(" + this.getLineTerminator();
        try {
            STRUCT sTRUCT = (STRUCT)object;
            Object[] objectArray = sTRUCT.getAttributes();
            StructDescriptor structDescriptor = sTRUCT.getDescriptor();
            ResultSetMetaData resultSetMetaData = structDescriptor.getMetaData();
            for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                Object object2;
                Object object3 = objectArray[i];
                int n = resultSetMetaData.getColumnType(i + 1);
                String string3 = resultSetMetaData.getColumnName(i + 1);
                list.add(i, new Integer(0));
                if (n == 2002) {
                    if (object3 != null) {
                        if (bl) {
                            string2 = string2 + "," + this.getLineTerminator();
                        }
                        bl = true;
                        string2 = string2 + string + "  " + string3 + " COLUMN OBJECT" + this.getLineTerminator();
                        ++this.indentNum;
                        object2 = new ArrayList();
                        string2 = string2 + this.getColumnObjectInfo(object3, (List<Object>)object2);
                        list.add(i, object2);
                        --this.indentNum;
                        continue;
                    }
                    list.add(i, new Integer(1));
                    continue;
                }
                if (n == 2003) {
                    if (object3 != null) {
                        if (bl) {
                            string2 = string2 + "," + this.getLineTerminator();
                        }
                        bl = true;
                        object2 = (ARRAY)object3;
                        ArrayDescriptor arrayDescriptor = object2.getDescriptor();
                        int n2 = arrayDescriptor.getArrayType();
                        String string4 = "";
                        string4 = n2 == 2 ? "NESTED TABLE" : "VARRAY";
                        string2 = string2 + string + "  " + string3 + " " + string4 + " TERMINATED BY '" + this.ldr_delim + "/'" + this.getLineTerminator();
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        ++this.indentNum;
                        string2 = string2 + this.getVarrayInfo(string3, object3, arrayList);
                        list.add(i, arrayList);
                        --this.indentNum;
                        continue;
                    }
                    list.add(i, new Integer(1));
                    continue;
                }
                if (bl) {
                    string2 = string2 + "," + this.getLineTerminator();
                }
                bl = true;
                string2 = string2 + string + "  " + string3 + this.getDateFormat(n);
            }
            string2 = string2 + this.getLineTerminator();
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return string2 + string + ")" + this.getLineTerminator();
    }

    private String getColumnInfo(Object object, int n) {
        this.indentNum = 1;
        this.colIsNullObject.add(n, new Integer(0));
        String string = this.getColumnName(n);
        String string2 = string.startsWith("\"") ? string : "\"" + string + "\"";
        int n2 = this.getDataType(n);
        if (n2 == 2002) {
            if (object == null) {
                this.colIsNullObject.add(n, new Integer(1));
                return null;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            String string3 = this.getColumnObjectInfo(object, arrayList);
            this.colIsNullObject.add(n, arrayList);
            return string2 + " COLUMN OBJECT" + this.getLineTerminator() + string3;
        }
        if (n2 == 2003) {
            Object object2;
            Object object3;
            if (object == null) {
                this.colIsNullObject.add(n, new Integer(1));
                return null;
            }
            String string4 = "";
            try {
                object3 = (ARRAY)object;
                object2 = object3.getDescriptor();
                int n3 = object2.getArrayType();
                string4 = n3 == 2 ? "NESTED TABLE" : "VARRAY";
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            object3 = string2 + " " + string4 + " TERMINATED BY '" + this.ldr_delim + "/'" + this.getLineTerminator();
            ++this.indentNum;
            object2 = new ArrayList();
            object3 = (String)object3 + this.getVarrayInfo(string2, object, (List<Object>)object2);
            this.colIsNullObject.add(n, object2);
            --this.indentNum;
            return object3;
        }
        if (n2 == 2004 || n2 == 2005 || n2 == 2007 && this.isXMLType(object)) {
            String string5 = this.getNewName(string2);
            return string5 + " FILLER char," + this.getLineTerminator() + string2 + " LOBFILE( " + string5 + ") TERMINATED BY EOF NULLIF " + string5 + " = 'null'";
        }
        if (n2 == -13) {
            int n4 = n + 1;
            String string6 = "dname_" + n4 + " FILLER char(20)" + "," + this.getLineTerminator();
            String string7 = "fname_" + n4 + " FILLER char(30)" + "," + this.getLineTerminator();
            String string8 = string2 + " BFILE(" + "dname_" + n4 + ",fname_" + n4 + ")";
            return string6 + string7 + string8;
        }
        return string2 + this.getDateFormat(n2);
    }

    public void start2(Object object, int n) throws IOException {
        String[] stringArray;
        int n2 = this.getColumnCount();
        if (n == 0) {
            this._EOLChars = null;
            this.header.append("LOAD DATA" + this.getLineTerminator());
            if (!this.isSeparateDataFile()) {
                this.header.append("INFILE *" + this.getLineTerminator());
            } else {
                this.header.append("INFILE '" + this.getFileName() + "' " + "\"" + "str '" + this.getLineTerminatorString() + "'" + "\"" + this.getLineTerminator());
            }
            this.header.append("APPEND" + this.getLineTerminator());
            this.header.append("CONTINUEIF NEXT(1:1) = '#'" + this.getLineTerminator());
            stringArray = this.tableName.split("\\.");
            if (stringArray.length == 1) {
                if (!stringArray[0].startsWith("\"")) {
                    this.header.append("INTO TABLE \"" + stringArray[0] + "\"" + this.getLineTerminator());
                } else {
                    this.header.append("INTO TABLE " + stringArray[0] + this.getLineTerminator());
                }
            } else {
                if (!stringArray[0].startsWith("\"")) {
                    this.header.append("INTO TABLE \"" + stringArray[0] + "\"" + ".");
                } else {
                    this.header.append("INTO TABLE " + stringArray[0] + ".");
                }
                if (!stringArray[1].startsWith("\"")) {
                    this.header.append("\"" + stringArray[1] + "\"" + this.getLineTerminator());
                } else {
                    this.header.append(stringArray[1] + this.getLineTerminator());
                }
            }
            this.header.append("FIELDS TERMINATED BY'" + this.ldr_delim + "'" + this.getLineTerminator());
            if (this.ldr_leftEnc.length() != 0) {
                this.header.append("OPTIONALLY ENCLOSED BY '" + this.handleSpecialEnclosure(this.ldr_leftEnc) + "'" + " AND " + "'" + this.handleSpecialEnclosure(this.ldr_rightEnc) + "'" + this.getLineTerminator());
            }
            this.header.append("TRAILING NULLCOLS ( " + this.getLineTerminator());
            this.headerStarted = false;
            this.colIsNullObject.clear();
        }
        if ((stringArray = this.getColumnInfo(object, n)) != null) {
            if (this.headerStarted) {
                this.header.append("," + this.getLineTerminator());
            }
            this.header.append((String)stringArray);
            this.headerStarted = true;
        }
        if (n == n2 - 1) {
            this.header.append(")" + this.getLineTerminator());
            this._ctlEOLChars = this._EOLChars;
            this._EOLChars = this._ldrEOLChars;
        }
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    private String getDateFormat(int n) {
        String string = "";
        if (n == 91) {
            string = NLSUtils.getDateFormat(this.getConnection());
            return " DATE \"" + string + "\" ";
        }
        if (n == 93) {
            string = NLSUtils.getTimeStampFormat(this.getConnection());
            return " TIMESTAMP \"" + string + "\" ";
        }
        if (n == -101) {
            string = NLSUtils.getTimeStampWithTimeZoneFormat(this.getConnection());
            return " TIMESTAMP WITH TIME ZONE \"" + string + "\" ";
        }
        if (n == -102) {
            string = NLSUtils.getTimeStampWithTimeZoneFormat(this.getConnection());
            return " TIMESTAMP WITH LOCAL TIME ZONE \"" + string + "\" ";
        }
        return " ";
    }

    @Override
    public void startRow() throws IOException {
        this.row = new StringBuilder();
        this.row.append(" ");
    }

    private String getStruct(Object object, List<Object> list) {
        String string = "";
        Object object2 = null;
        try {
            STRUCT sTRUCT = (STRUCT)object;
            Object[] objectArray = sTRUCT.getAttributes();
            StructDescriptor structDescriptor = sTRUCT.getDescriptor();
            ResultSetMetaData resultSetMetaData = structDescriptor.getMetaData();
            for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                Object object3;
                boolean bl = true;
                int n = resultSetMetaData.getColumnType(i + 1);
                if (list != null && (object2 = list.get(i)) instanceof Integer && (Integer)object2 == 1) {
                    bl = false;
                }
                if (!bl) continue;
                if (objectArray[i] == null) {
                    if (n == 2002) {
                        string = string + this.ldr_delim;
                        continue;
                    }
                    if (n == 2003) {
                        string = string + this.ldr_delim + "/";
                        continue;
                    }
                    if (n == 2004 || n == 2005) {
                        string = string + this.getLeftEnc(n) + "null" + this.getRightEnc(n) + this.ldr_delim;
                        continue;
                    }
                    string = string + this.getLeftEnc(n) + this.getRightEnc(n) + this.ldr_delim;
                    continue;
                }
                if (n == 2002) {
                    object3 = objectArray[i];
                    string = string + this.getStruct(object3, (List)object2);
                    continue;
                }
                if (n == 2003) {
                    object3 = objectArray[i];
                    string = string + this.getVarray(object3, (List)object2);
                    continue;
                }
                string = string + this.getLeftEnc(n) + this.cleanString(this.getValue(objectArray[i], n).toString()) + this.getRightEnc(n) + this.ldr_delim;
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return string;
    }

    private String getVarray(Object object, List<Object> list) {
        String string = "";
        Object object2 = null;
        try {
            boolean bl = true;
            ARRAY aRRAY = (ARRAY)object;
            int n = aRRAY.getBaseType();
            Datum[] datumArray = aRRAY.getOracleArray();
            if (list != null && (object2 = list.get(0)) instanceof Integer && (Integer)object2 == 1) {
                bl = false;
            }
            int n2 = 0;
            if (bl) {
                for (int i = 0; i < aRRAY.length(); ++i) {
                    if (datumArray[i] == null) {
                        if (n == 2002) {
                            string = string + this.ldr_delim;
                            continue;
                        }
                        if (n == 2003) {
                            string = string + this.ldr_delim;
                            continue;
                        }
                        if (n == 2004 || n == 2005) {
                            string = string + this.getLeftEnc(n) + "null" + this.getRightEnc(n) + this.ldr_delim;
                            continue;
                        }
                        string = string + this.getLeftEnc(n) + this.getRightEnc(n) + this.ldr_delim;
                        continue;
                    }
                    if (++n2 >= 10) {
                        string = string + this.getLineTerminator() + "#";
                        n2 = 0;
                    }
                    string = n == 2002 ? string + this.getStruct(datumArray[i], (List)object2) : (n == 2003 ? string + this.getVarray(datumArray[i], (List)object2) : string + this.getLeftEnc(n) + this.cleanString(this.getValue(datumArray[i], n).toString()) + this.getRightEnc(n) + this.ldr_delim);
                }
                string = string + "/";
            } else {
                string = string + this.ldr_delim + "/";
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return string;
    }

    @Override
    public void printColumn(Object object, int n, int n2) throws IOException {
        int n3;
        Object object2 = null;
        if (this.do_header) {
            this.start2(object, n);
        }
        if (!((n3 = this.getDataType(n)) != 2002 && n3 != 2003 || (object2 = this.colIsNullObject.get(n)) instanceof ArrayList || (Integer)this.colIsNullObject.get(n) != 1)) {
            return;
        }
        String string = "";
        this.columnOutputted = true;
        if (n3 == 2002) {
            string = object == null ? string + this.ldr_delim : string + this.getStruct(object, (List)object2);
        } else if (n3 == 2003) {
            string = object == null ? string + this.ldr_delim + "/" : string + this.getVarray(object, (List)object2);
        } else if (object == null) {
            if (n3 == 2004 || n3 == 2005 || n3 == 2007) {
                string = "null";
            }
            string = string + this.ldr_delim;
        } else if (n3 == -13) {
            try {
                string = ((BFILE)object).getDirAlias() + this.ldr_delim + ((BFILE)object).getName() + this.ldr_delim;
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        } else {
            string = string + this.getLeftEnc(n3) + this.cleanString(this.getValue(object, n3).toString()) + this.getRightEnc(n3) + this.ldr_delim;
        }
        this.row.append(string);
    }

    private String getLeftEnc(int n) {
        if (this._isEnclosed && (n == 1 || n == 12 || n == 93 || n == -15 || n == -9 || n == -16 || n == -1)) {
            return this.ldr_leftEnc;
        }
        return "";
    }

    private String getRightEnc(int n) {
        if (this._isEnclosed && (n == 1 || n == 12 || n == 93 || n == -15 || n == -9 || n == -16 || n == -1)) {
            return this.ldr_rightEnc;
        }
        return "";
    }

    @Override
    public String cleanString(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            Character c = Character.valueOf(string.charAt(i));
            string2 = string2 + c;
        }
        return string2;
    }

    @Override
    public void endRow() throws IOException {
        this.rowWritten = true;
        this.numRows = this.numRows + 1;
        if (this._zipper != null) {
            this._zipper.writeEntryText(this.row.toString());
            this._zipper.writeEntryText(this.getLineTerminator());
        } else if (this._out != null) {
            this._out.write(this.row.toString());
            this._out.write(this.getLineTerminator());
            if (this._writeTracker < 20) {
                ++this._writeTracker;
            } else {
                if (this._out != null) {
                    this._out.flush();
                }
                this._writeTracker = 0;
            }
        }
        this.do_header = false;
        this.columnOutputted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue(Object object, int n) {
        if (this.getFileName() == null && (object instanceof Blob || object instanceof Clob)) {
            if (!this.blobClobWarning) {
                this.blobClobWarning = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string = Messages.getString("LoaderFormatter.55");
                        String string2 = Messages.getString("LoaderFormatter.0");
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)string2, null);
                    }
                });
            }
            return "null";
        }
        if (object instanceof Clob) {
            Clob clob = (Clob)object;
            String string = "";
            boolean bl = false;
            try {
                Reader reader = clob.getCharacterStream();
                string = this.getNewFileName(EXT_DAT);
                this._createdFiles.add(string);
                try {
                    bl = this.writeFile(string, reader);
                }
                catch (Exception exception) {
                    LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    bl = true;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                Logger.getLogger(LoaderFormatter.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                bl = true;
            }
            if (bl) {
                return "null";
            }
            return new File(string).getName();
        }
        if (object instanceof Blob) {
            Blob blob = (Blob)object;
            String string = "";
            FilterOutputStream filterOutputStream = null;
            InputStream inputStream = null;
            boolean bl = false;
            try {
                string = this.getNewFileName(EXT_DAT);
                inputStream = blob.getBinaryStream();
                if (inputStream != null) {
                    this._createdFiles.add(string);
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(string));
                    byte[] byArray = new byte[4096];
                    int n2 = 0;
                    while ((n2 = inputStream.read(byArray)) != -1) {
                        ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n2);
                    }
                } else {
                    bl = true;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOGGER.log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (bl) {
                return "null";
            }
            return new File(string).getName();
        }
        if (object instanceof OPAQUE) {
            String string;
            boolean bl;
            block71: {
                String string2 = "";
                bl = false;
                string = "";
                try {
                    OPAQUE oPAQUE = (OPAQUE)object;
                    string2 = oPAQUE.getSQLTypeName().trim();
                    if (!string2.equals("SYS.XMLTYPE")) break block71;
                    XMLType xMLType = XMLType.createXML((OPAQUE)oPAQUE);
                    Reader reader = xMLType.getClobVal().getCharacterStream();
                    string = this.getNewFileName(EXT_DAT);
                    this._createdFiles.add(string);
                    try {
                        bl = this.writeFile(string, reader);
                    }
                    catch (Exception exception) {
                        bl = true;
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(LoaderFormatter.class.getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    bl = true;
                }
            }
            if (bl) {
                return "null";
            }
            return new File(string).getName();
        }
        if (this._isEnclosed && (n == 1 || n == -16 || n == -1 || n == -15 || n == -9 || n == 12)) {
            return this.enclosureRightDouble(this.getResultsFormatterWrapper().getValue(object).toString());
        }
        return this.getResultsFormatterWrapper().getValue(object);
    }

    private boolean isXMLType(Object object) {
        if (object instanceof OPAQUE) {
            try {
                OPAQUE oPAQUE = (OPAQUE)object;
                if (oPAQUE.getSQLTypeName().trim().equals("SYS.XMLTYPE")) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private String getNewFileName(String string) {
        return this.getNewFileName(string, GuidGen.toString((byte[])GuidGen.uuidCreate()).replaceAll("\\" + this.ldr_delim, "_"));
    }

    private String getNewFileName(String string, String string2) {
        String string3 = this.getFileName();
        int n = string3.lastIndexOf(".");
        String string4 = n != -1 ? string3.substring(0, n) : string3;
        int n2 = 0;
        string3 = string4 + string2 + "." + string;
        if (!new File(string3).exists()) {
            return string3;
        }
        while (new File(string3).exists()) {
            string3 = string4 + string2 + "_" + ++n2 + "." + string;
        }
        return string3;
    }

    private Writer getNewWriter(String string) {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.getEncode());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
                outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            }
            bufferedWriter = new BufferedWriter(outputStreamWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        return bufferedWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFile(String string, Reader reader) {
        Writer writer = this.getNewWriter(string);
        boolean bl = true;
        if (writer != null) {
            try {
                char[] cArray = new char[4096];
                int n = 0;
                while ((n = reader.read(cArray)) != -1) {
                    writer.write(cArray, 0, n);
                    bl = false;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOGGER.log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bl;
    }

    @Override
    public void end() throws IOException {
        if (!this.rowWritten) {
            return;
        }
        String string = this.getNewFileName(EXT, "");
        this.numRows = this.numRows > 500 ? Integer.valueOf(this.numRows / 10) : Integer.valueOf(50);
        String string2 = "OPTIONS (ERRORS=" + this.numRows.toString() + ")" + this._ctlEOLChars;
        if (this._zipper == null) {
            Writer writer = this.getNewWriter(string);
            this.addToControllingFile(string);
            writer.write(string2);
            writer.write(this.header.toString());
            writer.close();
        } else if (this._zipper != null) {
            this._zipper.closeEntry();
            this._zipper.openEntry(string);
            this.write(string2);
            this.write(this.header.toString());
            this._zipper.closeEntry();
            for (String string3 : this._createdFiles) {
                this._zipper.writeFileEntry(string3);
                File file = new File(string3);
                file.delete();
            }
        }
        this._createdFiles = new ArrayList();
    }

    @Override
    public Boolean getPromptForTable() {
        return true;
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public boolean isTableNameSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterSupported() {
        return true;
    }

    @Override
    public boolean isDelimiterConfigurable() {
        return true;
    }

    @Override
    public boolean isEnclosuresSupported() {
        return true;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }

    @Override
    public String getDelimiterConfigKey() {
        return KEY_DELIMITER;
    }

    @Override
    public String handleSpecialEnclosure(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getEnclosuresConfigKey() {
        return KEY_ENCLOSURES;
    }

    @Override
    public String getEnclosureLeftConfigKey() {
        return KEY_ENCL_LEFT;
    }

    @Override
    public String getEnclosureRightConfigKey() {
        return KEY_ENCL_RIGHT;
    }

    @Override
    public boolean isEnclosureRightDoubleConfigurable() {
        return false;
    }

    @Override
    public String getEnclosureRightDoubleConfigKey() {
        return KEY_ENCL_RIGHT_DOUBLE;
    }

    public boolean allowLobs() {
        return true;
    }

    @Override
    public boolean isTextEditorReadable() {
        return false;
    }

    @Override
    public boolean isSeparateDataFileSupported() {
        return true;
    }

    @Override
    public String getSeparateDataFileConfigKey() {
        return KEY_SEPARATE_DATA_FILE;
    }

    @Override
    public void isSeparateDataFile(boolean bl) {
        this._isSeparateDataFile = bl;
    }

    @Override
    public boolean isSeparateDataFile() {
        return this._isSeparateDataFile;
    }
}

