/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatter;

public class FixedFormatter
extends ResultsFormatter {
    public static final String TYPE = "fixed";
    public static final String EXT = "txt";
    public static final String KEY_HEADER = "EXPORT_FIX_HEADER";
    public static final String KEY_REC_TERM = "EXPORT_FIX_REC_TERM";
    private static final int FIXED_PAD_LENGTH = 30;
    private boolean _isHeader;

    public FixedFormatter() {
        super(TYPE, Messages.getString("FixedFormatter.1"), EXT);
    }

    @Override
    public void end() throws IOException {
    }

    @Override
    public void endRow() throws IOException {
        this.write(this.getLineTerminator());
    }

    @Override
    public void printColumn(Object object, int n, int n2) throws IOException {
        String string = "";
        String string2 = "";
        int n3 = 30;
        if (object != null) {
            if (this.getValue(object) != null) {
                string2 = this.cleanString(this.getValue(object).toString());
            }
            string = "\"" + string2 + "\"";
        } else {
            string = "\"\"";
        }
        this.write(this.rightpad(string, n3));
    }

    @Override
    public void setTableName(String string) {
    }

    @Override
    public void start() throws IOException {
        int n = 30;
        int n2 = this.getColumnCount();
        if (this.isHeader()) {
            for (int i = 0; i < n2; ++i) {
                String string = this.cleanString(this.getColumnName(i));
                int n3 = string.length();
                String string2 = "\"" + string + "\"";
                this.write(this.rightpad(string2, n));
            }
            this.write(this.getLineTerminator());
        }
    }

    private String rightpad(String string, int n) {
        String string2 = string != null ? string.trim() : string;
        String string3 = "%1$-" + n + "s";
        string2 = string != null ? String.format(string3, string) : String.format(string3, "\"\"");
        return string2;
    }

    @Override
    public void startRow() throws IOException {
    }

    @Override
    public boolean allowsLobs() {
        return true;
    }

    @Override
    public boolean isHeaderOptionSupported() {
        return true;
    }

    @Override
    public boolean isLineTerminatorSupported() {
        return true;
    }

    @Override
    public void isHeader(boolean bl) {
        this._isHeader = bl;
    }

    @Override
    public boolean isHeader() {
        return this._isHeader;
    }

    @Override
    public String getHeaderConfigKey() {
        return KEY_HEADER;
    }

    @Override
    public String getLineTerminatorConfigKey() {
        return KEY_REC_TERM;
    }
}

