/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extendedtype;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.ide.net.URLFileSystem;
import oracle.sql.CLOB;
import oracle.sql.OPAQUE;
import oracle.xdb.XMLType;

public class XMLExtendeType
implements ExtendedType {
    private URL _selectedURL;
    private OPAQUE _data;
    private boolean _isNULL = false;

    public XMLExtendeType(XMLType xMLType) {
        this._data = xMLType;
    }

    public void setValue(OPAQUE oPAQUE) {
        this._data = oPAQUE;
        this._selectedURL = null;
    }

    public OPAQUE getObjectValue() {
        return this._data;
    }

    public String toString() {
        try {
            if (this._selectedURL != null) {
                return "[" + URLFileSystem.getPlatformPathName((URL)this._selectedURL) + "]";
            }
            if (this._data != null) {
                return DataTypesUtil.stringValue(this._data, (Connection)this._data.getOracleConnection());
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return "";
    }

    @Override
    public void duplicate() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (this._selectedURL != null) {
            try {
                return URLFileSystem.openInputStream((URL)this._selectedURL);
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        } else if (this._data != null) {
            XMLType xMLType = XMLType.createXML((OPAQUE)this._data);
            CLOB cLOB = xMLType.getClobVal();
            try {
                return DataTypesUtil.getXMLAsBytes(cLOB.getCharacterStream());
            }
            catch (Exception exception) {
                return cLOB.getAsciiStream();
            }
        }
        return null;
    }

    @Override
    public InputStream getCharStream() throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToDb(Connection connection, String string, String string2, String string3, String string4, boolean bl, List<String> list) throws SQLException, IOException {
        Statement statement = null;
        try {
            Object object;
            XMLType xMLType = null;
            if (this._selectedURL != null) {
                object = URLFileSystem.openInputStream((URL)this._selectedURL);
                CLOB cLOB = DataTypesUtil.getTemporaryCLOB(connection);
                try {
                    Writer writer = cLOB.setCharacterStream(1L);
                    try {
                        DataTypesUtil.getXMLAsCharacters((InputStream)object, writer);
                        writer.flush();
                        xMLType = XMLType.createXML((Connection)connection, (CLOB)cLOB);
                    }
                    catch (XMLStreamException xMLStreamException) {
                        xMLType = XMLType.createXML((Connection)connection, (InputStream)URLFileSystem.openInputStream((URL)this._selectedURL));
                    }
                    finally {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    try {
                        cLOB.close();
                    }
                    catch (SQLException sQLException) {}
                }
            } else if (this._data != null) {
                xMLType = XMLType.createXML((OPAQUE)this._data);
            }
            object = new StringBuffer();
            ((StringBuffer)object).append("UPDATE ").append(string).append(" SET ").append(string2).append("=? WHERE ROWID=:sqldevrowid");
            if (bl && string4 != null) {
                ((StringBuffer)object).append(" AND ORA_ROWSCN=:sqldevrowscn");
            }
            list.add(((StringBuffer)object).toString());
            statement = connection.prepareStatement(((StringBuffer)object).toString());
            statement.setObject(1, xMLType);
            statement.setString(2, string3);
            if (bl && string4 != null) {
                statement.setString(3, string4);
            }
            int n = statement.executeUpdate();
            this._selectedURL = null;
            boolean bl2 = n == 1;
            return bl2;
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            throw sQLException;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    @Override
    public boolean saveToDisk(String string, String string2, String string3, String string4, boolean bl) throws SQLException, IOException {
        return false;
    }

    @Override
    public void setLoadFromURL(URL uRL) {
        this._selectedURL = uRL;
    }

    @Override
    public void setToDiskStream(OutputStream outputStream) {
    }

    @Override
    public void setNULL(boolean bl) {
        this._isNULL = bl;
    }

    @Override
    public boolean isSetNULL() {
        return this._isNULL;
    }

    @Override
    public URL getLoadFromURL() {
        return this._selectedURL;
    }
}

