/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.extendedtype;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import oracle.dbtools.raptor.extendedtype.ExtendedType;

public class GenericBlobType
implements ExtendedType,
Blob {
    protected Blob origBlob = null;
    protected InputStream in = null;
    protected OutputStream out = null;
    protected boolean _isNULL = false;

    public GenericBlobType() {
    }

    public GenericBlobType(Blob blob) {
        this.origBlob = blob;
    }

    public Blob getOrigBlob() {
        return this.origBlob;
    }

    @Override
    public void duplicate() throws SQLException {
        if (this.origBlob != null) {
            this.in = this.origBlob.getBinaryStream();
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (this.origBlob != null) {
            return this.origBlob.getBinaryStream();
        }
        return null;
    }

    @Override
    public InputStream getCharStream() throws SQLException {
        return null;
    }

    @Override
    public boolean saveToDb(Connection connection, String string, String string2, String string3, String string4, boolean bl, List<String> list) throws SQLException, IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToDisk(String string, String string2, String string3, String string4, boolean bl) throws SQLException, IOException {
        if (this.origBlob != null && this.out != null) {
            InputStream inputStream = null;
            try {
                inputStream = this.origBlob.getBinaryStream();
                if (inputStream != null) {
                    byte[] byArray = new byte[10];
                    int n = 0;
                    while ((n = inputStream.read(byArray)) != -1) {
                        this.out.write(byArray, 0, n);
                    }
                    boolean bl2 = true;
                    return bl2;
                }
                boolean bl3 = false;
                return bl3;
            }
            finally {
                this.out.close();
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return false;
    }

    @Override
    public void setLoadFromURL(URL uRL) {
    }

    @Override
    public URL getLoadFromURL() {
        return null;
    }

    @Override
    public void setToDiskStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        return this.origBlob.getBytes(l, n);
    }

    @Override
    public long length() throws SQLException {
        return this.origBlob.length();
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        return this.origBlob.position(byArray, l);
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        return this.origBlob.position(blob, l);
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        return this.origBlob.setBinaryStream(l);
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.origBlob.setBytes(l, byArray);
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        return this.origBlob.setBytes(l, byArray, n, n2);
    }

    @Override
    public void truncate(long l) throws SQLException {
        this.origBlob.truncate(l);
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public int hashCode() {
        return this.origBlob.hashCode();
    }

    public String toString() {
        return "(Blob)";
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        return null;
    }

    @Override
    public void setNULL(boolean bl) {
        this._isNULL = bl;
    }

    @Override
    public boolean isSetNULL() {
        return this._isNULL;
    }
}

