/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.dbtools.raptor.dialogs.DialogResources;
import oracle.dbtools.raptor.dialogs.Messages;
import oracle.dbtools.raptor.dialogs.RaptorMessageDialog;
import oracle.dbtools.raptor.dialogs.SQLExceptionScrubber;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class SQLErrorDialog
extends JPanel
implements ActionListener {
    private static ArrayList<SQLExceptionScrubber> SCRUBBERS;
    private GridBagLayout layMain = new GridBagLayout();
    private JMultiLineLabel lblMsg = new JMultiLineLabel();
    private SmallSquareButton copyBtn = new SmallSquareButton(OracleIcons.getIcon((String)"copy.png"), "Copy Error Message");
    private JButton btnBack = new JButton();
    private JButton btnForward = new JButton();
    private JPanel pnlBottom = new JPanel();
    private GridBagLayout layBottom = new GridBagLayout();
    private JPanel pnlButtons = new JPanel();
    private GridLayout layButtons = new GridLayout();
    private Component glue = Box.createGlue();
    private String _sql;
    private int _errOffset;
    private int _col = -1;
    private int _line = -1;
    private String connName;
    protected List<SQLException> _errs;
    private int _idx;
    private static final String BACK_CMD = "BACK";
    private static final String FWD_CMD = "FWD";

    public static synchronized void registerScrubber(SQLExceptionScrubber sQLExceptionScrubber) {
        if (SCRUBBERS == null) {
            SCRUBBERS = new ArrayList();
        }
        SCRUBBERS.add(sQLExceptionScrubber);
    }

    protected SQLErrorDialog(String string) {
        this.connName = string;
    }

    public void setCol(int n) {
        this._col = n;
    }

    public void setLine(int n) {
        this._line = n;
    }

    public void setSql(String string) {
        this._sql = string;
    }

    public void setOffset(int n) {
        this._errOffset = n;
    }

    private void setError(SQLException sQLException) {
        ArrayList<SQLException> arrayList = new ArrayList<SQLException>();
        while (sQLException != null) {
            arrayList.add(sQLException);
            sQLException = sQLException.getNextException();
        }
        this.setErrors(arrayList);
    }

    public static void showErrorDialog(String string, Component component, String string2, SQLException sQLException, String string3, int n) {
        SQLErrorDialog sQLErrorDialog = new SQLErrorDialog(string);
        sQLErrorDialog.setSql(string3);
        sQLErrorDialog.setOffset(n);
        sQLErrorDialog.setError(sQLException);
        sQLErrorDialog.runErrorDialog(string, component, string2, null);
    }

    public static void showErrorDialog(String string, Component component, String string2, SQLException sQLException, String string3, int n, int n2, int n3) {
        SQLErrorDialog sQLErrorDialog = new SQLErrorDialog(string);
        sQLErrorDialog.setSql(string3);
        sQLErrorDialog.setOffset(n);
        sQLErrorDialog.setLine(n2);
        sQLErrorDialog.setCol(n3);
        sQLErrorDialog.setError(sQLException);
        sQLErrorDialog.runErrorDialog(string, component, string2, null);
    }

    public static void showErrorDialog(String string, Component component, String string2, SQLException sQLException) {
        SQLErrorDialog sQLErrorDialog = new SQLErrorDialog(string);
        sQLErrorDialog.setError(sQLException);
        String string3 = DialogResources.getString("SQL_EXCEPTION_TITLE");
        sQLErrorDialog.runErrorDialog(string, component, string3, null);
    }

    public static void showWarningDialog(String string, Component component, SQLWarning sQLWarning) {
        SQLErrorDialog sQLErrorDialog = new SQLErrorDialog(string);
        sQLErrorDialog.setError(sQLWarning);
        String string2 = DialogResources.getString("SQL_WARNING_TITLE");
        sQLErrorDialog.runWarningDialog(string, component, string2, null);
    }

    public static boolean showErrorWithActionsDialog(String string, Component component, String string2, SQLException sQLException, String string3, String string4) {
        SQLErrorDialog sQLErrorDialog = new SQLErrorDialog(string);
        sQLErrorDialog.setError(sQLException);
        if (string2.endsWith("\n")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return sQLErrorDialog.runErrorWithActionDialog(string, component, string2, null, string3, string4);
    }

    protected void runErrorDialog(String string, Component component, String string2, String string3) {
        MessageDialog.error((Component)component, (Object)this, (String)string2, (String)string3);
    }

    protected void runWarningDialog(String string, Component component, String string2, String string3) {
        MessageDialog.information((Component)component, (Object)this, (String)string2, (String)string3);
    }

    protected boolean runConfirmDialog(String string, Component component, String string2, String string3) {
        return MessageDialog.confirm((Component)component, (Object)this, (String)string2, (String)string3, (boolean)false, (String)Messages.getString("SQLErrorDialog.3"), (String)Messages.getString("SQLErrorDialog.4"));
    }

    protected boolean runErrorWithActionDialog(String string, Component component, String string2, String string3, String string4, String string5) {
        return RaptorMessageDialog.errorAction(component, this, string2, null, string4, string5);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (BACK_CMD.equals(string)) {
            --this._idx;
            this._update();
        } else if (FWD_CMD.equals(string)) {
            ++this._idx;
            this._update();
        }
    }

    protected void setErrors(List<SQLException> list) {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        this._errs = list;
        this._idx = this._errs.size() > 0 ? 0 : -1;
        this.pnlBottom.setVisible(this._errs.size() > 1);
        this._update();
    }

    private void _update() {
        this.btnBack.setEnabled(this._idx > 0);
        this.btnForward.setEnabled(this._idx < this._errs.size() - 1);
        SQLException sQLException = this._idx != -1 ? this._errs.get(this._idx) : null;
        this.updateExceptionComponent(sQLException);
    }

    protected void updateExceptionComponent(SQLException sQLException) {
        String string = null;
        if (SCRUBBERS != null) {
            for (SQLExceptionScrubber object : SCRUBBERS) {
                if (string != null) continue;
                string = object.getMessage(this.connName, sQLException);
            }
        }
        if (string == null) {
            Object object2 = sQLException.getLocalizedMessage();
            if (object2 != null && !((String)object2).endsWith("\n")) {
                object2 = (String)object2 + '\n';
            }
            if (object2 != null && ((String)object2).indexOf("ORA") > -1) {
                Oerr oerr = new Oerr();
                try {
                    object2 = (String)object2 + oerr.oerr((String)object2);
                }
                catch (OerrException oerrException) {
                    // empty catch block
                }
            }
            if (this._sql != null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(DialogResources.format("SQL_EXCEPTION_MSG", object2, Integer.toString(sQLException.getErrorCode())));
                if (this._errOffset > 0) {
                    Object[] objectArray = SQLErrorDialog.getLineAndColumn(this._sql, this._errOffset, this._line, this._col);
                    stringBuilder.append(MessageFormat.format(Messages.getString("SQLErrorDialog.10"), objectArray));
                } else if (this._line >= 0) {
                    stringBuilder.append(MessageFormat.format(Messages.getString("SQLErrorDialog.11"), this._line));
                }
                string = stringBuilder.toString();
            } else {
                string = sQLException != null ? DialogResources.format(sQLException instanceof SQLWarning ? "SQL_WARNING_MSG" : "SQL_EXCEPTION_MSG", object2, Integer.toString(sQLException.getErrorCode())) : DialogResources.getString("SQL_EXCEPTION_UNKNOWN_MSG");
            }
        }
        this.lblMsg.setText(string);
        this.lblMsg.setMaximumRows(8);
    }

    public static Object[] getLineAndColumn(String string, int n, int n2, int n3) {
        String[] stringArray = null;
        if (string.length() >= n) {
            String string2 = "";
            string2 = string.length() >= n + 1 ? string.substring(0, n + 1) : string.substring(0, n);
            stringArray = string2.split("\n");
        } else {
            stringArray = new String[]{string};
        }
        int n4 = stringArray[stringArray.length - 1].length();
        int n5 = stringArray.length;
        if (n2 >= 0 && n3 >= 0 && n5 == 1) {
            n4 = n4 + n3 - 1;
        }
        if (n2 >= 0) {
            n5 = n5 + n2 - 1;
        }
        return new Object[]{n5, n4};
    }

    protected Component getExceptionComponent() {
        this.lblMsg.setPreferredAspectRatio(5.0f);
        return this.lblMsg;
    }

    private void jbInit() {
        this.setLayout(this.layMain);
        ResourceUtils.resButton((AbstractButton)this.btnBack, (String)DialogResources.getString("SQL_EXCEPTION_BUTTON_BACK"));
        this.btnBack.setActionCommand(BACK_CMD);
        this.btnBack.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.btnForward, (String)DialogResources.getString("SQL_EXCEPTION_BUTTON_NEXT"));
        this.btnForward.setActionCommand(FWD_CMD);
        this.btnForward.addActionListener(this);
        this.pnlBottom.setLayout(this.layBottom);
        this.pnlBottom.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        this.pnlButtons.setLayout(this.layButtons);
        this.layButtons.setColumns(2);
        this.layButtons.setHgap(5);
        this.add(this.getExceptionComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlButtons.add((Component)this.btnBack, null);
        this.pnlButtons.add((Component)this.btnForward, null);
        this.pnlBottom.add(this.glue, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlBottom.add((Component)this.pnlButtons, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.copyBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.copyBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringSelection stringSelection = new StringSelection(SQLErrorDialog.this.lblMsg.getText());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                ClipboardStack.pushCurrentClipboard();
                clipboard.setContents(stringSelection, stringSelection);
                SQLErrorDialog.this.copyBtn.setSelected(false);
            }
        });
        this.add((Component)this.pnlBottom, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

