/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.sql.CallableStatement;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.CallableBindingSplitMode;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataParameter;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.DataVariable;
import oracle.dbtools.raptor.datatypes.PLSQLBlockComponent;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingDatumAtName;

public class CallableBindingSplit<P extends DataBinding>
extends CallableBindingDatumAtName<P>
implements CallableBindingSplitMode<P> {
    protected CallableBindingDatumAtName inDatum;

    public CallableBindingSplit(BindContext bindContext, P p) {
        this(bindContext, p, p.getDataType());
    }

    public CallableBindingSplit(BindContext bindContext, P p, DataType dataType) {
        this(bindContext, p, dataType, p.getMode());
    }

    public CallableBindingSplit(BindContext bindContext, P p, BindingMode bindingMode) {
        this(bindContext, p, p.getDataType(), bindingMode);
    }

    public CallableBindingSplit(BindContext bindContext, P p, DataType dataType, BindingMode bindingMode) {
        super(bindContext, p, dataType, bindingMode.getEffectiveMode() == BindingMode.IN_OUT ? BindingMode.OUT : bindingMode);
        if (p.getMode().getEffectiveMode() == BindingMode.IN_OUT) {
            DataVariable dataVariable = dataType.getDataTypeFactory().getDataVariable(p.getName(), dataType, BindingMode.IN);
            this.inDatum = (CallableBindingDatumAtName)dataType.getBind(bindContext, dataVariable);
        } else {
            this.inDatum = null;
        }
    }

    @Override
    public void setByNameBindToken(String string) {
        if (this.inDatum != null) {
            this.inDatum.setByNameBindToken(string);
        } else {
            super.setByNameBindToken(string);
        }
    }

    @Override
    public String getByNameBindToken() {
        if (this.inDatum != null) {
            return this.inDatum.getByNameBindToken();
        }
        return super.getByNameBindToken();
    }

    @Override
    protected void customBind(DataValue dataValue) throws SQLException {
        if (this.inDatum != null) {
            this.inDatum.bind((CallableStatement)this.getCallableStatement(), dataValue);
        }
        super.customBind(dataValue);
    }

    @Override
    public PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder pLSQLBoundBlockBuilder) {
        String string = this.getParameter().getName();
        DataType dataType = this.getDataType();
        BindingMode bindingMode = this.param.getMode();
        if (this.param instanceof DataParameter) {
            switch (bindingMode) {
                case IN: {
                    super.customBuilder(pLSQLBoundBlockBuilder);
                    break;
                }
                case IN_OUT: {
                    this.inDatum.getBuilder(pLSQLBoundBlockBuilder);
                }
                case OUT: {
                    pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.DataDecls, string + " " + dataType.getConstrainedDataTypeString() + ";");
                    pLSQLBoundBlockBuilder.addComponent(PLSQLBlockComponent.ParamBinding, string + "=>" + string);
                    break;
                }
                default: {
                    super.customBuilder(pLSQLBoundBlockBuilder);
                    break;
                }
            }
        } else {
            switch (bindingMode) {
                case IN: {
                    super.customBuilder(pLSQLBoundBlockBuilder);
                    break;
                }
                case IN_OUT: {
                    this.inDatum.getBuilder(pLSQLBoundBlockBuilder);
                }
                case OUT: {
                    super.customBuilder(pLSQLBoundBlockBuilder);
                    break;
                }
                default: {
                    super.customBuilder(pLSQLBoundBlockBuilder);
                }
            }
        }
        return pLSQLBoundBlockBuilder;
    }

    @Override
    public void customReportBinding(StringBuilder stringBuilder, String string, DataValue dataValue) {
        super.customReportBinding(stringBuilder, string, dataValue);
        if (this.inDatum != null) {
            this.inDatum.reportBinding(stringBuilder, string, dataValue);
        }
    }

    @Override
    protected CallableBindingSplitMode<P> customSplitModeBinding() {
        return this;
    }
}

