/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.LongVarchar;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingDatum;
import oracle.jdbc.OracleCallableStatement;

public class CallableBindingLONGVARCHAR<P extends DataBinding>
extends CallableBindingDatum<P> {
    public CallableBindingLONGVARCHAR(BindContext bindContext, P p) {
        super(bindContext, p);
    }

    @Override
    protected void customBindIN(DataValue dataValue, int n) throws SQLException {
        this.inputValue = dataValue;
        LongVarchar longVarchar = (LongVarchar)dataValue.getTypedValue(this.context.getDataTypeConnectionProvider(), ValueType.DEFAULT);
        if (longVarchar != null && !longVarchar.isNull()) {
            try {
                this.getCallableStatement().setCharacterStream(n, longVarchar.getReader(), (int)longVarchar.getLength());
            }
            catch (IOException iOException) {
                throw new DataTypeIOException(iOException);
            }
        } else {
            this.getCallableStatement().setNull(n, this.dataType.getSqlDataType(ValueType.JDBC));
        }
    }

    @Override
    protected DataValue customOutputByPosition(OracleCallableStatement oracleCallableStatement, int n) throws SQLException {
        Reader reader = oracleCallableStatement.getCharacterStream(n);
        return this.dataType.getDataValue(reader);
    }
}

